
; ==============================================================================================
;
;  -------------------------------------------------------
;  TARGET COMPUTER
;  -------------------------------------------------------
;  
;  FOR IC SOCKET U18 ON THE IBM 5160 MOTHERBOARD.
;
;  -------------------------------------------------------
;  WHAT THE CODES DOES
;  -------------------------------------------------------
;  
;  In a loop, the code:
;     Step 1: Reads address 00000h (0000:0000)
;     Step 2: Reads address FFFFFh (FFFF:000F)
;  
;  -------------------------------------------------------
;  EXPECTED OBSERVATIONS
;  -------------------------------------------------------
;  
;  Reference diagram at https://minuszerodegrees.net/5160/misc/5160_address_bus.jpg
;  
;  Using a logic probe (or oscilloscope):
;     1. Observe the address bus lines of A0 to A19 toggling/pulsing. (An ISA expansion slot is a good place to measure at.)
;     2. Observe the external address bus lines of XA0 to XA19 toggling.
;  
;  -------------------------------------------------------
;  LIMITATIONS
;  -------------------------------------------------------
;  
;  Certain cases of failure will stop this code from running.
;
;  -------------------------------------------------------
;  COMPILATION
;  -------------------------------------------------------
;  
;  COMPILE THIS CODE USING NASM 2.10 (OR LATER).
;
; ==============================================================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

LOOP:	mov	dx,0000
	mov	es,dx
	mov	al,byte es:[0000]	; Read address 00000h (0000:0000)

	mov	dx,0FFFFh
	mov	es,dx
	mov	al,byte es:[000Fh]	; Read address FFFFFh (FFFF:000F)

	jmp	LOOP



TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector.

	jmp	0xFFF0:0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM.





