TITLE   SETCLOCK.ASM      27-11-87
; Written by:
;               Garry Kraemer
;               520 El Portal
;               Merced, CA  95340
;
;
;This software may be freely ditributed and no charge shall
;be made by anyone for its use or distribution except for
;a copying charge.

;This program reads the system clock and
;sets the Leading Edge Model-M battery backed-up clock to
;the system DATE and TIME values.
;
;*****************************************************************
;
;After upgrading my Leading Edge Model "M" to EGA (NEW ROM),
;adding a 40 MEG hard drive (KONAN Disk Controller), and switching
;to MSDOS 3.1, I found that I could no longer set the BATTERY backed-up
;clock.  I needed a small program to allow me to set the date and time in
;the BATTERY backed-up clock.  This program is the result!
;Use it as you wish and at your own RISK!  No warranties are
;"EXPRESSED or IMPLIED"!  It works for me, but I'm easy to please!
;
;This short program uses an undocumented feature of the Leading Edge
;ROM Bios.  The Time-of Day interrupt (INT 1AH) has four additional
;functions beyond that of the IBMPC ROM Bios.  (See the IBM code for
;INT 1AH in the Technical Reference Manual.  Note that this function
;allows the current clock [DOS clock] to be set/read for AH=1/0 upon
;entry)  For the Leading Edge, Model M, this interrupt can also 
;set/read the date/time of the on-board battery backed-up clock. Entry
;and return of CX/DX registers is the same as for the DOS function
;calls with INT 21H for AH=2AH through 2DH except that CX sets/returns
;an offset from the year 1980 (07cbh).  The following AH reg entry
;values accomplish the described functions:
;
;		AH=2	Read the time from the battery backed-up clock.
;		AH=3	Set the time into the     "	 "         "
;		AH=4	Read the date from the	  "      "         "		
;		AH=5	Set the date into the     "      "         "
;
;*********************************************************************
;     To Assemble use the following commands:
;
;                       MASM SETCLOCK;
;                       LINK SETCLOCK;
;                       EXE2COM SETCLOCK SETCLOCK.COM or
;                       EXE2BIN SETCLOCK SETCLOCK.COM
;
;equates
;
;INT 21H Dos functions
;
	get_sys_date       equ     2a00h   ;gets system date
					   ;cx = year, dh = month
					   ;dl = day
	set_sys_date       equ     2b00h   ;sets system date
					   ;cx = year, dh = month
					   ;dl = day
	get_sys_time       equ     2c00h   ;gets system time
					   ;ch = hour, cl = minute
					   ;dh = seconds, dl = hund seconds
	set_sys_time       equ     2d00h   ;sets system time
					   ;ch = hour, cl = minute
					   ;dh = seconds, dl = hund seconds
;
;
;INT 1AH Rom Bios functions
;
	get_bat_time       equ     0200h   ;gets battery clock time
	set_bat_time       equ     0300h   ;sets battery clock time
	get_bat_date       equ     0400h   ;gets battery clock date
	set_bat_date       equ     0500h   ;sets battery clock date
;
;********************************************************************
;
setclock segment
;
	assume ds:setclock, ss:setclock ,cs:setclock ,es:setclock
;
	org	100h
;
begin:                             ;read the time
	mov     ax,get_sys_time    ;read system time, set registers
	int     21h                ;call int
				   ;now set the battery clock time
	mov     ax,set_bat_time    ;set time TO SYSTEM time
	int     1ah                ;call ROM BIOS to do it!
				   ;
	mov     ax,get_sys_date    ;read system date
	int     21h                ;returns date in registers
				   ;now set the date for the BATTERY clock
	sub     cx,07bch           ;sub 1980 from cx register to determine
				   ;offset. cx contains offset!
	mov     ax,set_bat_date    ;set date in BATTERY clock
	int     1ah                ;using the ROM BIOS CALL
				   ;
done:   int     20h                ;we are done, so return to DOS
	setclock ends
;
end begin
