/* A.Fongen's "Mailorg" project - rmail compatible mail user interface.

   Module MAIN - main body of the program, contains initialization code
   and command "intepreter".

   Currrent version: 21.09.90
*/
#include <stdio.h>

extern int split();
extern void display_headers();
extern void display_letter();
extern void close_files();

char version[]="Mail Organizer 1.01, by Anders Fongen, 1990\n\n";

char prompt[]="Legal values are:\n\
+\tMove forward one message\n\
-\tMove backward one message\n\
?\tPrint this help list\n\
!\tEscape to /bin/sh\n\
d\tDelete current message\n\
f\tSwitch to another mailbox\n\
h\tDisplay message headers\n\
m\tEnter new message\n\
p\tView current message\n\
q\tUpdate mailbox and quit\n\
r\tReply to current message\n\
s mbox\tSave (and then delete) current message\n\
u\tUndelete current message\n\
w file\tWrite current message to file\n\
x\tExit without updating mailbox\n";

char uucpname[20];

main(argc,argv)
int argc;
char **argv;
{
	extern char *optarg;
	int i,letterno,curlet=0;		/* Current letter */
	char c[80],mailboxname[40];
	FILE *tempfile;

	/* Read in the contents of the file /etc/uucpname.
NB!NB! 	This is a non-portable Coherent method! A UNIX system
	should get the nodename with the "uname -n" command. */
	if ((tempfile = fopen("/etc/uucpname","r")) == NULL) {
		strcpy(uucpname,"<unknown>");
		printf("Can't find /etc/uucpname. IS THIS COHERENT?\n");
	} else {
		fscanf(tempfile,"%20s",uucpname);
		fclose(tempfile);
	}

	/* Check for runtime parameters */
	strcpy(mailboxname,"MAIL");	/* Default name of mailbox */
	while ((i = getopt(argc,argv,"sf:")) != EOF) {
		if (i == 'f') 		/* -f <mailbox> */
			strcpy(mailboxname,optarg);
		if (i == 's') {		/* Just send a message */
			create_mail(); return(0);
		}
	}

	printf("%s",version);

	/* Read mailfile and build approp. data structure */
#ifdef DEBUG
	printf("MBOX=%s\n",mailboxname);
#endif
	/* Split does it all */
	letterno = split(mailboxname);
	if (!letterno) {
		printf("No messages in mailbox\n");
		exit(0);
	}
	display_headers();

	/* This is the main loop of the program, get a command
	   line from the console and act upon it */
	while (1) {
		display_header_line(curlet);
		printf("%d ? ",curlet);
		gets(c);
		if (i = atoi(c)) 
			i < letterno ? curlet = i : printf("Too high!\n");
		else switch (c[0]) {
			case '0': curlet = 0; break;
			case '?': printf("%s",prompt); break;
			case '!': system("/bin/sh");
			case '+': curlet == letterno-1 ? curlet : curlet++; 
					break;
			case '\0':curlet == letterno-1 ? curlet : curlet++; 
					break;
			case '-': curlet > 0 ? curlet-- : curlet; break;
			case 'd': delete_letter(curlet);
					curlet == letterno-1 ? 
						curlet : curlet++; 
					break;
			case 'f': letterno = switch_mailbox(c); 
					curlet = 0; break;
			case 'h': display_headers(); break;
			case 'm': create_mail(); break;
			case 'p': display_letter(curlet); break;
			case 'q': update_mailbox();
					close_files();
					return(0);
			case 'r': reply_mail(curlet); break;
			case 's': save_letter(curlet,c);
					curlet == letterno-1 ? 
						curlet : curlet++; 
					break;
			case 'u': undelete_letter(curlet); break; 
			case 'w': write_letter(curlet,c); break;
			case 'x': close_files();return(0);
			default : printf("Illegal command\n");
			}
	}
}
