/* A.Fongen's "Mailorg" project - rmail compatible mail user interface.

   Module SEND - contains procedures to send and to reply to 
   messages

   current version: 21.09.90

*/
#include <stdio.h>

extern char *getenv();
extern char *isolate_letter();

void create_mail()
{
	char filename[80];
	char editname[120];
	char subject[50];
	char toaddr[60];
	char *envptr,resp[30];
	FILE *tempfile;

	/* Create a temporary file */
	strcpy(filename,mktemp("/tmp/moXXXXXX"));

	/* Check which editor is to be used, default is /usr/bin/me */
	if ((envptr = getenv("EDITOR")) == NULL)
		strcpy(editname,"/usr/bin/me");
	else
		strcpy(editname,envptr);

	/* Ask for address and subject */
	printf("To:  "); gets(toaddr);
	printf("Subj:"); gets(subject);
	if ((tempfile = fopen(filename,"w")) == NULL) {
		fprintf(stderr,"Could not open temporary file %s\n",filename);
		return;
	}

	/* Write subject line into tempfile */
	fprintf(tempfile,"Subject: %s\n\n",subject);
	fclose(tempfile);

	strcat(editname," ");
	strcat(editname,filename);
	system(editname);		/* Edit the file */

	/* Toaddr may need some transforming based on rule files */
	Transform(toaddr);

	printf("Send message to '%s' (y/n)? ",toaddr); gets(resp);
	if (resp[0] == 'y') {
		sprintf(editname,"/bin/mail %s < %s",toaddr,filename);
#ifdef DEBUG
		printf("%s\n",editname);
#endif
		system(editname);		/* Call the mail utility */
	}
	/* We should save the temporary file somewhere */
	unlink(filename);
}

void reply_mail(letterno)
/* Reply to current message */
int letterno;
{
	char filename[80];
	char editname[120];
	char subject[50];
	char toaddr[60];
	char *envptr,*tempname, resp[30];
	FILE *tempfile;

	/* Make name for a temporary file */
	strcpy(filename,mktemp("/tmp/moXXXXXX"));
	if ((envptr = getenv("EDITOR")) == NULL) {
		tempname = isolate_letter(letterno);
		sprintf(editname,"/usr/bin/me %s",tempname);
	} else
		strcpy(editname,envptr);

	/* Make subject line from the original message */
	strcpy(toaddr,letter_calladdr(letterno));
	sprintf(subject,"Re: %s",letter_subject(letterno));

	if ((tempfile = fopen(filename,"w")) == NULL) {
		fprintf(stderr,"Could not open temporary file %s\n",filename);
		exit(1);
	}

	/* Write subject line into tempfile */
	fprintf(tempfile,"Subject: %s\n\n",subject);
	fclose(tempfile);

	strcat(editname," ");
	strcat(editname,filename);
	system(editname);		/* Edit the file */

	/* Toaddr may need some transforming based on rule files */
	Transform(toaddr);
	printf("Send message to '%s' (y/n)? ",toaddr); gets(resp);
	if (resp[0] == 'y') {
		sprintf(editname,"/bin/mail %s < %s",toaddr,filename);
#ifdef DEBUG
		printf("%s\n",editname);
#endif
		system(editname);		/* Call the mail utility */
	}
	/* We should save the temporary file somewhere */
	unlink(filename);
	unlink(tempname);
}
