;	TITLE 	FLEX DISK DRIVER PIM (CODE SEGMENT)
;
;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   04-27-83  I   Original Entry                                       I  RP 
;   06-15-84  I   Enhancements for 02.00.00                            I  RP
;   08-29-84  I   Added special write protection for 48TPI/96TPI       I  WK  
;             I                                                        I 
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;_____________________________________________________________________________
;

	PAGE
     
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP  
;
;    				
;
;    ROUTINE NAME:       DREAD	
;			 DWRITE
;
;
;
;
;
;    FUNCTION:           DREAD - low level READ DATA
;			 DWRITE - low level WRITE DATA
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following variables are set:    
;                        TPI_DR, TPI_DI, BYTSEC, CYLMODE, DRV, HEAD, TRACK,
;			 SECTOR, SECCNT (Number of sectors), SECTRK,
;			 and DMAADDR (SEGMENT and OFFSET)
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DREAD:  			;
	MOV	CL,READDAT	; CL <-- READ DATA COMMAND
	MOV	DMAFUNC,DMAWRT	; DMAFUNC <-- WRITE DMA COMMAND
	JMP	SHORT IO0	;
DWRITE:				;
	MOV	CL,WRITDAT	; CL <-- WRITE DATA COMMAND
	MOV	DMAFUNC,DMAREAD	; DMAFUNC <-- READ DMA COMMAND
				;
	TEST	CONFIG_FLAGS,WT48ON96 ; If writing of 48TPI diskettes enabled
				      ; for 96TPI drives skip protection check
	JNZ	IO0
	MOV	AL,TPI_DI	; If 96 tpi drive
	SUB	AL,TPI_DR	; and
	JNS	IO0		; 48 tpi disk
				; then
	MOV	BYTE PTR ERRBUF,40H ; 'WRITE PROTECT'
	MOV	BYTE PTR ERRBUF+1,02 ;
	RET			;
IO0:				;
	MOV	AL,TPI_DR	; If 48 tpi drive
	SUB	AL,TPI_DI	; and
	JNS	IO1		; 96 tpi disk
				; then
	MOV	BYTE PTR ERRBUF,40H ; 'UNKNOWN MEDIA'
	MOV	BYTE PTR ERRBUF+2,01 ;
	RET			;
IO1:				;
	CMP	SECCNT,0	; Check if an I/O is necessary
	JNZ	IO2		; Jump if necessary
	RET			; Return if not necessary
IO2:				;
				; Check TRACK conflict 
	MOV	BH,00		; --------------------
	MOV	BL,SECTRK	; BX <-- SECTORS PER TRACK
	INC	BL		;
	SUB	BL,SECTOR	; BX - remainding sectors in track
				;
	MOV	AL,CYLMODE	; If CYLINDER MODE
	OR	AL,HEAD		; and HEAD 0
	JNZ	IO3		; 
	ADD	BL,SECTRK	; then add sectors of corresponding track
IO3:				;
	CMP	BX,SECCNT	; Compare remainding sectors with SECCNT
	JB	IO4		; Jump if more than one I/O
	MOV	BX,SECCNT	;
IO4:				; BX - number of sectors fitting in TRACK
				;
				; Check BANK conflict
				; -------------------
	MOV	AX,DMAADDR+2	; AX <-- DMA SEGMENT
	SHL	AX,1		;
	SHL	AX,1		;
	SHL	AX,1		;
	SHL	AX,1		;
	ADD	AX,DMAADDR	; AX <-- absolute addr within BANK
	NEG	AX		; AX <-- remainding bytes within BANK
				;
	PUSH	CX		;
	MOV	CL,BYTSEC	;
	MOV	DX,80H		;
	SHL	DX,CL		; DX <-- sector size
	POP	CX		;
				;
	MOV	SI,DX		; SI <-- sector size
	MOV	DX,0000		; DX <-- 0000
	DIV	SI		; AX <-- number of sectors fitting in BANK
				;
	CMP	AX,BX		; Check if we must do Special Sector Handling
	JB	IO6		; Jump if we must
				;
	JMP	IO15		; Jump around if not
IO6:				;
	XCHG	BX,AX		; BX <-- number of sectors fitting in BANK
	CMP	BX,00		; Check if we must do now Special Sector Handling
	JZ	IO7		; Jump if we must     ---
				;
	JMP	IO15		; Jump around if not 

	PAGE

IO7:				;** Special Sector Handling
				;** -----------------------
	SUB	SECCNT,01	;** SECCNT <-- remainding sectors for next I/O
				;**
	PUSH	CX		;**
	MOV	CL,BYTSEC	;**
	MOV	AX,80H		;**
	SHL	AX,CL		;** AX <-- sector size
	POP	CX		;**
				;**
	MOV	DMALENG,AX	;** DMALENG <-- sector size
				;**
	AND	CL,0FH		;** Clear upper bits
	CMP	CL,WRITDAT	;** Check if WRITE DATA COMMAND
	JNZ	IO9		;** Jump around if not
				;*
				;*
				;*
	PUSH	CX		;* Save CX
	MOV	SI,DMAADDR	;* SI <-- source offset
	MOV	DI,OFFSET SSB	;* DI <-- destination offset
	MOV	CX,DMALENG	;* CX <-- sector size
	SHR	CX,1		;* We move WORDS
	CLD			;* incrementing
	PUSH	DS		;* Save DS
	MOV	AX,DMAADDR+2	;* 
	MOV	DS,AX		;* DS <-- SEGMENT of TRANSFER ADDR
	POP	ES		;*
	PUSH	ES		;* ES <-- our SEGMENT of Special Sector Buffer
				;*
				;* W R I T E  D A T A  C O M M A N D:
REP	MOVSW			;* Move BANK into Special Sector Buffer
				;* ------------------------------------
	POP	DS 		;* Restore DS
	POP	CX		;* Restore CX
				;*
				;*
				;*
IO9:				;**
	MOV	AX,DMAADDR	;** 
	PUSH	AX		;** Save DMA OFFSET
	MOV	AX,DMAADDR+2	;**
	PUSH	AX		;** Save DMA SEGMENT
				;**
	MOV	AX,OFFSET SSB	;**
	MOV	DMAADDR,AX	;** new OFFSET <-- Special Sector Buffer
	MOV	AX,DS		;**
	MOV	DMAADDR+2,AX	;** new SEGMENT <-- our SEGMENT
				;**
	CALL	IO		;** Do I/O
				;** ------
	JC	IO10		;** Jump if normal termination
	POP	AX		;** else 
	POP	AX		;** flush STACK
	RET			;** and return with bad status in ERRBUF
IO10:				;**
	POP	AX		;**
	MOV	DMAADDR+2,AX	;** Restore DMA SEGMENT
	MOV	ES,AX		;**
	POP	AX		;**
	MOV	DMAADDR,AX	;** Restore DMA OFFSET
				;**
				;**
				;**
	AND	CL,0FH		;** Clear upper bits
	CMP	CL,READDAT	;** Check if READ DATA COMMAND
	JNZ	IO11		;** Jump around if not
				;*
	PUSH	CX		;* Save CX
	MOV	SI,OFFSET SSB	;* SI <-- source offset
	MOV	DI,DMAADDR	;* DI <-- destination offset
	MOV	CX,DMALENG	;* CX <-- sector size
	SHR	CX,1		;* We move WORDS
	CLD			;* incrementing
				;* R E A D  D A T A  C O M M A N D:
REP	MOVSW			;* Move Special Sector Buffer into BANK
				;* ------------------------------------
	POP	CX		;* Restore CX
				;*
				;*
IO11:				;**
	MOV	BX,0001		;** BX - number of sectors of previous I/O
	JMP	IO30		;** Jump to update variables for next I/O

	PAGE

IO15:				; BX - number of sectors for I/O
	PUSH	BX		; ------------------------------
	SUB	SECCNT,BX	; SECCNT <-- remainding sectors for next I/O
				;
	PUSH	CX		;
	MOV	CL,BYTSEC	;
	MOV	AX,80H		;
	SHL	AX,CL		; AX <-- sector size
	POP	CX		;
				;
	MUL	BX		; * sectors for I/O gives DMA LENGTH
	MOV	DMALENG,AX	; DMALENG <-- DMA LENGTH
				;
	CALL	IO		; Do I/O
				; ------
	JC	IO17		; Jump if normal termination
	POP	AX		; else flush STACK
	RET			; and return with bad status in ERRBUF
IO17:				;
	POP	BX		; BX - number of sectors of previous I/O
	JMP	IO30		; Jump to update variables for next I/O

	PAGE

IO:				; Disk I/O
				; --------
 	MOV	AL,RETRIES	; AL <--  retry counter
IO20:				;
	PUSH	AX		; Save retry counter
	CALL    SETUP9		; Set up COMMAND STRING and DMA  
	CALL	XWAIT		; Send COMMAND STRING to FDC 
 	CALL	GETBYT		; Get STATUS BYTES
	POP	AX		; Restore retry counter
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JNZ	IO21		; Jump on error
	STC			; Set status flag
	RET			; Return with good status
				;
				;
				;
IO21:				;
	TEST	ERRBUF,08H	; Test for 'NOT READY'
	JZ	IO22		;
	CLC			; Set status flag
	RET			; Return immediately if disk 'NOT READY'
IO22:				;
	TEST	ERRBUF+1,02H	; Test for 'WRITE PROTECTED'
	JZ	IO23		;
	CLC			; Set status flag
	RET			; Return immediately if 'WRITE PROTECTED'
IO23:				;
	TEST	ERRBUF,80H	; Test for 'INVALID COMMAND'
	JZ	IO24		;
	CLC			; Set status flag
	RET			; Return immediately if 'INVALID COMMAND'
IO24:				;
	DEC	AL		; Decrement retry counter
	JZ  	IO25		; Jump to exit with bad status
				;
	PUSH	AX		; Save retry counter
	CALL	DREST  		; Do a low level RESTORE
	POP	AX		; Restore retry counter
	JMP   	IO20   		; Do retries
				;
				;
				;
IO25:				;
	CLC			; Set status flag
	RET        		; Return with bad status                      

	PAGE

IO30:				; Update variables for next I/O
				; -----------------------------
				; BX - number of sectors of previous I/O
				;
	CMP	SECCNT,0	; Check if another I/O is necessary
	JNZ	IO31		; Jump if necessary
	RET			; Return if not necessary
IO31:				;
	MOV	DX,DMALENG	; DX <-- previous DMA LENGTH
	SHR	DX,1		;
	SHR	DX,1		;
	SHR	DX,1		;
	SHR	DX,1		; DX - previous DMA LENGTH in paragraphs
	ADD	WORD PTR DMAADDR+2,DX ; Update DMAADDR (SEGMENT)
				;
	ADD	SECTOR,BL	; Update SECTOR variable
	MOV	AL,SECTRK	; AL <-- sectors per track
				;
	CMP	CYLMODE,00	; Check if CYLINDER MODE
	JZ	IO34		; Jump if CYLINDER MODE
				;
				; Not CYLINDER MODE
				; -----------------
	CMP	AL,SECTOR	; Check for legal SECTOR variable
	JB	IO32		; Jump if not legal
				;
	JMP	IO1		; Do next I/O
IO32:				;
	MOV	SECTOR,1	; Set SECTOR to begin of track
	CMP	TRACK,39	; Check if side 1 is full
	JZ	IO33		; Jump if full
				;
	INC	TRACK		; Increment TRACK
	JMP	IO1		; Do next I/O
IO33:				;
	MOV	HEAD,1		; If side 1 is full
	MOV	TRACK,0		; then initialize for side 2
	JMP	IO1		; Do next I/O
IO34:				;
	       			; CYLINDER MODE
    				; -------------
	CMP	AL,SECTOR	; Check for legal SECTOR variable
	JB	IO35		; Jump if not legal
				;
	JMP	IO1		; Do next I/O
IO35:				;
	CMP	HEAD,1		; Check if cylinder is full
	JZ	IO36		; Jump if full
				;
	SHL	AL,1		; AL <-- sectors per cylinder
	CMP	AL,SECTOR	; Check if cylinder is full
	JB	IO36		; Jump if full
				;
	SHR	AL,1		; AL <-- sectors per track
	SUB	SECTOR,AL	; Set SECTOR variable within
	MOV	HEAD,1		; corresponding track with HEAD 1
	JMP	IO1		; Do next I/O
IO36:				;
	INC	TRACK		; Increment TRACK        
	MOV	HEAD,0		; Set HEAD 0
	MOV	SECTOR,1	; Set SECTOR to begin of cylinder
	JMP	IO1		; Do next I/O

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DREST
;
;
;
;
;
;    FUNCTION:           Low level RESTORE
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   DRV variable is set
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    CL - preserved
;			 STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DREST:				;
	MOV	AH,02		; Special retry for CP/M
				;
DREST1:				; Set up COMMAND STRING 
				; ---------------------
	MOV	COMSTR,2	; COMMAND STRING <-- LENGTH 2	
	MOV	COMSTR+1,RESTORE; 	         <-- RESTORE COMMAND
	MOV	AL,DRV	        ;
   	MOV     COMSTR+2,AL     ;	         <-- DRIVE NUMBER
				;
	PUSH	AX		; Save retry counter
 	CALL	XWAIT		; Send COMMAND STRING to FDC
DREST2:				;	
	IN	AL,SYSSTA	; Wait on interrupt
	AND	AL,08		; Test DISK INTERRUPT BIT
	JZ	DREST2		; Jump if no interrupt
				;
	CALL  	DSIS		; Reset interrupt via low level SENSE
				; INTERRUPT STATUS
				;
	POP	AX		; Restore retry counter
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	DREST3		; Jump if normal termination	
				;
	DEC	AH		; Decrement retry counter
	JNZ	DREST1		; Do special retry !
DREST3:				; Reason: MOTOR OFF & RESTORE in CP/M
	RET			; 

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DSEEK
;
;
;
;
;
;    FUNCTION:           Low level SEEK A TRACK
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following variables are set:
;			 TPI_DR, TPI_DI, DRV, HEAD, and TRACK                  
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    CL - preserved
;			 STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE

DSEEK:				; Set up COMMAND STRING 
				; ---------------------
	MOV	COMSTR,3  	; COMMAND STRING <-- LENGTH 3
 	MOV	COMSTR+1,SEEKTRK;                <-- SEEK COMMAND
	MOV	AL,HEAD         ;   
	SHL	AL,1		;
	SHL	AL,1		;
	OR 	AL,DRV		;
	MOV	COMSTR+2,AL	;                <-- DRIVE & HEAD
	MOV	AL,TRACK	;		 
				;
	MOV	AH,TPI_DI	;
	CMP	AH,TPI_DR	; Check if tpi from disk and drive are equal
	JZ	DSEEK1		; Jump if equal
				; else
	SHL	AL,1		; 48 tpi disk in 96 tpi drive
DSEEK1:				;
	MOV	COMSTR+3,AL	;		 <-- TRACK
				;
	CALL	XWAIT		; Send COMMAND STRING to FDC
DSEEK2:				;
	IN	AL,SYSSTA	; Wait on interrupt
	AND	AL,08		; Test DISK INTERRUPT BIT
	JZ	DSEEK2		; jump if no interrupt
				;
	CALL 	DSIS		; Reset interrupt via low level SENSE
				; INTERRUPT STATUS
	RET			; 

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/02/14      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DREADID
;
;
;
;
;
;    FUNCTION:           Low level READ ID
;			 (Used to get SECTOR SIZE)
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following variables are set:
;			 DRV and HEAD
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    STATUS and BYTES PER SECTOR (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DREADID:			; Set up COMMAND STRING
				; ---------------------
	MOV	COMSTR,2	; COMMAND STRING <-- LENGTH 2
	MOV	AL,IDREAD	;		
	OR	AL,DENSITY	;
	MOV	COMSTR+1,AL	;		 <-- READ ID COMMAND & DENSITY
	MOV	AL,HEAD		;
	SHL	AL,1		;
	SHL	AL,1		;
	OR	AL,DRV		;
	MOV	COMSTR+2,AL	;		 <-- DRIVE & HEAD
				;
	CALL	XWAIT		; Send COMMAND STRING to FCB
	CALL	GETBYT		; Get STATUS BYTES (sector size)
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DSIS
;
;
;
;
;
;    FUNCTION:           Low level SENSE INTERRUPT STATUS
;                        (used to reset interrupt)
;      
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DSIS:				; Set up COMMAND STRING 
				; ---------------------
	MOV  	COMSTR,1 	; COMMAND STRING <-- LENGTH 1
	MOV	COMSTR+1,FDCSIS ;                <-- FDCSIS COMMAND
				;
	CALL	XWAIT		; Send COMMAND STRING to FDC
	CALL	GETBYT		; Get STATUS BYTES
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DFORMAT
;
;
;
;
;
;    FUNCTION:           Low level FORMAT A TRACK
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following variables are set:
;			 TPI_DR, TPI_DI, BYTSEC, DRV, HEAD, TRACK,
;			 SECTRK, PATTERN,
;			 and DMAADDR (SEGMENT and OFFSET)
;
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DFORMAT:			;
	MOV	CL,WRITFMT	; CL <-- FORMAT COMMAND
	MOV	DMAFUNC,DMAREAD	; DMAFUNC <-- READ DMA COMMAND
	MOV	BH,00		;
	MOV    	BL,SECTRK	;
	SHL	BX,1		;
	SHL	BX,1		;
	MOV	DMALENG,BX	; DMALENG <-- DMA LENGTH (SECTRK*4)
				;
	CALL	SETUP6  	; Set up COMMAND STRING and DMA
	CALL	XWAIT		; Send COMMAND STRING to FDC
	CALL	GETBYT		; Get STATUS BYTES
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       SETUP9
;
;
;
;
;
;    FUNCTION:           Set up (9 byte) COMMAND STRING and DMA 
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   CL - COMMAND
;			 Following variables are set:
;                        TPI_DR, TPI_DI, BYTSEC, CYLMODE, DRV, HEAD, TRACK,
;			 SECTOR, SECTRK
;			 DMAADDR (SEGMENT and OFFSET)
;			 DMALENG and DMAFUNC
;                	
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE	
SETUP9:				;
	CALL    DSEEK    	; First do low level SEEK A TRACK
				;
	MOV	COMSTR,9 	; COMMAND STRING <-- LENGTH 9
	OR	CL,DENSITY	;
	CMP	CYLMODE,00	;
	JNZ	SET1		;
				;
	OR	CL,80H		;
SET1:				;
	MOV    	COMSTR+1,CL     ;                <-- FUNCTION & DENSITY	& MT
	MOV	AL,HEAD         ;
	SHL	AL,1		;
	SHL	AL,1		;
	OR	AL,DRV		;
	MOV 	COMSTR+2,AL     ;                <-- DRIVE & HEAD
	MOV	AL,TRACK	;
	MOV 	COMSTR+3,AL     ;                <-- TRACK
	MOV	AL,HEAD		;
	MOV	COMSTR+4,AL     ;         	 <-- HEAD
	MOV	AL,SECTOR	;
	MOV	COMSTR+5,AL     ;              	 <-- SECTOR
	MOV	AL,BYTSEC	;
	MOV	COMSTR+6,AL	;                <-- BYTES PER SECTOR
        MOV	AL,SECTRK	;
     	MOV	COMSTR+7,AL	;                <-- SECTORS PER TRACK
     	MOV	AL,GPL		;
	MOV	COMSTR+8,AL	;		 <-- GAP LENGTH
	MOV	COMSTR+9,0FFH   ;                <-- DTL 
				;
	CALL	DMA		; Initialize DMA
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       SETUP6
;
;
;
;
;
;    FUNCTION:           Set up (6 byte) COMMAND STRING and DMA
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   CL - (FORMAT) COMMAND
;			 Following variables are set:
;			 TPI_DR, TPI_DI, BYTSEC, DRV, HEAD, TRACK, PATTERN              
;			 DMAADDR (SEGMENT and OFFSET)
;			 DMALENG and DMAFUNC
;   
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
SETUP6:				;
	CALL	DSEEK		; First do low level SEEK A TRACK
  				; 
	MOV	COMSTR,6	; COMMAND STRING <-- LENGTH 6
	OR      CL,DENSITY      ;
	MOV	COMSTR+1,CL     ;                <-- FUNCTION & DENSITY
	MOV	AL,HEAD         ;
	SHL	AL,1		;
	SHL	AL,1		;
	OR	AL,DRV		;
   	MOV 	COMSTR+2,AL     ;                <-- DRIVE & HEAD
	MOV	AL,BYTSEC	;
	MOV	COMSTR+3,AL	;                <-- BYTES PER SECTOR
	MOV	AL,SECTRK	;
	MOV	COMSTR+4,AL	;                <-- SECTORS PER TRACK
	MOV	COMSTR+5,50H    ;                <-- GAP LENGTH
	MOV	AL,PATTERN	;
	MOV	COMSTR+6,AL	;                <-- PATTERN
				;
	CALL	DMA		; Initialize DMA
 	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       XWAIT
;
;
;
;
;
;    FUNCTION:           Send COMMAND STRING to FDC
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    CL - preserved
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
XWAIT:				;
	CALL	MOTORCK		; SWITCH MOTOR ON
				;
  	MOV	CH,COMSTR       ; CH <-- COMMAND STRING LENGTH
	MOV	BX,OFFSET COMSTR; BX <-- Addr of COMMAND STRING
XWAIT1:				;
	INC	BX		; 
	CALL	FDCRDY		; Wait until FDC is ready
	MOV	AL,BYTE PTR [BX]; AL <-- next COMMAND STRING byte
	OUT	DCOMD,AL	; Send byte to FDC
	DEC	CH		; Decrement counter
	JNZ	XWAIT1		; Loop until last byte
				;
	CALL	FDCRDY		; Wait until FDC is ready
				;
	MOV	AL,07		;
	OUT	DMAMB,AL  	; Disable DMA CHANNEL  	
	RET			;

 	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       GETBYT
;
;
;
;
;
;    FUNCTION:           Get STATUS BYTES into ERRBUF
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE            
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
GETBYT:				; 
	MOV	BX,OFFSET ERRBUF; BX <-- Addr of ERROR BUFFER
GETBYT1:			;
	IN 	AL,FDCRA	; Read STATUS BYTE from FDC
	MOV	BYTE PTR [BX],AL; into ERROR BUFFER
	INC	BX		; 
	CALL	FDCRDY		; Wait until FDC is ready
	TEST	AL,40H		; Check if FDC has another byte
	JNZ	GETBYT1		; Jump to fetch next byte 
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       FDCRDY
;
;
;
;
;
;    FUNCTION:           Wait until FDC is ready
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE        
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
FDCRDY:				;
	IN	AL,DSTAT	; AL <-- DISK STATUS
	TEST	AL,80H		; Test MASTER REQUEST BIT
	JZ 	FDCRDY		; Jump if no MASTER REQUEST (means: in execution)
				;
	RET			; Return if FDC is ready
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       MOTORCK
;
;
;
;
;
;    FUNCTION:           Check if motor is on
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    Motor is on
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
MOTORCK:			;
	IN	AL,SYSSTA	; AL <-- SYSTEM STATUS
	AND 	AL,01		; Test DISK MOTOR ON BIT
	OUT	MOTORON,AL	; Switch motor on
	JNZ 	MOTORCK1	;
	RET			; Return if motor was on
MOTORCK1:			;
	MOV	BX,0FFFFH	; Wait some time if motor was off 
MOTORCK2:			;
	AAM			; (83)
	DEC	BX		; ( 2)
	JNZ	MOTORCK2	; ( 8)  = 93 CLOCKS * FFFF = 1 sec
				;
	RET			;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/01/26      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DMA
;
;
;
;
;
;    FUNCTION:           DMA routines
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following variables are set:
;			 DMAADDR (SEGMENT and OFFSET)        	
;			 DMALENG and DMAFUNC
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DMA:				;
	MOV	AL,DMAFUNC	; DMAFUNC <-- DMA FUNCTION
  	OUT	DMAMO,AL	; OUT MODE
				;
	MOV	AX,DMAADDR+2    ; AX <-- DMA SEGMENT
	SHL	AX,1		; 
	SHL	AX,1		; 	
	SHL	AX,1   		;  
	SHL	AX,1		; 
	ADD	AX,DMAADDR  	; AX <-- absolute addr within BANK
	OUT	COAD,AL		; OUT DMA ADDR low
	MOV	AL,AH		;
	OUT	COAD,AL		; OUT DMA ADDR high
				;
	MOV	AX,DMALENG	; AX <-- DMA LENGTH
	DEC	AX		; 
	OUT	COTC,AL		; OUT DMA LENGTH low
	MOV	AL,AH		;
	OUT 	COTC,AL		; OUT DMA LENGTH high
				;
	MOV	DH,00		;
	MOV	DL,BANK		; DX - BANK 0 initialisation
	ADC	DL,00		; DX - next BANK if SEGMENT + OFFSET > 64K		
				;
	MOV	AX,DMAADDR+2	; AX <-- DMA SEGMENT
	SHR	AH,1		;
	SHR	AH,1		;
	SHR	AH,1		;
	SHR	AH,1		;     
	ADD	DL,AH		; DX <-- BANK SELECT PORT
				;
	OUT	DX,AL		; SELECT BANK
				; -----------
	MOV 	AL,03		;  
   	OUT	DMAMB,AL	; Enable FDC CHANNEL  	
	RET			;
