
;	TITLE	FLEX DISK DRIVER PIM (DATA SEGMENT)
;
;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   04-27-83  I   Original Entry                                       I  RP 
;   06-15-84  I   Enhancements for 02.00.00                            I  RP
;   08-29-84  I   Added special write protection for 48TPI/96TPI       I  WK  
;             I                                                        I 
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;_____________________________________________________________________________
;

	PAGE      

;******************
;*** MODE FLAGS ***
;******************
;
;
WT48ON96  EQU	02H		; Bit 1 set in CONFIG_FLAGS enables writing
;				; to 48TPI diskettes on 96TPI drives
;
;
;
;******************* 
;***  I/O PORTS  ***     
;*******************
;
;
; FDC
; ---
;
DCOMD	EQU	51H		; DISK COMMAND PORT
DSTAT	EQU	50H 		; DISK STATUS PORT
FDCRA	EQU	51H		; READ DMA FROM FDC PORT
;
;
;
; DMA
; ---
;
DMAMB	EQU	2AH		; WRITE SINGLE MASK REGISTER BIT
DMAMO	EQU	2BH		; DMA MODE PORT
COAD	EQU	26H		; DMA ADDR PORT
COTC	EQU	27H		; DMA LENGTH PORT
;
;
;
; SYSTEM STATUS
; -------------
;
SYSSTA	EQU	13H		; SYSTEM STATUS PORT
MOTORON	EQU	14H		; MOTOR ON PORT
;
;
;
; BANK SELECT
; -----------					
;
BANK  	EQU	0E0H		; BANK SELECT E0 :    0K -  64K
				;	      E1 :   64K - 128K
				;	      E2 :  128K - 196K
 				;	      E3 :  196K - 256K
;
;
;
	PAGE
;
;
;
;**********************                   
;***  FDC COMMANDS  ***
;**********************
;
; 
READTRK	EQU	02H		; READ TRACK COMMAND
SPECIFY	EQU	03H		; SPECIFY COMMAND
WRITDAT	EQU	05H		; WRITE DATA COMMAND
READDAT	EQU	06H		; READ DATA COMMAND
RESTORE	EQU	07H		; RESTORE COMMAND
FDCSIS	EQU	08H		; SENSE INTERRUPT STATUS
IDREAD	EQU	0AH		; READ ID COMMAND
WRITFMT	EQU	0DH		; FORMAT A TRACK
SEEKTRK	EQU	0FH		; SEEK A TRACK
;
;
;
;
;***********************             
;***  FDC VARIABLES  ***             
;***********************             
;
;
CYLMODE	DB	00		; 0 = CYLINDER MODE, 1 = not CYLINDER MODE
DRV	DB	00		; DRIVE NUMBER           
HEAD	DB	00		; HEAD NUMBER         
TRACK	DB	00		; TRACK NUMBER         
SECTOR	DB	00		; SECTOR NUMBER         
 				;
SECCNT	DW	0000		; Number of sectors for I/O
;
;
COMSTR	DB 	00		; COMMAND STRING LENGTH
	DB	00		; COMMAND STRING (max. 9 bytes)
	DB	00		;
	DB	00		;
	DB	00		;
	DB	00		;
	DB	00		;
	DB	00		;
	DB	00		;
	DB	00		;
				;
ERRBUF	DB	00		; STATUS BYTE 0
	DB	00		; STATUS BYTE 1
	DB	00		; STATUS BYTE 2
	DB	00		; CYLINDER/TRACK
	DB	00		; HEAD 0 or HEAD 1
	DB	00		; SECTOR
	DB	00		; SECTOR SIZE
				;
				;
				;
	PAGE
;
;
;
;**********************   
;***  DMA COMMANDS  ***
;**********************
;
;
DMAWRT	EQU	47H		; WRITE DMA COMMAND
DMAREAD	EQU	4BH		; READ DMA COMMAND
;
;
;
;
;*********************** 
;***  DMA VARIABLES  ***
;***********************
;
;
DMAADDR DW	0000		; DMA ADDR OFFSET 
	DW	0000		;	   SEGMENT
				;
DMALENG	DW	0000		; DMA LENGTH
DMAFUNC	DB	00		; DMA FUNCTION
;	
;
;
	PAGE
;
;
;
;************************
;***  DISK VARIABLES  ***    
;************************
;
;
TPI_DR	DB	00		; 0 = 48 tpi, 1 = 96 tpi drive
				;
TPI_DI	DB	00		; 0 = 48 tpi, 1 = 96 tpi disk
				;
SECTRK	DB 	08		; SECTORS PER TRACK
DENSITY	DB 	40H		; DOUBLE DENSITY BIT (MFM)
BYTSEC	DB 	02		; BYTES PER SECTOR (N): 00 - 128 bytes
				;			01 - 256 bytes
				;			02 - 512 bytes
				;			   .
				;			   .
				; 			   .	        
GPL	DB 	1BH		; GAP LENGTH
 				;
PATTERN	DB 	0F6H		; FORMAT PATTERN
				;
RETRIES	DB 	05		; Number of retries 
;
;
;
	PAGE
;
;
;
SSB	DW	0000		; Special Sector Buffer for BANK conflict
				; (not expanded for some CP/M O.S.)
