PAGE 65,132
TITLE	CONSOLE DRIVER FOR NCR DECISION MATE 5
;
;
;******************************************************************************
;		**						**
;		**	   C O N S O L E   D R I V E R		**
;		**						**
;		**		      F O R			**
;		**		               			**
;		**    N C R   D E C I S I O N   M A T E   5	**
;		**		               			**
;******************************************************************************
;*****************						***************
;*****************		 CHANGE SHEET			***************
;*****************						***************
;******************************************************************************
;
;
;------------------------------------------------------------------------------
;  06-26-84  I  ORIGINAL ENTRY					        I  HE
;	     I							        I
;  07-04-84  I	SPAR Q2798 CORRECTED  (BAD CURSOR POSITIONING AFTER	I  HE
;            I			      SCREEN FULL)			I
;	     I							        I
;  07-04-84  I	SPAR Q2799 CORRECTED  (BAD ATTRIBUTE AFTER DELETING A	I  HE
;	     I			      CHARACTER)			I
;	     I							        I
;  07-05-84  I	SPAR Q2809 CORRECTED  (SCROLLING AFTER SWITCHING 24	I  HE
;	     I			      LINES WITH MODE COMMAND)	        I
;	     I							        I
;  07-05-84  I	SPAR G2823 CORRECTED  (UNNECESSARY PUSH AND POP         I  HE
;	     I			      STATEMENTS DELETED)	        I
;	     I							        I
;  07-20-84  I	SPAR Q2866 CORRECTED  (REVERSE LINEFEED AFTER SCREEN	I  HE
;	     I			      FILLED)				I
; 	     I							        I
;  07-20-84  I	SPAR G2878 CORRECTED  (DISPLAY OF CHARCTERS BELOW 20H)	I  HE
;	     I							        I
;  07-23-84  I	SPAR Q2864 CORRECTED  (CTL-P AS FUNCTION KEY)		I  HE
;	     I							        I
;  07-25-84  I	SPAR G____ CORRECTED  (REVERSE LINEFEED)		I  HE
;	     I							        I
;------------------------------------------------------------------------------
PAGE
;
;
;******************************************************************************
;	
;		    P U B L I C S   A N D   E X T E R N A L S
;
;******************************************************************************
;
;      
PUBLIC	FUNCTBL,CUU,CUD,CUF,CUB,CUP,ED,EL,SGR,PSCP,PRCP,DEFFK,XDSR,BELL,BACKSP
PUBLIC	LINEFD,RLF,NDFS,CARRET,VHOME,SHALF_INT,RHALF_INT,BLEOS,INSLIN,DELLIN
PUBLIC	ICHR,DCHR,POSIT,PLAY_MUSIC,REVERSE,I29_HANDLER,KBD_BUFF_IN,CON_INT
PUBLIC	ST12,KBD_FL,I16_HANDLER,H2
;
;
EXTRN	CRTACTTBL:NEAR,CMDTABL:BYTE		;TABLES
EXTRN	COMTBL:BYTE,ETBLENT:WORD
EXTRN	ESCTBL:BYTE,KBD_RDEF_TBL:NEAR
;
EXTRN	CURSOR_TYPE:BYTE			;VARIABLES IN THE COMMON AREA
EXTRN	CONSOLE_FLAGS:BYTE
EXTRN	CRT_ROWS:BYTE
;
EXTRN	INP_BUF:BYTE				;NEEDED FOR KEYBOARD DRIVER
EXTRN	BUF_A:WORD
EXTRN	BUF_E:WORD
;
EXTRN	LINBUF:BYTE				;NEEDED FOR CRT DRIVER
EXTRN	PARMS:BYTE
EXTRN	LASTPRM:BYTE
;
EXTRN	PTRSAV:DWORD				;POINTER TO I/O-PACKET
;
;
PAGE
;
;
CSEG	SEGMENT PUBLIC 'CODE'
	ASSUME DS:CSEG,CS:CSEG,SS:CSEG
;
;
;******************************************************************************
;	
;		  I / O - P A C K E T   S T R U C T U R E
;
;******************************************************************************
;
;
IODAT   STRUC
;
	CMDLEN  DB      ?               	;LENGTH OF THIS COMMAND
		DB      ?               	;NOT USED FOR CHARACTER DEVICES
	CMD     DB      ?               	;COMMAND CODE
	STATUS  DW      ?               	;STATUS
	        DB      8 DUP (?)		;RESERVED
	NDREAD	DB      ?               	;NONDESTRUCTIVE READ BYTE
	TRANS   DD      ?               	;TRANSFER ADDRESS
	COUNT   DW      ?               	;COUNT OF BLOCKS OR CHARACTERS
;
IODAT   ENDS
;
;
PAGE
INCLUDE FUNCTBL.INC
PAGE
;
;
;**********
; RELEASE *
;**********
;
RELEASE_ID	DB	2,3,0
;
;
;******************************************************************************
;	
;		C O N S O L E   I N T E R R U P T   E N T R Y		
;
;******************************************************************************
;
;
CON_INT:
        PUSH    SI				;SAVE REGISTERS THAT WILL
	PUSH    AX              		;BE CHANGED
        PUSH    CX
        PUSH    DI
        PUSH    DS
	PUSH	ES
	PUSH	BX
	LDS	BX,CS:PTRSAV			;GET IO-PACKET POINTER
        MOV     CX,[BX.COUNT]   		;GET # OF TRANSFER BYTES
        MOV     AL,[BX.CMD]     		;GET COMMAND CODE
        CMP	AL,08H				;WRITE COMMAND ?
	JNZ	NO_WRITE			;NO - CONTINUE
	JMP	CON_WRIT			;YES - JUMP TO OUTPUT ROUTINE
;
NO_WRITE:
	CMP     AL,12           		;VALID COMMAND CODE ?
        JNA	COM_OK
	MOV	AL,3
	JMP	ERROR	         		;NO - RETURN AN ERROR
;
COM_OK:
        XOR     AH,AH           		;CLEAR AH FOR CALCULATION
        MOV     SI,OFFSET CONTBL		;GET POINTER TO COMMAND TABLE
        ADD     SI,AX           		;COMPUTE JUMP ADDRESS ACCORDING
        ADD     SI,AX				;TO COMMAND CODE
        MOV	AL,[BX.CMDLEN]			;GET LENGTH OF I/O-PACKET
	LES     DI,[BX.TRANS]   		;GET TRANSFER ADDR. INTO ES:DI
        PUSH    CS				;GET CORRECT DATA SEGMENT
        POP     DS
        JMP     [SI]            		;PERFORM I/O PACKET COMMAND
;
;
PAGE
;
;
;******************************************************************************
;	
;			E X I T S   T O   M S - D O S		
;
;******************************************************************************
;
;
;**************
; NORMAL EXIT *
;**************
;
EXITP	PROC	FAR
;
EXIT:
	MOV     AH,00000001B    		;SET DONE BIT FOR MSDOS
;
EXIT1:
	LES	BX,CS:PTRSAV
	MOV     ES:[BX.STATUS],AX  		;SEND STATUS TO MS-DOS
        POP	BX
	POP	ES
	POP     DS				;RESTORE REGISTERS
        POP     DI
        POP     CX
        POP     AX
        POP     SI
        RET                             	;RETURN TO MS-DOS
;
EXITP	ENDP
;
;
;************
; BUSY EXIT *
;************
;
BUS_EXIT:
        MOV     AH,00000011B    		;SET BUSY AND DONE BITS
        JMP     SHORT EXIT1
;
;
PAGE
;
;
;*************
; ERROR EXIT *
;*************
;
;	ENTRY:	AL MUST CONTAIN ACTUAL ERROR CODE
;
;		ERROR #	 0 = WRITE PROTECT VIOLATION
;           		 1 = UNKOWN UNIT
;           		 2 = DRIVE NOT READY
;           		 3 = UNKNOWN COMMAND IN I/O PACKET
;           		 4 = CRC ERROR
;           		 5 = BAD DRIVE REQUEST STRUCTURE LENGTH
;           		 6 = SEEK ERROR
;           		 7 = UNKNOWN MEDIA DISCOVERED
;           		 8 = SECTOR NOT FOUND
;           		 9 = PRINTER OUT OF PAPER
;          		10 = WRITE FAULT
;          		11 = READ FAULT
;          		12 = GENERAL FAILURE
;
ERROR:
        MOV     AH,10000001B    		;SET ERROR AND DONE BITS
        STC                     		;SET CARRY BIT ALSO
        JMP     SHORT EXIT1     		;QUICK WAY OUT
;
;
PAGE
;
;
;******************************************************************************
;	
;	     C O N S O L E   C O M M A N D   J U M P   T A B L E
;
;******************************************************************************
;
;
CONTBL:
	DW      CONSOLE_INIT        		;0  - CONSOLE INIT            
        DW      EXIT            		;1  - NOT USED
        DW      EXIT            		;2  - NOT USED
        DW      CTL_READ   			;3  - IO CONTROL READ
        DW      KEY_IN          		;4  - CHARACTER READ
        DW      KEY_ND_IN       		;5  - NONDEST. CHARACTER READ
        DW      KEY_ST          		;6  - RETURN STATUS            
        DW      KEY_IN_FL       		;7  - FLUSH INPUT BUFFER
        DW      CON_WRIT        		;8  - CHARACTER WRITE
        DW      CON_WRIT        		;9  - CHARACTER WRITE (VERIFY)
        DW      EXIT            		;10 - NOT USED
        DW      EXIT            		;11 - NOT USED
        DW      CTL_WRIT			;12 - IO CONTROL WRITE
;
;
PAGE
INCLUDE CONDATA.INC
PAGE
;
;
;******************************************************************************
;
;		C O N S O L E   I N I T I A L I Z A T I O N
;
;******************************************************************************
;
;
CONSOLE_INIT:
	CMP  	AL,SRH_INIT_L			;CORRECT LENGTH OF I/O-PACKET ?
	JAE	CONSOLE_INIT_1                  ;NO - THEN RETURN AN ERROR
	MOV	AL,5
	JMP	ERROR
;
CONSOLE_INIT_1:
	MOV	BYTE PTR FLAG_BUF,00H		;RESET ALL OPERATION FLAGS 
	MOV	AL,CURSOR_TYPE			;INSTALL REQUESTED CURSOR
	MOV	BYTE PTR CURST_1+1,AL
	MOV	AL,CURSOR_TYPE+1
	MOV	BYTE PTR CURST_2+1,AL
	MOV	AL,CURSOR_TYPE+2
	MOV	BYTE PTR CURST_3+1,AL
	CALL	CURON
	CALL	LINES_INIT
	JMP	EXIT
;
LINES_INIT:					;INITIALIZE PROGRAM ACCORDING
	MOV	AL,CRT_ROWS			;TO # OF CRT LINES
	DEC	AL
	MOV	CRT_ROWM1,AL
	MOV	BYTE PTR LINE_CHECK+4,AL
	CMP	AL,23
	JNZ	INIT25
	MOV	AX,OFFSET SCROLL_24
	SUB	AX,OFFSET THIRD_JUMP+2
	MOV	BYTE PTR THIRD_JUMP+1,AL
	MOV	AX,OFFSET ILF1
	SUB	AX,OFFSET SCRL_JUMP+2
	MOV	BYTE PTR SCRL_JUMP+1,AL
	RET
;
INIT25:
	MOV	AX,OFFSET SCROLL_25
	SUB	AX,OFFSET THIRD_JUMP+2
	MOV	BYTE PTR THIRD_JUMP+1,AL
	MOV	AX,OFFSET NO_SAVE
	SUB	AX,OFFSET SCRL_JUMP+2
	MOV	BYTE PTR SCRL_JUMP+1,AL
	RET
;
;
PAGE
INCLUDE KBDCODE.INC
PAGE
INCLUDE CRTCODE.INC
;
;
CSEG	ENDS
;
;
END
