;
;
;******************************************************************************
;	
;		C O N S O L E   D R I V E R   E Q U A T E S
;
;******************************************************************************
;
;
;*******************
; KEYBOARD EQUATES *
;*******************
;
KEYBASE		EQU	40H			;NO OF CONTROLLER
RDKEY		EQU	KEYBASE			;INPUT FROM KEYBOARD
RSKEY		EQU	KEYBASE+1		;STATUS ADDR OF KEYBOARD
KBELL		EQU	KEYBASE+1		;ADDR FOR OUTPUT A BELL
BEEP		EQU	07H			;COMMAND TO SEND A BEEP
INPBUFF86	EQU	02H			;FLAG FOR OUTPUT TO KBD FULL
KBDAT86		EQU	01H			;FLAG FOR INPUT FROM KBD READY
;
;
;**************
; GDC EQUATES *
;**************
;
GDCSTA		EQU	0A0H			;GDC STATUS PORT
FIFO		EQU	0A1H			;GDC FIFO PORT ADDR
GDCPAR		EQU	0A0H			;PARAMETER INTO FIFO
GDCCOM		EQU	0A1H			;COMMAND INTO FIFO
DATRDY		EQU	01H			;A BYTE IS AVAILABLE TO READ
FIFULL		EQU	02H			;FIFO IS FULL
FIEMPTY		EQU	04H			;FIFO IS EMPTY
CCHAR		EQU	04BH			;CURS. & CHAR. CHARACTERISTICS
CURS		EQU	049H			;SPECIFY CURSOR POSITION
MASKREG		EQU	04AH			;LOAD MASK REGISTER
FIGS		EQU	04CH			;SPECIFY FIGURE DRAWING PARA
PRAM		EQU	070H			;LOAD PARAMETER RAM
WDAT		EQU	020H			;WRITE DATA INTO DISPLAY MEMORY
TYWORD		EQU	0			;WORD, LOW THEN HIGH BYTE
MOREPL		EQU	0			;REPLACE WITH PATTERN
RDAT		EQU	0A0H			;READ DATA FROM DISPLAY MEMORY
;
;
PAGE
;
;
;*********************
; I/O-PACKET EQUATES *
;*********************
;
SRH_INIT_L	EQU	18			;INIT BLOCK LENGTH
SRH_FLUSH_L	EQU	13			;FLUSH BLOCK LENGTH
SRH_STAT_L	EQU	13			;STATUS REQUEST BLOCK LENGTH
SRH_ND_L	EQU	14			;NON DESTR. READ BLOCK LENGTH
SRH_R_W_L	EQU	20			;READ OR WRITE BLOCK LENGTH
;
;
;******************
; FURTHER EQUATES *
;******************
;
FUNCLEN		EQU	610			;MAX. LENGTH OF FUNCTION TABLE
CLR_INPUT	EQU	96H			;FLUSH ALL INPUT BUFFERS
NO_KEY		EQU	0FFH			;UNDEFINED KEY CODE
SWIDTH		EQU	80			;SCREEN WIDTH
INP_BUF_E	EQU	OFFSET BUF_A 		;END OF WHOLE SW-BUFFER
;
;
PAGE
;
;
;******************************************************************************
;	
;				V A R I A B L E S
;
;******************************************************************************
;
;
;**********************************
; VARIABLES FOR FUNCTION HANDLING *
;**********************************
;
FUNCOFF		DW	OFFSET FUNCTBL		;OFFSET TO FUNCTION TABLE
REMLEN		DW	00H			;# OF BYTES BEHIND CHANGED FUNC
REMNUM		DW	00H			;# OF BYTES NOT TRANSFERED
;
;
;*******************
; OUTPUT VARIABLES *
;*******************
;
CURCOL		DB	0			;CURSOR POSITION (COLUMN)
CURROW		DB	0			;CURSOR POSITION (ROW)	
ATTRIBUTE	DB	0E8H			;DEFAULT MONOCROME
OUTCHAR		DB	0			;OUTPUT CHARACTER
FREQUENCY	DB	0
TONE_LENGTH	DB	0
SAVCURCOL	DW	0			;CURSOR POSITION SAVED HERE
ATTRIBUTE_SAVE	DB	0			;ATTRIBUTE SAVED HERE
;
;
;***********************************
; DEFINITION OF CRT PAGE VARIABLES *
;***********************************
;
SP1		DW	0			;START OF PAGE 1
LP11		DB	0			;LENGTH OF PAGE1 LOW
LP12		DB	0			;LENGTH OF PAGE1 HIGH 
SP2		DW	0			;START OF PAGE 2
LP21		DB	0			;LENGTH OF PAGE2 LOW
LP22		DB	0			;LENGTH OF PAGE2 HIGH
;
;
;********************
; FURTHER VARIABLES *
;********************
;
FLAG_BUF	DB	?			;KEYBOARD INPUT FLAGS
CRT_ROWM1	DB	0
RADDR		DW	0			;ADDRESS OF ROUTINE REQU. DATA
MON_ATT		DB	0E8H			;MONOCHROME CRT DEFAULT ATTR.
BG_FG		DB	0			;0 = BG DEFINED / 1 = FG DEF.
DREQ		DB	0			;DATA REQUEST FLAG
STRINGF		DB	0			;STRING FLAG
STATE		DW      ST1             	;CURRENT ANSI CHARACTER STATE
SCROLL_STATE	DW	(?)			;CURRENT SCROLL STATE
PRMPNT		DW      PARMS           	;CURRENT PARAMETER POINTER
;
;
PAGE
;
;
;******************************************************************************
;	
;		S P E C I A L   K E Y B O A R D   F L A G S
;
;******************************************************************************
;
;
KBD_FLAGS RECORD UD:1,HEBR_KBD:1,BELL_OFF:1,DU:1,FK_ACT:1,DISFK:1,HEBR_ON:1,IN_BUFF:1
;
;
;	THIS RECORD IS USED FOR MASKING THE BYTES 'CONSOLE_FLAGS' AND
;	'FLAG_BUF'. IT IS DEFINED IN THE FOLLOWING WAY:
;
;		UD		NOT USED
;
;		HEBR_KBD	BIT = 1 --> A HEBREW KEYBOARD IS INSTALLED
;
;		BELL_OFF	BIT = 1 --> BELL SWITCHED OFF
;
;		DU		NOT USED
;
;		FK_ACT		FUNCTION KEY NOT COMPLETED AT LAST INPUT
;
;		DISFK		DISABLE FUNCTION KEY
;				IF SET:	FUNCTION KEY CODE IS GIVEN BACK
;					DIRECTLY (NO READING OF FUNCTBL)
;
;		HEBR_ON		SWITCHES DISPLAY OF SPECIAL HEBREW
;				CHARACTERS ON OR OFF
;
;		IN_BUFF		INPUT BUFFER FULL 
;
;
;
;******************************************************************************
;	
;			S P E C I A L   C R T   F L A G S
;
;******************************************************************************
;
;
CRT_FLAGS	RECORD	COLOR:1,UNNDEFF:2,VIDEO_DISK:1,UUNDEEF:4
;
;	THIS RECORD IS USED FOR MASKING THE BYTE 'CONSOLE_FLAGS'.
;	IT IS DEFINED IN THE FOLLOWING WAY:
;
;		COLOR		= SYSTEM HAS COLOR CRT
;
;		UNNDEFF		= NOT USED
;
;		VIDEO_DISK	= VIDEO DISK IS INSTALLED
;
;		UUNDEEF		= NOT USED
;
;
