;
;
;******************************************************************************
;	
;		C O N S O L E   O U T P U T   R O U T I N E		
;
;******************************************************************************
;
;
CON_WRIT:
	LES	SI,[BX.TRANS]			;SET SOURCE POINTER
	PUSH	CS
	POP	DS				;GET CORRECT DATA SEGMENT
	CMP	CX,01H				;# OF OUTPUT CHARACTERS > 1 ?
	JNZ	CON_LOOP			;YES - THEN LOOP
	MOV	AL,BYTE PTR ES:[SI]		;NO - THEN GET OUTPUT CHARACTER
	CALL	CONOUT				;CALL ANSI DRIVER
	JMP	EXIT				;RETURN TO MS-DOS
;
CON_LOOP:
        LODS    BYTE PTR ES:[SI]		;GET OUTPUT CHARACTER
        PUSH    CX				;SAVE COUNTER
        CALL    CONOUT          		;CALL ANSI DRIVER.
        POP     CX				;GET COUNTER BACK
        LOOP    CON_LOOP        		;LOOP UNTIL USER BUFFER THROUGH
        JMP     EXIT				;RETURN TO MS-DOS
;
;
PAGE
;
;
;******************************************************************************
;	
;		I N T E R R U P T   2 9   H A N D L E R		
;
;******************************************************************************
;
;
I29_HANDLER:
	STI
	PUSH	AX				;SAVE ALL REGISTERS THAT WILL
	PUSH	BX				;BE CHANGED
	PUSH    CX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	CS				;GET CORRECT DATA SEGMENT
	POP	DS
	CALL    CONOUT				;CHARACTER IN AL TO CRT
	POP	DS				;RESTORE REGISTERS
	POP	SI
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	IRET	
;
;
PAGE
;
;
;******************************************************************************
;	
;		N O R M A L   C H A R A C T E R   O U T P U T
;
;******************************************************************************
;
;
CONOUT:
	JMP	[STATE]
;
;
;*******************
; STATE ONE A (1A) *
;*******************
;
ST1:
	CMP	AL,' '				;CONTROL CHARACTER ?
	JAE	HIPOUT				;NO - THEN HIGH PERFORM. OUTPUT
	JMP	NO_CHAR				;YES - THEN CONTINUE CHECK
;
HIPOUT:
	TEST	FLAG_BUF,MASK HEBR_ON  		;TEST HEBREW DISPLAY ACTIVE
	JNZ	HEB_ACTIVE			;JUMP IF ACTIVE
	MOV	BX,OFFSET CRTACTTBL		;GET OFFSET OF TRANSLATION TBL
	XLAT					;TRANSLATE CHARACTER
	MOV	OUTCHAR,AL
	JMP	SHORT PUTOUT			;AND DISPLAY IT ON SCREEN
;
HEB_ACTIVE:
	CMP	AL,60H
	JB	PUTOUT				;JUMP IF < 60H
	CMP     AL,7AH				;TEST FOR > 7AH
	JA      PUTOUT	         		;JUMP IF > 7AH
	SUB	AL,60H				;FOR AL=60H TO 7AH SUBTRACT 60H
	MOV	OUTCHAR,AL
;
PUTOUT:
	CMP	CURCOL,SWIDTH			;END OF SCREEN ?
	JB	QUICK_OUT			;NO - THEN SEND CHARACTER
	JMP	[SCROLL_STATE]			;ELSE SCROLL SCREEN
;
QUICK_OUT:
	MOV	AL,WDAT OR TYWORD OR MOREPL	;NO - THEN SEND OUTPUT COMMAND
	OUT 	GDCCOM,AL			;TO GDC
	MOV	AL,OUTCHAR
	OUT	GDCPAR,AL			;SEND CHARACTER TO GDC
	MOV	AL,ATTRIBUTE
	OUT	GDCPAR,AL			;SEND ATTRIBUTE TO GDC
	INC	CURCOL				;INCREMENT COLUMN COUNTER
	CMP	CURCOL,SWIDTH			;COLUMN < 80 ?
	JB	H2				;YES - THEN RETURN
;
LINE_CHECK:
	CMP	CURROW,23			;CHECK ROW COUNTER
;
THIRD_JUMP:
	JAE	SCROLL_24			;LAST ROW ?
	INC	CURROW				;NO - THEN DO A CR LF
	MOV	CURCOL,0
	JMP	WRITEPOS			;SET CURSOR
;
SCROLL_24:
	JA	SET_SCROLL_SL_STATE		;CURSOR IN STATUS LINE ?
	MOV	SCROLL_STATE,OFFSET SCROLL_SCREEN	;NO - THEN SET UP STATE
H2:
	RET					;FOR NORMAL SCROLLING
;
SET_SCROLL_SL_STATE:
	MOV	CURCOL,0			;DO A CARRIAGE RETURN
	MOV	SCROLL_STATE,OFFSET SCROLL_ST_LINE	;AND SET UP STATE FOR
	JMP	WRITEPOS			;STATUS LINE SCROLLING
;
SCROLL_SCREEN:					;SCROLLING IN 24 LINES MODE
	MOV	OUTCHAR,AL
	MOV	WORD PTR CURCOL,1700H
	CALL	ILF1
	JMP	PUTOUT
;
SCROLL_ST_LINE:					;SCROLLING OF STATUS LINE
	MOV	OUTCHAR,AL
	CALL	LINEFD				;CLEAR LINE 
	JMP	PUTOUT
;
SCROLL_25:					;SCROLLING IN 25 LINES MODE
X122:	IN	AL,GDCSTA
	AND	AL,FIFULL
	JNZ	X122				;LOOP UNTIL FIFO NOT FULL
	MOV	AL,CCHAR
	OUT 	GDCCOM,AL
	MOV	AL,0FH				;CURSOR OFF
	OUT	GDCPAR,AL
	CALL	SCROLLX				;SCROLL UP ONE LINE
	CALL	CURON				;CURSOR ON
	MOV	WORD PTR CURCOL,1800H
	JMP	WRITEPOS
;
;	
PAGE
;
;
;******************************************************************************
;	
;   S I N G L E   B Y T E   C O N T R O L   F U N C T I O N   H A N D L I N G
;
;******************************************************************************
;
;
;*******************
; STATE ONE B (1B) *
;*******************
;
NO_CHAR:
	MOV	BX,OFFSET COMTBL		;GET OFFSET OF JUMP TABLE
	XOR	AH,AH
	SHL	AL,1
	ADD	BX,AX				;COMPUTE JUMP ADDRESS
	JMP	[BX]				;AND PERFORM FUNCTION
;
ST12:
	MOV	STATE,OFFSET ST2		;THIS STATE IS SET, IF CHAR.
        RET					;WAS ESCAPE (1B).
;
;
PAGE
;
;
;******************************************************************************
;	
;      N O N   A N S I   E S C A P E   F U N C T I O N   H A N D L I N G
;
;******************************************************************************
;
;
;****************
; STATE TWO (2) *
;****************
;
ST2:
	CMP     AL,'['          		;ANSI ESCAPE SEQUENCE ?
	JZ	ST21				;YES - SET STATE 3
ESCNONA:					;NO, TEST NON_ANSI ESC SEQUENCE
	TEST 	DREQ,0FFH			;SEE IF ANY SEQUENCE ACTIV
	JNZ	PASSCH				;PASS BYTE TO REQ. ROUTINE
       	MOV	CX,ETBLENT			;CX = # OF ESCAPE TABLE ENTRIES
	MOV	BX,OFFSET ESCTBL 		;BX POINTS TO ESC TABLE
;
ESCNON:
	CMP	AL,[BX]				;SEARCH FOR CORRESPONDING ENTRY
	JNZ	ESCFAL		 		;NO MATCH THIS TIME
	MOV	STATE,OFFSET ESCNONA  		;NON ANSII ESCAPE SEQUENCE
	JMP	[BX+1]           		;JUMP TO CORR. ROUTINE
;
ESCFAL:
	ADD	BX,3				;BUMP POINTER TO NEXT ENTRY
	LOOP	ESCNON				;LOOP UNTIL TABLE ENDS
	MOV	STATE,OFFSET ST1 		;RETURN TO STATE 1
	RET					;ESC FUNCTION NOT IMPLEMENTED
;
PASSCH:
	MOV	DI,OFFSET RADDR 		;RADDR CONTAINS REQUESTERS ADDR
	JMP	[DI]		    		;PASS THE CHARACTER IN AL
;
ST21:
	MOV     BX,OFFSET PARMS 		;YES, GET PARAMETER POINTER.
        MOV     WORD PTR [PRMPNT],BX    	;SETUP IN POINTER INDEX.
        MOV     WORD PTR [BX],0 		;CLEAR FIRST ENTRY.
	MOV	STATE,OFFSET ST3		;SETUP FOR STATE THREE.
        RET
;
;
PAGE
;
;
;******************************************************************************
;	
;	  A N S I   E S C A P E   S E Q U E N C E   H A N D L I N G
;
;******************************************************************************
;
;
;******************
; STATE THREE (3) *	ENTERED ONE OR MORE TIMES FOR PARAMETER PASSING.
;******************
;
ST3:
	TEST	STRINGF,'"'			;TEST IF STRING PROCESSING
	JNZ	ST31				;JUMP IF STRING FLAG SET
        CMP     AL,';'	        		;LOOK FOR DECIMAL # SEPERATOR.
        JZ      ST3C    	        	;FALL THROUGH IF NOT ";"
;
ST31:
	CMP	AL,'"'				;LOOK FOR STRING SEPARATOR.
	JNZ	ST3A				;NO CHECK PHASE A
	XOR	STRINGF,AL			;TOGGLE STRING FLAG
	TEST 	STRINGF,AL		
	JNZ	ST3RET
	DEC	WORD PTR [PRMPNT]		;SET POINTER TO END OF STRING
;
ST3RET:
	RET 
;
ST3C:
	INC     WORD PTR [PRMPNT]       	;INCR. POINTER TO NEXT PARAM.
        MOV     AX,OFFSET LASTPRM       	;OUT OF PARAMETER LIST ?
        CMP     [PRMPNT],AX
        JBE     RETST3          		;YES, PROCEED WITH NEXT PARAM.
        MOV     [PRMPNT],AX     		;NO, TREAT AS EXTENTSION TO OLD
;
RETST3:
	MOV     DI,[PRMPNT]     		;SETUP FOR NEXT PARAMETER.
        MOV     BYTE PTR [DI],0 		;PRE-INITIALIZE IT TO ZERO.
        RET
;
;
;*********************
; STATE THREE A (3A) *		CHECK FOR A ASCII DIGIT.
;*********************
;
ST3A:
	TEST	STRINGF,'"'			;TEST IF STRING PROCESSING
	JNZ	ST3B				;JUMP IF THRU
        CMP     AL,'0'          		;CHECK FOR ASCII DIGIT.
        JB      ST3D            		;NO - THEN 2ND COMMAND CHAR. ?
        CMP     AL,'9'          		;STILL CHECKING FOR ASCII DIGIT
        JA      ST3D            		;NO, IT MUST BE A SECONDARY.
        SUB     AL,'0'          		;CONVERT TO BINARY.
        MOV     DI,[PRMPNT]     		;GET CURRENT PARAMETER POINTER.
        XCHG    [DI],AL         		;GET EXISTING #.
        MOV     AH,10           		;SCALE BY 10.
        MUL     AH
        ADD     [DI],AL         		;ADD TO NEW DIGIT.
        RET
;
;
;*********************
; STATE THREE B (3B) *		WASN'T A ASCII DIGIT, SO CHECK FOR STRING 
;*********************		FLAG AND SECONDARY COMMAND.
;
;
ST3B:
	MOV	DI,[PRMPNT]			;GET POINTER TO PARMS
	MOV	BYTE PTR [DI],AL		;STORE CHARACTER IN PARMS
	INC	WORD PTR [PRMPNT]		;AND MOVE POINTER.
	RET
;
ST3D:
	MOV	STATE,OFFSET ST1		;PRESET STATE TO STATE 1
	MOV	CX,[PRMPNT]
	MOV	DI,OFFSET PARMS-1		;GET POINTER TO START OF PARAMS
	MOV	[PRMPNT],DI			;SAVE IT IN PARAMETER POINTER
	MOV	DI,OFFSET CMDTABL-3		;GET START OF SECONDARY COMM.-T
;
ST3B1:
	ADD     DI,3            		;UPDATE COMMAND TABLE POINTER.
        CMP     BYTE PTR [DI],0 		;CHECK FOR END OF TABLE.
        JNZ     ST3B2           		;NO, CONTINUE PROCESSING.
        JMP     ST1	          		;YES - THEN REGULAR OUTPUT
;
ST3B2:
	CMP     AL,[DI]         		;CHECK FOR VALID. COMMAND.
        JNZ     ST3B1           		;NO, KEEP CHECKING.
        JMP     [DI+1]          		;YES, JUMP TO SECONDARY COMMAND
;
;
;************************************************************
; GET BINARY PARAMETER FROM STORAGE AND RETURN A ONE IF = 0 *
;************************************************************
;
GETONE:
	INC     WORD PTR [PRMPNT]       	;INCREMENT PARAMETER POINTER.
	MOV     DI,[PRMPNT]     		;GET PARAMETER POINTER.
        MOV     AL,[DI]         		;GET PARAMETER VALUE.
        OR      AL,AL           		;VERIFY FOR NON-ZERO.
        JNZ     GETRET          		;GOOD, THEN RETURN TO CALLER.
        INC     AL              		;BAD, MAKE IT AT LEAST A ONE.
;
GETRET:
	CBW                     		;SIGN EXTEND AL.
        MOV     CX,AX           		;COPY OF IT TO CX.
        RET
;
;
PAGE
;
;
;******************************************************************************
;	
;	C U R S O R   P O S I T I O N I N G   S U B R O U T I N E S
;
;******************************************************************************
;
;
;***********************************	
; ANSI CURSOR POSITIONING ROUTINES *
;***********************************
;
CUU:						;CURSOR UP
	CALL	GETONE				;GET # OF POSITIONS TO MOVE
	MOV	AH,CURROW			;GET CURRENT CURSOR POSITION
	SUB	AH,CL				;GET NEW POSITION
	JNB	ROWPOS				;EXECUTE POSITIONING IF VALID
	MOV	CURROW,00H			;ELSE SET CURSOR TO LINE 1
	JMP	WRITEPOS			;EXECUTE POSITIONING
;
CUD:						;CURSOR DOWN
	CALL	GETONE				;GET # OF POSITIONS TO MOVE
	MOV	AH,CURROW			;GET CURRENT CURSOR POSITION
	ADD	AH,CL				;GET NEW POSITION
	CMP	AH,CRT_ROWS			;BELOW BOTTOM LINE ?
	JB	ROWPOS				;EXECUTE IF NOT BELOW
	MOV	AL,CRT_ROWS
	MOV	CURROW,AL			;ELSE FORGET REST OF COUNT 
	JMP	WRITEPOS			;EXECUTE POSITIONING
;
ROWPOS:
	MOV	CURROW,AH
	JMP	WRITEPOS
;
CUF:						;CURSOR FORWARD
	CALL	GETONE				;GET # OF POSITIONS TO MOVE
	MOV	AL,CURCOL			;GET CURRENT CURSOR POSITION
	ADD	AL,CL				;GET NEW POSITION
	CMP	AL,SWIDTH			;BEHIND RIGHT BOUNDARY ?
	JB	COLPOS				;EXECUTE IF NOT 
	MOV	CURCOL,SWIDTH-1			;ELSE FORGET REST OF COUNT 
	JMP	WRITEPOS
;
CUB:    					;CURSOR BACKWARD
	CALL	GETONE				;GET # OF POSITIONS TO MOVE
	MOV	AL,CURCOL			;GET CURRENT CURSOR POSITION
	SUB	AL,CL				;GET NEW POSITION
	JNB	COLPOS				;EXECUTE POSITIONING IF VALID
	XOR	AL,AL				;ELSE SET TO FIRST COLUMN
;
COLPOS:
	MOV	CURCOL,AL
	JMP	WRITEPOS
;
CUP:						;DIRECT CURSOR POSITIONING
	CALL    GETONE          		;GET X POSITION.
	DEC	AL		
	MOV	CURROW,AL
        CALL    GETONE          		;GET Y POSITION.
        DEC	AL
	MOV	CURCOL,AL	
	JMP	WRITEPOS
;
;
;*********************************	
; SAVE / RESTORE CURSOR POSITION *
;*********************************
;
PSCP:
        MOV     AX,WORD PTR CURCOL		;SAVE CURRENT CURSOR POSITION 
	MOV	WORD PTR SAVCURCOL,AX
	RET
;
PRCP:
	MOV     AX,WORD PTR SAVCURCOL		;RESTORE LAST CURSOR SAVE.
	MOV	WORD PTR CURCOL,AX
	JMP	WRITEPOS
;
;
;*****************************************************
; ANSI CURSOR POSITION REPORT (DEVICE STATUS REPORT) *
;*****************************************************
;
XDSR:
	MOV	AX,WORD PTR CURCOL
	INC	AL
	INC	AH				;ADD 1 TO DEFINE HOME AS L1 P1
	MOV	BX,OFFSET CPR_MESS+2		;POINTER TO ROW IN CPR_MESS
	CALL	THEX_ASCII			;AH --> TWO ASCII BYTES
	INC	BX
	INC	BX				;MOVE POINTER TO COLUMN DIGITS
	MOV	AH,AL				;COLUMN TO AH
	CALL	THEX_ASCII			;TRANSLATE
	MOV	WORD PTR REMNUM,9		;SET LENGTH OF MESSAGE FOR KBD
	MOV	FUNCOFF,OFFSET CPR_MESS		;MESSAGE POINTER FOR KBD
	OR 	FLAG_BUF,MASK FK_ACT		;TELL KBD TO RETURN CPR_MESS
	RET
;
THEX_ASCII:
	MOV	WORD PTR [BX],3030H		;INITIALIZE DIGITS
;
THEX1:
	SUB	AH,10
	JB	LT10				;JUMP IF LESS THAN TEN
	INC	BYTE PTR [BX]  	 
	JMP SHORT THEX1
;
LT10:
	INC	BX
	ADD	AH,10
	OR 	BYTE PTR [BX],AH
	RET	
;
CPR_MESS:					;CURSOR POSITION REPORT MESSAGE
	DB	1BH				;ESC
	DB	'['
	DB	30H     			;ROW (TENS)
	DB	30H     			;ROW (ONES)
	DB	';'				;DECIMAL SEPERATOR
	DB	30H				;COLUMN (TENS)
	DB	30H				;COLUMN (ONES)
	DB	'R'
	DB	0DH				;CARRIAGE RETURN
;
;
;******************
; POSITION CURSOR *
;******************
;
POSIT:
	MOV	DREQ,-1				;SET DATA REQUEST FLAG
	MOV	RADDR,OFFSET POSC1 		;REQUESTERS ADDRESS
	RET
;
POSC1:
	SUB	AL,20H				;ROW 1 TRANSLATED TO ZERO
	MOV	CL,CRT_ROWS
	INC	CL
	CMP	AL,CL				;TEST FOR OUT OF RANGE
	JNB	POS1				;JUMP IF OUT
	MOV	CURROW,AL			;SET NEW ROW
;
POS1:
	MOV	RADDR,OFFSET POSC2 		;REQUESTERS ADDRESS
	RET
;
POSC2:
	SUB	AL,20H				;COLUMN 1 TRANSLATED TO ZERO
	CMP	AL,SWIDTH			;TEST FOR OUT OF RANGE COLUMN
	JNB	POS2				;JUMP IF OUT
	MOV	CURCOL,AL			;SET NEW COLUMN
;
POS2:
	MOV	DREQ,0				;CLEAR DATA REQUEST
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	JMP	WRITEPOS
;
;
;*********************************
; NON DESTRUCTIVE BACKWARD SPACE *
;*********************************
;
BACKSP:
	DEC	CURCOL
	JS	BKSP1
	JMP	WRITEPOS
;
BKSP1:
	MOV	AL,CRT_ROWM1
	CMP	CURROW,AL
	JA	BKSP3
	DEC	CURROW				;CHANGE ROW
	JNS	BKSP2				;JUMP IF NOT BEYOND TOP OF SCR
	MOV	WORD PTR CURCOL,00H		;ELSE SET ROW 0, COLUMN 0
	JMP 	WRITEPOS
;
BKSP2:
	MOV	CURCOL,SWIDTH-1			;CURSOR TO END OF LINE
	JMP	WRITEPOS
;
BKSP3:
	MOV	CURCOL,0
	JMP	WRITEPOS
;
;
;***********
; LINEFEED *
;***********
;
LINEFD:
	MOV	AL,CURROW
	INC	AL
	CMP	AL,CRT_ROWS
SCRL_JUMP:
	JZ	ILF1
	JA	ILFNO
	MOV	CURROW,AL
	JMP	WRITEPOS
;
ILF1:
XX122:	IN	AL,GDCSTA
	AND	AL,FIFULL
	JNZ	XX122				;LOOP UNTIL FIFO NOT FULL
	MOV	AL,CCHAR
	OUT 	GDCCOM,AL
	MOV	AL,0FH				;CURSOR OFF
	OUT	GDCPAR,AL
	MOV	BX,24*80
	CALL	SETCUR
	CALL	RDLIN				;SAVE STATUS LINE
	MOV	BX,24*80 
	MOV	CX,SWIDTH
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	CALL	SCROLLX				;SCROLL UP ONE LINE
	MOV	BX,24*80
	CALL	SETCUR
	CALL	WRLIN				;RESTORE STATUS LINE
	CALL	CURON
	JMP	WRITEPOS
;
NO_SAVE:
	CALL	CUROFF
	CALL	SCROLLX
	CALL	CURON
	JMP	WRITEPOS
;
ILFNO:
	MOV	BX,24*80			;DELETE STATUS LINE
	MOV	CX,SWIDTH
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	MOV	CURCOL,0
	JMP	WRITEPOS
;
;
;*******************
; REVERSE LINEFEED *
;*******************
;
RLF:
	CMP	CURCOL,SWIDTH
	JNE	UVW
	MOV	WORD PTR CURCOL,1800H
;
UVW:
	DEC	CURROW				;CURSOR UP ONE LINE
	JNS	WRITEPOS
	INC	CURROW
	RET
;
;
;********************************
; NON DESTRUCTIVE FORWARD SPACE *
;********************************
;
NDFS:
	INC	CURCOL				;COLUMN +1
	CMP	CURCOL,SWIDTH			;TEST IF WITHIN SCREEN
	JNB	NDFS1				;YES - THEN SET CURSOR
	JMP	WRITEPOS
;
NDFS1:
	MOV	CURCOL,00H			;ELSE DO A CR LF
	JMP	LINEFD
;
;
;******************
; CARRIAGE RETURN *
;******************
;
CARRET:
	MOV	CURCOL,00H
	JMP	WRITEPOS
;
;
;**************
; HOME CURSOR *
;**************
;
VHOME:
	MOV	WORD PTR CURCOL,00H
	JMP	WRITEPOS
;
;
;***************************
; SET CURSOR IN CRT MEMORY *
;***************************
;
SETCUR:						;ENTRY: BX=GDC CURSOR POSITION 
	ADD	BX,SP1
	CMP	BX,07D0H
	JB	SETCUR1
	SUB	BX,07D0H
;
SETCUR1:
XX6:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX6
	MOV	AL,CURS
	OUT 	GDCCOM,AL
	MOV	AL,BL
	OUT	GDCPAR,AL
	MOV	AL,BH
	OUT	GDCPAR,AL
	XOR	AL,AL
	OUT	GDCPAR,AL
;
SETMSK:
XX7:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX7
	MOV	AL,MASKREG
	OUT 	GDCCOM,AL
	MOV	AL,-1
	OUT	GDCPAR,AL
	MOV	AL,-1
	OUT	GDCPAR,AL
	RET
;
;
;*********************************
; WRITE CURSOR POSITION INTO GDC *
;*********************************
;
WRITEPOS:
	MOV	BX,WORD PTR CURCOL
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	ADD	BX,SP1
	CMP	BX,07D0H
	JB	WRPO1
	SUB	BX,07D0H
;
WRPO1:
	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	WRPO1
	MOV	AL,CURS
	OUT 	GDCCOM,AL
	MOV	AL,BL
	OUT	GDCPAR,AL
	MOV	AL,BH
	OUT	GDCPAR,AL
	XOR	AL,AL
	OUT	GDCPAR,AL
	MOV	AL,MASKREG
	OUT 	GDCCOM,AL
	MOV	AL,-1
	OUT	GDCPAR,AL
	MOV	AL,-1
	OUT	GDCPAR,AL
	RET
;
;
PAGE
;
;
;******************************************************************************
;	
;  S U B R O U T I N E S   F O R   C H A N G I N G   D I S P L A Y   M O D E
;
;******************************************************************************
;
;
SGR:
	SUB	CX,OFFSET PARMS-1 		;CX NOW HOLDS # OF PARAMETERS 
;
SGRX:
	INC	WORD PTR [PRMPNT]		;INCREMENT PARAMETER POINTER
	MOV	DI,[PRMPNT]			;GET PARAMETER POINTER
	MOV	AL,[DI]				;GET PARAMETER VALUE
	CMP	AL,0				;TEST FOR RESET ALL ATTRIBUTES
	JNZ	SGR1
	CALL	RINV_VIDEO			;RESET INVERSE VIDEO
	CALL	RHALF_INT			;RESET HALF INTENSITY
	CALL	RBLINK				;RESET BLINKING
;
SGR1:	CMP	AL,7				;TEST FOR INVERSE VIDEO
	JNZ	SGR2
	CALL	SINV_VIDEO			;SET INVERSE VIDEO
;
SGR2:
	CMP     AL,5				;TEST FOR BLINKING
	JNZ	SGR3
	CALL	SBLINK				;SET BLINKING
;
SGR3:
	CMP	AL,1				;TEST FOR BOLD ON
	JNZ	SGR4
	CALL	RHALF_INT			;RESET HALF INTENSITY
;
SGR4:
	CMP	AL,8				;TEST FOR CONCEALED
	JNZ	SGR5
	CALL	SHALF_INT			;SET HALF INTENSITY
;
SGR5:
	TEST	CONSOLE_FLAGS,MASK COLOR	;TEST FOR COLOR CRT
	JNZ	SGRC				;JUMP IF TRUE
	LOOP	SGRX				;GET NEXT PARAMETER
	RET
;
SGRC:
	CMP	AL,30				;PARAMETERS < 30 ILLEGAL
	JB	SGEXIT				;FORGET < 30 ONES
	CMP 	AL,47				;PARAMETERS > 47 ILLEGAL
	JA	SGEXIT				;FORGET > 47
	CMP	AL,38				;38 AND 39 ARE ILLEGAL TOO
	JZ	SGEXIT
	CMP	AL,39
	JZ	SGEXIT
	CMP	AL,40				;TEST FOR BACKGROUND SETTING
	JAE	SGRBG				;JUMP FOR 40 OR ABOVE
	OR 	BYTE PTR BG_FG,02H		;FLAG FOREGROUND DEFINED
	JMP SHORT SGRC1
;
SGRBG:
	OR 	BYTE PTR BG_FG,01H		;FLAG BACKGROUND DEFINED
;
SGRC1:
	MOV	BX,OFFSET COLOR_TBL-30  	;BX = BASE FOR COLOR_TBL
	XLAT   					;TRANSLATE PARAM. TO COLOR BITS
	TEST	MON_ATT,01H			;TEST FOR INVERSE ACTIVE
	JNZ	SGRINV				;JUMP IF TRUE
	TEST	AL,04H				;TEST FOR FG RED SET
	JZ	SGRCDO 				;JUMP IF NOT
	AND	ATTRIBUTE,0FEH			;RESET HALF INT ATTRIBUTE BIT
	JMP SHORT SGRCDO
;
SGRINV:
	TEST	AL,20H				;TEST FOR RED IN BG
	JNZ	SGRCDO				;JUMP IF NOT
	AND	ATTRIBUTE,0FEH			;RESET HALF INT ATTRIBUTE BIT
;
SGRCDO:
	TEST	BG_FG,02H			;TEST FOR FG SETTING
	JNZ	SGRSFG				;JUMP IF TRUE
	AND	ATTRIBUTE,01FH			;RESET BG BITS FOR ORING
	OR 	ATTRIBUTE,AL			;SET NEW BG
	JMP SHORT SGRCEX
;
SGRSFG:
	AND	ATTRIBUTE,0E3H			;RESET FG BITS FOR ORING
	OR	ATTRIBUTE,AL			;SET NEW FG
;
SGRCEX:
	MOV	BG_FG,0				;RESET FLAGS
	TEST	MON_ATT,04H			;TEST FOR HALF INT ACTIVE
	JZ	SGEXIT
	CALL	REAC_HI				;REACTIVATE HALF INT
;
SGEXIT:
	DEC	CX
	JZ     	SGRENDE				;EXIT IF LAST PARAM. PROCESSED
	JMP     SGRX				;GET NEXT PARAMETER
;
SGRENDE:
	RET
;
COLOR_TBL:
	DB	00				;BLACK   FOREGROUND
	DB	04H				;RED     FOREGROUND
	DB	08H				;GREEN   FOREGROUND
	DB	0CH				;YELLOW  FOREGROUND
	DB	10H				;BLUE    FOREGROUND
	DB	14H				;MAGENTA FOREGROUND
	DB	18H				;CYAN    FOREGROUND
	DB	1CH				;WHITE   FOREGROUND
	DB      -1				;DUMMY
	DB	-1				;DUMMY
	DB	0E0H				;BLACK   BACKGROUND
	DB	0C0H				;RED	 BACKGROUND
	DB	0A0H            		;GREEN	 BACKGROUND
	DB	080H				;YELLOW  BACKGROUND
	DB	060H      			;BLUE	 BACKGROUND
	DB	040H				;MAGENTA BACKGROUND
	DB	020H				;CYAN	 BACKGROUND
	DB	0				;WHITE   BACKGROUND
;
REV_COLOR:					;REVERSING FG AND BG COLOR
	MOV	AL,ATTRIBUTE			;AL=ATTRIBUTE
	MOV	AH,AL				;COPY TO AH
	AND	AH,0E0H				;SEPARATE BG COLOR BITS
	SHR     AH,1
	SHR	AH,1
	SHR	AH,1				;BG BITS IN FG POSITION NOW
	AND	AL,01CH				;SEPARATE FG COLOR BITS
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1				;FG BITS IN BG POSITION NOW
	OR	AL,AH				;AL HOLDS BOTH NOW
	XOR	AL,0FCH				;REVERSE THEM
	AND	ATTRIBUTE,03H	
	OR	ATTRIBUTE,AL
	RET
;
SBLINK:	
	OR	ATTRIBUTE,02H			;SET BLINKING
	RET
;
RBLINK:
	AND	ATTRIBUTE,0FDH			;RESET BLINKING
	RET
;
;
;*********************
; SET HALF INTENSITY *
;*********************
;
SHALF_INT:
	TEST	MON_ATT,04H			;HALF INTENSITY ALREADY SET ?
	JNZ	S_STAT1				;JUMP IF TRUE
	OR	MON_ATT,04H			;SET HALF INTENSITY FLAG
	TEST	CONSOLE_FLAGS,MASK COLOR  	;TEST FOR COLOR CRT
	JZ	SHALF1				;JUMP IF NOT
;
REAC_HI:
	TEST	MON_ATT,01H			;TEST FOR INVERSE ACTIVE
	JNZ	SHALFBG				;JUMP IF TRUE
	TEST	ATTRIBUTE,04H   		;TEST FOR RED ALREADY SET IN FG
	JZ	SHALF2				;JUMP IF NOT
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
SHALF2:
	OR	ATTRIBUTE,05H			;SET RED FG BIT + HALF INT.
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
SHALF1:
	OR	ATTRIBUTE,04H			;SET HALF INT. FOR MONOCHROME
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
SHALFBG:
	TEST	ATTRIBUTE,20H   		;TEST FOR RED IN BG
	JZ	S_STAT1				;JUMP IF RED SET
	AND	ATTRIBUTE,0DFH  		;SET RED BIT IN BG
	OR	ATTRIBUTE,01H			;SET HALF INTENSITY
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
S_STAT1:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
;
;***********************
; RESET HALF INTENSITY *
;***********************
;
RHALF_INT:
	TEST	MON_ATT,04H			;TEST FOR HALF INTENSITY ACTIVE
	JZ	S_STAT1				;NO ACTION IF NOT
	AND	MON_ATT,0FBH			;RESET HALF INTENSITY FLAG
	TEST	CONSOLE_FLAGS,MASK COLOR	;TEST FOR COLOR CRT
	JNZ	RHALFC				;JUMP IF TRUE
;
RHALF1:
	AND	ATTRIBUTE,0FBH			;RESET HALF INT. IN ATTRIBUTE
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
RHALFC:
	TEST	ATTRIBUTE,01H			;TEST FOR HALF INTENSITY ACTIVE
	JZ	S_STAT1				;IF ZERO --> NO ACTION
	AND	ATTRIBUTE,0FEH			;RESET COLOR HALF INTENSITY BIT
	TEST 	MON_ATT,01H			;TEST FOR INVERS ACTIVE IF ZERO
	JZ	RHALF1				;HALF INTENSITY WAS NOT ACTIVE
	OR 	ATTRIBUTE,20H			;RESET RED BACKGROUND
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
;
;*****************************************
; SET / RESET REVERSE VIDEO AND BLINKING *
;*****************************************
;
REVERSE:
	MOV	DREQ,-1				;SET DATA REQUEST
	MOV	RADDR,OFFSET RVO 		;AND REQUESTER'S ADDRESS
	RET			
;
RVO:
	CMP	AL,'0'
	JNZ	RV1				;JUMP IF NO RESET OF THIS FLAG
	CALL	RINV_VIDEO			;RESET INVERSE VIDEO
	CALL	RBLINK				;RESET BLINKING
	JMP SHORT RVE
;
RV1:
	CMP	AL,'2'				;BLINKING TO SET ?
	JNZ	RV2				;JUMP IF NOT
	CALL	SBLINK				;SET BLINKING
	JMP SHORT RVE
;
RV2:
	CMP	AL,'4'				;WOULD BE SET FLAG
	JNZ	RVE				;NO ACTION IF NOT '4'
	CALL	SINV_VIDEO			;SET INVERSE VIDEO
;
RVE:
	MOV	DREQ,0				;CLEAR DATA REQUEST
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
SINV_VIDEO:
	TEST	MON_ATT,01H			;TEST FOR INVERS ACTIVE
	JNZ	JMPS_STAT1			;JUMP IF TRUE --> NO ACTION
	OR	MON_ATT,01H			;SET INVERS FLAG
	TEST	CONSOLE_FLAGS,MASK COLOR  	;TEST FOR COLOR CRT
	JZ	SINV_VID1			;JUMP IF MONOCHROME
	CALL    REV_COLOR			;EXCHANGE FG BG
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
SINV_VID1:
	OR	ATTRIBUTE,01H			;SET INVERS BIT FOR MONOC. CRT
	RET
;
RINV_VIDEO:
	TEST	MON_ATT,01H			;TEST FOR INVERS ACTIVE
	JZ	JMPS_STAT1			;JUMP IF NOT --> NO ACTION
	AND	MON_ATT,0FEH			;RESET INVERSE FLAG
	TEST	CONSOLE_FLAGS,MASK COLOR	;TEST FOR COLOR CRT
	JZ	RINV_VID1			;JUMP IF MONOCHROME
	CALL	REV_COLOR			;EXCHANGE FG BG
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	RET
;
RINV_VID1:
	AND	ATTRIBUTE,0FEH			;RESET INVERSE BIT FOR M. CRT
	RET
;
JMPS_STAT1:
	JMP	S_STAT1
;
;
PAGE
;
;
;******************************************************************************
;	
;	   I N S E R T   A N D   D E L E T E   S U B R O U T I N E S
;
;******************************************************************************
;
;
;**********************
; ERASE ALL OF SCREEN *
;**********************
;
ED:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	CALL	CUROFF				;CURSOR OFF
	CALL	INIT10
	CALL	SCROL1				;INITIALIZE PAGES
	MOV	BX,0
	MOV	CX,07D0H
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	MOV	WORD PTR CURCOL,0		;ZERO OUT CURCOL AND CURROW
	CALL	CURON				;TURN CURSOR BACK ON
	JMP	WRITEPOS
;
;
;***************************
; ERASE ALL/PART OF A LINE *
;***************************
;
EL:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
;
ICLEOL:
	MOV	BL,CURCOL			;CURRENT COLUMN # TO CH AND BL
	MOV	CH,BL
	MOV	AL,SWIDTH
	SUB	AL,CH
	JZ	ICLEOL_RET	
	MOV	CL,AL				;CX = NUMBER OF BYTES TO CLEAR
	XOR	CH,CH
	PUSH	CX
	MOV	BH,CURROW
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	POP	CX
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	JMP	WRITEPOS
;
ICLEOL_RET:
	RET
;
;
;*************************
; ERASE TO END OF SCREEN *
;*************************
;
BLEOS:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	AL,CRT_ROWM1			;GET # OF ROWS TO BE CLEARED
	SUB	AL,CURROW
	JZ	CLEOS1				;ZERO ? - CLEAR CURRENT ROW
	MOV	BH,CURROW
	INC	BH				;BH = CURRENT ROW + 1
	XOR	BL,BL				;BL = 0  (COLLUMN 0)
	PUSH	AX
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	POP	AX
	MOV	DL,SWIDTH
	MUL	DL				;AX = NUMBER OF BYTES TO CLEAR
	MOV	CX,AX
	CALL	CUROFF				;SWITCH OFF CURSOR
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	CALL	CURON				;SWITCH ON CURSOR
;
CLEOS1:
	CALL	ICLEOL
	RET	
;
;
;**************
; INSERT LINE *
;**************
;
INSLIN:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	AL,CURROW
	PUSH	AX
	MOV	CL,CRT_ROWM1
	SUB	CL,AL				;CL = ROWS TO MOVE
	JZ	SCLDN2
	MOV	CH,CRT_ROWM1			;CH = ROW TO START
	DEC	CH
	CALL	CUROFF
;
SCLDN1:
	PUSH	CX
	MOV	AL,CH
	MOV	CL,SWIDTH
	MUL	CL
	MOV	BX,AX
	PUSH	AX
	CALL	SETCUR				;SET CURSOR TO START OF ROW B
	CALL	RDLIN				;READ IN A ROW TO LINBUF
	POP	BX
	ADD	BX,SWIDTH
	CALL 	SETCUR				;SET CURSOR TO START OF ROW B+1
	CALL	WRLIN				;WRITE ROW IN LINBUF
	POP	CX
	DEC	CH
	DEC	CL
	JNZ	SCLDN1
	CALL	CURON
;
SCLDN2:
	POP	AX
	CALL	CLRLIN				;CLEAR CURRENT LINE
	MOV	CURCOL,0
	JMP	WRITEPOS
;
;
;**************
; DELETE LINE *
;**************
;
DELLIN:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	AL,CURROW
	OR	AL,AL
	JNZ	LINE_OK
	JMP	ILF1
;
LINE_OK:
	MOV	CH,AL				;CH = ROW NO.
	MOV	AL,CRT_ROWM1
	SUB	AL,CH
	JZ	SCLUP2
	MOV	CL,AL				;CL = NO. OF ROWS TO MOVE
	CALL	CUROFF				;TURN OFF CURSOR
;
SCLUP1:
	PUSH	CX
	MOV 	AL,CH
	MOV	CL,SWIDTH
	MUL	CL				;AX = ROW * CHR/ROW
	PUSH	AX
	ADD	AX,SWIDTH			;AX = (ROW+1)*(CHR/ROW)
	MOV	BX,AX				;BX = ROW B+1
	CALL	SETCUR				;CURSOR TO THE START OF ROW B+1
	CALL	RDLIN	 			;READ IN A ROW (CHAR AND ATTR)
	POP	BX				;SET CURSOR TO START OF ROW B
	CALL	SETCUR
	CALL	WRLIN				;WRITE OUT A ROW
	POP	CX
	INC	CH				;INCREMENT ROW NO.
	DEC	CL				;DECREMENT NO. OF ROWS TO MOVE
	JNZ	SCLUP1
	CALL	CURON				;TURN CURSOR BACK ON
;
SCLUP2:
	MOV	AL,CRT_ROWM1
	CALL	CLRLIN				;CLEAR LINE
	MOV	CURCOL,0
	JMP	WRITEPOS
;
;
;*******************
; INSERT CHARACTER *
;*******************
;
ICHR:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	BX,WORD PTR CURCOL		;BL = COLUMN ; BH = ROW
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	MOV	CL,SWIDTH-1			;TEST CURRENT COLUMN = SWIDTH-1
	SUB	CL,CURCOL			;CL = COUNT
	JZ	BLANK_ONE
	MOV	BH,CURROW
	MOV	BL,SWIDTH-2
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	CALL	CUROFF				;SWITCH CURSOR OFF
;
INSCH1:
	PUSH	BX
	CALL	SETCUR				;SET CURSOR
	CALL	RDGCHR				;GET CHARACTER
	POP	BX
	INC	BX
	PUSH	BX
	CALL	SETCUR				;SET CURSOR
	CALL	WRGCHR				;SET CHARACTER
	POP	BX
	DEC	BX
	DEC	BX
	DEC	CL				;DECREMENT COUNTER
	JNZ	INSCH1				;LOOP UNTIL ZERO
	CALL	CURON				;SWITCH CURSOR ON
	INC	BX
;
BLANK_ONE:
	MOV	OUTCHAR,' '
	CALL	SETCUR				;SET CURSOR
	CALL	WRGCHR				;CLEAR CHARACTER
	JMP	WRITEPOS			;SET CURSOR
;
;
;*******************
; DELETE CHARACTER *
;*******************
;
DCHR:
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	BX,WORD PTR CURCOL		;BL = COLUMN ; BH = ROW
	MOV	AL,SWIDTH			;CHARS/ROW IN AL
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX				;BX IS POSITION IN CRT BUFFER
	MOV	CL,SWIDTH-1			;TEST CURRENT COLUMN = SWIDTH-1
	SUB	CL,CURCOL			;CL = COUNT
	JZ	BLANK_ONE			;EXIT IF NONE TO MOVE
	INC	BX				;START AT PRES + 1
	CALL	CUROFF				;SWITCH OFF CURSOR
	MOV	AL,ATTRIBUTE			;GET CURRENT ATTRIBUTE
	MOV	ATTRIBUTE_SAVE,AL		;AND SAVE IT
;
DELCHR1:
	PUSH	BX
	CALL	SETCUR				;SET CURSOR
	CALL	RDGCHR				;GET CHARACTER
	POP	BX
	DEC	BX
	PUSH	BX
	CALL	SETCUR				;SET CURSOR
	CALL	WRGCHR				;SET CHARACTER
	POP	BX
	INC	BX
	INC	BX
	DEC	CL
	JNZ	DELCHR1				;LOOP UNTIL ZERO
	MOV	AL,ATTRIBUTE_SAVE		;RESTORE CURRENT
	MOV	ATTRIBUTE,AL			;ATTRIBUTE
	CALL	CURON				;SWITCH ON CURSOR
	DEC	BX
	JMP	SHORT BLANK_ONE
;
;
;**********************************
; DELETE CHARACTERS IN CRT MEMORY *
;**********************************
;
SPCLEAR1:
	ADD	BX,CX
	CMP	BX,07D0H
	JBE	SPCLEAR2
	SUB	BX,07D0H
	CALL	SPCLEAR2
	MOV	CX,BX
	XOR	BX,BX
	CALL	SETCUR1
;
SPCLEAR2:
	DEC	CX
	CALL	SETMSK
XX4:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX4
	MOV	AL,FIGS
	OUT 	GDCCOM,AL
	MOV	AL,2
	OUT	GDCPAR,AL
	MOV	AL,CL
	OUT	GDCPAR,AL
	MOV	AL,CH
	OUT	GDCPAR,AL
	MOV	AL,WDAT OR TYWORD OR MOREPL
	OUT 	GDCCOM,AL
	MOV	AL,020H
	OUT	GDCPAR,AL
	MOV	AL,ATTRIBUTE
	OUT	GDCPAR,AL
	RET
;
;
;***************************
; CLEAR ROW <AL> TO SPACES *
;***************************
;
CLRLIN:
	MOV	BL,SWIDTH
	MUL 	BL				;GET ABSOLUTE CURSOR POSITION
	MOV	BX,AX				;AND MOVE IT TO BX
	MOV	CX,SWIDTH
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	JMP	WRITEPOS
;
;
PAGE
;
;
;******************************************************************************
;	
;		C R T   M E M O R Y   R E A D / W R I T E
;
;******************************************************************************
;
;
;***************************
; WRITE GRAPHICS CHARACTER *
;***************************
;
WRGCHR:
	MOV	AL,WDAT OR TYWORD OR MOREPL
	OUT 	GDCCOM,AL			;SEND COMMAND TO GDC
	MOV	AL,OUTCHAR
	OUT	GDCPAR,AL			;SEND CHARACTER TO GDC
	MOV	AL,ATTRIBUTE
	OUT	GDCPAR,AL			;SEND ATTRIBUTE TO GDC
	RET
;
;
;**************************
; READ GRAPHICS CHARACTER *
;**************************
;
RDGCHR:
	MOV	AL,FIGS				;FIGURE DRAWING PARAMETER
	OUT 	GDCCOM,AL			;SEND COMMAND TO GDC
	MOV	AL,2				;DIRECTION = 2
	OUT	GDCPAR,AL			;SEND PARAMETER TO GDC
	MOV	AL,1				;DC = 1
	OUT	GDCPAR,AL			;SEND PARAMETER TO GDC
	MOV	AL,RDAT OR TYWORD		;READ WORD FROM DISPLAY MEMORY
	OUT 	GDCCOM,AL			;SEND COMMAND TO GDC
;
IN5:
	IN	AL,GDCSTA
	AND	AL,DATRDY
	JZ	IN5
	IN	AL,FIFO
	MOV	OUTCHAR,AL
;
IN1:
	IN	AL,GDCSTA			;READ GDC STATUS
	AND	AL,DATRDY
	JZ	IN1				;WAIT IF NO CHARACTER READY
	IN	AL,FIFO
	MOV	ATTRIBUTE,AL
	RET
;
;
;*************************
; READ 1 ROW INTO LINBUF *
;*************************
;
RDLIN:
XX8:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX8
	MOV	AL,FIGS
	OUT 	GDCCOM,AL
	MOV	AL,2
	OUT	GDCPAR,AL
	MOV	AL,80				;80 WORDS [CHAR + ATTR]
	OUT	GDCPAR,AL
	XOR	AL,AL
	OUT	GDCPAR,AL
	MOV	AL,RDAT
	OUT 	GDCCOM,AL
	MOV	BX,OFFSET LINBUF
	MOV	CX,160
;
RDLIN1:
IN2:
	IN	AL,GDCSTA
	AND	AL,DATRDY
	JZ	IN2
	IN	AL,FIFO
	MOV	0[BX],AL
	INC	BX
	LOOP	RDLIN1
	RET
;
;
;***********************
; WRITE 1 ROW INTO GDC *
;***********************
;
WRLIN:
XX10:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX10
	MOV	AL,FIGS
	OUT 	GDCCOM,AL
	MOV	AL,2
	OUT	GDCPAR,AL
	XOR	AL,AL
	OUT	GDCPAR,AL
	XOR	AL,AL
	OUT	GDCPAR,AL
	MOV	AL,WDAT OR TYWORD OR MOREPL
	OUT 	GDCCOM,AL
	MOV	BX,OFFSET LINBUF
	MOV	CX,10
;
WRLIN1:
XX37:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX37
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX
	LOOP	WRLIN1
	RET
;
;
PAGE
;
;
;******************************************************************************
;	
;		C U R S O R   D I S P L A Y   S U B R O U T I N E S
;
;******************************************************************************
;
;
;******************
; TURN CURSOR OFF *
;******************
;
CUROFF:
XX12:	IN	AL,GDCSTA
	AND	AL,FIFULL
	JNZ	XX12
	MOV	AL,CCHAR
	OUT 	GDCCOM,AL
	MOV	AL,0FH
	OUT	GDCPAR,AL
	RET
;
;
;*****************
; TURN CURSOR ON *
;*****************
;
CURON:
XX13:	IN	AL,GDCSTA
	AND	AL,FIFULL
	JNZ	XX13
	MOV	AL,CCHAR
	OUT 	GDCCOM,AL
;
CURST_1:
	MOV	AL,08FH
	OUT	GDCPAR,AL
;
CURST_2:
	MOV	AL,0CEH
	OUT	GDCPAR,AL
;
CURST_3:
	MOV	AL,072H
	OUT	GDCPAR,AL
	RET
;
;
PAGE
;
;
;******************************************************************************
;	
;     S C R E E N   S C R O L L I N G   A N D   I N I T I A L Z A T I O N
;
;******************************************************************************
;
;
INIT10:						;INITIALIZE SCREEN PAGE VALUES
	XOR	AX,AX
	MOV	SP1,AX
	MOV	SP2,AX				;START OF PAGES 1 AND 2 = 0
	TEST	CONSOLE_FLAGS,MASK VIDEO_DISK	;VIDEO DISK INSTALLED ?
	JZ	NO_VIDEO			;NO - THEN NORMAL PAGE INIT
	MOV	LP21,80H
	MOV	LP22,0CH
	MOV	LP11,80H
	MOV	LP12,0CH
	JMP	SHORT XX14
;
NO_VIDEO:
	MOV	LP21,AL
	MOV	LP22,AL
	MOV	LP11,AL
	MOV	LP12,25				;LENGTH OF PAGE 1
XX14:	IN	AL,GDCSTA
	AND	AL,FIFULL
	JNZ	XX14
	MOV	AL,FIGS
	OUT 	GDCCOM,AL
	MOV	AL,2
	OUT	GDCPAR,AL
	RET
;
SCROLLX:					;SCROLL ROUTINE
	XOR	BX,BX				;START OF PAGE 1
	MOV	CX,80
	CALL	SETCUR				;SET CURSOR
	CALL	SPCLEAR1
	CALL	WRITEPOS
	ADD	SP1,80
	TEST	CONSOLE_FLAGS,MASK VIDEO_DISK	;VIDEO DISK INSTALLED ?
	JZ	SCROLNOR
	MOV	CL,4				;SHIFT COUNT
	MOV	AX,WORD PTR LP11
	SHR	AX,CL				;SHIFT LENGTH OF PAGE
	SUB	AX,8				;LENGTH OF PAGE 1 - 8 SCAN L.
	JNZ	SCROL2				;IF LENGTH OF PAGE 1 = 0
	CALL	INIT10				;THEN INITIALIZE THE PAGES
	JMP	SHORT SCROL1
;
SCROL2:
	SHL	AX,CL
	MOV	WORD PTR LP11,AX		;STORE BACK NEW LENGTH OF P.
	MOV	AX,WORD PTR LP21
	SHR	AX,CL
	ADD	AX,8				;LENGTH OF PAGE 2 + 8 SCAN L.
	SHL	AX,CL
	MOV	WORD PTR LP21,AX		;STORE BACK LENGTH OF PAGE 2
;
SCROL1:
XX25:	IN	AL,GDCSTA
	AND	AL,FIEMPTY
	JZ	XX25
	MOV	AL,PRAM+0			;SEND 8 BYTE SCREEN PAGES INFO
	OUT 	GDCCOM,AL
	MOV	CX,8
	MOV	BX,OFFSET SP1	
;
SENPAR:
	MOV	AL,0[BX]
	OUT	GDCPAR,AL
	INC	BX				;BUMP TO NEXT PARAMETER
	LOOP	SENPAR				;LOOP UNTIL ALL PARAMETERS SENT
	RET
;
SCROLNOR:
	DEC	LP12
	JNZ	SCROLNO1
	CALL	INIT10
	JMP	SHORT SCROL1
;
SCROLNO1:
	INC	LP22
	JMP	SHORT SCROL1
;
;
PAGE
;
;
;******************************************************************************
;	
;			I O - C O N T R O L   W R I T E
;
;******************************************************************************
;
;
;*************************
; IO-CONTROL WRITE ENTRY *
;*************************
;
CTL_WRIT:
	PUSH	CX				;SAVE COUNT
	MOV	AL,BYTE PTR ES:[DI]		;GET CHARACTER
	INC	DI				;ADJUST POINTER TO SOURCE
	MOV	CX,CTL_WR_TABLEN		;GET LENGTH OF JUMP TABLE
	MOV	BX,OFFSET CTL_WRITABLE		;GET OFFSET OF JUMP TABLE
;
CTL1:
	CMP	AL,BYTE PTR [BX]
	JZ	CTL2				;JMP IF MATCH FOUND
	ADD	BX,3				;MOVE POINTER TO NEXT ENTRY
	LOOP	CTL1				;LOOP TIL MATCH OR END OF TABLE
	POP	CX				;GET COUNT BACK
;
SLOOPY:
	LOOP	CTL_WRIT			;BUFFER THROUGH ?
	JMP	EXIT				;YES - THEN RETURN
;
CTL2:
	POP	CX				;GET COUNTER BACK
	JMP	[BX+1]				;START PROCESSING
;
;
;*******************************
; IO-CONTROL WRITE SUBROUTINES *
;*******************************
;
SELECT_LINES:
	DEC	CX				;IS THERE MORE DATA
	JZ	CTL_EXIT			;NO - THEN RETURN
	MOV	AL,BYTE PTR ES:[DI]		;GET PARAMETER
	INC	DI				;ADJUST PARAMETER POINTER
	CMP	AL,25				;25 LINES MODE REQUESTED ?
	JZ	LINES				;YES - THEN INSTALL IT
	CMP	AL,24				;24 LINES MODE REQUESTED
	JNZ	SLOOPY				;NO - THEN FORGET COMMAND
	PUSH	CX				;SAVE LOOP COUNTER
	CMP	CURROW,24			;CURSOR IN STATUS LINE ?
	JNZ	CLST				;NO - THEN ONLY DELETE IT
	CALL	LINEFD				;ELSE SCROLL UP ONE LINE
	MOV	CURROW,23			;AND DO A REVERSE LINEFEED
;
CLST:
	MOV	BX,24*80
	MOV	CX,SWIDTH
	CALL	SETCUR
	CALL	SPCLEAR1			;CLEAR STATUS LINE
	CALL	WRITEPOS			;SET CURSOR
	POP	CX				;RESTORE LOOP COUNTER
	MOV	AL,24
;
LINES:
	MOV	CRT_ROWS,AL
	CALL	LINES_INIT			;INITIALIZE NEW LINES MODE
	JMP	SLOOPY				;CONTINUE
;
SELECT_CURSOR:
	DEC	CX
	JZ	CTL_EXIT
	MOV	AL,BYTE PTR ES:[DI]
	MOV	BYTE PTR CURSOR_TYPE,AL
	MOV	BYTE PTR CURST_1+1,AL
	INC	DI
;
	DEC	CX
	JZ	CTL_EXIT
	MOV	AL,BYTE PTR ES:[DI]
	MOV	BYTE PTR CURSOR_TYPE+1,AL
	MOV	BYTE PTR CURST_2+1,AL
	INC	DI
;
	DEC	CX
	JZ	CTL_EXIT
	MOV	AL,BYTE PTR ES:[DI]
	MOV	BYTE PTR CURSOR_TYPE+2,AL
	MOV	BYTE PTR CURST_3+1,AL
	INC	DI
;
	CALL	CURON
	JMP	SLOOPY
;
CTL_EXIT:
	JMP	EXIT
;
BELLONOFF:
	MOV	AL,CONSOLE_FLAGS		;GET CONSOLE FLAGS INTO AL
	MOV	AH,AL				;COPY AL INTO AH
	AND	AL,NOT MASK BELL_OFF		;CLEAR BELL FLAG
	NOT	AH				;COMPLEMENT AH
	AND	AH,MASK BELL_OFF		;CLEAR ALL OTHER FLAGS
	ADD	AL,AH				;ASSEMBLE NEW CONSOLE_FLAGS
	MOV	CONSOLE_FLAGS,AL		;AND STORE THEM
	JMP	SLOOPY
;
SELECT_VIDEO:
	MOV	AL,CONSOLE_FLAGS		;GET CONSOLE FLAGS INTO AL
	MOV	AH,AL				;COPY AL INTO AH
	AND	AL,NOT MASK VIDEO_DISK		;CLEAR VIDEO DISK FLAG
	NOT	AH				;COMPLEMENT AH
	AND	AH,MASK VIDEO_DISK		;CLEAR ALL OTHER FLAGS
	ADD	AL,AH				;ASSEMBLE NEW CONSOLE_FLAGS
	MOV	CONSOLE_FLAGS,AL		;AND STORE THEM
	JMP	SLOOPY
;
;
;*************************
; IO-CONTROL WRITE TABLE *
;*************************
;
CTL_WR_TABLEN	DW	8			;# OF TABLE ENTRIES
CTL_WRITABLE	DB	'B'
		DW	BELLONOFF		;BELL ON/OFF SWITCH
		DB	'C'
		DW	SELECT_CURSOR		;CURSOR TYPE SELECTION
		DB	'L'
		DW	SELECT_LINES		;24 OR 25 LINES SCROLLING
		DB	'V'
		DW	SELECT_VIDEO		;VIDEO DISK ON/OFF
		DB	'b'
		DW	BELLONOFF		;BELL ON/OFF SWITCH
		DB	'c'
		DW	SELECT_CURSOR		;CURSOR TYPE SELECTION
		DB	'l'
		DW	SELECT_LINES		;24 OR 25 LINES SCROLLING
		DB	'v'
		DW	SELECT_VIDEO		;VIDEO DISK ON/OFF
;
;
PAGE
;
;
;******************************************************************************
;	
;			I O - C O N T R O L   R E A D
;
;******************************************************************************
;
;
;************************
; IO-CONTROL READ ENTRY *
;************************
;
CTL_READ:
	CMP	CX,00H				;EXIT IF COUNT = 0 
	JNZ	COUNT_CHECK
	JMP	EXIT
;
COUNT_CHECK:
	CMP	CX,08H
	JBE	SET_UP
	MOV	CX,08H
;
SET_UP:
	MOV	AL,CURSOR_TYPE			;SET UP I/O-CTL-BLOCK
	MOV	CUSTY,AL
	MOV	AL,CURSOR_TYPE+1
	MOV	CUSTY+1,AL
	MOV	AL,CURSOR_TYPE+2
	MOV	CUSTY+2,AL
	MOV	AL,CRT_ROWS
	MOV	ROWY,AL
	MOV	AL,CONSOLE_FLAGS
	MOV	CONSY,AL
	MOV	SI,OFFSET IO_CTL_BLK
	PUSH	CX
;
OUT_LOOP:
	MOVSB
	LOOP	OUT_LOOP
	POP	CX
	LES	BX,CS:PTRSAV
	MOV	ES:[BX.COUNT],CX
	JMP	EXIT
;
IO_CTL_BLK:
	DB	'C'				;ID FOR CURSOR_TYPE
CUSTY	DB	(?)
	DB	(?)
	DB	(?)
	DB	'L'				;ID FOR CRT_ROWS
ROWY	DB	(?)
	DB	'B'				;ID FOR CONSOLE_FLAGS
CONSY	DB	(?)
;
;
