


	PAGE	65,132

	TITLE	DSKDRV  FLEX DISK DRIVER

;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   04-27-83  I   Original Entry                                       I  RP 
;   05-26-83  I   Correction to be able to assemble with NEWMASM       I  RP
;   05-27-83  I   MEDIA CHECK flags into common area for door open     I  RP
; 	      I   simulation  Q2334 for FORMAT utility		       I 
;   06-15-84  I	  Enhancements for 02.00.00			       I  RP 
;   06-19-84  I	  Changes for single drive system                      I  RP
;   07-16-84  I   Changes for single drive system & FORMAT utility     I  RP
;   08-29-84  I   Added special write protection for 48TPI/96TPI       I  WK
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;_____________________________________________________________________________
;      

	PAGE
 
CSEG	SEGMENT 	PUBLIC 'CODE'

ASSUME	CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG

PUBLIC	DSK_INT,DREND

EXTRN	PTRSAV:DWORD,KBD_FL:NEAR,CONFIG_FLAGS:WORD
EXTRN	FLOPPY_DRIVES:BYTE,FL_OUT_RETRIES:BYTE,FLTAB:WORD,FL_FLAGS:BYTE


	DB	02		; ISSUE
	DB	02		; SUB ISSUE
	DB	00		; PATCH LEVEL


ES_SAVE	DW	?		; Save area for
BX_SAVE	DW	?		; ES:BX pointer to I/O data packet
; 
; I/O data packet structure
;
IODAT	STRUC
CMDLEN	DB	?		; COMMAND LENGTH
UNIT	DB	?		; UNIT NUMBER
CMD	DB	?		; COMMAND CODE
STATUS	DW	?		; RETURN STATUS
				;
	DB	8 DUP (?)	;
MEDIA	DB	?		; MEDIA DESCRIPTOR
TRANS	DW	?		; TRANSFER ADDRESS (OFFSET)
	DW	?		;		   (SEGMENT)
COUNT	DW	?		; COUNT OF BLOCKS
START	DW	?		; FIRST BLOCK TO TRANSFER
IODAT	ENDS

;
; BIOS PARAMETER BLOCK structure
;
DPB	STRUC
SECSIZE	DW	?		; Sector size in bytes	
ALLOC	DB	?		; Number of sectors per allocation unit
RESSEC	DW	?		; Reserved sectors
FATS	DB	?		; Number of FAT's
MAXDIR	DW	?		; Number of root directory entries
SECTORS	DW	?		; Number of sectors per diskette
MEDIAID	DB	?		; Media byte ID
FATSEC	DW	?		; Number of FAT sectors
				;
SECPTR	DW	?		; Number of sectors per track
HEADS	DW	?		; Number of heads
HIDSEC	DW	?		; Number of hidden sectors
DPB	ENDS

	PAGE
	INCLUDE	FLXPIMD.ASM
	DW	1023 DUP (0)	; Max. possible sector size

	PAGE
	INCLUDE FLXPIMC.ASM

	PAGE

DSKTBL:
	DW      DSK_INIT        ; 0  - INIT               
	DB	26		; Length of drive request structure
				;
        DW      MEDIAC          ; 1  - MEDIA CHECK                 
	DB	15		; Length of drive request structure
				;       
	DW      GET_BPB         ; 2  - Build BPB                  
	DB	22		; Length of drive request structure
				;       
        DW      CMDERR          ; 3  - IOCTL INPUT (currently returns error)
	DB	22		; Length of drive request structure
				;       
        DW      DREAD           ; 4  - READ       
	DB	22		; Length of drive request structure
				;       
        DW      0000	        ; 5  - NON DESTRUCTIVE INPUT (char. devices)
	DB	00		; Length of drive request structure
				;       
        DW      0000            ; 6  - INPUT STATUS (char. devices)
	DB	00		; Length of drive request structure
				;       
        DW      0000            ; 7  - INPUT FLUSH (char. devices)    
	DB	00		; Length of drive request structure
				;       
        DW      DWRITE          ; 8  - WRITE       
	DB	22		; Length of drive request structure
				;       
        DW      DVERIFY         ; 9  - WRITE WITH VERIFY         
	DB	22		; Length of drive request structure
				;       
        DW      0000            ; 10 - OUTPUT STATUS (char. devices)
	DB	00		; Length of drive request structure
				;	
        DW      0000            ; 11 - OUTPUT FLUSH (char. devices)    
	DB	00		; Length of drive request structure
				;
	DW	CMDERR		; 12 - IOCTL OUTPUT (currently returns error)
	DB	22		; Length of drive request structure
				;       

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 84/06/05      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DSK_INT
;
;
;
;
;
;    FUNCTION:           DISK INTERRUPT ROUTINE FOR PROCESSING I/O PACKETS
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    SOME DISK VARIABLES ARE SET
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DSK_INT:			;
	PUSH	SI		;
        PUSH    AX              ;
        PUSH    CX		;
        PUSH    DX		;
        PUSH    DI		;
        PUSH    BP		;
        PUSH    DS		;
        PUSH    ES		;
        PUSH    BX		;
				;
	PUSH	CS		;
	POP	DS		; Set DATA SEGMENT to CODE SEGMENT
				;
	LES	BX,[PTRSAV]	; Retrieve pointer to I/O data packet
	MOV	ES_SAVE,ES	;
	MOV	BX_SAVE,BX	; Save pointer to I/O data packet
				;
	MOV	AX,ES:[BX.COUNT];
	MOV	SECCNT,AX	; PIM.SECCNT <-- sector count
				;
	MOV	AX,ES:[BX.TRANS];
	MOV	DMAADDR,AX	; PIM.DMAADDR <-- transfer addr (OFFSET)
	MOV	AX,ES:[BX.TRANS+2] ;
	MOV	DMAADDR+2,AX	; PIM.DMAADDR <-- transfer addr (SEGMENT)
				;
	MOV	AL,ES:[BX.UNIT] ;
	MOV	DRV,AL		; PIM.DRV <-- unit code
				;
	CMP	FLOPPY_DRIVES,1	;
	JNZ	INT1		; Jump if a two drive system
				;
				; Single drive system
				; ...................
	CMP	AL,FL_FLAGS+2	; Request to same drive ?
	MOV	FL_FLAGS+2,AL	; Update regardless
	MOV	DRV,00		; and use drive 0
	JZ	INT1		; Jump if the same drive
INT0:				; else
	CALL	PRDICH		; Prompt disk change message
	PUSH	BX		;
	CALL	MOTORCK		; 
	POP	BX		;
	IN	AL,SYSSTA	;
	TEST	AL,08		; Test DISK INTERRUPT BIT
	JZ	INT0		; Jump if no interrupt
INT1:				;
	MOV	AL,ES:[BX.UNIT]	;
	MOV	AH,BPB_SIZE	;
	MUL	AH		;
	MOV	SI,OFFSET BPB0	;
	ADD	SI,AX		; SI - addr of BPB of selected drive
				;
	MOV	AX,[SI.SECPTR]	;
	MOV	SECTRK,AL	; PIM.SECTRK <-- sectors per track
				;
	MOV	AX,[SI.HEADS]	;
	MOV	CYLMODE,00	; PIM.CYLMODE <-- 00  if 2 heads
	CMP	AL,02		;
	JZ	INT2		;
				;
	MOV	CYLMODE,01	; PIM.CYLMODE <-- 01  if 1 head
INT2:				;
	MOV	AX,[SI.SECSIZE]	;
	CMP	AX,80H		;
	MOV	AL,00		; N <-- 00  if sector size = 128
	JZ	INT4		; 
INT3:				;
	INC	AL		; N <-- 01  if sector size = 256
	RCR	AH,1		;	02		     512
	JC	INT4		;	03		    1024
				;
	CMP	AL,03		; If sector size > 1024
	JB	INT3		;
				; then
	JMP	ERROR_7		; 'UNKNOWN MEDIA'
INT4:				;
	MOV	BYTSEC,AL	; PIM.BYTSEC <-- N
				;
	MOV	AX,[SI.SECTORS] ; AX <-- total number of sectors
	MUL	WORD PTR [SI.SECSIZE] ; * sector size in bytes
				; gives total disk capacity in bytes
	MOV	AL,AH		;
	MOV	AH,DL		;
	SHR	AX,1		;
	SHR	AX,1		; AX - total disk capacity in KB
				;
	MOV	CX,[SI.HEADS]	;
	DEC	CX		;
	SHR	AX,CL		; / sideness gives disk capacity per surface
				;
	CMP	AX,200		; Check if disk capacity per surface > 200 KB
	MOV	TPI_DI,00	; PIM.TPI_DI <-- 48 tpi if below or equal
	JBE	INT5		;
				;
	MOV	TPI_DI,01	; PIM.TPI_DI <-- 96 tpi if above
INT5:				;
	MOV	AH,00		;
	MOV	AL,SECTRK	;
	MUL	[SI.HEADS]	;
	MOV	CX,AX		; CX <-- sectors per cylinder
				;
	MOV	AX,ES:[BX.START]; AX <-- start sector
	XOR	DX,DX		;
	DIV	CX		; AX - track
	INC	DX		; DX - sector (MS-DOS starts with log sector 0)
	MOV	TRACK,AL	; PIM.TRACK <-- track
				;
	CMP	DL,SECTRK  	; Test for side 0 or side 1
	MOV	HEAD,00		; PIM.HEAD <-- 0
	MOV	SECTOR,DL	; PIM.SECTOR <-- sector
	JBE	INT6		; Jump if side 0
				;
	SUB	DL,SECTRK	; DL - sector within track
	MOV	HEAD,01		; PIM.HEAD <-- 1
	MOV	SECTOR,DL	; PIM.SECTOR <-- sector
INT6:				;
	MOV	SI,OFFSET DSKTBL; SI <-- addr of disk-table
	MOV	AH,00		;
	MOV	AL,ES:[BX.CMD]	; AX <-- command code
	ADD	SI,AX		;
	ADD	SI,AX		; Compute entry in disk-table
	ADD	SI,AX		;
				;
	CMP	AL,12		; If more than 12 commands
	JBE	INT7		; then
	JMP	ERROR_3 	; 'UNKNOWN COMMAND'
INT7:				;
	MOV	AL,ES:[BX.CMDLEN] ;
	CMP	BYTE PTR [SI+2],00 ;
	JZ	INT9		; Skip character device commands
				;
	CMP	AL,[SI+2]	; If wrong length
	JAE 	INT8 		; then
	JMP	ERROR_5 	; 'BAD DRIVE REQUEST STRUCTURE LENGTH'
INT8:				;
	CALL	[SI]		; Perform I/O packet command
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JNZ	DSKERR		; Jump to disk error routine
INT9:				;
	JMP	EXIT		; Jump to EXIT
				;
CMDERR:				;
	POP	AX		; Flush return address from stack
	JMP	ERROR_3		; Generate 'UNKNOWN COMMAND' error
							
        PAGE

DSKERR:				;
	MOV	ES,ES_SAVE	;
	MOV	BX,BX_SAVE	; Retrieve pointer to I/O data packet
	MOV	AL,ES:[BX.CMD]	; AL <-- Command code
	CMP	AL,04		; Test if READ
	JZ	DSKERR0		; Jump if READ
	CMP	AL,08		; Test if WRITE
	JZ	DSKERR0		; Jump if WRITE
	CMP	AL,09		; Test if VERIFY
	JZ	DSKERR0		; Jump if VERIFY
				;
	JMP	SHORT DSKERR1	; Jump if not READ, WRITE or VERIFY
DSKERR0:			;
	MOV	ES:[BX.COUNT],0	; Transfer counter <-- 0000
DSKERR1:			;	
	TEST	ERRBUF+1,02	; Test for 'WRITE PROTECTED'
	JZ	DSKERR2		;
	JMP	ERROR_0 	; Jump if 'WRITE PROTECTED'
DSKERR2:			;
	TEST	ERRBUF,08	; Test for 'DRIVE NOT READY'
	JZ	DSKERR3		;
	JMP	ERROR_2 	; Jump if 'DRIVE NOT READY'
DSKERR3:			;
	TEST	ERRBUF,80H	; Test for 'UNKNOWN COMMAND'
	JZ	DSKERR4		;
	JMP	ERROR_3 	; Jump if 'UNKNOWN COMMAND'
DSKERR4:			;
	TEST	ERRBUF+1,20H	; Test for 'CRC ERROR'
	JZ	DSKERR5		;
	JMP	ERROR_4 	; Jump if 'CRC ERROR'
DSKERR5:			;
	TEST	ERRBUF,20H	; Test for 'SEEK ERROR'
	JNZ	DSKERR6		;
	TEST	ERRBUF+2,10H	; Test for 'SEEK ERROR'
	JZ	DSKERR6		;
	JMP	ERROR_6 	; Jump if 'SEEK ERROR'
DSKERR6:			;
	TEST	ERRBUF+2,01	; Test for 'UNKNOWN MEDIA'	
	JZ	DSKERR7		;
	JMP	ERROR_7 	; Jump if 'UNKNOWN MEDIA'
DSKERR7:			;
	TEST	ERRBUF+1,04	; Test for 'SECTOR NOT FOUND'
	JZ	DSKERR8		;
	JMP	ERROR_8 	; Jump if 'SECTOR NOT FOUND'
DSKERR8:			;
	MOV	AH,WRITDAT	;
	AND	AH,COMSTR+1	;
	CMP	AH,WRITDAT	;
	JNZ	DSKERR9		;
	JMP     ERROR_10	; Jump if error after WRITE COMMAND
DSKERR9:			;
	MOV	AH,READDAT	;
	AND	AH,COMSTR+1	;
	CMP	AH,READDAT	;
	JNZ	DSKERR10	;
	JMP	ERROR_11	; Jump if error after READ COMMAND
DSKERR10:			;
	JMP	ERROR_12	; Rest becomes 'GENERAL FAILURE'		
	PAGE
;
;  Common error processing routine.
;   AL contains actual error code.
;
;   Error # 0 = Write Protect violation.
;           1 = Unkown unit.
;           2 = Drive not ready.
;           3 = Unknown command in I/O packet.
;           4 = CRC error.
;           5 = Bad drive request structure length.
;           6 = Seek error.
;           7 = Unknown media discovered.
;           8 = Sector not found.
;           9 = Printer out of paper.
;          10 = Write fault.
;          11 = Read fault.
;          12 = General failure.
;

ERROR_0:
	XOR	AL,AL		;Write protect violation.
	JMP	SHORT ERR_EXIT
ERROR_1:
	MOV	AL,1		;Unknown unit.
	JMP	SHORT ERR_EXIT
ERROR_2:
	MOV	AL,2		;Drive not ready.
	JMP	SHORT ERR_EXIT
ERROR_3:
	MOV	AL,3		;Unknown command in I/O packet.
	JMP	SHORT ERR_EXIT
ERROR_4:
	MOV	AL,4		;CRC error.
	JMP	SHORT ERR_EXIT
ERROR_5:
	MOV	AL,5		;Bad drive request structure length.
	JMP	SHORT ERR_EXIT
ERROR_6:
	MOV	AL,6		;Seek error.
	JMP	SHORT ERR_EXIT
ERROR_7:
	MOV	AL,7		;Unknown media discovered.
	JMP	SHORT ERR_EXIT
ERROR_8:
	MOV	AL,8		;Sector not found.
	JMP	SHORT ERR_EXIT
ERROR_9:
	MOV	AL,9		;Printer out of paper.
	JMP	SHORT ERR_EXIT
ERROR_10:
	MOV	AL,10		;Write fault.
	JMP	SHORT ERR_EXIT
ERROR_11:
	MOV	AL,11		;Read fault.
	JMP	SHORT ERR_EXIT
ERROR_12:
	MOV	AL,12		;General failure.
;
;fall through to ERR_EXIT
;

ERR_EXIT:
        MOV     AH,10000001B    ;Set error and done bits.
        STC                     ;Set carry bit also.
        JMP     SHORT EXIT1     ;Quick way out.

EXITP	PROC	FAR		;

EXIT:   MOV     AH,00000001B    ;Set done bit for MSDOS.
EXIT1:  MOV	BX,BX_SAVE
	MOV	DS,ES_SAVE
        MOV     [BX.STATUS],AX  ;Save operation complete and status.

        POP     BX              ;Restore registers.
        POP     ES
        POP     DS
        POP     BP
        POP     DI
        POP     DX
        POP     CX
        POP     AX
        POP     SI
        RET
EXITP	ENDP	

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/03/14      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DSK_INIT
;
;
;
;
;
;    FUNCTION:           DISK INITIALIZE
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
DSK_INIT:			; 
	MOV	ES:[BX.MEDIA],2	; I/O data packet <-- 2 units
				;
	MOV	SI,OFFSET DREND	; 
	MOV	ES:[BX.TRANS],SI; I/O data packet <-- BREAK ADDR (OFFSET)
	MOV	ES:[BX.TRANS+2],CS ; 		  <-- 		 (SEGMENT)
				;
	MOV	SI,OFFSET INITTAB ;
	MOV	ES:[BX.COUNT],SI; I/O data packet <-- Pointer to
	MOV	ES:[BX.START],CS;		      BPB array
				;
	MOV	AL,FL_OUT_RETRIES ;
	MOV	RETRIES,AL	; Set retry counter
				;
	MOV	FLTAB,0101H	; Set flags in common area
	MOV	BYTE PTR FL_FLAGS,00 ;
	MOV	BYTE PTR FL_FLAGS+1,00 ;
				;
				; Set shortest HLT to improve the performance
				; ...........................................
	MOV	COMSTR,03	; COMMAND STRING <-- LENGTH 3
	MOV	COMSTR+1,SPECIFY;		 <-- SPECIFY COMMAND
	MOV	COMSTR+2,0D6H	;		 <-- STEPPING RATE & HUT
	MOV	COMSTR+3,02	;		 <-- HLT & ND
				;
	CALL	XWAIT		; Send COMMAND STRING to FDC
				;
	MOV	ERRBUF,00	; Set normal termination
	RET			;
				;
	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/02/25      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       MEDIAC
;
;
;
;
;
;    FUNCTION:           MEDIA CHECK
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   NONE
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE
MEDIAC:				;
	CMP	FLOPPY_DRIVES,1	;
	JZ	MEDIAC1		; Jump if a single drive system
				;
	IN	AL,SYSSTA	;
	TEST	AL,08		; Test DISK INTERRUPT BIT
	JZ	MEDIAC2		; Jump if no interrupt
MEDIAC1:			;
	MOV	FLTAB,0101H	; Set interrupt flags for both units
MEDIAC2:			;
	MOV	ERRBUF,00	; Set normal termination
				;
	MOV	SI,OFFSET FLTAB	; SI <-- Addr of FLAG TABLE
	MOV	AH,00		;
	MOV	AL,DRV		; AX <-- Unit code
	ADD	SI,AX		; Compute entry in FLAG TABLE
				;
	CMP	BYTE PTR [SI],0	; Check if interrupt flag is set for that unit
	JZ	MEDIAC3		; Jump if not set
				;
	MOV	BYTE PTR [SI],0	; Reset interrupt flag  
	MOV	BYTE PTR ES:[BX.TRANS],00 ; I/O data packet <-- don't know
	RET			;
MEDIAC3:			;
	MOV	BYTE PTR ES:[BX.TRANS],01 ; I/O data packet <-- not changed
	RET			;
				;

PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/02/25      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       GET_BPB
;
;
;
;
;
;    FUNCTION:           Get BPB (BIOS PARAMETER BLOCK)
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   DRV variable is set
;  
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    SOME DISK VARIABLES ARE SET
;			 STATUS (returned in ERRBUF)
;			 
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************

;
;
	PAGE
EC:				; Entry counter
	DB	90H		;
GET_BPB:			; Fill PIM variables to read BOOT SECTOR
				; --------------------------------------
	MOV	TPI_DI,00	; PIM.TPI_DI <-- 48 tpi disk
	MOV	CYLMODE,00	; PIM.CYLINDER MODE <-- 00
				; PIM.DRV already set
	MOV	HEAD,00		; PIM.HEAD <-- 00
	MOV	TRACK,00	; PIM.TRACK <-- 00
	MOV	SECTOR,01	; PIM.SECTOR <-- 1st phy  = 0th log
	MOV	SECCNT,0001	; PIM.SECCNT <-- one sector	
				; DMA ADDRESS of scratch buffer already set
				;
	CALL	DREAD		; Read BOOT SECTOR
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	GETBPB1		; Jump if normal termination
				;
	INC	BYTE PTR EC	;
	INC	BYTSEC		;
	AND	BYTSEC,03	; BYTSEC <-- next sector size
				;
	CMP	BYTE PTR EC,94H	; Maximum of 4 attempts (BYTSEC = 0, 1, 2, 3)
	JB	GET_BPB		; Jump to try again
	MOV	BYTE PTR EC,90H	; else reset EC 
	RET			; and return
GETBPB1:			;
	MOV	BYTE PTR EC,90H	; Reset EC 
	MOV	ES,ES_SAVE	;
	MOV	BX,BX_SAVE	;
	MOV	SI,DMAADDR	;
	ADD	SI,11		; SI <-- scratch BUFFER.BPB
				;
	MOV	AH,BPB_SIZE	;
	MOV	AL,ES:[BX.UNIT]	;
	MUL	AH		;
	MOV	DI,OFFSET BPB0	;
	ADD	DI,AX		; DI <-- BUFFER AREA for BPB of selected DRIVE
	PUSH	DI		; Save addr of BUFFER AREA
				;
				; Update I/O data packet
	MOV	ES:[BX.COUNT],DI;	<-- BPB POINTER
	MOV	ES:[BX.COUNT+2],CS;	<-- CODE SEGMENT
				; 
	PUSH	DS		;
	POP	ES		; ES <-- DS
	MOV	AX,DMAADDR+2	;
	MOV	DS,AX		; DS <-- scratch BUFFER SEGMENT
				;
	CLD			; incrementing	
	MOV	CX,BPB_SIZE	; Length of (extended) BPB
REP	MOVSB			; Move BPB from scratch BUFFER into BUFFER AREA
	PUSH	ES		;
	POP	DS		; DS <-- ES
				;
	POP	SI		; Restore addr of BUFFER AREA
	MOV	AX,WORD PTR [SI.SECTORS] ; AX <-- total number of sectors
	OR	AX,AX		; Check if no BPB in BOOT SECTOR (IBM - Formats)
	JNZ	GETBPB2		;
				;
	JMP	GETBPB10	; If so, jump to determine BPB by FAT-ID
GETBPB2:			;
	MOV	AL,BYTE PTR [SI.MEDIAID] ; AL <-- media descriptor byte
	CMP	AL,0F8H		;
	JNB	GETBPB3		;
				;
	JMP	GETBPB10	; Jump if unknown media descriptor (CPM - Formats)
GETBPB3:			;
	CMP	AL,0FCH		;
	JZ	GETBPB4		; Jump if single sided NCR - Format
	CMP	AL,0FEH		;
 	JZ	GETBPB4		; Jump if single sided NCR - Format
	JMP	SHORT GETBPB5	;
GETBPB4:			;
	MOV	WORD PTR [SI.HEADS],0001 ; HEADS <-- 1  if single sided NCR - Format
GETBPB5:			;
	MOV	ES,ES_SAVE	;
	MOV	BX,BX_SAVE	; Update I/O data packet
	MOV	ES:[BX.MEDIA],AL; 	<-- media descriptor
				;
GETBPB6:			;* tpi determination of drive
				;* --------------------------
	CMP	BYTE PTR FL_FLAGS,00 ;*
	JZ	GETBPB7		;* Jump to set TPI_DR
	MOV	AL,FL_FLAGS+1	;* else
	MOV	TPI_DR,AL	;* PIM.TPI_DR <-- value from common area
	RET			;* and return
GETBPB7:			;*
				;* 1) Check if tpi from drive & disk are equal
				;* ...........................................
	MOV	TPI_DR,01 	;* PIM.TPI_DR <-- 96 tpi
	MOV	TPI_DI,01	;* PIM.TPI_DI <-- 96 tpi
				;* PIM.CYLMODE already set
				;* PIM.DRV already set
	MOV	TRACK,02	;* PIM.TRACK <-- 2
	MOV	SECTOR,01	;* PIM.SECTOR <-- 1
	MOV	SECCNT,0001	;* PIM.SECCNT <-- one sector
				;* PIM.DMAADDR already set
				;*
	CALL	DREAD		;* Try to read
				;*
	TEST	ERRBUF,0C0H	;* Test for normal termination
	JZ	GETBPB8		;* Jump if tpi from drive & disk are equal
				;* else
				;* try with other tpi variables
				;*
				;* 2) Check if 48 tpi disk in 96 tpi drive
				;* .......................................
				;* PIM.TPI_DR <-- 96 tpi already set
	MOV	TPI_DI,00	;* PIM.TPI_DI <-- 48 tpi
				;* PIM.CYLMODE already set
				;* PIM.DRV already set
				;* PIM.TRACK already set
				;* PIM.SECTOR already set
	MOV	SECCNT,0001	;* PIM.SECCNT <-- one sector
				;* PIM.DMAADDR already set
				;*
	CALL	DREAD		;* Try to read
				;*
	TEST	ERRBUF,0C0H	;* Test for normal termination
	JZ	GETBPB9		;* Jump if 48 tpi disk in 96 tpi drive
				;* else
	MOV	BYTE PTR ERRBUF,40H ;* 'UNKNOWN MEDIA'
	MOV	BYTE PTR ERRBUF+2,01 ;* and
	RET			;* return
				;*
GETBPB8:			;* determine tpi of drive from disk capacity
				;* .........................................
	MOV	ES,ES_SAVE	;*
	MOV	BX,BX_SAVE	;*
	MOV	SI,ES:[BX.COUNT];* SI <-- addr of BPB
				;*
	MOV	AX,[SI.SECTORS] ;* AX <-- total number of sectors
	MUL	WORD PTR [SI.SECSIZE] ;* multiplied with sector size in bytes
				;* gives total disk capacity in bytes
	MOV	AL,AH		;*
	MOV	AH,DL		;*
	SHR	AX,1		;*
	SHR	AX,1		;* AX - total disk capacity in KB
				;*
	MOV	CX,[SI.HEADS]	;*
	DEC	CX		;*
	SHR	AX,CL		;* / sideness gives disk capacity per surface
				;*
	CMP	AX,200		;* Check if disk capacity per surface > 200 KB
	JA	GETBPB9		;* Let variables unchanged (96 tpi) if above
				;*
	MOV	TPI_DR,00	;* PIM.TPI_DR <-- 48 tpi if below or equal
	MOV	TPI_DI,00	;* PIM.TPI_DI <-- 48 tpi if below or equal
				;*
	MOV	BYTE PTR FL_FLAGS+1,00 ;* Set 48 tpi drive in common area
	MOV	BYTE PTR FL_FLAGS,0FFH ;* Set flag
	RET			;*
GETBPB9:			;*
				;* Specify other stepping rate for 96 tpi drive
				;* ............................................
	MOV	COMSTR,03	;* COMMAND STRING <-- LENGTH 3
	MOV	COMSTR+1,SPECIFY ;*		  <-- SPECIFY COMMAND
	MOV	COMSTR+2,0E6H	;*		  <-- STEPPING RATE & HUT
	MOV	COMSTR+3,02	;*		  <-- HLT & ND
				;*
	CALL	XWAIT		;* Send COMMAND STRING to FDC
				;*
	MOV	BYTE PTR FL_FLAGS+1,01 ;* Set 96 tpi drive in common area
	MOV	BYTE PTR FL_FLAGS,0FFH ;* Set flag
	RET			;*
	
	PAGE
GETBPB10:			; Fill PIM variables to read 1st FAT
				; ----------------------------------
				; PIM.CYLINDER MODE <-- already set
				; PIM.DRV already set
				; PIM.HEAD <-- already set
				; PIM.TRACK <-- already set
	MOV	SECTOR,02	; PIM.SECTOR <-- 2nd phy  = 1st log
	MOV	SECCNT,0001	; PIM.SECCNT <-- one sector	
				; DMA ADDRESS of scratch buffer already set
				;
	CALL	DREAD		; Read 1st FAT sector
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	GETBPB11	; Jump if normal termination
	RET			; else return
GETBPB11:			;
	MOV	DI,DMAADDR	;
	MOV	ES,DMAADDR+2	; ES:DI <-- scratch buffer address
	MOV	AL,ES:[DI]	; AL <-- media descriptor byte from FAT
				;
	MOV	SI,OFFSET F9800	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	SI,OFFSET FB720	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	SI,OFFSET FC180	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	SI,OFFSET FD360	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	SI,OFFSET FE160	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	SI,OFFSET FF320	; SI <-- Pointer to BPB
	CMP	AL,[SI.MEDIAID]	; Compare media descriptors in FAT & BPB
	JZ	GETBPB12	; Jump if equal
				;
	MOV	BYTE PTR ERRBUF,40H ;
	MOV	BYTE PTR ERRBUF+2,01 ; No match - generate 'UNKNOWN MEDIA'
GETBPB12:			;
	MOV	ES,ES_SAVE	;
	MOV	BX,BX_SAVE	; Update I/O data packet
	MOV	ES:[BX.MEDIA],AL;	<-- media descriptor
				;
	MOV	DI,ES:[BX.COUNT]; DI <-- BUFFER AREA for BPB of selected drive
	PUSH	DS		;
	POP	ES		; ES <-- DS
				;
	CLD			; incrementing	
	MOV	CX,BPB_SIZE	; Length of (extended) BPB
REP	MOVSB			; Move BPB into BUFFER AREA
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	GETBPB13	; Jump if normal termination
	RET			; else return
GETBPB13:			;
	JMP	GETBPB6		; Jump to determine tpi of drive
;
;
;
; ***************************************
; ***  BPB's (BIOS PARAMETER BLOCKS)  ***	
; ***************************************
;
;
;
INITTAB:			;
	DW	F9800		;
	DW	F9800		;
				;
BPB_START	EQU	$
				;
BPB0:				; BUFFER AREA for BPB of DRIVE 0
				; (with default values for initialisation)
				;
	DW	512		; Sector size
	DB	2		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	7*16		; Number of directory entries
	DW	2*40*9		; Total number of sectors
	DB	0FDH		; Media byte
	DW	2		; Sectors for one FAT
				;
	DW	9		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors
				;
BPB_SIZE	EQU	$-BPB_START
				;
				;
BPB1:				; BUFFER AREA for BPB of DRIVE 1
				; (with default values for initialisation)
				;
	DW	512		; Sector size
	DB	2		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	7*16		; Number of directory entries
	DW	2*40*9		; Total number of sectors
	DB	0FDH		; Media byte
	DW	2		; Sectors for one FAT
				;
	DW	9		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors

	PAGE

FF320:				;
	DW	512		; Sector size
	DB	2		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	7*16		; Number of directory entries
	DW	2*40*8		; Total number of sectors
	DB	0FFH		; Media byte
	DW	1		; Sectors for one FAT
				;
	DW	8		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors
				;
FE160:				;
	DW	512		; Sector size
	DB	1		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	4*16		; Number of directory entries
	DW	40*8		; Total number of sectors
	DB	0FEH		; Media byte
	DW	1		; Sectors for one FAT
				;
	DW	8		; Extension: Sectors per track
	DW	1		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors
				;
FD360:				;
	DW	512		; Sector size
	DB	2		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	7*16		; Number of directory entries
	DW	2*40*9		; Total number of sectors
	DB	0FDH		; Media byte
	DW	2		; Sectors for one FAT
				;
	DW	9		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors

	PAGE

FC180:				;
	DW	512		; Sector size
	DB	1		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	4*16		; Number of directory entries
	DW	40*9		; Total number of sectors
	DB	0FCH		; Media byte
	DW	2		; Sectors for one FAT
				;
	DW	9		; Extension: Sectors per track
	DW	1		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors
				;
FB720:				;
	DW	512		; Sector size
	DB	4		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	7*16		; Number of directory entries
	DW	2*80*9		; Total number of sectors
	DB	0FBH		; Media byte
	DW	2		; Sectors for one FAT
				;
	DW	9		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors
				;
F9800:				;
	DW	1024		; Sector size
	DB	2		; Sectors per allocation unit
	DW	1		; Number of reserverd sectors
	DB	2		; Number of FATs
	DW	5*32		; Number of directory entries
	DW	2*80*5		; Total number of sectors
	DB	0F9H		; Media byte
	DW	1		; Sectors for one FAT
				;
	DW	5		; Extension: Sectors per track
	DW	2		; Extension: Number of heads
	DW	0		; Extension: Number of hidden sectors

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 83/02/25      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       DVERIFY
;
;
;
;
;
;    FUNCTION:           WRITE with verify
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:   Following  variables are set:
;                        TPI_DR, TPI_DI, BYTSEC, CYLMODE, DRV, HEAD, TRACK,
;			 SECTOR, SECCNT (Number of sectors), SECTRK,
;			 and DMAADDR (SEGMENT and OFFSET)
;
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    STATUS (returned in ERRBUF)
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE

DVERIFY:			;
	MOV	AH,HEAD		; Save PIM.HEAD
	MOV	AL,TRACK	;      PIM.TRACK
	PUSH	AX		;
	MOV	AH,SECTOR	;      PIM.SECTOR
	PUSH	AX		;
	MOV	AX,SECCNT	;      PIM.SECCNT variables to READ
	PUSH	AX		;			 after WRITE
				;
	CALL	DWRITE		; Do low level WRITE DATA
				;
	POP	AX		;
	MOV	SECCNT,AX	; Restore PIM.SECCNT
	POP	AX		;
	MOV	SECTOR,AH	;	  PIM.SECTOR
	POP	AX		;
	MOV	TRACK,AL	;	  PIM.TRACK      
	MOV	HEAD,AH		;	  PIM.HEAD variables to READ
				;			  after WRITE
				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	DVER0		; Jump if normal termination
				; else
	RET			; return
DVER0:				;
				;
				; Fill PIM variables to READ after WRITE
				; --------------------------------------
	MOV	DMAADDR,OFFSET BYTEBUF ; DMAADDR <-- OFFSET
	MOV	DMAADDR+2,CS	; 	         <-- SEGMENT	
	MOV	DMALENG,0001	; DMALENG	 <-- 1 byte transfer
	MOV	DMAFUNC,DMAWRT	; DMAFUNC	 <-- WRITE DMA COMMAND
DVER1:				;
	MOV	CL,READDAT	; CL <-- READ DATA COMMAND
	CALL	SETUP9		; Set up COMMAND STRING and DMA
	CALL	XWAIT		; Send COMMAND STRING to FDC
	CALL	GETBYT		; Get STATUS BYTES
  				;
	TEST	ERRBUF,0C0H	; Test for normal termination
	JZ	DVER2		; Jump if normal termination
				;
	POP	AX		; Flush return addr from stack
	JMP	ERROR_10	; Generate 'WRITE FAULT' error
DVER2:				;
	DEC	SECCNT		; Decrement sector counter
	JNZ	DVER3		; Jump if another I/O is necessary
	RET			; else return if I/O is complete
DVER3:				;
	MOV	AL,SECTOR	; 
	CMP	AL,SECTRK	; Check if next sector fits in track
	JZ	DVER4		; Jump if not
				;
	INC	SECTOR		; Increment SECTOR (next sector fits in track)
	JMP	DVER1		;
DVER4:				;
	MOV	SECTOR,1	; Set SECTOR to begin of track
				;
	CMP	CYLMODE,0	; Check if double sided disk
	JZ	DVER5		; Jump if double sided
				;
				; Single sided
				; ------------
	INC	TRACK		; Increment TRACK
	JMP	DVER1		;	 
DVER5:				; Double sided
				; ------------
	CMP	HEAD,0		;
	JNZ	DVER6		; If HEAD 0
	INC	HEAD		; then set HEAD 1
	JMP	DVER1		; 
DVER6:				; else
	MOV	HEAD,0		; set HEAD 0
	INC	TRACK		; and increment TRACK 
	JMP     DVER1		;
				;
				;
BYTEBUF:			;
	DB	?		; BYTE BUFFER to detect CRC errors	

	PAGE
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;    
;    DATE: 84/06/19      AUTHOR: RP
;
;    				
;
;    ROUTINE NAME:       PRDICH
;
;
;
;
;
;    FUNCTION:           PROMPT DISK CHANGE MESSAGE FOR SINGLE DRIVE SYSTEMS
;
;
;
;
;    ENTRY VIA:          CALL
;    
;
;    ENTRY CONDITIONS:	 DRV variable is set
;
;
;    EXIT VIA:           RETURN
;    
;
;    EXIT CONDITIONS:    NONE
;
;
;
;******************************************************************************
;******************************************************************************
;******************************************************************************
;
;
;
	PAGE

CR	EQU	0DH		; Carriage return
LF	EQU	0AH		; Line feed
MSGEND	EQU	24H		; Message end
				;
PROMPT1	DB	CR,LF
	DB	'Insert diskette for drive ',MSGEND

PROMPT2 DB					': and strike',CR,LF
	DB	'any key when ready',CR,LF,MSGEND

PRDICH:				;
	MOV	SI,OFFSET PROMPT1 ;
	CALL	DISP		; Display PROMPT1
				;
	MOV	AL,FL_FLAGS+2	;
	ADD	AL,'A'		;
	INT	29H		; Display drive letter
				;
	MOV	SI,OFFSET PROMPT2 ;
	CALL	DISP		; Display PROMPT2
				;
	CALL	KBD_FL		; Flush keyboard
				;
	MOV	AH,00		;
	INT	16H		; Read keyboard
				;
	RET			;
				;
				;
DISP:				;
	CLD			; Incrementing
DISP1:				;
	LODS	BYTE PTR [SI]	; Get next character
	CMP	AL,MSGEND	;
	JZ	DISP2		; Exit if message end
				; else
	INT	29H		; display character
	JMP	SHORT DISP1	;
DISP2:				;
	RET			;




DREND:				; End of driver

CSEG	ENDS
END
