;
PAGE  65,132
;
TITLE  WIDRV5
;
;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   06-15-84  I   Original Entry                                       I  WL/TR
;   07-09-84  I   Change to accept a Sector counter of zero (G2831)    I  TR
;   07-11-84  I   Correct media check                       (Q2835)    I  TR 
;             I                                                        I    
;             I                                                        I       
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;_____________________________________________________________________________
;
;
;
PAGE
;
;
;
;***************************************************
;*                                                 *
;*        W I N C H E S T E R    D I S K           *
;*                                                 *
;*                D R I V E R                      *
;*                                                 *
;***************************************************
;
; 
;
;     DEFINE OFFSETS FOR IO DATA PACKET
;
CMDLEN  EQU     0               ;LENGTH OF THIS BLOCK
UNIT    EQU     1               ;SUB UNIT SPECIFIER
CMD     EQU     2               ;COMMAND CODE
STATUS  EQU     3               ;STATUS
MEDIA   EQU     13              ;MEDIA DESCRIPTOR
TRANS   EQU     14              ;TRANSFER ADDRESS
COUNT   EQU     18              ;COUNT OF SECTORS
START   EQU     20              ;FIRST BLOCK TO TRANSFER
; 
;
;
;          WINCHESTER DISK DEFINITIONS
;          ===========================
;
;************************************************
;*						*
;*	PORT DEFINITIONS			*
;*						*
;************************************************
; 
HBASE   EQU     0C0H      	;     CONTROLLER BASE ADDR.
DATA    EQU     HBASE     	; R/W DATA REGISTER
ERROR   EQU     HBASE+1   	; R   ERROR REGISTER
WPC     EQU     HBASE+1   	;   W WRITE PRECOMP. REGISTER
SECNT   EQU     HBASE+2   	; R/W SECTOR COUNT REGISTER 
SECNO   EQU     HBASE+3   	; R/W SECTOR NUMBER REGISTER
CYLLO   EQU     HBASE+4   	; R/W CYLINDER LOW REGISTER
CYLHI   EQU     HBASE+5   	; R/W CYLINDER HIGH REGISTER
SDH     EQU     HBASE+6   	; R/W ECC/CRC-BYTES PER SECTOR-DRIVE-HEAD
STAT    EQU     HBASE+7   	; R   STATUS REGISTER
COMND   EQU     HBASE+7   	;   W COMMAND REGISTER
;
;
;************************************************
;*						*
;*	DISK FUNCTIONS				*
;*						*
;************************************************
;
STRATE  EQU     0         	;STEPING RATE TRACK TO TRACK = BUFFERED STEP
REST    EQU     10H OR STRATE 	;RESTORE COMMAND WITH STRATE
SEEK    EQU     70H OR STRATE 	;SEEK COMMAND WITH STRATE
READ    EQU     20H           	;READ COMMAND
WRITE   EQU     30H           	;WRITE COMMAND
FORMAT  EQU     50H           	;FORMAT COMMAND
;
;
;************************************************
;*						*
;*	ERRROR  REGISTER  EQUATES               *
;*						*
;************************************************
;
DAMNFD  EQU   	01H             ; ADDR. MARK NOT FOUND
TR0     EQU   	02H             ; TRACK 0 ERROR
ABC     EQU   	04H             ; ABORTED COMMAND
IDNFD   EQU   	10H		; ID NOT FOUND
CRCID   EQU   	20H             ; CRC-ERROR  ID-FIELD
UNCOR   EQU   	40H             ; UNCORRECTED DATA IN DATA FIELD
BBD     EQU   	80H             ; BAD BLOCK DETECTED
;
;************************************************
;*						*
;*	STATUS REGISTER EQUATES    		*
;*						*
;************************************************
;
CERR    EQU   	01H             ; CONTROLLER ERROR
CORRD   EQU   	04H             ; DATA CORRECTED IN DATA FIELD (ECC)
CDRQ    EQU   	08H             ; CONTROLLER DATA REQUEST
DSEEC   EQU   	10H             ; DRIVE SEEK COMPLETE
DWRFA   EQU   	20H             ; DRIVE WRITE FAULT
DREADY  EQU   	40H             ; DRIVE READY
CBUSY   EQU   	80H             ; CONTROLLER BUSY
;
;
;************************************************
;*						*
;*	SPECIALS				*
;*						*
;************************************************
;
SDHREG	EQU	0A0H		;ECC/512 BYTES PER SECTOR
;											
;	
;
PUBLIC WI_STRATEGY     		;STRATEGY ENTRY POINT
PUBLIC WI_INTERRUPT		;INTERRUPT ENTRY POINT
PUBLIC WI_START              	;BEGIN OF DRIVER  
PUBLIC WI_END			;END OF DRIVER
;
;
EXTRN WINDEV:WORD
EXTRN WINCH_DRIVES:BYTE 	;NO. OF WINCHESTER DRIVES
EXTRN WI_OUT_RETRIES:BYTE	;NO. OF RETRIES  (OUT)
EXTRN WI_IN_RETRIES:BYTE	;NO. OF RETRIES  (IN)
EXTRN WI_FLAGS:BYTE
;
;
;
;
;
;
PAGE
;
CSEG	SEGMENT PUBLIC  'CODE'
ASSUME	CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG

	ORG	0

;
BEGIN:
;
;**********************************************************
;*                                                        *
;*    S P E C I A L   D E V I C E   H E A D E R           *
;*                                                        *
;**********************************************************
;
;-----------------------------------------------+
;     DWORD pointer to next device              | 1 word offset.
;         (-1,-1 if last device)                | 1 word segement.
;-----------------------------------------------+
;     Device attribute WORD                     ; 1 word.
;       Bit 15 = 1 for chacter devices.         ;
;                0 for Block devices.           ;
;                                               ;
;       Charcter devices. (Bit 15=1)            ;
;         Bit 0 = 1  current sti device.        ;
;         Bit 1 = 1  current sto device.        ;
;         Bit 2 = 1  current NUL device.        ;
;         Bit 3 = 1  current Clock device.      ;
;                                               ;
;         Bit 14 = 1 IOCTL control bit.         ;
;-----------------------------------------------+
;     Device strategy pointer.                  ; 1 word offset.
;-----------------------------------------------+
;     Device interrupt pointer.                 ; 1 word offset.
;-----------------------------------------------+
;     Device name field.                        ; 8 bytes.
;       Character devices are any valid name    ;
;         left justified, in a space filled     ;
;         field.                                ;
;       Block devices contain # of units in     ;
;         the first byte.                       ;
;-----------------------------------------------+
;
;
WI_START:
;
;	RELEASE ID
	DB	02		;ISSUE
        DB	02		;SUB ISSUE
	DB	00		;PATCH LEVEL
;
PAGE
;
;
;
;   SIMPLISTIC STRATEGY ROUTINE FOR NON-MULTI-TASKING SYSTEM
;
;        CURRENTLY JUST SAVES I/O PACKET POINTER IN PTRSAV 
;        FOR LATER PROCESSING BY THE INTERRUPT ROUTINE.
;
STRATP	PROC	FAR
;
WI_STRATEGY:
        MOV	CS:WORD PTR PTRSAV,BX
	MOV	CS:WORD PTR PTRSAV+2,ES
	RET 
;
STRATP	ENDP
;
PTRSAV	DW	0,0		;STRATEGY POINTER SAVE
;
;
WI_INTERRUPT:
	PUSH	SI
	MOV	SI,OFFSET WITBL
;
ENTRY:  PUSH    AX              	;SAVE ALL NECESSARY REGISTERS.
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    DS
        PUSH    ES
        PUSH    BX
	PUSH    CS
	POP	DS   			;SET DATA SEG. TO CODE SEG.
        MOV     BX,WORD PTR PTRSAV	;Retrieve pointer to I/O Packet.
	MOV	ES,WORD PTR PTRSAV+2
        MOV     AL,ES:UNIT[BX]  	;AL = Unit code.
	MOV	BYTE PTR WIPAR,AL
        MOV     AH,ES:MEDIA[BX]         ;AH = Media descriptor.
	CMP 	ES:BYTE PTR CMD[BX],0	
	JZ	ENTRY1			;SKIP MEDIA CHECK IF INIT FUNCT.
  	CMP	AH,0F8H
	JB	WI_INTERRUPT1           ;Uknown Media descriptor
ENTRY1:
	MOV	CX,ES:COUNT[BX]		;CX = Contains byte/sector count.
	MOV	DX,ES:START[BX]		;DX = Starting Logical sector.
	MOV	WORD PTR WIPAR+2,DX
	XCHG	DI,AX			;Move Unit/Media into DI temporarily
	MOV	AL,ES:CMD[BX]		;Retrieve Command type.
	XOR	AH,AH			;Clear upper half of AX for calc.
        ADD     SI,AX           	;Comp. entry point in funct. table.
        ADD     SI,AX
        CMP     AL,11           	;Not more than 11 commands.
        JA      CMDERR          	;Ah, well, error out.
        XCHG    AX,DI           	;Move Unit & Media back.
        MOV     DI,ES:TRANS+2 [BX] 	;DI = addess of Transfer address.
	MOV	WORD PTR WIPAR+6,DI	;Buffer Addr. to PIM table
	MOV	DI,ES:TRANS [BX]
	MOV	WORD PTR WIPAR+8,DI	 
        JMP     WORD PTR[SI]    	;Perform I/O packet command.
WI_INTERRUPT1:
        JMP     MEDERR			;UNKNOWN MEDIA DESCRIPTOR
;
;  
;
;     WINCHESTER DISK FUNCTION TABLE
;
WITBL	DW      WIINIT        	;0  - Initialize Driver.
        DW      MEDIAC          ;1  - Return current media code.
        DW      GETBPB         	;2  - Get Bios Parameter Block.
        DW      CMDERR          ;3  - Reserved. (currently returns error)
        DW      WIREAD         	;4  - Block read.
        DW      BUSEXIT        	;5  - (Not used, return busy flag)
        DW      EXIT            ;6  - Return status. (Not used)
        DW      EXIT            ;7  - Flush input buffer. (Not used.)
        DW      WIWRT         	;8  - Block write.
        DW      WIWRTV        	;9  - Block write with verify.
        DW      EXIT            ;10 - Return output status.
        DW      EXIT            ;11 - Flush output buffer. (Not used.)
;
;
;      BIOS PARAMETER BLOCK ARRAY
;
WIBPB	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
	DW	WIBPB1C
;
;      BIOS PARAMETER BLOCK (BPB)
;
;
;      SEAGATE
;
WIBPB1C DW      512	 	;BYTES PER SECTOR
        DB     	16	  	;SECTOR PER ALLOCATION UNIT
	DW	1	 	;RESERVED SECTORS
	DB	1	 	;NUMBER OF FAT'S
      	DW	496             ;NUMBER OF ROOT DIRECT. ENTRIES
        DW	10370		;NUMBER OF SECTORS PER DISK
	DB	0F9H            ;MEDIA DESCRIPTOR
	DW	2		;NUMBER OF FAT SECTORS
	DW	17		;SECTORS PER TRACK
	DW   	2		;NUMBER OF HEADS
	DW	0		;HIDDEN SECTORS
;
;
;      SEAGATE WITHOUT BOOT RECORD
;
WIBPB1A DW	512		;BYTES PER SECTOR
	DB	16		;SECTOR PER ALLOCATION UNIT
	DW	0		;RESERVED SECTORS
	DB	1		;NUMBER OF FAT'S
	DW	512		;NUMBER OF ROOT DIRECT. ENTRIES
	DW	10370		;NUMBER OF SECTORS PER DISK
	DB	0FAH		;MEDIA DESCRIPTOR
	DW	2		;NUMBER OF FAT SECTORS
;
;
;
;  COMMON ERROR PROCESSING ROUTINE.
;   AL = ERROR CODE.
;
;   Error # 0 = Write Protect violation.
;           1 = Unknown unit.
;           2 = Drive not ready.
;           3 = Unknown command in I/O packet.
;           4 = CRC error.
;           5 = Bad drive request structure length.
;           6 = Seek error.
;           7 = Unknown media discovered.
;           8 = Sector not found.
;           9 = Printer out of paper.
;          10 = Write fault.
;          11 = Read fault.
;          12 = General failure.
;  
;
BUSEXIT:                       		;Device busy exit.
        MOV     AH,00000011B    	;Set busy and done bits.
        JMP	SHORT    EXIT1
UNITERR:
	MOV	AL,1
	JMP	SHORT	ERREXIT
LENERR: MOV	AL,5			;Bad drive request struct.length
	JMP	SHORT	ERREXIT
MEDERR:	MOV	AL,7			;Unknown Media discovered.
	JMP	SHORT	ERREXIT
CMDERR: MOV     AL,3            	;Set unknown command error #.
ERREXIT:
        MOV     AH,10000001B    	;Set error and done bits.
	STC				;Set Carry bit.
        JMP	SHORT    EXIT1     	;Quick way out.
;
EXITP	PROC	FAR
;
EXIT:   MOV     AH,00000001B    	;Set done bit for MSDOS.
EXIT1:  MOV     BX,WORD PTR PTRSAV
	MOV	ES,WORD PTR PTRSAV+2
        MOV     ES:STATUS[BX],AX   	;Save operation complete and status.
        POP     BX              	;Restore registers.
        POP     ES
        POP     DS
        POP     DI
        POP     DX
        POP     CX
        POP     AX
        POP     SI
        RET                             ;RESTORE REGS AND RETURN
;
EXITP	ENDP
;
;
;     MOVE LENGTH OF DRIVE REQU. STRUCT. TO AL REG.
;
GETLEN:	MOV	BX,WORD PTR PTRSAV
	MOV 	ES,WORD PTR PTRSAV+2
	MOV	AL,ES:BYTE PTR CMDLEN[BX]
	RET
;
;
MEDIAC:	
	CALL	GETLEN			;GET DRIVE STRUCT. LENGTH
	CMP	AL,15
	JB 	LENERR			;BAD STRUCTURE LENGTH
        MOV     AH,WI_FLAGS      	;GET MEDIA CHECK FLAG
        MOV	CL,BYTE PTR WIPAR	;GET DISK UNIT
 	MOV 	AL,01H
	SAL	AL,CL			;SHIFT AL BECAUSE CL=0
	AND     AL,AH
	JNZ     MEDIAC1
	MOV	ES:BYTE PTR TRANS[BX],1	;SET MEDIA NOT CHANGED      
	JMP	EXIT
MEDIAC1:
        MOV	ES:BYTE PTR TRANS[BX],0	;DON'T KNOW IF MEDIA HAS BEEN CHANGED
	JMP	EXIT
;
GETBPB:
	CALL	GETLEN			;GET DRIVE STRUCT. LENGTH
	CMP	AL,22
	JB 	GETBPB2			;BAD STRUCT. LENGTH
	CALL 	FIXREADY        	;CHECK IF DRIVE READY	 
	JNZ	GETBPB3
        MOV	BYTE PTR WIPAR+1,REST	;SET RESTORE FUNCTION
	MOV	WORD PTR WIPAR+2,0	;SET FAT SECTOR
	CALL 	FIXDR
	CMP	BYTE PTR WIPAR+4,50H	;CHECK IF READY AND SEEK COMPLETE
        JNZ	GETBPB3
 	PUSH 	ES
	MOV	CL,BYTE PTR WIPAR
	MOV	AL,01H
	SAL	AL,CL
	PUSH    AX 
        MOV	BYTE PTR WIPAR+1,READ   ;SET READ FUNCTION
	CALL	FIXDR
   	MOV	ES,WORD PTR WIPAR+6
	MOV     DI,WORD PTR WIPAR+8
	CMP     BYTE PTR ES:[DI],0FAH
	JZ      GETBPB5
	CMP     BYTE PTR ES:19[DI],0	;CHECK BPB  (MAX. SECTORS PER DISK)
        JZ	GETBPB1
	CMP   	BYTE PTR ES:21[DI],0F9H	;CHECK BPB  (MEDIA DESCRIPTOR)
        JZ	GETBPB6
GETBPB1:
	POP	AX
        OR      WI_FLAGS,AL	        ;SET UNKNOWN MEDIA FLAG
	POP	ES
	JMP	MEDERR			;MEDIA ERROR
GETBPB2:
	JMP	LENERR
GETBPB3:
	MOV	AL,2			;DRIVE NOT READY
	JMP	ERREXIT	
GETBPB5:	
	MOV	SI,OFFSET WIBPB1A	;BPB ADDR. OLDSTYLE SEAGATE
	JMP	GETBPB8
GETBPB6:
	MOV	CX,19
	ADD	DI,11 			;ADDR. OF BPB IN BOOT RECORD
	MOV	SI,OFFSET WIBPB1C
GETBPB7:
	MOV	AL,BYTE PTR ES:[DI]	;MOVE BPB FROM BOOT RECORD
	MOV	BYTE PTR [SI],AL
	INC	DI
	INC	SI
	LOOP	GETBPB7
	MOV	SI,OFFSET WIBPB1C
GETBPB8:
	POP	AX
	NOT	AL			;MEDIA FLAG = 0
     	AND     WI_FLAGS,AL	        ;SET MEDIA FLAG
	POP	ES
	MOV	WORD PTR ES:COUNT [BX],SI
	MOV	WORD PTR ES:COUNT+2[BX],CS
	JMP	EXIT
;
;
;      READ DATA
;
WIREAD:
  	CMP     CX,0			;CHECK IF READ SEKTOR > 0
  	JZ      WIREAD1A
	CALL	GETLEN			;GET DRIVE REQU.STRUCT.LENGTH
	CMP	AL,22
	JB 	GETBPB2			;BAD STRUCT. LENGTH
	CALL	CHKDRIVE		;CHECK IF UNIT AVAILABLE
	JC	WIREAD4			;UNIT ERROR
	CALL	FIXREADY		;CHECK IF DRIVE READY
	JNZ	WIREAD3
	MOV	AX,WORD PTR RETRYDEF	;GET NO. OF RETRIES
	MOV	WORD PTR RETRYC,AX
WIREAD1:
	MOV	BYTE PTR WIPAR+1,READ	;SET READ FUNCTION
	CALL	FIXDR			;READ ONE SECTOR
	MOV	AL,BYTE PTR WIPAR+4	;GET STATUS
	AND	AL,0F9H
	CMP	AL,58H
	JNZ	WIREAD2			;GO PERFORM RETRIES
	MOV	AX,WORD PTR RETRYDEF
	MOV	WORD PTR RETRYC,AX	;SET RETRY DEFAULT VALUE
	ADD	WORD PTR WIPAR+8,0200H	;BUFFER ADDR. +200H
	INC	WORD PTR WIPAR+2	;SECTOR # +1
	DEC	CX			;SECTOR COUNT -1
	JNZ	WIREAD1			;GO READ NEXT SECTOR
WIREAD1A:
	JMP	EXIT
;
WIREAD2:
	AND	AL,CBUSY
	JNZ	WIREAD3			;CHECK DRIVE NOT READY
	DEC	BYTE PTR RETRYC
	JNS	WIREAD1			;PERFORM RETRY
	MOV	AL,BYTE PTR RETRYDEF
	MOV	BYTE PTR RETRYC,AL	;SET RETRY DEFAULT VALUE
	DEC	BYTE PTR RETRYC+1
	JS	WIERR			;CHECK ERROR TYPE
	MOV	BYTE PTR WIPAR+1,REST	;SET RESTORE FUNCTION
	CALL	FIXDR			;RESTORE DRIVE
	JMP	WIREAD1			;GO READ AGAIN
;
WIREAD3:
	CALL	GETLEN
	MOV	ES:WORD PTR COUNT[BX],00	;SET NO. OF SECT.PROCESSED
	MOV	AL,2			;SET DRIVE NOT READY STATUS
	JMP	SHORT	WIERR2 
WIREAD4:
	JMP	UNITERR
;
;
;       ERROR ROUTINE
;
WIERR:
	CALL	GETLEN
	SUB	ES:WORD PTR COUNT[BX],CX	;SET NO. OF PROCESSED SECT.
	MOV	AL,BYTE PTR WIPAR+4	;GET STATUS REG.
	RCR	AL,1
	JC	WIERR8			;CONTROLLER ERROR
	MOV	CL,4
	RCR	AL,CL
	JNC	WIERR3			;SEEK ERROR
	RCR	AL,1
	JC	WIERR4			;WRITE FAULT
WIERR1: MOV	AL,12			;GENERAL FAILURE
WIERR2: JMP	ERREXIT			;STORE ERROR AND EXIT
;
WIERR3:	MOV	AL,6			;SEEK ERROR
	JMP	SHORT 	WIERR2
WIERR4:	MOV	AL,10			;WRITE FAULT
	JMP	SHORT	WIERR2
WIERR5:	MOV	AL,11			;READ FAULT
	JMP	SHORT	WIERR2
WIERR6:	MOV	AL,8			;SECTOR NOT FOUND
	JMP	SHORT	WIERR2
WIERR7:	MOV	AL,4			;CRC ERROR
	JMP	SHORT	WIERR2
WIERR8: MOV	AL,BYTE PTR WIPAR+5	;GET ERROR REGISTER
	RCR	AL,1
	JC	WIERR5			;ADDR. MARK NOT FOUND
	RCR	AL,1
	JC	WIERR1			;TRACK 0 ERROR
	RCR	AL,1
	JC	WIERR1			;ABORTED COMMAND
	RCR	AL,1
	RCR	AL,1
	JC	WIERR6			;ID NOT FOUND
	RCR	AL,1
	JC	WIERR7			;CRC ERROR IN ID FIELD
	RCR	AL,1
	JC	WIERR5			;UNCORRECTABLE DATA
	RCR	AL,1
	JC	WIERR6			;BAD BLOCK DETECTED
	JMP	SHORT	WIERR1
;
;
;
;
WIWRTC:
	JMP	LENERR
WIWRTD:
	JMP	UNITERR
;
;
RETRYDEF	DW	0		;RETRY DEFAULT VALUE
RETRYC		DW	0		;RETRY COUNT
WRTFLG		DB	0		; 00=WRITE, FF=WRITE/VERIFY
;
;
;
;       WRITE DATA
;
WIWRT:
	MOV	BYTE PTR WRTFLG,0	;SET WRITE DATA FLAG
WIWRT1:
	CMP	CX,0			;CHECK IF WRITE SECTOR > 0
	JZ	WIWRT31
	CALL	GETLEN			;GET DRIVE REQU. STRUCT. LENGTH
	CMP	AL,22
	JB 	WIWRTC			;BAD STRUCT. LENGTH
	CALL	CHKDRIVE		;CHECK IF UNIT AVAILABLE
	JC	WIWRTD			;UNIT ERROR
	CALL	FIXREADY		;CHECK IF DRIVE READY
	JNZ	WIWRT3A
	MOV	AX,WORD PTR RETRYDEF
	MOV	WORD PTR RETRYC,AX	;SET RETRY COUNT
WIWRT2:
	MOV	BYTE PTR WIPAR+1,WRITE	;SET WRITE FUNCTION
	CALL	FIXDR			;WRITE DATA
	MOV	AL,BYTE PTR WIPAR+4	;GET STATUS
	AND	AL,0F9H
	CMP	AL,50H			;CHECK FOR ERROR
	JNZ	WIWRT4			;PERFORM RETRIES
	MOV	AX,WORD PTR RETRYDEF
	MOV	WORD PTR RETRYC,AX	;SET RETRY DEFAULT VALUES
	CMP	BYTE PTR WRTFLG,0
	JNZ	WIWRT5			;GO VERIFY DATA
WIWRT3:
	ADD	WORD PTR WIPAR+8,0200H	;BUFFER ADDR. +200H
	INC	WORD PTR WIPAR+2	;SECTOR NUMBER +1
	DEC	CX			;SECTOR COUNT -1
	JNZ	WIWRT2			;GO WRITE NEXT SECTOR
WIWRT31:
	JMP	EXIT
WIWRT3A:
	CALL	GETLEN
	MOV	ES:WORD PTR COUNT[BX],00	;SET NO. OF PROCESSED SECT.
	MOV	AL,2			;DRIVE NOT READY
	JMP   	ERREXIT	
WIWRT3B:
	JMP	WIERR			;CHECK STATUS TYPE
WIWRT4:
	AND	AL,CBUSY		;CHECK IF DRIVE NOT READY
	JNZ	WIWRT3A
	DEC	BYTE PTR RETRYC
	JNS	WIWRT2			;WRITE AGAIN
	MOV 	AL,BYTE PTR RETRYDEF
	MOV	BYTE PTR RETRYC,AL	;SET RETRY DEFAULT VALUE
	DEC	BYTE PTR RETRYC+1
	JS	WIWRT3B			;WRITE ERROR
	MOV	BYTE PTR WIPAR+1,REST	;SET RESTORE FUNCTION
	CALL	FIXDR			;RESTORE DRIVE
	JMP	WIWRT2			;WRITE NEXT SECTOR
WIWRT5:
	MOV	ES,WORD PTR WIPAR+6
	MOV	DI,WORD PTR WIPAR+8	;SAVE DATA BUFFER ADDR.
WIWRT6:
	MOV	AL,BYTE PTR WIPAR+10	;GET ACTUAL SDH REG. CONTENTS
	OUT	SDH,AL
	MOV	AL,READ
	OUT	COMND,AL		;OUTPUT READ FUNCTION
	CALL	WAIT
	IN	AL,SDH
	OR	AL,18H
	OUT	SDH,AL			;CLEAR DRIVE LAMP
	PUSH	CX
	MOV	CX,512
WIWRT6A:
	IN	AL,DATA			;GET READ DATA
	SCASB				;COMPARE WITH DATA WRITTEN
	LOOPZ	WIWRT6A
	JNZ	WIWRT7
WIWRT6B:
	POP	CX
	MOV	AL,BYTE PTR WIPAR+4	;GET STATUS
	AND	AL,0F9H
	CMP	AL,58H
	JZ	WIWRT8
	DEC	BYTE PTR RETRYC
	JNZ	WIWRT6			;PERFORM RETRY
	MOV	BYTE PTR RETRYC,5
	DEC	BYTE PTR RETRYC+1
	JZ	WIWRTB 			;READ ERROR
	MOV	BYTE PTR WIPAR+1,REST	;SET RESTORE FUNCTION
	CALL 	FIXDR			;RESTORE DRIVE
	JMP	WIWRT6
WIWRT7:
	CMP	CX,0
	JZ	WIWRT7B
WIWRT7A:
	IN	AL,DATA
	LOOP	WIWRT7A
WIWRT7B:
	OR	BYTE PTR WIPAR+4,DWRFA	;SET WRITE FAULT ERROR
	JMP	SHORT	WIWRT6B	
WIWRT8:
	MOV	WORD PTR RETRYC,0505H	;SET RETRY DEFAULT VALUE
	JMP	WIWRT3
WIWRTA:
	POP	CX
  	JMP	WIERR4			;DATA VERIFY ERROR
WIWRTB:
	JMP	WIERR			;SET ERROR STATUS
;				
;
;
;
;       WRITE DATA AND VERIFY
;
WIWRTV:
	MOV	BYTE PTR WRTFLG,0FFH	;SET WRITE/VERIFY FLAG
	JMP	WIWRT1
;
;
;      ROUTINE TO CHECK IF UNIT AVAILABLE
;         EXIT: CARRY ON=UNIT ERROR
;
CHKDRIVE:
	PUSH	AX
	MOV	AL,BYTE PTR WIPAR	;GET UNIT NO. TO WORK WITH
	MOV	AH,BYTE PTR WINDEV+10	;GET NO.OF UNITS IN SYSTEM
	CMP	AH,AL
	POP	AX
	JBE	CHKDRIVE1
	CLC
	RET
CHKDRIVE1:
	STC
	RET
;
;
; 
;
;
PAGE
;
;
;************************************************
;*						*
;*	PERIPHERAL INTERFACE MODULE (PIM)       *
;*						*
;*             WINCHESTER DISK                	* 
;*						*
;************************************************
;
;UNIT 0= HEAD 0 AND 1
;UNIT 1= HEAD 2 AND 3
;
;
;          WINCHESTER DISK PARAMETER BLOCK
;          ===============================
;
;
WIPAR   DB  	0           	; WIPAR + 0      DISK UNIT
        DB  	REST        	; WIPAR + 1      FUNCTION 
        DW  	0           	; WIPAR + 2      SECTOR LO
                         	; WIPAR + 3      SECTOR HI
        DB  	0           	; WIPAR + 4      STATUS 1
        DB  	0           	; WIPAR + 5      STATUS 2
	DW	0		; WIPAR + 6      BUFFER ADDR.(SEGMENT)
	DW	0		; WIPAR + 8      BUFFER ADDR.(OFFSET)
	DB	0		; WIPAR + 10     ACTUAL SDH REG. CONTENTS
; 
;
;
;********************************************
;*                                          *
;*   CHECK IF WINCHESTER DRIVE IS           *
;*    CONNECTED AND POWERED ON.             *
;*                                          *
;*    EXIT: ZERO FLAG ON = DRIVE READY      *
;*                                          *
;********************************************
;
FIXREADY:
	MOV	AL,55H
	OUT	CYLLO,AL		;OUTPUT PATTERN TO R/W PORT
	MOV	AL,0AAH
	OUT	SECNO,AL
	IN	AL,CYLLO		;READ PATTERN BACK AND COMPARE
	CMP	AL,55H
	JNZ	FIXREADY1
	IN	AL,SECNO
	CMP	AL,0AAH
FIXREADY1:
	RET
;
;
;********************************************
;*                                          *
;*    WINCHESTER DISK DRIVER                *
;*                                          *
;*     ENTRY: PARAMETER BLOCK FILLED UP     *
;*     EXIT:  STATUS BYTES IN PARAM.        *
;*            BLOCK UPDATED AND ALL         *
;*            REGISTERS SAVED.              *
;********************************************
;
;   
FIXDR:	PUSH 	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV  	AX,WORD PTR WIPAR+2	;GET LOGIC SECTOR NUMBER
	MOV  	CX,17
	MOV  	DX,0
	DIV  	CX			;CALCULATE CYL/HEAD
	PUSH 	AX
	MOV  	AL,DL
	OUT  	SECNO,AL		;SET SECTOR NUMBER
	MOV  	BL,BYTE PTR WIPAR	;GET DISK UNIT #
	MOV	BH,BL
	AND	BX,0601H
	ROL	BH,1
	OR	BL,BH
	ROL  	BL,1
	POP  	AX
	PUSH 	AX
	AND  	AL,01H			;GET HEAD BIT
	OR   	AL,BL
	OR   	AL,SDHREG		;ECC/CRC AND BYTES PER SECTOR
	OUT  	SDH,AL			;SET ECC/CRC-BYTES/SECT-DRIVE-HEAD
	MOV	BYTE PTR WIPAR+10,AL	;SAVE ACTUAL SDH REG. CONTENTS
	POP  	AX
	ROR  	AX,1
	OUT  	CYLLO,AL		;SET CYLINDER LOW
	AND  	AH,03H
	MOV  	AL,AH
	OUT  	CYLHI,AL		;SET CYLINDER HIGH
	IN   	AL,STAT			;GET DISK STATUS
	MOV	BYTE PTR WIPAR+4,AL
	AND  	AL,CBUSY		;CHECK IF CONTROLLER BUSY
	JNZ  	FIXD3
	MOV  	AL,BYTE PTR WIPAR+1
	OUT  	COMND,AL		;SET FUNCTION
	AND  	AL,0F0H
	CMP  	AL,READ
	JZ   	RD			;GO READ DATA
	CMP  	AL,WRITE
	JZ   	WR			;GO WRITE DATA
	CMP  	AL,FORMAT
	JZ   	WR0			;GO FORMAT ONE TRACK
	JMP  	WR2			;SEEK OR RESTORE
FIXD3:	IN	AL,SDH
	OR	AL,18H
	OUT	SDH,AL			;CLEAR DISK LAMP
	POP  	DX
	POP	CX
	POP	BX
	POP	AX
	RET
; 
;
;
;         *****************************
;         *	READ ROUTINE          *
;         *****************************
;
RD:	CALL 	WAIT			;WAIT UNTIL READ COMPLETE
	PUSH	DS
	MOV	BX,WORD PTR WIPAR+8	;GET OFFSET
	MOV	DS,WORD PTR WIPAR+6	;GET SEGMENT ADDR.
	MOV	CX,512			;INPUT COUNT
RD2:    IN   	AL,DATA			;INPUT DATA
	MOV  	BYTE PTR[BX],AL 	;SAVE INPUT
	INC  	BX
	LOOPNZ  RD2		;CONTINUE UNTIL ALL BYTES IN BUFFER
				;BUT STOP BEFORE BUFFER ADDR. WRAP AROUND
	CMP	CX,0
	JZ	RD4
RD3:	IN	AL,DATA			;CLEAR CONTROLLER BUFFER
	LOOP	RD3
RD4:    POP	DS
        JMP	SHORT 	FIXD3
;
;
;         *****************************
;         *     WAIT ROUTINE          *
;         *****************************
;
WAIT:   IN   	AL,STAT			;GET STATUS
	AND  	AL,CBUSY
	JNZ  	WAIT			;LOOP UNTIL DISK READY
	IN   	AL,STAT
	MOV  	BYTE PTR WIPAR+4,AL	;SAVE STATUS
	RCR  	AL,1
	JC   	ER1			;JUMP IF ERROR CONDITION
	RET
;
ER1:    IN   	AL,ERROR		;GET ERROR STATUS
	MOV  	BYTE PTR WIPAR+5,AL	;SAVE STATUS
	RET
;
;         *****************************
;         *     WRITE ROUTINE         *
;         *****************************
;
WR0:    MOV  	AL,17
	OUT  	SECNT,AL		;SET SECT COUNT FOR FORMAT
;
WR:	PUSH	DS
	MOV	BX,WORD PTR WIPAR+8	;BUFFER ADDR.(OFFSET)
	MOV  	DS,WORD PTR WIPAR+6	;BUFFER ADDR.(SEGMENT)
    	MOV  	CX,512			;INPUT COUNT
WR1:	MOV  	AL,BYTE PTR[BX]		;GET BYTE FROM BUFFER
	OUT  	DATA,AL			;OUTPUT DATA
	INC  	BX
	LOOP 	WR1
	POP	DS
WR2:    CALL 	WAIT			;WAIT UNTIL FUNCT. COMPLETE
	JMP	SHORT 	FIXD3
;
;
;
;
;
;
;
;
WIINIT:
	CALL	GETLEN			;GET DRIVE REQU. STRUCT.LENGTH
	CMP	AL,22
	JB 	WIINIT1			;BAD STRUCT. LENGTH
	MOV	AL,WI_FLAGS
	OR	AL,7FH			;SET UNKNOWN DISK
	MOV	WI_FLAGS,AL
	MOV	AL,WINCH_DRIVES   	;GET NO. OF DRIVES ON SYSTEM
	ROL	AL,1			;MAKE NO. OF UNITS
	MOV	CL,WI_OUT_RETRIES       ;GET RETRY (OUT) COUNTS
        MOV     CH,WI_IN_RETRIES	;GET RETRY (IN) COUNTS
	MOV	BYTE PTR RETRYDEF,CH
	MOV	BYTE PTR RETRYDEF+1,CL	;SAVE RETRY COUNTS
	MOV	BYTE PTR WINDEV+10,AL	;SET NUMBER OF UNITS
	MOV 	ES:BYTE PTR MEDIA[BX],AL
	MOV	ES:WORD PTR TRANS[BX],OFFSET WIINIT
	MOV 	ES:WORD PTR TRANS+2[BX],CS
	MOV 	ES:WORD PTR COUNT[BX],OFFSET WIBPB 	;ADDR. OF BPB ARRAY
	MOV	ES:WORD PTR COUNT+2[BX],CS
	MOV	WORD PTR WITBL,OFFSET EXIT
	CALL	FIXREADY
	JNZ	WIINIT4
	MOV	BYTE PTR WIPAR+1,REST
	AND	BYTE PTR WIPAR,01
	CALL	FIXDR			;RESTORE DRIVE
	CMP	BYTE PTR WIPAR+4,50H
	JNZ	WIINIT2			;ERROR CONDITION
	JMP     EXIT
WIINIT1:
	JMP	LENERR
WIINIT2:
	MOV	AL,BYTE PTR WIPAR+4
	AND	AL,CBUSY
WIINIT4:
	MOV	AL,2			;DRIVE NOT READY
	JNZ	WIINIT3
	MOV	AL,12			;GENERAL FAILURE
WIINIT3:
	JMP	ERREXIT			;SAVE STATUS AND EXIT
;
;	
;
;
;
WI_END: 
;
CSEG   ENDS
;
;
END	BEGIN
;
