/*
 * Decompiled with CFR 0.152.
 */
package cdt2wav;

import cdt2wav.CDT2WAV;
import cdt2wav.PCMFilePlayer;
import cdt2wav.Samples;
import cdt2wav.wav2mp3;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends JFrame
implements KeyListener {
    private ArrayList<DropTarget> dropTargetList;
    public static int[] blocks;
    String[] ids;
    byte[] tapesample;
    AdjustmentListener hListener = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Main.this.bar.repaint();
        }
    };
    int divider = 500;
    int tapeposition = 0;
    boolean wait = false;
    ActionListener updateScroll = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Main.this.Update(Main.this.bar.getGraphics());
                }
            });
        }
    };
    public Timer cycleUpdate = new Timer(30, this.updateScroll);
    final URL glossy = this.getClass().getResource("lcd2.png");
    final Image Glossy = this.getToolkit().getImage(this.glossy);
    final URL glossy2 = this.getClass().getResource("lcd22.png");
    final Image Glossy2 = this.getToolkit().getImage(this.glossy2);
    final URL glassy = this.getClass().getResource("glass.png");
    final Image Glas = this.getToolkit().getImage(this.glassy);
    BufferedImage tapeMagnetBand;
    BufferedImage controlImg;
    int drawtime;
    int pausepos = 200;
    Font font;
    int flashdelay;
    boolean flash;
    boolean playing = false;
    int freq = 44100;
    String savename = "";
    wav2mp3 wmp3 = new wav2mp3();
    boolean showmp3 = false;
    int lastpos;
    PCMFilePlayer player;
    private JCheckBox autoplay;
    private JLabel bar;
    public static JList blocklist;
    private ButtonGroup buttonGroup1;
    private JRadioButton high;
    private JButton jButton1;
    public JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    public static JScrollPane jScrollPane1;
    private JRadioButton low;
    private JRadioButton medium;
    private JCheckBox mp3;
    private JButton play;
    private JProgressBar progress;
    private JButton rewind;
    private JButton save;
    public JButton stop;

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.autoplay.isSelected() && e.getKeyCode() == 32 && this.playing) {
            this.stop();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.autoplay.isSelected() && e.getKeyCode() == 32 && !this.playing) {
            this.play();
        }
    }

    public void setTape(int index) {
        System.out.println("Jumping to " + blocks[index]);
        this.player.setPos(blocks[index]);
    }

    public void initBand() {
        Graphics2D g = this.tapeMagnetBand.createGraphics();
        this.tapeposition = 0;
        this.wait = true;
        int i = 0;
        int p = 0;
        int oldy = 20;
        int k = 0;
        int l = 0;
        while ((i += this.divider) < this.tapesample.length) {
            int y = this.tapesample[i] == -128 ? 20 : ((this.tapesample[i] & 0x28) == 0 ? 10 : 30);
            g.setColor(Color.black);
            g.drawLine(p + 100, oldy, p + 100, y);
            ++p;
            if (k < this.tapesample.length / this.divider) {
                g.setColor(Color.black);
                g.drawLine(k + 100, 36, k + 100, 50);
                g.drawLine(k + 100, 0, k + 100, 6);
                k += 45;
            }
            if (l < this.tapesample.length / this.divider) {
                g.setColor(Color.darkGray);
                g.drawLine(l + 100, 40, l + 100, 60);
                g.drawLine(l + 100, 0, l + 100, 2);
                l += 5;
            }
            oldy = y;
        }
    }

    public void Update(Graphics v) {
        if (this.controlImg == null) {
            this.controlImg = new BufferedImage(240, 42, 1);
        }
        Graphics2D f = this.controlImg.createGraphics();
        if (this.tapeMagnetBand == null) {
            f.drawImage(this.autoplay.isSelected() ? this.Glossy2 : this.Glossy, 0, 0, 240, 42, null);
            f.setColor(Color.black);
            f.drawLine(98, 20, 290, 20);
            int k = 0;
            int l = 0;
            for (int i = 0; i < 100; ++i) {
                f.setColor(Color.black);
                f.drawLine(k + 100, 36, k + 100, 50);
                f.drawLine(k + 100, 0, k + 100, 6);
                k += 45;
                f.setColor(Color.darkGray);
                f.drawLine(l + 100, 40, l + 100, 60);
                f.drawLine(l + 100, 0, l + 100, 2);
                l += 5;
            }
            f.setColor(new Color(255, 0, 0, 63));
            f.fillRect(98, 0, 4, 44);
            ++this.flashdelay;
            if (this.flashdelay == 6) {
                this.flashdelay = 0;
                this.flash = !this.flash;
            }
            f.setColor(this.flash ? Color.red : Color.black);
            if (this.font == null) {
                this.font = new Font("Tahoma", 1, 24);
            }
            f.setFont(this.font);
            ((Graphics)f).drawString("PLEASE OPEN CDT FILE!", this.pausepos, 30);
            this.pausepos -= 2;
            if (this.pausepos < -380) {
                this.pausepos = 240;
            }
            f.drawImage(this.Glas, 0, 0, 240, 42, null);
            v.drawImage(this.controlImg, 0, 0, null);
            return;
        }
        this.tapeposition = this.player.getPos() / this.divider;
        boolean showInfo = false;
        if (this.playing) {
            this.drawtime = this.tapeposition;
            showInfo = false;
        } else {
            showInfo = true;
        }
        this.progress.setValue(this.drawtime);
        f.drawImage(this.autoplay.isSelected() ? this.Glossy2 : this.Glossy, 0, 0, 240, 42, null);
        f.drawImage((Image)this.tapeMagnetBand, -this.drawtime, 0, null);
        f.setColor(new Color(255, 0, 0, 63));
        f.fillRect(98, 0, 4, 44);
        if (this.showmp3) {
            ++this.flashdelay;
            if (this.flashdelay == 6) {
                this.flashdelay = 0;
                this.flash = !this.flash;
            }
            f.setColor(this.flash ? Color.red : Color.black);
            if (this.font == null) {
                this.font = new Font("Tahoma", 1, 24);
            }
            f.setFont(this.font);
            ((Graphics)f).drawString("STORING MP3 FILE", this.pausepos, 30);
            this.pausepos -= 2;
            if (this.pausepos < -180) {
                this.pausepos = 240;
            }
        } else if (showInfo) {
            ++this.flashdelay;
            if (this.flashdelay == 6) {
                this.flashdelay = 0;
                this.flash = !this.flash;
            }
            f.setColor(this.flash ? Color.red : Color.black);
            if (this.font == null) {
                this.font = new Font("Tahoma", 1, 24);
            }
            f.setFont(this.font);
            ((Graphics)f).drawString("PAUSED!", this.pausepos, 30);
            this.pausepos -= 2;
            if (this.pausepos < -180) {
                this.pausepos = 240;
            }
        }
        f.drawImage(this.Glas, 0, 0, 240, 42, null);
        v.drawImage(this.controlImg, 0, 0, null);
    }

    public void UpdateScroller() {
        if (this.playing) {
            try {
                this.tapeposition = this.player.getPos() / this.divider;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void Convert(byte[] data) {
        this.setAlwaysOnTop(false);
        this.tapesample = new byte[10000];
        if (this.high.isSelected()) {
            this.freq = 44100;
            this.divider = 400;
        }
        if (this.medium.isSelected()) {
            this.freq = 22050;
            this.divider = 200;
        }
        if (this.low.isSelected()) {
            this.freq = 11025;
            this.divider = 100;
        }
        CDT2WAV cdt2wav = new CDT2WAV(data, this.freq, this.jCheckBox1.isSelected());
        this.tapesample = cdt2wav.convert();
        this.progress.setValue(0);
        blocks = cdt2wav.blocks;
        this.ids = cdt2wav.ids;
        Main.blocks[Main.blocks.length - 1] = this.tapesample.length - 44;
        for (int i = 0; i < blocks.length; ++i) {
            System.out.println(blocks[i]);
        }
        this.ids[this.ids.length - 1] = "Eject tape";
        cdt2wav.dispose();
        this.setAlwaysOnTop(this.autoplay.isSelected());
    }

    private void Convert(String name) {
        File cdt = new File(name);
        this.savename = name;
        this.savename = this.savename.replace(".cdt", "");
        this.savename = this.savename.replace(".CDT", "");
        this.savename = this.savename + ".wav";
        if (this.player != null) {
            this.player.stop();
            this.player.close();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cdt));
            int length = in.available();
            byte[] data = new byte[length];
            in.read(data);
            in.close();
            this.Convert(data);
            if (this.tapesample != null && this.tapesample.length > 10) {
                if (this.high.isSelected()) {
                    this.divider = 1000;
                }
                if (this.medium.isSelected()) {
                    this.divider = 500;
                }
                if (this.low.isSelected()) {
                    this.divider = 250;
                }
                this.progress.setMinimum(0);
                this.tapeMagnetBand = new BufferedImage(this.tapesample.length / this.divider + 300, 64, 2);
                this.initBand();
                this.save.setEnabled(true);
                this.feedInfo();
                if (this.jCheckBox3.isSelected()) {
                    this.Save(this.savename);
                } else {
                    this.play.setEnabled(true);
                    this.stop.setEnabled(true);
                    this.rewind.setEnabled(true);
                    this.prepareToPlay();
                }
            } else {
                this.save.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLength() {
        return this.tapesample.length / this.divider + 300;
    }

    private void feedInfo() {
        String[] blockinfo = new String[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            int o = i;
            String pre = "";
            if (o < 1000) {
                pre = pre + "0";
            }
            if (o < 100) {
                pre = pre + "0";
            }
            if (o < 10) {
                pre = pre + "0";
            }
            pre = pre + i;
            blockinfo[i] = pre + " - " + this.ids[i];
        }
        this.buildInfo(blockinfo);
    }

    public void buildInfo(final String[] block) {
        blocklist.setModel(new AbstractListModel(){

            public int getSize() {
                return block.length;
            }

            public Object getElementAt(int i) {
                return block[i];
            }
        });
    }

    private void Convert() {
        this.setAlwaysOnTop(false);
        JFrame dummy = new JFrame();
        System.out.println("Load CDT");
        FileDialog filedia = new FileDialog((Frame)dummy, "Load CDT", 0);
        filedia.setFile("*.cdt");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            this.Convert(filename);
        }
        this.setAlwaysOnTop(true);
    }

    private void Save() {
        this.setAlwaysOnTop(false);
        JFrame dummy = new JFrame();
        System.out.println("Save WAV");
        FileDialog filedia = new FileDialog((Frame)dummy, "Save WAV", 1);
        filedia.setFile("*.wav");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            this.Save(filename);
        }
        this.setAlwaysOnTop(this.autoplay.isSelected());
    }

    private void Save(final String name) {
        File cdt = new File(name);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cdt));
            out.write(this.tapesample);
            out.close();
            this.play.setEnabled(true);
            this.stop.setEnabled(true);
            this.rewind.setEnabled(true);
            this.prepareToPlay();
            if (this.mp3.isSelected()) {
                this.showmp3 = true;
                this.progress.setIndeterminate(true);
                Thread thread = new Thread(){

                    public void run() {
                        Main.this.wmp3.encodeAudio(new File(name), new File(name.replace(".wav", ".mp3")), "audio/wav");
                        Main.this.progress.setIndeterminate(false);
                        Main.this.showmp3 = false;
                    }
                };
                thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if (this.player != null) {
            this.stop.setEnabled(true);
            Samples.RELAIS.play();
            this.playing = true;
            this.progress.setMinimum(0);
            this.progress.setMaximum(this.getLength());
            try {
                this.player.start();
                this.player.setPos(this.lastpos);
                this.progress.setValue(60);
            }
            catch (Exception e) {
                this.prepareToPlay();
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            this.stop.setEnabled(false);
            Samples.RELAISOFF.play();
            this.playing = false;
            this.lastpos = this.player.getPos();
            this.player.stop();
        }
    }

    public void prepareToPlay() {
        if (this.player != null) {
            Samples.RELAISOFF.play();
            this.player.stop();
            this.player.close();
        }
        this.player = null;
        System.gc();
        try {
            this.player = new PCMFilePlayer(new File(this.savename), this);
            this.player.lastindex = -1;
            this.jCheckBox2.setEnabled(true);
            this.autoplay.setEnabled(true);
            this.lastpos = 0;
        }
        catch (Exception e) {
            this.jCheckBox2.setEnabled(false);
            this.autoplay.setEnabled(false);
        }
    }

    public Main() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.jCheckBox3.setVisible(false);
        this.addKeyListener(this);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.cycleUpdate.start();
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        Main.registerDropListener(this.dropTargetList, this, myListener);
        this.save.setVisible(false);
        this.save.setEnabled(false);
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                Main.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.save = new JButton();
        this.jButton1 = new JButton();
        this.play = new JButton();
        this.stop = new JButton();
        this.rewind = new JButton();
        this.progress = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.low = new JRadioButton();
        this.medium = new JRadioButton();
        this.high = new JRadioButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        jScrollPane1 = new JScrollPane();
        blocklist = new JList();
        this.jPanel2 = new JPanel();
        this.bar = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.autoplay = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.mp3 = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("CDT2WAV 1.6 - \u00a9 2016 by Markus Hohmann");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Main.this.formFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                Main.this.formFocusLost(evt);
            }
        });
        this.jPanel1.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Main.this.jPanel1FocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                Main.this.jPanel1FocusLost(evt);
            }
        });
        this.save.setText("Save WAV");
        this.save.setFocusable(false);
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.saveActionPerformed(evt);
            }
        });
        this.jButton1.setText("Open CDT");
        this.jButton1.setToolTipText("As expected: Open a CDT file here");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.jButton1ActionPerformed(evt);
            }
        });
        this.play.setText("Play");
        this.play.setToolTipText("Plays back loaded CDT file");
        this.play.setEnabled(false);
        this.play.setFocusable(false);
        this.play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.playActionPerformed(evt);
            }
        });
        this.stop.setText("Pause");
        this.stop.setToolTipText("Pauses the playback");
        this.stop.setEnabled(false);
        this.stop.setFocusable(false);
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.stopActionPerformed(evt);
            }
        });
        this.rewind.setText("Stop");
        this.rewind.setToolTipText("Yeah! It really stops the playback");
        this.rewind.setEnabled(false);
        this.rewind.setFocusable(false);
        this.rewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.rewindActionPerformed(evt);
            }
        });
        this.progress.setToolTipText("Huh! Where am I?");
        this.progress.setFocusable(false);
        this.jLabel1.setText("CDT routines by John Girvin");
        this.jLabel1.setToolTipText("Right! This nice guy converted some important routines from C to Java!");
        this.jLabel1.setEnabled(false);
        this.jLabel1.setFocusable(false);
        this.jLabel2.setText("CDT2WAV \u00a92010-2016 by Markus Hohmann");
        this.jLabel2.setToolTipText("Yeah all your money goes here! (For contact: drop a mail to webmaster@cpc-live.com)");
        this.jLabel2.setEnabled(false);
        this.jLabel2.setFocusable(false);
        this.buttonGroup1.add(this.low);
        this.low.setText("11khz");
        this.low.setToolTipText("Poorest audio quality. You should avoid it.");
        this.low.setFocusable(false);
        this.buttonGroup1.add(this.medium);
        this.medium.setText("22khz");
        this.medium.setToolTipText("22 khz sample quality. 44 khz is better!");
        this.medium.setFocusable(false);
        this.buttonGroup1.add(this.high);
        this.high.setSelected(true);
        this.high.setText("44khz");
        this.high.setToolTipText("For getting the best audio signal results");
        this.high.setFocusable(false);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Use 3 states (High, Low, No)");
        this.jCheckBox1.setToolTipText("Should be enabled to get a better audio signal");
        this.jCheckBox1.setFocusable(false);
        this.jLabel3.setText("Based on TZX2WAV by Francisco Javier Crespo");
        this.jLabel3.setToolTipText("Woohooo! The original author for the command line tool TZX2WAV! Cheers!");
        this.jLabel3.setEnabled(false);
        this.jLabel3.setFocusable(false);
        jScrollPane1.setAutoscrolls(true);
        jScrollPane1.setFocusable(false);
        blocklist.setToolTipText("Shows the blocks found in a CDT file. Double click a block to jump to it.");
        blocklist.setFocusable(false);
        blocklist.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                Main.this.blocklistMouseMoved(evt);
            }
        });
        blocklist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Main.this.blocklistMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                Main.this.blocklistMousePressed(evt);
            }
        });
        jScrollPane1.setViewportView(blocklist);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setFocusable(false);
        this.jPanel2.setLayout(new BorderLayout());
        this.bar.setIcon(new ImageIcon(this.getClass().getResource("/cdt2wav/lcd2.png")));
        this.jPanel2.add((Component)this.bar, "Center");
        this.jCheckBox2.setText("Auto Pause");
        this.jCheckBox2.setToolTipText("Pauses playback after each block");
        this.jCheckBox2.setEnabled(false);
        this.jCheckBox2.setFocusable(false);
        this.jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.autoplay.setText("Autoplay");
        this.autoplay.setToolTipText("Plays CDT while space bar is pressed. Pauses playback when spacebar is being released");
        this.autoplay.setFocusable(false);
        this.autoplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.autoplayActionPerformed(evt);
            }
        });
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("Autosave");
        this.jCheckBox3.setFocusable(false);
        this.jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.mp3.setText("MP3");
        this.mp3.setFocusable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.progress, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.low).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.medium).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.high)).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoplay).addComponent(this.jCheckBox2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.play).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rewind).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mp3))).addGap(0, 0, Short.MAX_VALUE))).addGap(6, 6, 6).addComponent(jScrollPane1, -2, 201, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.save).addComponent(this.jCheckBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.play).addComponent(this.stop).addComponent(this.rewind).addComponent(this.mp3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.low).addComponent(this.medium).addComponent(this.high).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.autoplay)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3))).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Convert();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.Save();
    }

    private void playActionPerformed(ActionEvent evt) {
        this.play();
    }

    private void stopActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void rewindActionPerformed(ActionEvent evt) {
        this.prepareToPlay();
    }

    private void blocklistMouseClicked(MouseEvent evt) {
        if (this.player != null) {
            this.player.interval = -50;
            if (evt.getClickCount() == 2) {
                this.setTape(blocklist.getSelectedIndex());
            }
        }
    }

    private void blocklistMousePressed(MouseEvent evt) {
        if (this.player != null) {
            this.player.interval = -50;
        }
    }

    private void blocklistMouseMoved(MouseEvent evt) {
        if (this.player != null) {
            this.player.interval = -50;
        }
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.player.autoPause = this.jCheckBox2.isSelected();
        this.autoplay.setEnabled(!this.player.autoPause);
    }

    private void jPanel1FocusGained(FocusEvent evt) {
        System.out.println("Focus gained");
    }

    private void jPanel1FocusLost(FocusEvent evt) {
        System.out.println("Focus lost");
    }

    private void formFocusGained(FocusEvent evt) {
        System.out.println("Main Window: Focus gained");
    }

    private void formFocusLost(FocusEvent evt) {
        System.out.println("Main Window: Focus lost");
        if (this.isAlwaysOnTop()) {
            this.requestFocus();
        }
    }

    private void autoplayActionPerformed(ActionEvent evt) {
        this.jCheckBox2.setEnabled(!this.autoplay.isSelected());
        this.setAlwaysOnTop(this.autoplay.isSelected());
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.save.setVisible(!this.jCheckBox3.isSelected());
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main main = new Main();
                if (args.length > 0 && args[0].toLowerCase().contains("-batch")) {
                    String d = args[1];
                    System.out.println("parameters:");
                    for (int i = 0; i < args.length; ++i) {
                        System.out.println(args[i]);
                    }
                    System.out.println("----------");
                    d = d.replace("-batch", "");
                    while (d.startsWith(" ")) {
                        d = d.substring(1);
                    }
                    while (d.endsWith(" ")) {
                        d = d.substring(0, d.length() - 1);
                    }
                    if (d.toLowerCase().equals("root")) {
                        d = ".";
                    }
                    System.err.println(d);
                    File f = new File(d);
                    String[] dd = f.list();
                    if (dd != null && dd.length > 0) {
                        for (int i = 0; i < dd.length; ++i) {
                            String g = d + "/" + dd[i];
                            if (!g.toLowerCase().endsWith(".cdt")) continue;
                            main.Convert(g);
                        }
                        System.exit(0);
                    }
                }
                if (args.length > 0 && args[0].toLowerCase().contains(".cdt")) {
                    main.Convert(args[0]);
                }
                main.setVisible(true);
            }
        });
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    String fileName;
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List && (fileName = ((List)userObject).get(0).toString()).toLowerCase().endsWith("cdt")) {
                        if (Main.this.player != null) {
                            Main.this.player.stop();
                            Main.this.player.close();
                        }
                        Main.this.Convert(fileName);
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

