/*
 * Decompiled with CFR 0.152.
 */
package cdt2wav;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Samples {
    RELAIS("cdt2wav/relon.wav"),
    RELAISOFF("cdt2wav/reloff.wav");

    public static Volume volume;
    public boolean nosamples = false;
    public static boolean quiet;
    private Clip clip;

    private Samples(String soundFileName) {
        if (this.nosamples) {
            return;
        }
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        catch (Exception e) {
            this.nosamples = true;
        }
    }

    public void play() {
        if (quiet) {
            return;
        }
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void stop() {
        if (this.nosamples) {
            return;
        }
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
        this.clip.stop();
    }

    static void init() {
        Samples.values();
    }

    static {
        volume = Volume.HIGH;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

