/*
 * Decompiled with CFR 0.152.
 */
package cdt2wav;

import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncodingAttributes;
import java.awt.EventQueue;
import java.io.File;

public class wav2mp3 {
    private static final Integer bitrate = 128000;
    private static final Integer channels = 1;
    private static final Integer samplingRate = 44100;
    private AudioAttributes audioAttr = new AudioAttributes();
    private EncodingAttributes encoAttrs = new EncodingAttributes();
    private Encoder encoder = new Encoder();
    private String oggFormat = "ogg";
    private String mp3Format = "mp3";
    private String wavFormat = "wav";
    private String oggCodec = "vorbis";

    public wav2mp3() {
        this.audioAttr.setBitRate(bitrate);
        this.audioAttr.setChannels(channels);
        this.audioAttr.setSamplingRate(samplingRate);
    }

    public void encodeAudio(File source, File target, String mimeType) {
        if (mimeType.equals("audio/wav")) {
            this.wav2mp3(source, target);
        }
    }

    private void wav2mp3(final File source, File target) {
        this.encoAttrs.setFormat(this.mp3Format);
        this.encoAttrs.setAudioAttributes(this.audioAttr);
        try {
            this.encoder.encode(source, target, this.encoAttrs);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    source.delete();
                }
            });
        }
        catch (Exception e) {
            System.out.println("Encoding Failed");
        }
    }

    public static void main(String[] args) {
        wav2mp3 aed = new wav2mp3();
        File source = new File("singelementsmp3.mp3");
        File target = new File("test.ogg");
        String mimeType = "audio/mp3";
        aed.encodeAudio(source, target, mimeType);
    }
}

