/*
 * Copyright 1990-1992 by Tektronix, Inc. Beaverton, Oregon,
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Tektronix not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Tektronix makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * TEKTRONIX DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL TEKTRONIX BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Sample program originally written for BSD-derived UNIX to talk to an
 * Apple LaserWriter attached to the serial port on an X terminal.
 * Modifications have been made to make this program more general purpose
 * and add TDEnet support.  An attempt has been made to add VMS support.
 *
 * It has been compiled and run on SunOS 3.5,
 * SunOS 4, VAX ULTRIX, VAX VMS 5.3, and Tektronix UTEK 4.1
 *
 *
 * To compile this code:
 *
 * On a Sun or on a Tek 4300 use
 * cc data_xp.c -o data_xp
 *
 * On a Tek XD88 use
 * cc data_xp.c -o data_xp -DSYSV
 *
 * On an IBM RS600 use
 * cc data_xp.c -o data_xp -DSYSV -Dibm
 *
 * On Ultrix use
 * cc data_xp.c -o data_xp  (tcpip only)
 * cc data_xp.c -o data_xp -DTDENET -ldnet (DECnet and tcpip)
 * on vax/ultrix 3.1(not vax/ultrix 4.0 or risc/ultrix 4.1)
 *
 * On VMS use
 * cc data_xp.c or  (DECnet only)
 * cc data_xp.c /def=UCX  or  (DECnet + UCX)
 * cc data_xp.c /def=MULTINET (DECnet + Multinet)
 * link data_xp.obj with proper libraries
 * DECnet only, MULTINET + DECnet, UCX +DECnet
 *
 * For TDEnet support add -DTDENET to the compile command (already done for VMS)
 */

/* configure tcpip option */
#ifdef VMS
#define TDENET
#ifdef MULTINET
#define TCPIP
#endif /* MULTINET */
#ifdef UCX
#define TCPIP
#endif /* UCX */
#else
#define TCPIP
#endif /* VMS */

#include <stdio.h>

#ifdef VMS
#include <libdef.h>
#include <ssdef.h>
#include <stsdef.h>
#define NORMAL_EXIT SS$_NORMAL
#define ERROR_EXIT STS$M_CUST_DEF|STS$M_INHIB_MSG|STS$K_ERROR
#include <string.h>
#include <descrip.h>
#include "vmsonly.h"
#ifdef MULTINET
#include "multinet_root:[multinet.include.sys]types.h"
#include "multinet_root:[multinet.include.sys]time.h"
#include "multinet_root:[multinet.include.sys]file.h"
#include "multinet_root:[multinet.include.sys]socket.h"
#include "multinet_root:[multinet.include.sys]ioctl.h"
#include "multinet_root:[multinet.include.netinet]in.h"
#include "multinet_root:[multinet.include]netdb.h"
#include "multinet_root:[multinet.include]errno.h"
#include "multinet_root:[multinet.include.vms]inetiodef.h"
#else
#include <types.h>
#include <time.h>
#include <file.h>
#include <errno.h>
#include <socket.h>
#endif /* MULTINET */
#ifdef UCX
#include <in.h>
#include <netdb.h>
#include <inet.h>
#include  <ucx$inetdef.h>       /* INET symbol definitions */
#endif /* UCX */
#else
#define NORMAL_EXIT 0
#define ERROR_EXIT 1
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef SYSV
#include <time.h>
#endif /* SYSV */
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#ifndef hpux
#include <arpa/inet.h>
#endif /* hpux */
#endif /* VMS */

#ifdef TDENET
#ifdef VMS
#include <iodef.h>
#include <rmsdef.h>
#else
#include <netdnet/dn.h>
#include <netdnet/dnetdb.h>
#include <sys/ioctl.h>
#endif /* VMS */
#endif /* TDENET */

#ifdef SYSV
#include <sys/file.h>
#endif /* SYSV */

#ifdef ibm
#include <sys/select.h>
#endif /* ibm */

/* for systems that don't have the latest select() */

#ifndef FD_SETSIZE
#ifndef VMS
#include <sys/param.h>
#define FD_SETSIZE	((NOFILE > sizeof (long)) ? sizeof (long) : NOFILE)
#else
#define FD_SETSIZE      256
#endif /* !VMS */
#define NBBY    8
typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
#ifndef howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif /* !howmany */
typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif /* FD_SETSIZE */

#define BUFSIZE		1024
#define DNET_OBJ_NUM 128
#define	RS232PORT	87	/* the RS-232 daemon TCP port */
#define	MAX_RETRIES    100	/* number of times we'll retry initial reset */
#define	CTRLD		'\004'
#define	TRUE	1
#define	FALSE	0

/* imports */
#ifndef VMS
extern unsigned long inet_addr();
#endif /* !VMS */

extern time_t time();
extern int      errno;
extern struct tm *localtime();

#ifdef VMS
struct io_stat_blk {		/*  I/O status block */
	short int status ;
	short int msg_len ;
	int unused;
};
struct io_stat_blk c_iosb;
struct io_stat_blk w_iosb;
struct io_stat_blk r_iosb;
struct msgvec_blk {			/*  Message vector for $putmsg */
	short int count;
	short int options;
	int msg_code;
} msgvec = { 1, 15, 0 };

struct net_con_blk {		/*  Network Connect Block (NCB) */
	char node[8];
	char task_delimeter;
	char task[15];
	short int resrvd;
	char ncb_end;
} ncb = { "        ",'"',"128=",0,'"' };

static $DESCRIPTOR (net_device, "_NET:");
struct dsc$descriptor_s ncb_desc;
long int readEventFlag;
long int writeEventFlag;
#endif /* VMS */

char *progname;
char *printername = NULL;
int debug = FALSE;
int delay_timeout = 5;	/* seconds to wait on reset before timing out */

#ifndef hpux
struct linger net_linger;
#else  /* is hpux */
int net_linger;
#endif /*hpux*/

#ifdef MULTINET
#define PERROR socket_perror
#define ERRNO  socket_errno
#else
#define PERROR perror
#define ERRNO  errno
#endif  /* MULTINET */

#ifdef VMS
#ifdef TCPIP
int use_tdenet = FALSE;
#else
int use_tdenet = TRUE;
#endif /* TCPIP */
#else
int use_tdenet = FALSE;
#endif /* VMS */

#ifdef VMS
#define NEEDSTRFUNC
#endif /* VMS */
#ifdef hpux
#define NEEDSTRFUNC
#endif /* hpux */

#ifdef NEEDSTRFUNC
#ifndef MULTINET
bcopy(b1, b2, length)
    char b1[], b2[];
    int length;
{
#ifdef VMS
    _MOVC3(length, b1, b2);
#else
    int i;

    for(i = 0; i < length; i++) {
	b2[i] = b1[i];
    }
#endif /* VMS */
}
bzero(b, length)
    char b[];
    int length;
{
#ifdef VMS
    char nullChar='\0';

    _MOVC5(1, &nullChar, nullChar, length, b);
#else
    int i;

    for(i = 0; i < length; i++) {
	b[i] = '\0';
    }
#endif /* VMS */
}
#endif /* MULTINET */
char *index(s, c)
    char *s, c;
{
#ifdef VMS
    return (strchr(s, (int)c));
#else
    char *tmp;

    tmp = (char *)0;
    while (*s) {
	if (*s == c) {
	    tmp = s;
            break;
	}
	s++;
    }

    return(tmp);
#endif /* VMS */
}
#else
extern char *index();
#endif /* NEEDSTRFUNC */

/*
 * This utility is invoked with the host name or IP address of a network
 * display station as it's only required argument.  It will take characters
 * from STDIN (assumed to be PostScript) and write them to the serial port
 * on the specified network display station.  The utility will also
 * monitor status from the printer and report any information returned
 * by the printer to STDERR.
 */
usage()
{
    fprintf(stderr,"usage: %s\n",progname);
    fprintf(stderr," -addr <string>  address or name of the X station to");
    fprintf(stderr," send to. REQUIRED\n");
#ifdef TDENET
    fprintf(stderr," -tdenet         use TDEnet protocol instead of TCP/IP\n");
#endif /* TDENET */
    fprintf(stderr," -in <file>      use <file> as input file, default is");
#ifdef VMS
    fprintf(stderr," SYS$INPUT\n");
#else
    fprintf(stderr," standard in\n");
#endif /* VMS */
    fprintf(stderr," -debug          print debug info\n");
    fprintf(stderr," -nctld          no control D at beginning and end\n");
#ifndef VMS
    fprintf(stderr," -npipe <file>   use file as name of a named pipe\n");
#endif /* !VMS */
    fprintf(stderr," -dtime <int>    delay <int> seconds when sending control");
    fprintf(stderr," D (laserwriter reset),\n");
    fprintf(stderr,"                     or checking for printer (-nctld)");
    fprintf(stderr,", default is 5\n");
    exit(ERROR_EXIT);
}



main (argc, argv)
    int         argc;
    char      **argv;
{
    int         sfd, i;
#ifdef TCPIP
    struct sockaddr_in inaddr;
    struct hostent *hp;
#endif /* TCPIP */
    int is_ps = TRUE;
    int pipe = 0;
    int pipefd = 0;
    int in_fd = 0;
#ifdef MULTINET
    int enable;
#endif /* MULTINET */
#ifdef TDENET
    char *colonPos;        /* colon position */
#ifndef VMS
    struct sockaddr_dn dnaddr;
    struct dn_naddr *node_addr;
    struct nodeent *nodep;
#else
    int len;
    char open_buf[128];
    int stat;
#endif /* !VMS */
#endif /* TDENET */

#ifdef VMS
    if ((stat = LIB$GET_EF(&readEventFlag)) != SS$_NORMAL) {
        LIB$SIGNAL(stat);
        exit (ERROR_EXIT);
    }
    if ((stat = LIB$GET_EF(&writeEventFlag)) != SS$_NORMAL) {
        LIB$SIGNAL(stat);
        exit (ERROR_EXIT);
    }
    /* prime for asynchronous reads */
    r_iosb.status = SS$_NORMAL;
    r_iosb.msg_len = 0;
#endif /* VMS */
    progname = argv[0];

    if (argc < 3) {
        usage();
    }

    for (i = 1; i < argc; i++) {
        if (!strcmp(argv[i], "-nctld")) {
            is_ps = FALSE;
        }
        else if (!strcmp(argv[i], "-debug")) {
            debug = TRUE;
        }
        else if (!strcmp(argv[i], "-tdenet")) {
#ifdef TDENET
            use_tdenet = TRUE;
#else
            fprintf(stderr,
              "TDENET support is not available in this version of data_xp\n");
            usage();
#endif /* TDENET */
        }
        else if (!strcmp(argv[i], "-dtime")) {
	    if (++i >= argc) usage();
	    sscanf(argv[i], "%d", &delay_timeout);
        }
        else if (!strcmp(argv[i], "-addr")) {
	    if (++i >= argc) usage();
	    printername = argv[i];
        }
        else if (!strcmp(argv[i], "-in")) {
            if (++i >= argc) usage();
            in_fd = open(argv[i], O_RDONLY, 0777);
            if (in_fd < 0) {
		fprintf(stderr,"Can't open input file as specified.\n");
		exit(ERROR_EXIT);
	    }
        }
#ifndef VMS
        else if (!strcmp(argv[i], "-npipe")) {
            if (++i >= argc) usage();
            pipe = 1;
            pipefd = open(argv[i], O_RDWR, 0777);
            if (pipefd < 0) {
                fprintf(stderr,"Can't open named pipe as specified.\n");
                exit(1);
            }
        }
#endif /* !VMS */
        else
            usage();
    }

/* make sure required parameters were specified */
    if (printername == NULL) {
       fprintf(stderr, "No printer name specified, use -addr\n");
       usage();
    }
#ifdef TDENET
/* enforce data_xp DECnet addr rule of trailing "::" */
    if (use_tdenet) {
        if (!((colonPos = index(printername, ':')) && (*(colonPos+1) == ':'))) {
            fprintf(stderr, "Invalid TDENET address.  No \"::\".\n");
            usage();
        }
#ifdef ultrix
        /* ultrix decnet requires "a.n" format, strip "::" */
        *colonPos = '\0';
#endif /* ultrix */
    }
#endif /* TDENET */

    if (use_tdenet == FALSE) {
#ifdef TCPIP
	/* create a socket */
	if ((sfd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
	    stamp (stderr);
	    fprintf (stderr, "can't open Internet socket, aborting\n");
	    fprintf (stderr, "errno = %d\n",ERRNO);
	    PERROR (progname);
	    exit (ERROR_EXIT);
	}

#ifndef hpux
	net_linger.l_onoff = 1;   /* enable linger on close of socket */
	net_linger.l_linger = 360; /* 360 second timeout */
#else /* is hpux */
	net_linger = 1;
#endif /*hpux*/
	setsockopt(sfd,SOL_SOCKET,SO_LINGER,&net_linger,sizeof(net_linger));


	/* resolve network address of unit */
	inaddr.sin_family = AF_INET;
	inaddr.sin_port = htons (RS232PORT);
	if ((inaddr.sin_addr.s_addr = inet_addr (printername)) == -1) {
	    if ((hp = gethostbyname (printername)) == NULL ||
					 hp->h_addrtype != AF_INET) {
		stamp (stderr);
		fprintf (stderr, "can't resolve name %s, aborting\n",
								printername);
		exit (ERROR_EXIT);
	    }
	    bcopy(hp->h_addr, (char *)&inaddr.sin_addr.s_addr, hp->h_length);
	}
#endif /* TCPIP */
    }

#ifdef TDENET
    else {  /* is TDEnet */
#ifndef VMS
	/* Create a socket in TDEnet domain */
	if ((sfd = socket(AF_DECnet, SOCK_SEQPACKET, 0)) < 0 ) {
	    stamp (stderr);
	    fprintf (stderr, "can't open DECnet socket, aborting\n");
	    PERROR (progname);
	    exit(ERROR_EXIT);
	}

#ifndef hpux
	net_linger.l_onoff = 1;   /* enable linger on close of socket */
	net_linger.l_linger = 360; /* 360 second timeout */
#else /* is hpux */
	net_linger = 1;
#endif /*hpux*/
	setsockopt(sfd,SOL_SOCKET,SO_LINGER,&net_linger,sizeof(net_linger));

	/* Specify target object number for connection */
	bzero(&dnaddr, sizeof(dnaddr));
	dnaddr.sdn_family = AF_DECnet;
	dnaddr.sdn_objnum = DNET_OBJ_NUM;

	if( (node_addr = dnet_addr(printername)) == NULL ) {
	    if( (nodep = getnodebyname(printername)) == NULL ) {
		fprintf(stderr, "%s : Node unknown\n", printername);
		PERROR (progname);
		exit(ERROR_EXIT);
	    } else {
		bcopy(nodep->n_addr,dnaddr.sdn_nodeaddr,nodep->n_length);
		dnaddr.sdn_nodeaddrl = nodep->n_length;
	    }
	} else {
	    dnaddr.sdn_add = *node_addr;
	}
#else /* is VMS */
	if ((i = sys$assign(&net_device, &sfd, 0, 0)) != SS$_NORMAL) {
	    stamp (stderr);
	    fprintf (stderr,
                "Can't assign NET logical link channel, aborting\n");
            LIB$SIGNAL(i);
	    exit(ERROR_EXIT);
	}
#endif /* !VMS */
    }
#endif /* TDENET */


    /* connect to RS-232 daemon */
    if (use_tdenet == FALSE) {
#ifdef TCPIP
	if (connect(sfd, &inaddr, sizeof (inaddr)) < 0) {
	    PERROR (progname);
	    exit (ERROR_EXIT);
	}
#endif /* TCPIP */
    }
#ifdef TDENET
      else {
#ifndef VMS
	if (connect(sfd, &dnaddr, sizeof (dnaddr)) < 0) {
            fprintf(stderr, "Unable to connect TDENET socket\n");
	    PERROR (progname);
	    exit (ERROR_EXIT);
	}
#else /* is VMS */
	ncb_desc.dsc$w_length = sizeof( ncb );
	ncb_desc.dsc$a_pointer = &ncb;
	ncb_desc.dsc$b_dtype = DSC$K_DTYPE_T;
	ncb_desc.dsc$b_class = DSC$K_CLASS_S;
	len = strlen(printername);
	if (len > 8) len = 8;
	bcopy(printername,
		&(ncb.node[0]), len);
	if (((i = sys$qiow ( writeEventFlag, sfd, IO$_ACCESS, &c_iosb, 0, 0, 0,
			&ncb_desc, 0, 0, 0, 0)) != SS$_NORMAL) ||
             (c_iosb.status != SS$_NORMAL)) {
	    fprintf(stderr,"Unable to create logical link\n");
            if (i != SS$_NORMAL)
                LIB$SIGNAL(i);
            else
                LIB$SIGNAL(c_iosb.status);
	    exit (ERROR_EXIT);
	}
#endif /* !VMS */
    }
#endif /* TDENET */

#ifdef MULTINET
    enable = 1;
    socket_ioctl(sfd, FIONBIO, &enable);
#endif /* MULTINET */

    if (debug == TRUE) {
	stamp (stderr);
	fprintf (stderr, "got connection\n");
    }
#ifndef VMS
   if(pipe)
        do_com(pipefd, sfd);
#endif /* !VMS */
    if (is_ps == TRUE) {
        /* reset the printer */
	if (debug == TRUE) {
	    stamp (stderr);
	    fprintf (stderr, "trying to reset printer\n");
	}
        reset_printer (sfd, stderr);
	if (debug == TRUE) {
	    stamp (stderr);
	    fprintf (stderr, "initial printer reset worked, sending job\n");
	}
    } else {
	/* check connection */
	if (debug == TRUE) {
	    stamp (stderr);
	    fprintf (stderr, "checking printer connection\n");
	}
        check_printer (sfd, stderr);
	if (debug == TRUE) {
	    stamp (stderr);
	    fprintf (stderr, "initial printer check worked, sending job\n");
	}
    }

    /* send the PostScript to the printer and wait for echoed ^D */
    print_job (in_fd, sfd, stderr, is_ps);

    if (debug == TRUE) {
	stamp (stderr);
	fprintf (stderr, "job done\n");
    }

    /* clean up */
    exit (NORMAL_EXIT);
}


#ifndef VMS

/* This function takes as input, an open file descriptor for a named pipe
 * and an open file descriptor for a socket connection to the XP
 * net-to-serial process.
 * It then sends any input to the pipe over the socket to the XP.
 * This allows an application to to write to the pipe and have that 
 * data sent to the terminal's serial port.
 */

do_com (pfd, sfd)
   int pfd;
   int sfd;
{
    unsigned char        rbuf[BUFSIZE];
    unsigned char        wbuf[BUFSIZE];
    int         rlen, wlen, tmp;
    fd_set      rfds, wfds;
    struct timeval timeout;
    int         err, written;


    /* establish timeout values */
    timeout.tv_sec = 0;
    timeout.tv_usec = 250;

 while(1){
   if (able_to_read(pfd, &rfds, &timeout, stderr) == TRUE) {
    wlen = read(pfd, wbuf, sizeof (wbuf));
    if(wlen > 0){
        written = 0;
        while(written < wlen){
            if (able_to_write(sfd, &wfds, &timeout, stderr) == TRUE) {
                    err = do_write(sfd, wbuf+written, wlen-written, FALSE);
                    written+=err;
            }
        }
    }
   }

/*
    if (able_to_read(sfd, &rfds, &timeout, stderr) == TRUE) {
        rlen = do_read(sfd, rbuf, sizeof (rbuf));
        if(rlen > 0){
           written = 0;
           while(written < rlen){
             if (able_to_write(pfd, &wfds, &timeout, stderr) == TRUE) {
                tmp = write(pfd, rbuf+written, rlen-written);
                written+=tmp;
                fprintf(stderr, " "); 
            }
          }
        }
    }
*/
  }
}




#endif /* !VMS */

int do_write(fd, buff, len)
int fd;
char *buff;
int len;
{
    int err, stat;

    if (use_tdenet == FALSE) {
#ifdef TCPIP
#ifdef MULTINET
	err = socket_write (fd, buff, len);
#else
	err = write (fd, buff, len);
#endif /* MULTINET */
#endif /* TCPIP */
    }
#ifdef TDENET
    else {
#ifdef VMS
	if (len > 0) {
	    if ((stat = sys$qiow(writeEventFlag, fd, IO$_WRITEVBLK,
	       &w_iosb, 0, 0, buff, len, 0, 0, 0, 0)) != SS$_NORMAL) {
                LIB$SIGNAL(stat);
	        err = 0;
            }
            else {
                if (w_iosb.status != SS$_NORMAL)
                    LIB$SIGNAL(w_iosb.status);
                err = w_iosb.msg_len;
            }
	}
#else
	err = write (fd, buff, len);
#endif /* VMS */
    }
#endif /* TDENET */

    return(err);
}

#ifdef VMS
char tmp_buff[BUFSIZE];
#endif


int do_read(fd, buff, len)
int fd;
char *buff;
int len;
{
    int err, stat, i;

    if (use_tdenet == FALSE) {
#ifdef TCPIP
#ifdef MULTINET
	err = socket_read(fd, buff, len);
#else
	err = read(fd, buff, len);
#endif /* MULTINET */
#endif /* TCPIP */
    }
#ifdef TDENET
     else {
#ifdef VMS
         /* check status to determine the read state.  if status ==
          * 0, read has been queued.  Otherwise, return whatever is
          * in the tmp_buff, signal the error if so. issue an
          * asynchronous read and let able_to_read()
          * check queueing status
          */
         if (r_iosb.status == 0)
             err = 0;        /* read still queued */
         else {
             /* return anything read */
             err = r_iosb.msg_len;
             if (err > 0) {
                bcopy (tmp_buff, buff, err);
             }
             else if (err == 0) {
	         err = -2;
     /* this is a special indicator!!! using this can cause access-vio */
             }
             if (r_iosb.status != SS$_NORMAL)
                /* let'em know completion status if abnormal */
                 LIB$SIGNAL (r_iosb.status);

             /* queue an asynchronous read */
             if ((stat = sys$qio(readEventFlag, fd, IO$_READVBLK,
              &r_iosb, 0, 0, tmp_buff, len, 0, 0, 0, 0)) != SS$_NORMAL) {
              /* queueing error */
                   LIB$SIGNAL( stat);
             }
         }
#else
	err = read(fd, buff, len);
#endif /* VMS */
    }
#endif /* TDENET */

    return(err);
}


int able_to_write(fd, wfds_ptr, timeout_ptr, errfd)
int fd;
fd_set *wfds_ptr;
struct timeval *timeout_ptr;
FILE *errfd;
{
    int stat, ret_val;
    char buf1;

    FD_ZERO (wfds_ptr);
#ifdef VMS
    if (use_tdenet == FALSE) {
#endif /* VMS */
#ifdef TCPIP
	FD_SET (fd, wfds_ptr);
	if((stat = select(FD_SETSIZE, (int *)0, wfds_ptr,
						(int *)0,timeout_ptr)) < 0) {
	    stamp(errfd);
	    fprintf(errfd,"able_to_write select returned %d, aborting\n", stat);
	    exit (ERROR_EXIT);
	}
#endif /* TCPIP */
#ifdef VMS
    }
#ifdef TDENET
    else { /* use tdenet */
        FD_SET (fd,wfds_ptr);
    }
#endif /* TDENET */
#endif /* VMS */
    if (FD_ISSET (fd, wfds_ptr)) {
	ret_val = TRUE;
    } else {
	ret_val = FALSE;
    }

    return(ret_val);
}



int able_to_read(fd, rfds_ptr, timeout_ptr, errfd)
int fd;
fd_set *rfds_ptr;
struct timeval *timeout_ptr;
FILE *errfd;
{
    int stat;
    char buf1;
    int ret_val;

    FD_ZERO (rfds_ptr);
#ifdef VMS
    if (use_tdenet == FALSE) {
#endif /* VMS */
#ifdef TCPIP
	FD_SET (fd, rfds_ptr);
	if((stat = select(FD_SETSIZE, rfds_ptr, (int *)0,
						(int *)0,timeout_ptr)) < 0) {
	    stamp(errfd);
	    fprintf(errfd, "reset select returned %d, aborting\n", stat);
	    exit (ERROR_EXIT);
        }
#endif /* TCPIP */
#ifdef VMS
    }
#ifdef TDENET
    else { /* use tdenet */
        /* check status of asynchronous read of able_to_read() */
        if (r_iosb.status != 0)
            return (TRUE);
        else {
	    sleep(timeout_ptr->tv_sec);
            return (FALSE);
        }
    }
#endif /* TDENET */
#endif /* VMS */

    if (FD_ISSET (fd, rfds_ptr)) {
	ret_val = TRUE;
    } else {
	ret_val = FALSE;
    }

    return(ret_val);
}

/*
 * This function attempts to write an EOF (^D) to the LaserWriter
 * and then waits for the ^D to be echoed by the printer.  It will
 * only try to read the echoed ^D MAX_RETRIES times.  Each time it
 * cannot read from the printer it will wait delay_timeout seconds
 * before attempting another read.  If it cannot complete it's task
 * it causes the utility to exit with status FAILED_REQUEUE.  This
 * is intended to tell the BSD spooler to requeue the request even
 * though it could not be printed.
 */
reset_printer (fd, errfd)
int fd;
FILE *errfd;
{
    char        buf[BUFSIZE];
    int         len;
    int         err;
    fd_set      rfds, wfds;
    struct timeval timeout;
    int         retry_count;

    retry_count = 0;


    if (able_to_write(fd, &wfds, &timeout, errfd) == TRUE) {
	/* write ^D to printer */
	buf[0] = CTRLD;
	err = do_write(fd, buf, 1, TRUE);

	if (err != 1) {
	    stamp (errfd);
	    fprintf (errfd, "write of reset EOF returned %d, aborting\n", err);
	    exit (ERROR_EXIT);
	}
    } else {
	stamp (errfd);
	fprintf (errfd, "unable to write reset EOF, aborting\n");
	exit (ERROR_EXIT);
    }

    /* establish timeout values */
    timeout.tv_sec = delay_timeout;
    timeout.tv_usec = 0;

    /* we'll loop until the echoed ^D is read at which time we return */
    for(; ; ) {
	/* see if read on socket will work */
	if (able_to_read(fd, &rfds, &timeout, errfd) == TRUE) {
	    /* read from network connection, watch for echoed ^D */
	    if ((len = do_read(fd, buf, sizeof (buf)-1)) > 0) {
		buf[len] = '\000';
		if (index ((char *)buf, CTRLD) != (char *)0) {
		    if (debug == TRUE) {
			stamp (errfd);
			fprintf (errfd, "EOF echoed, printer reset\n");
		    }
		    return;
		} else {
		    if (debug == TRUE) {
	 		stamp (errfd);
			fprintf (errfd,
			    "reset got \"%s\" while waiting for EOF\n", buf);
		    }
		}
	    } else if (len == -2) {  /* nothing really read */

	    } else {		/* read error or EOF */
		stamp (errfd);
		fprintf (errfd, "reset read returned %d, aborting\n", len);
		exit (ERROR_EXIT);
	    }
	} else {		/* timeout */
	    ++retry_count;
	    if (retry_count < MAX_RETRIES) {
		stamp (errfd);
		fprintf (errfd, "timed out reseting printer %d\n",retry_count);
	    } else {
		stamp (errfd);
		fprintf(errfd, "hit max retries, aborting\n");
		exit (ERROR_EXIT);
	    }
	}
    }
}




check_printer (fd, errfd)
int fd;
FILE *errfd;
{
    char        buf[BUFSIZE];
    int         len;
    int         err_num;
    fd_set      rfds;
    struct timeval timeout;
    int         retry_count = 0;


    /* establish timeout values */
    timeout.tv_sec = delay_timeout;
    timeout.tv_usec = 0;

    /* see if read on socket will work */
    if (able_to_read(fd, &rfds, &timeout, errfd) == TRUE) {
	/* read from network connection */
	if (debug == TRUE) {
	    stamp(errfd);
	    fprintf(errfd,"check_printer starting read\n");
	}

	len = do_read(fd, buf, sizeof (buf)-1);

	err_num = ERRNO;
	if (((len < 0) && (err_num == EWOULDBLOCK)) || (len == -2)) {
	    return;	/* just paranoid about blocking ... */
	} else if (len > 0) {
	    buf[len] = '\000';
	    if (debug == TRUE) {
 		stamp (errfd);
		fprintf (errfd,
		    "check_printer got \"%s\" while reading\n", buf);
	    }
    	    return;
	} else {    /* read error or EOF */
    	    stamp (errfd);
    	    fprintf (errfd, "check_printer read returned %d, aborting\n", len);
    	    exit (ERROR_EXIT);
	}
    }
}



/*
 * This function ...
 *
 */

print_job (input, printer, errors, is_ps)
int input;
int printer;
FILE *errors;
int is_ps;
{
    int		no_eof_yet = TRUE;
    int		err;
    int		len;
    char	buf[BUFSIZE];
    int		written;
    struct	timeval timeout;
    fd_set rfds, wfds;
    int         can_read;
#ifdef VMS
    int stat;
#endif /* VMS */

    if (debug == TRUE) {
	stamp(errors);
	fprintf(errors,"Entering print_job\n");
    }

    /* establish timeout values */
    timeout.tv_sec = delay_timeout;
    timeout.tv_usec = 0;

#ifndef VMS
    /* make sure we don't get stuck in a write to the socket */
/*   err = fcntl (printer, F_SETFL, FNDELAY); */
#endif /* VMS */

    /* we'll copy bytes from the input to the printer until we get
     * an EOF on the input side.
     */
    while (no_eof_yet) {
	/* see if we can read */
	/* We must be able to read input.  Otherwise we'll delay and */
	/* go back to the select. */
#ifdef VMS
	can_read = TRUE;
#else
	can_read = able_to_read(input, &rfds, &timeout, errors);
#endif /* VMS */
	if (can_read == TRUE) {
	    if ((len = read(input, buf, sizeof (buf))) <= 0) {
		/* EOF or error - manufacture ^D for the printer */
		no_eof_yet = FALSE;
		buf[0] = CTRLD;
		len = 1;
		if (is_ps == FALSE) {
		   len = 0;
		} else {
		    if (debug == TRUE) {
			stamp (errors);
			fprintf (errors, "manufactured EOF for printer\n");
		    }
		}
	    }

	    if (debug == TRUE) {
		stamp (errors);
		fprintf (errors, "read %d chars from input file\n", len);
	    }

	    /* send read data to printer - watch out for partial writes */
	    written = 0;
	    while (written < len) {
		/* To make sure we don't spin on non-blocking write, let's
		/* check first ... */
		/* make sure we can write something */
		if (able_to_write(printer, &wfds, &timeout, errors) == TRUE) {
		    err = do_write(printer, buf+written, len-written, FALSE);

		    if (debug == TRUE) {
			stamp (errors);
			fprintf (errors, "write to printer %d chars from %d\n",
			    err, (len - written));
		    }
		    /* this isn't really an error ... */
		    if ((err == -1) && (ERRNO == EWOULDBLOCK)) {
			err = 0;
			if (debug == TRUE) {
			    stamp (errors);
			    fprintf (errors, "write to printer would block\n");
			}
			/* check printer status - allow some delay */
			err = check_printer_for_errors (printer, errors,
						    delay_timeout);
		    } else
			if (err < 0) {
			    stamp (errors);
			    fprintf (errors,
				"write to printer returned %d, errno = %d, aborting\n",err,ERRNO);
			    exit (ERROR_EXIT);
			}
		    /* update # bytes written and check printer status */
		    written += err;
		    err = check_printer_for_errors (printer, errors, 0);
		} else		/* can't write right now ... */
		    /* check printer status - allow some delay */
		    err = check_printer_for_errors (printer, errors,
						    delay_timeout);

		/* we shouldn't see ^D from printer yet */
		if (no_eof_yet && (err < 0)) {
		    stamp (errors);
		    fprintf (errors, "Spurious EOF from printer\n");
		}
	    }
	}
    }

#ifdef VMS
    if (use_tdenet == TRUE) {
        /* wait for any ansychronous write */
	sys$synch(writeEventFlag, &w_iosb);
    }
#endif /* VMS */

    if (is_ps == TRUE) {
	/* watch for final ^D echo */
	while (check_printer_for_errors (printer, errors, delay_timeout*2) >= 0)
	    ;
    }
#ifdef VMS
    if (use_tdenet == TRUE) {
        /* disconnect the logical link */
	if ((stat = sys$qiow(writeEventFlag, printer, IO$_DEACCESS | IO$M_SYNCH,
             &w_iosb, 0, 0, 0, 0, 0, 0, 0, 0)) != SS$_NORMAL) {
            LIB$SIGNAL(stat);
            exit (ERROR_EXIT);
        }
	sys$dassgn(printer);
    }
#else
    sleep(2);
    close(printer);
#endif /* VMS */
}

/*
 * This function reads text back from the LaserWriter and parses it
 * into lines.  It then emits these lines on the specified file
 * (usually stderr).
 */

int	prtbufi = 0;
char	prtbuf[BUFSIZE];

int
check_printer_for_errors (fd, errfd, delay)
int		fd;
FILE *errfd;
int		delay;
{
    char	*left, *right;
    int		err, len, retval = 0;
    fd_set      rfds;
    struct	timeval timeout;
    int         err_num;
    int i;

    if (debug == TRUE) {
	stamp (stderr);
	fprintf (stderr, "check printer with delay %d\n", delay);
    }

    timeout.tv_sec = delay;
    timeout.tv_usec = 0;

    /* If we can't read, then return */
    if (able_to_read(fd, &rfds, &timeout, errfd) == FALSE) {
	if (debug == TRUE) {
	    stamp (errfd);
	    fprintf (errfd, "no printer status to read\n");
	}
	return (retval);
    }


    /* if we can read, then let's do it ... */
    len = do_read(fd, prtbuf+prtbufi, sizeof (prtbuf)-prtbufi-1);

    err_num = ERRNO;
    if (((len < 0) && (err_num == EWOULDBLOCK)) || (len == -2)) {
	return (retval);	/* just paranoid about blocking ... */
    }
    if (len < 0) {
	stamp (errfd);
	fprintf (errfd, "read from printer returned %d, aborting\n", len);
	exit (ERROR_EXIT);
    }
    prtbufi += len;


    /* terminate the current input buffer and parse away */
    prtbuf[prtbufi] = '\000';
    left = right = prtbuf;
    while (*right) {
	switch (*right) {
	    case CTRLD:		/* ^D seen - make sure we return -1 */
		retval = -1;
		if (debug == TRUE) {
		    stamp (errfd);
		    fprintf (errfd, "EOF from printer\n");
		}
		/* drop through and treat ^D as line break */
	    case '\012':	/* LF */
	    case '\015':	/* CR */
		/* if we see adjacent line break characters ignore them */
		if (left == right) {
		    left = ++right;
		    break;
		}
		/* terminate the line string and pass it to the reporter */
		*right = '\000';
		printer_status (left, errfd);
		left = ++right;
		break;
	    default:		/* just skip over other chars */
		right++;
	}
    }

    /* If we've not collected anything to report, just return */
    if (left == prtbuf) {
	if (debug == TRUE) {
	    stamp (errfd);
	    fprintf (errfd, "no printer status line collected\n");
	}
	return (retval);
    }

    /* Otherwise copy the partial line back to the beginning of the buffer */
    right = left;
    left = prtbuf;
    while (*right)
	*left++ = *right++;
    prtbufi = (left-prtbuf);

    return (retval);
}

/*
 * Just report the status line to the specified file.
 */

printer_status (line, fd)
char	*line;
FILE *fd;
{
    stamp (fd);
    fprintf (fd, "data from remote device = \"%s\"\n", line);
}

/*
 * generate time stamp for logging messages.
 */
stamp (fd)
FILE *fd;
{
	register struct tm *tm_ptr;
	time_t now;

	now = time((time_t *)NULL);
	tm_ptr = localtime(&now);
	fprintf(fd, "%02d%02d%02d %2d:%02d:%02d: %s: %s: ",
	    tm_ptr->tm_year, tm_ptr->tm_mon, tm_ptr->tm_mday,
	    tm_ptr->tm_hour, tm_ptr->tm_min, tm_ptr->tm_sec,
	    progname, printername);
}
