/* @(#)$Header: /nwd/tools/media/X11/XP/src/include/X11/Xp/RCS/XpGetProp.h,v 1.2 1993/02/09 21:29:31 kentb Exp $ */
#ifndef XPGETPROP


/*
 * XpGetProperty routines do not remove the property
 */

#define XpGetPropertyInt(dpy,win,property,intptrptr,len)		\
    XpGetPropertyData(dpy,win,property,False,XA_INTEGER,(unsigned char **)(intptrptr),len)

#define XpGetPropertyStr(dpy,win,property,strptr,len)			\
    XpGetPropertyData(dpy,win,property,False,XA_STRING,(unsigned char **)(strptr),len)


/*
 * XpReceiveProperty routines REMOVE the property.
 *
 * These should be called when receiving a property that has been sent
 * with a XpSendProperty routine since the client calling that routine
 * is blocking waiting for the property to be deleted.
 */

#define XpReceivePropertyInt(dpy,win,property,intptrptr,len)		\
    XpGetPropertyData(dpy,win,property,True,XA_INTEGER,(unsigned char **)(intptrptr),len)

#define XpReceivePropertyStr(dpy,win,property,strptr,len)		\
    XpGetPropertyData(dpy,win,property,True,XA_STRING,(unsigned char **)(strptr),len)

extern void XpGetPropertyData();
extern void XpGetPropertyStrList();

#define XPGETPROP
#endif
