/********************************************************************
 * $Header: /tmp_mnt/vol/nwd/tools/media/X11/XP/src/include/RCS/tekxp_lang.h,v 1.10 1993/02/01 20:57:11 alanj Exp $
 * $Locker:  $
 *
 *	COPYRIGHT (c) TEKTRONIX, INC., 1990, 89
 *	ALL RIGHTS RESERVED
 *
 *	TEKTRONIX, INC.
 *	P.O. BOX 500
 *	BEAVERTON, OREGON 97077 U.S.A.
 *
 *-------------------------------------------------------------------
 *            C O M P A N Y   C O N F I D E N T I A L
 *-------------------------------------------------------------------
 *
 * This program is proprietary to TEKTRONIX, Inc. and is protected under
 * United States Copyright Law as an unpublished work. Its use and dis-
 * closure is limited by the terms and conditions of an express license
 * agreement. It may not be copied or otherwise reproduced or disclosed
 * to persons outside the licensee's organization except in accordance
 * with the terms and conditions of such agreement. All copies and re-
 * productions shall be the property of TEKTRONIX, Inc. and must bear
 * this notice in its entirety.
 *
 *-------------------------------------------------------------------
 *
 * DESCRIPTION:
 *	The following definitions and data structures are used
 *	when accessing eeprom memory.
 *
 ********************************************************************/
#ifndef TEKXP_LANG_H
#define TEKXP_LANG_H

/*************/
/* CONSTANTS */
/*************/

#define IS_KBD_PROPERTY           	True
#define IS_LANG_PROPERTY           	False
#ifndef ASM
extern char *GetLangKbdNationality();   
extern int LangNameToKbdValue();
extern char *GetLangName();             
extern char *GetNationalityName();
extern char *GetTypeName();             
extern char *GetLayoutName();             
#endif /* not ASM */
/* in libXp:lang.c */

/* KEYBOARD TYPE -
 *
 *    Bits
 *    0-3 	Nationality
 *    4		DPMODE
 *    5-7 	Type (101,102, TEKSUN4, or VT200)
 * 
 *    NC_MORE_KBD_TYPES in nonclearableflags extends the range to Type above to
 *    4-7 	Type (101,102, TEKSUN4, or VT200)
 */

/*
 * DPMODE
 */
#define KBD_DPMODE	0x10

/* 
 * MASKS
 */
#define KBD_MASK_TYPE	0xE0
#define KBD_MORE_MASK_TYPE  0xF0
#define KBD_MASK_DPMODE 0x10
#define KBD_MASK_NATION	0x0F
#define KBD_MASK_TYPE_NC 0x10

 /*
  *  Types..
  */
#define KBD_IBM101		0x00
#define KBD_IBM101_SETUP	0x00
#define KBD_IBM101_PAUSE	0x10     /* 0x10 bit will be stored in
					    nonclearableflags */
#define KBD_IBM102  		0x20
#define KBD_IBM102_SETUP	0x20
#define KBD_IBM102_PAUSE	0x30     /* 0x10 bit will be stored in
					    nonclearableflags */
#define KBD_VT200_ULTRIX 	0x40     /* put VT200 types between 0x40 */
#define KBD_VT200_VMS		0x60 
#define KBD_VT200_X_ESC 	0x80
#define KBD_VT200_X_F11 	0xA0     /* and 0xA0 */
#define KBD_TEKSUN4		0xC0
#define KBD_GENERIC		0xE0

#define KBD_FIRST_VT200 	KBD_VT200_ULTRIX 
#define KBD_LAST_VT200 		KBD_VT200_X_F11

/*
 * LAYOUT code are used only by the Boot ROM
 */
#define KBD_LAYOUT_IBM_SETUP	0
#define KBD_LAYOUT_IBM_PAUSE	1
#define KBD_LAYOUT_VT200_ULTRIX	2
#define KBD_LAYOUT_VT200_VMS	3
#define KBD_LAYOUT_VT200_X_ESC	4
#define KBD_LAYOUT_VT200_X_F11	5
#define KBD_LAYOUT_TEKSUN4	6
#define KBD_LAYOUT_GENERIC	7

#define KBD_LAYOUT_LAST 	7
#define KBD_LAYOUT_FIRST_VT	2
#define KBD_LAYOUT_LAST_VT	5

#ifdef PENGUIN
#define NUM_KBD_TYPES 		6
#else /* PENGUIN */
#define NUM_KBD_TYPES 		8
#endif /* else PENGUIN */
#define INVALID_KBD_TYPE 	-1

/*
 * Mapping macros between LAYOUT codes (used by boot ROM) and
 * the keyboard types and languages as stored in eeprom:
 */
#define KBD_LAYOUT(x,e)	(kbd_get_layout((x),(e)))
#define KBD_LANGUAGE(x) ((x) & KBD_MASK_NATION )
#define MAKE_KBD_TYPE(lang,layout)  (kbd_make_type((lang),(layout)))
#define MAKE_KBD_NCFLAGS(layout)    (kbd_make_ncflags((layout)))

#define CHAR_FIRST_NAT		'a'
#define CHAR_LAST_NAT		'l'

/* 
 * Language and Nationality
 */

#define KBD_US			0x00
#define KBD_UK			0x01
#define KBD_FRENCH		0x02
#define KBD_SWEDISH		0x03
#define KBD_DANISH		0x04
#define KBD_NORWEGIAN		0x05
#define KBD_GERMAN		0x06
#define KBD_ITALIAN		0x07
#define KBD_SPANISH		0x08
#define KBD_SWISS_GERM		0x09
#define KBD_KATAKANA		0x0a
#define KBD_FINNISH		0x0b
#define KBD_FOLLOWS_LANG        0x0c    
#define NUM_LANGUAGES 		12
#define NUM_KBD_NATIONALITIES (NUM_LANGUAGES + 1)

#define LANG_PROPERTY           	"_TEK_LANGUAGE"
#define KBD_NATIONALITY_PROPERTY "_TEK_KEYBOARD_NATIONALITY"
#define KBD_TYPE_PROPERTY "_TEK_KEYBOARD_TYPE"
#define KBD_LAYOUT_PROPERTY "_TEK_KEYBOARD_LAYOUT"
#define KBD_MODE_PROPERTY "_TEK_KEYBOARD_MODE"
#define KBD_COMPOSE_PROPERTY "_TEK_KEYBOARD_COMPOSE_LOADING"
#define KBD_MAPPING_FILE_PROPERTY "_TEK_KEYBOARD_MAPPING_FILE"
#define KBD_LK401_PROPERTY "_TEK_KEYBOARD_LK401"
#define DONOTTRANSLATE_LANG_PROPERTY           	"DONOTTRANSLATE_TEK_LANGUAGE"
#define DONOTTRANSLATE_KBD_NATIONALITY_PROPERTY \
        "DONOTTRANSLATE_TEK_KEYBOARD_NATIONALITY"
#define DONOTTRANSLATE_KBD_TYPE_PROPERTY "DONOTTRANSLATE_TEK_KEYBOARD_TYPE"
#define DONOTTRANSLATE_KBD_LAYOUT_PROPERTY "DONOTTRANSLATE_TEK_KEYBOARD_LAYOUT"
#define DONOTTRANSLATE_KBD_MODE_PROPERTY "DONOTTRANSLATE_TEK_KEYBOARD_MODE"
#define DONOTTRANSLATE_KBD_COMPOSE_PROPERTY \
        "DONOTTRANSLATE_TEK_KEYBOARD_COMPOSE_LOADING"
#define DONOTTRANSLATE_KBD_MAPPING_FILE_PROPERTY \
        "DONOTTRANSLATE_TEK_KEYBOARD_MAPPING_FILE"
#define DONOTTRANSLATE_KBD_LK401_PROPERTY \
        "DONOTTRANSLATE_TEK_KEYBOARD_LK401"


/* 
 * ACCESS methods
 */

#define NO_ACCESS	0x00	        /* No access entered */
#define UNIX_ACCESS 	0x01	        /* Unix domain (NFS) access */
#define TFTP_ACCESS	0x02	        /* TFTP protocol access */
#define ROM_ACCESS	0x03	        /* ROM file system access */
#define MOP_ACCESS	0x04	        /* MOP protocol access */
#define DAP_ACCESS	0x05	        /* DAP protocol access */
#define NFS_TFTP_ACCESS	0x06		/* NFS, else TFTP protocol access */
#define RES_ACCESS	0x07		/* Resident file access */
#define RSS_ACCESS	0x08		/* Serial access via RSS */
/* Note - only accesses 0-7 can be used for boot file access for V5 */


#endif /* TEKXP_LANG_H */

