#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpAtom.c,v 1.13 1993/02/03 18:28:46 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpAtom.c - package defining globals and macros for atoms
 *
 *	DESCRIPTION
 *		This file contains macros for referencing predefined
 *		Xp atoms and a global data structure used to intern the
 *		the atoms via a call to XInternAtom().
 *
 *		To define an Xp atom, the following four things are
 *		defined in this file: atom name string, atom index integer,
 *		atom XA_ macro used to reference the interned atom,
 *		and the nth entry in the AtomNames array which MUST
 *		correspond to the atom name string used to initialize
 *		that array.
 *
 *		Examples:
 *		#define XI_TEK_XP_foo	n
 *		#define XN_TEK_XP_foo	"foo atom name"
 *		#define XA_TEK_XP_foo	(Atom) XpAtom[XI_TEK_XP_foo]
 *
 *		char * AtomNames[] = {
 *		...
 *		XN_TEK_XP_foo,
 *		...
 *		}
 *
 *		To intern the atom values in the array, the application
 *		must first call the function XpInternAtoms().
 *		So the application MUST call XpInternAtoms() BEFORE attempting
 *		to use the XA_TEK_foo macros.
 *
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known bugs>
 *
 */
#include <X11/Xlib.h>
#include <stdio.h>
#ifndef VMS
#include <X11/Xp/XpAtom.h>
#else
#include <Xp/XpAtom.h>
#endif

Atom XpAtom[NumXpAtoms];

static char *AtomNames[NumXpAtoms] = {
/*  Name 		Index	 */
    XN_TEK_XP_LOCK,	/*  0 */
    XN_TEK_XPSHD_WID,	/*  1 */
    XN_TEK_XPSH_WID,	/*  2 */
    XN_TEK_XPSH_CMD,	/*  3 */
    XN_TEK_XPSH_ARG,	/*  4 */
    XN_TEK_XPSH_ENV,	/*  5 */
    XN_TEK_XPSH_LCK,	/*  6 */
    XN_TEK_XPSH_OPT,	/*  7 */
    XN_TEK_XPSH_SIG,	/*  8 */
    XN_TEK_XPSH_EXIT,	/*  9 */
    XN_TEK_XPSH_HCMD,	/* 10 */
    XN_TEK_XPSH_HARG,	/* 11 */
    XN_TEK_XPSH_HENV,	/* 12 */
    XN_TEK_XPSH_HLCK,	/* 13 */
    XN_TEK_SXP_ADDRESS,	/* 14 */
    XN_TEK_XPSH_KILL,   /* 15 */
};
/* if you change the above array you must also change XpAtom.h */


/*
 *	NAME
 *		XpInternAtoms - Intern all predefined Xp atoms
 *
 *	DESCRIPTION
 *		XInternAtom() will be used to internalize the atom strings
 *		specified in the global array AtomNames.
 *
 *		This routine, XpInternAtoms() MUST be called before any
 *		of the XA_TEK_... macros are used.
 *
 *	RETURNS
 *		void
 *
 */
void
XpInternAtoms(dpy)
Display *dpy;
{

    /*
     * Note this obviously requires all clients to be working from the same
     * AtomNames array of atoms above.
     * Again, to do that a client must have:
     * #include <X11/Xp/Xp.h> or #include <X11/Xp/XpAtoms.h>
     * and call XpInternAtoms(dpy)
     */

    int i;

      for(i=0; i < NumXpAtoms; i++){
	XpAtom[i] = XInternAtom(dpy,AtomNames[i],False);
      }
}

