/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpCrPropWin.c - package for creating Inputonly Window for properties
 *
 *	DESCRIPTION
 *		Creates a property window to pass properties on.
 *
 *	EXTERNAL INCLUDES
 */
#include <X11/Xlib.h>

/*
 *	INTERNAL INCLUDES
 */
/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */

/*
 *	INTERNALS
 */
#define POSITIVE	(10)
#define OFFSCREEN_X	(-POSITIVE)
#define OFFSCREEN_Y	(-POSITIVE)
#define OFFSCREEN_WIDTH	(POSITIVE)
#define OFFSCREEN_HEIGHT	(POSITIVE)
#define OFFSCREEN_BORDER	(0)

#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpCrPropWin.c,v 1.4 1992/01/30 22:50:45 cathybr Exp $";
#endif /* RCS_ID */
#endif /* LINT */



/*
 *	NAME
 *		XpCreatePropWindow - Create offscreen InputOnly window
 *
 *	SYNOPSIS
 */
Window XpCreatePropWindow(dpy)
Display *dpy;
/*
 *	DESCRIPTION
 *		Create a offscreen InputOnly window
 *		with override_redirect == True.
 *		This window will only be used for passing properties between
 *		cooperating clients.  The window id can be passed to other
 *		processes, perhaps via the environ.
 *
 *	RETURNS
 *		Window returned from XCreateWindow.
 *
 */
{
    Window root, win;
    XSetWindowAttributes wsa;
    unsigned long valuemask;

    root = RootWindow(dpy,DefaultScreen(dpy));
    wsa.override_redirect = True;
    valuemask = CWOverrideRedirect;

    win = XCreateWindow(dpy, root,
	OFFSCREEN_X, OFFSCREEN_Y, OFFSCREEN_WIDTH, OFFSCREEN_HEIGHT,0,
	CopyFromParent,InputOnly,CopyFromParent,valuemask,&wsa);

    return(win);
}
