#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpEnv.c,v 1.12 1993/06/04 01:18:00 houchin Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpEnv.c - package for environment routines
 *
 *	DESCRIPTION
 *		Add or Delete environment variables.
 *
 *		WARNING!!! This package modifies the value of 
 *		the extern "environ".  The new value should be
 *		accessed AFTER a routine are called.
 *
 *	EXTERNAL INCLUDES
 */

#ifdef VXWORKS
#define  REDEFINE_MALLOC
#include "tmem.h"
#include "envLib.h"
#else
extern char **environ;		/* system environ pointer, may be reset */
#endif

#include <X11/Xlib.h>
#ifdef	X11R5
#include <X11/Xlibint.h>	/* added for bcopy redefinition */
#endif

#include <stdio.h>

#ifdef VMS
#include <ssdef.h>
#include <Xp/XpError.h>
#else
#ifdef TEKXP
#include <X11/Xp/XpError.h>
#endif
#endif /* VMS */

/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */

#ifndef REDEFINE_MALLOC
#ifndef	X11R5
extern char *malloc(), *realloc();
#endif
#endif /* REDEFINE_MALLOC */
#define MAXSTR 256



/*
 *	NAME
 *		XpPutEnv - Put a new environment value and return new environ
 *
 *	DESCRIPTION
 *		XpPutEnv adds a new environment variable "name=value" to
 *		the current environment.  The current enviroment string
 *		list is copied to a list one larger.  The new varable is
 *		added.  Then, if this is the first addition, the original
 *		system environ pointer is not freed.  However, if this is
 *		the second or more call to this routine, the current
 *		environ pointer is assumed to be one that this routine
 *		alloced and it is therefore freed.
 *		(XXX will need to be modified to port to a shared library.)
 *		(XXX potential memory leaks since no freeing done when
 *			vars are deleted.)
 *
 *	RETURNS
 *		A pointer to the new environment with the added value.
 *		(Also resets "environ" to the new environment.)
 *
 */
char **XpPutEnv(name,value)
char *name;
char *value;
{
    static Bool firstcall = True;
    Bool found = False;
    unsigned int count = 0;
    char **envp;
    char name_eq[MAXSTR], *name_eq_value;

    /* When passed a null value pointer, use the null string */
    if( value == NULL ){
	value = "";
    }
    /*
     * Warning, don't rely on the return value of sprintf !!!
     * bsd  sprintf returns ptr to s
     * sysV sprintf returns count of chars
     */
#ifdef VXWORKS
    sprintf(name_eq,"%s=%s",name,value);
    putenv(name_eq);
#else
    sprintf(name_eq,"%s=",name);
    name_eq_value = malloc((unsigned int)(strlen(name)+strlen(value)+2));
    if(!name_eq_value){
	XpError("XpPutEnv cannot allocate memory");
    }
    sprintf(name_eq_value,"%s=%s",name,value);

    envp = environ;
    while(*envp && !found){
	if( !strncmp(name_eq,*envp,strlen(name_eq)) ){
	    *envp = name_eq_value;
	    found = True;
	}
	envp++;
	count++;
    }
    if(found){
	return(environ);
    }

    /* alloc count+2, the current values + 1 to add + 1 null pointer */
    if( firstcall ){
        envp = (char **) malloc( (count+2)*(sizeof (char *)) );
	bcopy( (char*) environ, (char *)envp, count*(sizeof (char*)) );
	firstcall = False;
    } else {
        envp = (char **) realloc( (char *)environ, (count+2)*(sizeof (char *)) );
    }
    if(!envp){
	XpError("XpPutEnv cannot allocate memory");
    }
    environ = envp;
    environ[count] = name_eq_value;
    environ[count+1] = NULL;

#endif /* not VXWORKS */
    return(environ);
}

#ifndef VXWORKS

/*
 *	NAME
 *		XpDeleteEnv - Delete an environment variable
 *
 *	SYNOPSIS
 */
Bool XpDeleteEnv(name)
char *name;
/*
 *	DESCRIPTION
 *		Delete the environment variable "name" from the environment.
 *		This routine removes the "name=value" string from the
 *		environment by collapsing the environ list and inserting
 *		another NULL in the second to the last entry.
 *
 *	RETURNS
 *		Returns True if the variable name was found and deleted.
 *		Returns False if the variable was not found.
 *
 */
{
    char **envp;
    char buf[MAXSTR];
    Bool found = False;

#ifdef VMS
	int status;

	status = deleteVmsLogicalName(name);
#endif /* VMS */
    sprintf(buf,"%s=",name);
    envp = environ;
    while(*envp){
	if( !found ){
	    if( !strncmp(buf,*envp,strlen(buf)) ){
		found = True;
	        *envp = *(envp+1);
	    }
	} else {
	    *envp = *(envp+1);
	}
	envp++;
    }
    return(found);
}
#endif /* not VXWORKS */



