#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpError.c,v 1.7 1993/02/03 18:33:43 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

#ifndef VXWORKS

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpError.c - package for error and warning routines
 *
 *	DESCRIPTION
 *		Error and warning routines and macros
 *
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 */
#include <stdio.h>
#include <X11/Xlib.h>
#ifdef TEKXP
#ifdef VMS
#include <Xp/XpGlobals.h>
#include <Xp/XpError.h>
#else
#include <X11/Xp/XpGlobals.h>
#include <X11/Xp/XpError.h>
#endif /* VMS */
#endif

extern int errno;


/*
 *	NAME
 *		XpErrorF - Print error message to stderr
 *
 *	SYNOPSIS
 */
/*VARARGS1*/
void
XpErrorF( f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9) /* limit of ten args */
char *f;
char *s0, *s1, *s2, *s3, *s4, *s5, *s6, *s7, *s8, *s9;
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		void
 *
 */
{
    fprintf( stderr, f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9);
}


/*
 *	NAME
 *		XpError - print error message in standard format
 *
 *	SYNOPSIS
 */

void
XpError(str)
char *str;
/*
 *	DESCRIPTION
 *		Print error message using perror.
 *
 *	RETURNS
 *		void
 *
 */
{
    perror(str);
}


/*
 *	NAME
 *		XpWarning - print warning message in standard format
 *
 *	SYNOPSIS
 */
/*VARARGS1*/
void
XpWarning(f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9) /* limit of ten args */
char *f;
char *s0, *s1, *s2, *s3, *s4, *s5, *s6, *s7, *s8, *s9;
/*
 *	DESCRIPTION
 *		Print warning message in the standard format and return.
 *
 *	RETURNS
 *		void
 *
 */
{
    XpErrorF("\nWarning!\n");
    XpErrorF(f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9);
    XpErrorF("\n");
}


/*
 *	NAME
 *		XpFatalError - print error message and exit
 *
 *	SYNOPSIS
 */
/*VARARGS1*/
void
XpFatalError(f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9) /* limit of ten args */
char *f;
char *s0, *s1, *s2, *s3, *s4, *s5, *s6, *s7, *s8, *s9;
/*
 *	DESCRIPTION
 *		Print error message in the standard format.
 *		Exit using errno as the return code.
 *
 *	RETURNS
 *		void
 *
 */
{
    XpErrorF("\nFatal error!\n");
    XpErrorF(f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9);
    XpErrorF("\n");
    exit(errno);
}

#endif /* not VXWORKS */
