#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpGetProp.c,v 1.12 1993/02/03 18:26:21 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpGetProp.c - Convenience routines to get window properties
 *
 *	DESCRIPTION
 *		Get a Property into a string or an array of strings.
 *
 */

#ifdef VXWORKS
#define  REDEFINE_MALLOC
#include "tmem.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>	/* need string.h */
#include <stdio.h>

#ifdef VMS
#include <Xp/XpGetProp.h>
#else
#include <X11/Xp/XpGetProp.h>
#endif


/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */

#define PROP_BUFSIZE	1024L

#ifndef REDEFINE_MALLOC
#define tm_malloc(size)	malloc(size)
extern char *malloc();
#endif /* REDEFINE_MALLOC */



/*
 *	NAME
 *		XpGetPropertyData - Get a window property data and length
 *
 *	DESCRIPTION
 *		XpGetPropertyData will return a string when passed a window
 *		property of type XA_STRING.  The string is returned in the
 *		variable pointed to by dataptr and the length of the char data
 *		is returned in the variable pointed to by len.
 *
 *		XpGetPropertyData will return a interger array when passed a
 *		window property of type XA_INTEGER.  The array is returned
 *		in the variable pointed to by dataptr and the length of
 *		the int data is returned in the variable pointed to by len.
 *
 *		If delete is True, the property is deleted after being read.
 *
 *	RETURNS
 *		void
 *
 */
void
XpGetPropertyData(dpy,win,property,delete,type,dataptr,len)
Display *dpy;
Window win;
Atom property;
Bool delete;
Atom type;
unsigned char **dataptr; /* address of return for string pointer to return */
unsigned long *len;	 /* returns the length of the string without null */
{
    Atom type_return;
    int	format_return;
    unsigned long bytes_after;

    XGetWindowProperty(dpy,win,property,0L,PROP_BUFSIZE,delete,
	type,&type_return,&format_return,len,&bytes_after,dataptr);
    if(bytes_after){
	/* whoops, didn't get it all, simply try again with sufficent length */
	XFree((char *)*dataptr);
	XGetWindowProperty(dpy,win,property,0L,PROP_BUFSIZE+((bytes_after+4)>>2),delete,
	    type,&type_return,&format_return,len,&bytes_after,dataptr);
    }
    /* XXX Error checking */
}


/*
 *	NAME
 *		XpGetPropertyStrList - Get an array of strings from a property
 *
 *	DESCRIPTION
 *		XpGetPropertyStrList allocates an array of string pointers
 *		terminated by a null pointer.  The string pointers point to
 *		the strings gotten from the window property passed.
 *
 *		To free the memory allocated, use the routines:
 *		XFree((*strarray)[0]) to free the property returned data
 *		free(*strarray) to free the array of pointers 
 *
 *	RETURNS
 *		void
 *
 */
void
XpGetPropertyStrList(dpy,win,property,strarray)
Display *dpy;
Window win;
Atom property;
char ***strarray; /* address of return for array of string pointers */
{
    unsigned long len;
    unsigned int i, count=0;
    unsigned char *str;
    char *strp;

    XpGetPropertyStr(dpy,win,property,&str,&len);

    /* count the strings in the property */
    /* one caveat, property len cannot overflow an unsigned int */
    for(i=0;i<(unsigned int)len;i++){
	if(str[i]=='\0'){
	    count++;
	}
    }
    /*
     * allocate one more pointer than number of strings in the property
     * set last pointer to NULL
     */
    *strarray = (char **) tm_malloc( (count+1)*sizeof(char *) );
    (*strarray)[count] = (char *)NULL;

    /*
     * use count and rindex instead
     */
    strp = (char *)str;
    i=0;
    do{
	(*strarray)[i++] = strp;
	strp = strp + strlen(strp) + 1;
    } while(i<count);

}
