#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpGlobals.c,v 1.11 1993/04/23 22:51:17 houchin Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpGlobals.c - globals available to any Xp routine
 *
 *	DESCRIPTION
 *		This library provides a single structure that is global.
 *		Different packages can have members in this structure.
 *		This avoids many global variables introduced by different
 *		packages.  It has the minor problem of a "need one you
 *		get all" attitude, but we should emphasize that this should
 *		be a small global structure.  Minimize what is put here.
 *
 *	EXTERNAL INCLUDES
 */
#include	<stdio.h>

#include <X11/Xlibint.h>
#include <X11/Xlib.h>
#ifdef VXW_LIBXR
#include <X11/shxGlobals.h>
#else
#include <X11/Xp/XpGlobals.h>
XpGlob _Xp = {
    /* argc	*/	NULL,
    /* argv	*/	(char **)NULL,
    /* dpyname	*/	(char *)NULL,
    /* Display	*/	(Display *)NULL,
    /* Bool	*/	True
};
#endif


/*
 *	NAME
 *		XpInitialize - Initialize global data for the Xp library
 *
 *	DESCRIPTION
 *
 *		Initialize global data that can be used from within
 *		Xp routines.  For example, the X Display pointer dpy
 *		dpy will be used in cases where the routine we are
 *		providing in Xp does not normally have a dpy argument.
 *		For example the Xp_exec* routines take the exact same
 *		arguments that the unix exec* routines do, but Xp
 *		implements them with a display pointer.  Thus we need
 *		to have the dpy accessed via the global _Xp structure.
 *
 *		Also the error routines may use argv[0], which can be
 *		accessed via the global _Xp structure.
 *
 *		Other Xp global variables may only be needed by certain
 *		packages (Xp*.c files).  Those globals will always begin with
 *		the prefix _Xp but may not be placed in this structure.
 *
 *		Currently this routine is called within XpOpenDisplay().
 *		If XpOpenDisplay() is not used, then XpInitialize() must
 *		be called explicitly!!!
 *
 *		WARNING!!! argv and dpyname should never be freed by the
 *		caller.
 *
 *	RETURNS
 *		void
 *
 */
void
XpInitialize(argc,argv,dpyname,dpy)
int	argc;
char	**argv;
char	*dpyname;
Display *dpy;
{
    _Xp.argc = argc;
    _Xp.argv = argv;
    _Xp.dpyname = dpyname;
    _Xp.dpy = dpy;

}
