#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpHomeAccess.c,v 1.32 1993/04/23 22:54:49 houchin Exp $";
#endif /* RCS_ID */
#endif /* LINT */
/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpHomeAccess.c - package for local client file access settings
 *
 *	DESCRIPTION
 *		Routines which return information needed for a TekXpress
 *		local client to access files on a remote host.
 *		Xpsh passes this information to the local client environment.
 *
 *	EXTERNAL INCLUDES
 */

/*
 *	INTERNAL INCLUDES
 */

#ifdef TEKXP
#include "tekxp_lang.h"
#else
#ifdef X11R5
#include <X11/tekxp_lang.h>
#else
#include "tekxp_lang.h"
#endif /* X11R5 */
#endif /* TEKXP */

#include <stdio.h>

#ifdef VMS
#include <ssdef.h>
#include <syidef.h>
#include <unixlib.h>
#include <nam.h>
#define MAXPATHLEN NAM$C_MAXRSSLCL
#endif /* not VMS */

#include <X11/Xlibint.h>
#include <X11/Xos.h>

#ifdef ultrix
#include <netdnet/dn.h>
#endif

#if !defined(TEKXP) && !defined(VMS)
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#endif /* !defined(TEKXP) && !defined(VMS) */

#ifndef MAXPATHLEN
#define MAXPATHLEN 256
#endif 

#ifndef MAXHOSTNAMELEN
/* VMS doesn't provide a definition. */
#define MAXHOSTNAMELEN 64
#endif

/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */

/*
 *	INTERNALS
 */




#ifndef TEKXP
/*
 * hpux
 * Hand-patched versions of HP-UX prior to version 7.0 can usefully add
 * -DUSE_UNAME in the appropriate config file to get long hostnames.
 */
#ifdef hpux				/* stupid makedepend [need if] */
#define USE_UNAME
#endif
#ifdef USG
#define USE_UNAME
#endif
#ifdef USE_UNAME
#include <sys/utsname.h>
#endif

/*
 *	NAME
 *		XpGetHostname - get host name;  based on Xlib's _XGetHostname
 *
 *	SYNOPSIS
 */
int XpGetHostname(buf, maxlen, access_int)
char *buf;
int maxlen;
int access_int;
/*
 *	DESCRIPTION
 *		Get the hostname, depending on the value of access_int,
 *		and store it in the caller's buffer buf, which is maxlen
 *		characters long.  (MAXPATHLEN is a good size for buf.)
 *		If the hostname cannot be found, buf is set to the
 *		empty string ("").
 *
 *		Access_int is one of:
 *			TFTP_ACCESS
 *			UNIX_ACCESS
 *			NFS_TFTP_ACCESS
 *			DAP_ACCESS
 *			SXP_ACCESS
 *
 *	RETURNS
 *		Size of hostname string in buf.
 */
{
    int len;
    char *ptr;
#if defined(ultrix)
    extern char *getnodename();
    extern void nerror();
#endif /* ultrix */

#ifdef VMS
#ifdef TCPIP
	if (access_int == DAP_ACCESS) {
#endif /* TCPIP */
	/* for now assume that transport is DAP, so return the DECnet executor
	 * node name 
	 */
	if ((ptr = getVmsEnv("SYS$NODE",buf)) != NULL) {
	    len = strlen(buf);
		if (*(buf + len - 1) == ':') {
			len = len - 2;
			*(buf + len) = '\0';
		}
	}
	else {
		len = 0;
	}
#ifdef TCPIP
	}
	else {
    buf[0] = '\0';
    (void) gethostname (buf, maxlen);
    buf [maxlen - 1] = '\0';
    len = strlen(buf);
	}
#endif /* TCPIP */
#else  /* !VMS */
#ifdef USE_UNAME
    struct utsname name;

    uname (&name);
    len = strlen (name.nodename);
    if (len >= maxlen) len = maxlen - 1;
    (void) strncpy (buf, name.nodename, len);
    buf[len] = '\0';
#else  /* !USE_UNAME */
    buf[0] = '\0';
#if defined(ultrix)
    if (access_int == DAP_ACCESS) {   /* DAP */
       if (!(ptr = getnodename())) {
           (void) nerror("Unable to get DECnet nodename");
           len = 0;
       }
       else {
           strcpy(buf, ptr);
           len = strlen(buf);
           buf [len] = '\0';
       }
       return len;
    }
#endif /* ultrix */
    (void) gethostname (buf, maxlen);
    buf [maxlen - 1] = '\0';
    len = strlen(buf);
#endif /* USE_UNAME */
#endif /* VMS */
    return len;
}



#ifndef VMS
#include <pwd.h>
#endif /* !VMS */

/*
 *	NAME
 * 		XpGetHomeDirName - get the user's home directory
 *
 *	SYNOPSIS
 */
char *XpGetHomeDirName()
/*
 *	DESCRIPTION
 *		Get the user's home directory.
 *		The returned home directory path should not be freed
 *		by the caller.
 *
 *	RETURNS
 *		User's home directory.  If no home directory can be found,
 *		returns empty string ("").
 */
{
     static char *ptr = NULL;
     extern char *getenv();
#ifdef VMS
    static char homeEnv[256];
    ptr = getVmsEnv("HOME",homeEnv);
    if (!ptr)
        ptr = "";
#else
    uid_t uid;
    struct passwd *pw;

    if (ptr == NULL) {
	if((ptr = getenv("HOME")) == NULL) {
	    if((ptr = getenv("USER")) != NULL) pw = getpwnam(ptr);
	    else {
		uid = getuid();
 		pw = getpwuid(uid);
	    }
	    if (pw) ptr = pw->pw_dir;
	    else {
		ptr = "";
	    }
	}
    }
#endif /* VMS */
     return ptr;
}



/*
 *	NAME
 * 		XpGetCwd - get the user's current working directory
 *
 *	SYNOPSIS
 */
char *XpGetCwd()
/*
 *	DESCRIPTION
 *		Get the user's current working directory.
 *		The returned current directory path should not be freed
 *		by the caller.
 *
 *	RETURNS
 *		User's current working directory.  If no current working
 *		directory can be found,	returns empty string ("").
 */
{
     extern char *getcwd();
     static char cwdEnv[MAXPATHLEN];

#ifndef umips
     if (!getcwd(cwdEnv, MAXPATHLEN)) {
#else
      {
#endif
        cwdEnv[0] = '\0';
      }
#ifdef VMS
    (void) stringDowncase (cwdEnv);
#endif /* VMS */

    return (cwdEnv);
}
#endif /* !TEKXP */



static struct {
    char *accessname;
    int access;
} accessnames [] = {
    "tftp", TFTP_ACCESS,	    /* TFTP protocol access */
    "nfs", UNIX_ACCESS,		    /* Unix domain (NFS) access */
    "nfs/tftp", NFS_TFTP_ACCESS,    /* NFS, else TFTP protocol access */
    "dap", DAP_ACCESS,		    /* DAP protocol access */
    "sxp", RSS_ACCESS,		    /* RSS protocol access */
};

/*
 *	NAME
 * 		XpTranslateAccessName - translate access name to internal rep
 *
 *	SYNOPSIS
 */
int XpTranslateAccessName(accessname, access, dpyname, rssname)
char *accessname;
char *access;
char *dpyname;
char *rssname;
/*
 *	DESCRIPTION
 *		Convert the access method ("tftp", "nfs", "nfs/tftp","dap",or 
 *		"sxp")
 *		specified in accessname to its internal integer representation.
 *		The access method is returned in the caller buffer, access,
 *		as an integer string, which corresponds to the access methods'
 *		internal representations as defined in penguin_lang.h.
 *		The caller buffer, access, must be at least 3 bytes long.
 *		
 *		If accessname is NULL or "", the access method follows the
 *		"display variable" transport access method.  If the 'rssname'
 *		is the same as the dpyname, the access will be set to
 *		RSS_ACCESS but the return value will not be changed.
 *
 *	RETURNS
 *		Integer representation of access method.
 *		If a valid access method is not found, NO_ACCESS is returned.
 *		If the caller buffer, access, is NULL, -1 is returned. 
 *
 *     MODIFICATION
 *		26-feb-1992 MMA changed default access method to
 *		follows-display-variable rather than simply dap for VMS
 *		and tftp/nfs for others.
 */
{
    int access_int = NO_ACCESS;
    int i;
    char *transport;

    if (!access) {
	return -1;
    }

    if (accessname && *accessname) {
	for (i = 0; i < (sizeof (accessnames) / sizeof (accessnames[0])); i++)
#ifdef VMS
	    if (! caseInsensStrcmp (accessnames[i].accessname, accessname))
#else
	    if (! strcmp (accessnames[i].accessname, accessname))
#endif /* VMS */
	    {
	        access_int = accessnames[i].access;
	    }
	if (access_int == NO_ACCESS) {
	    fprintf(stderr, "bad access setting \"%s\", legal values are ",
		    accessname);
	    for (i = 0; i < (sizeof (accessnames) / sizeof (accessnames[0])); 
		 i++)
		fprintf(stderr,"\"%s\" ", accessnames[i].accessname);
	    fprintf(stderr,"\n");
	}
    }
#ifndef TEKXP
    else {
      if (rssname && dpyname && strrchr(dpyname,':') && 
	  (strcmp(rssname,(char *)(strrchr(dpyname,':')+1)) == 0)){
	access_int = RSS_ACCESS;
      }else{
	/* follow the "display-variable"'s transport specified */
	if (dpyname && (transport = index (dpyname,':'))) {
	  if ( *(transport+1) == ':') /* :: */
	    access_int = DAP_ACCESS;
	  else
	    access_int = NFS_TFTP_ACCESS; /* : */
	}
      }
    }
#endif /* !TEKXP */
    sprintf(access,"%d",access_int);
    return access_int;
}

#ifndef TEKXP
#include <X11/Xlib.h>

/*
 *	NAME
 *		XpGetHostAddr - get host address
 *
 *	SYNOPSIS
 */
int XpGetHostAddr(dpy, buf, maxlen, access_int)
Display *dpy;
char *buf;
int maxlen;
int access_int;
/*
 *	DESCRIPTION
 *		Get the host address, depending on the value of access_int,
 *		and store it in the caller's buffer buf, which is maxlen
 *		characters long.  (MAXPATHLEN is a good size for buf.)
 *		If the hostname cannot be found, buf is set to the
 *		empty string ("").
 *
 *		Access_int is one of:
 *			TFTP_ACCESS
 *			UNIX_ACCESS
 *			NFS_TFTP_ACCESS
 *			DAP_ACCESS
 *			SXP_ACCESS
 *
 *	RETURNS
 *		Size of string in buf.
 */
{
    int len = 0;
    char tmpbuf[MAXHOSTNAMELEN];
    char *ptr;

    if (access_int == DAP_ACCESS)
    {
	/* Get the node's DECnet address */
#if !defined(VMS) && !defined(ultrix)
	return 0;
#else
#ifdef VMS
	long number, area, status;
	short number_length, area_length;
	struct {
	    short buflen;
	    short itemCode;
	    long bufAddr;
	    long retnLenAddr;
	} items[] =
	{
		{sizeof area, SYI$_NODE_AREA, &area, 0},
		{sizeof number, SYI$_NODE_NUMBER, &number, 0},
		{0, 0, 0, 0} /* Terminates the list. */
	};

	status = sys$getsyiw(NULL, NULL, NULL, &items, NULL, NULL, NULL);

	if (status != SS$_NORMAL)
	    return 0;
#else
#ifdef ultrix
	int number, area, dnet_address;
	struct dn_naddr *addr = getnodeadd();

	if (addr == NULL)
	    return 0;

	dnet_address = addr->a_addr[0] + addr->a_addr[1] * 256L;

	number = dnet_address % 1024;
	area = dnet_address / 1024;
#endif /* ultrix */
#endif /* !VMS */

	sprintf(tmpbuf, "%ld.%ld::", area, number);
	if ((len = strlen(tmpbuf)) >= maxlen)
	    return 0;

	strcpy(buf, tmpbuf);
#endif /* !defined(VMS) && !defined(ultrix) */
    }
    else
    {
	/* Get the host's IP address. */
#ifdef VMS
	/* Don't have a common way among the 4 supported TCP/IP's */
	return 0;
#else
#ifdef USE_UNAME
	struct utsname name;
#endif /* USE_UNAME */
	struct hostent *the_hostent;
	struct in_addr the_addr;
	struct sockaddr_in the_sockaddr;
	int namelen = sizeof the_sockaddr;

	/* See if we can get the address via the
	 * X Display structure's socket.
	 */

	if (0 == getsockname(dpy->fd, &the_sockaddr, &namelen))
	{
	    /* Convert the in_addr to a string. */

	    ptr = inet_ntoa(the_sockaddr.sin_addr);

	    if (ptr != NULL && (len = strlen(ptr)) < maxlen && len > 0)
	    {
	        strcpy(buf, ptr);

		return len;
	    }
	}

	/* That failed.  Unix doesn't provide a direct way of getting
	 * the address of the system you're on.  So, start by getting
	 * the name of the system, then the address with that name.
	 */
#ifdef USE_UNAME
	if (uname(&name) != 0)
	    return 0;
	
	ptr = name.nodename;
#else
	if (gethostname(tmpbuf, MAXHOSTNAMELEN) != 0)
	    return 0;

	ptr = tmpbuf;
#endif /* !USE_NAME */

	the_hostent = gethostbyname(ptr);

	if (!the_hostent ||
	    the_hostent->h_length != sizeof the_addr.s_addr)
	    return 0;

	/* Create an in_addr struct with this address in it. */

	memcpy(&the_addr.s_addr,
	       the_hostent->h_addr,
	       sizeof the_addr.s_addr);

	/* Convert the in_addr to a string. */

	ptr = inet_ntoa(the_addr);

	if (ptr == NULL || (len = strlen(ptr)) >= maxlen)
	    return 0;

	strcpy(buf, ptr);
#endif /* !VMS */
    }
    return len;
}

#endif /* !TEKXP */


