#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpOpenDpy.c,v 1.7 1993/02/03 18:35:40 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpOpenDpy -- open display, wait for server if necessary
 *
 *	DESCRIPTION
 *		Initialization routines
 *
 */

#include <X11/Xlib.h>

#ifdef TEKXP
#ifdef VMS
#include <Xp/XpGlobals.h>
#else
#include <X11/Xp/XpGlobals.h>
#endif
#endif

#ifdef VMS
#include <ssdef.h>
#include <stsdef.h>
#define ERROR_EXIT	(STS$M_CUST_DEF | STS$M_INHIB_MSG | STS$K_ERROR)
#define NORMAL_EXIT SS$_NORMAL
#else
#define ERROR_EXIT 1
#define NORMAL_EXIT 0
#endif /* VMS */


/*
 *	NAME
 *		XpOpenDisplay 
 *
 *	DESCRIPTION
 *		Opens the display on a penguin - waits for server if necessary
 *
 *	RETURNS
 *		pointer to a display
 *
 */
Display *
XpOpenDisplay(argc,argv,display)
int argc;	/* in, passed to XpInitialize */
char **argv;	/* in, passed to XpInitialize */
char *display;	/* in, display name, also passed to XpInitialize */
{
    Display *pdisplay;

#ifndef TEKXP
    if (!(pdisplay = XOpenDisplay(display)))
    {
       perror("Cannot open display\n");
       exit(ERROR_EXIT);
    }
#else 
    while (!(pdisplay = XOpenDisplay(display)))
    {
	sleep(1);
    }
#endif

    /*
     * Automatically call XpInitialize().
     * Any program that calls XOpenDisplay directly needs to
     * explicitly call XpInitialize().
     * 
     * XXX 
     * Furture mods may initialize less after a fork as opposed to startup.
     * The state of the global variables could indicate whether it was
     * startup or after a fork.
     */
    XpInitialize(argc,argv,display,pdisplay);

    return(pdisplay);
}
