#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpSIGCHLD.c,v 1.8 1993/02/03 18:35:14 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

#ifndef VMS
/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpSIGCHLD.c - package for handling signal SIGCHLD
 *
 *	DESCRIPTION
 *		Routines to catch and handle signal.
 *
 *	EXTERNAL INCLUDES
 */
/*
 *	INTERNAL INCLUDES
 */
#include <stdio.h>
#include <signal.h>
#include <sys/wait.h>
#include <X11/Xlib.h>

typedef int (*PFI)();
Bool _XpChildStopped = False;


#ifdef NOTIMPLEMENTED
/*
 *	NAME
 *		XpHandlerExitSIGCHLD - Signal Handler for SIGCHLD
 *
 *	SYNOPSIS
 */
int
XpHandlerExitSIGCHLD(sig, code, scp)
int sig;
int code;
struct sigcontext *scp;
/*
 *	DESCRIPTION
 *		Signal handler for SIGCHLD when the code wants to exit.
 *		This handler will set a static flag to show the interrupt
 *		has been caught.  The main loop should call the cooperating
 *		routine XpCheckExitSIGCHLD() which will check the flag,
 *		make the correct X calls if the flag is set, and exit.
 *
 *		Signal ARGUMENTS are NOT used since this is also called from
 *		main loop with NULL arguments.
 *
 *		Wait for all child processes that may have exited.
 *		Caller should also wait in main loop since we are
 *		not guaranteed to get all children in this loop.
 *
 *		Purpose of this handler is to guarantee that we do
 *		not leave zombie child processes.
 *
 *	RETURNS
 *		int ???
 *
 */
{
    /*
     * DO NOT use any of the passed arguments since this routine is
     * also called from the main loop with NULL arguments
     */
#ifdef SYSV
    while( waitpid(-1,NULL,WNOHANG) > 0 );
#else
    union wait status;
    while( wait3(&status,WNOHANG,(struct rusage *)NULL) > 0 );
#endif /* SYSV */
}
#endif /* NOTIMPLEMENTED */

#ifndef VXWORKS			/* no wait or SIG_IGN in vxworks */
/*
 *	NAME
 *		XpHandleSIGCHLD - Signal Handler for SIGCHLD
 *
 *	SYNOPSIS
 */
int
XpHandlerSIGCHLD(sig, code, scp)
int sig;
int code;
struct sigcontext *scp;
/*
 *	DESCRIPTION
 *		Signal handler for SIGCHLD.
 *
 *		Signal ARGUMENTS are NOT used since this is also called from
 *		main loop with NULL arguments.
 *
 *		Wait for all child processes that may have exited.
 *		Caller should also wait in main loop since we are
 *		not guaranteed to get all children in this loop.
 *
 *		Purpose of this handler is to guarantee that we do
 *		not leave zombie child processes.
 *
 *	RETURNS
 *		int ???
 *
 */
{
    /*
     * DO NOT use any of the passed arguments since this routine is
     * also called from the main loop with NULL arguments
     */
#ifdef SYSV
    while( waitpid(-1,NULL,WNOHANG) > 0 );
#else
    union wait status;
    while( wait3(&status,WNOHANG,(struct rusage *)NULL) > 0 );
#endif /* SYSV */
}

/*
 *	NAME
 *		XpSignal - Catch a signal if it is not already ignored
 *
 *	SYNOPSIS
 */
PFI XpSignal(sig,func)
int sig;
PFI func;
/*
 *	DESCRIPTION
 *		If the signal is not currently ignored,
 *		catch the signal using the func handler.
 *
 *		This routine should be used to provide a consistent
 *		portable select routines to different flavors of hosts.
 *
 *		Error processing may be done within this Xp routine.
 *
 *	RETURNS
 *		Same as signal().
 *
 */
{
    /*
     * Catch SIGCHLD indicating that the child has stopped or exited.
     */
    if(signal(sig, SIG_IGN) != SIG_IGN){
	return((PFI) signal(sig,func));
    } else {
	return((PFI) SIG_IGN);
    }
}
#endif /* VXWORKS */
#endif /* VMS */
