#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpSendClMsg.c,v 1.14 1993/02/03 18:29:22 kentb Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpSendClMsg.c - Routines to send client messages
 *
 *	DESCRIPTION
 *		This package has convenience routines for sending a client
 *		message.
 *
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <X11/Xos.h>	/* need string.h */


#ifdef TEKXP
#ifdef VMS
#include <Xp/XpError.h>
#else
#include <X11/Xp/XpError.h>
#endif /* VMS */
#endif

/*
 * For the client message event mask sent to the root window,
 * choose some event mask that would normally never be used on the root.
 * This is used because it is an event mask that would never
 * be requested by any other client on the root window.  Any that do 
 * can receive our Client Message, but hopefully they would discard it
 * if they don't care about the unique message_type atom used.
 */
#define XP_CLMSG_ROOT_EVENT_MASK	ResizeRedirectMask



/*
 *	NAME
 *		XpSendClientMessageInt - Send a client msg of one long int
 *
 *	SYNOPSIS
 *		This routine will package a long int into a client message
 *		and send it to the owner of win.
 *
 *		If win==root, then the CLMSG_ROOT_EVENT_MASK will be used
 *		so that any client that has selected that event mask
 *		on the root window will receive the message.  This
 *		technique is used when you are sending a unique
 *		atom message_type so that only one receiver is interested
 *		in the unique message.  (Or it could be used to broadcast
 *		a message to serveral receivers if that is what you want.)
 *
 *	DESCRIPTION
 *		Send a client message to the window.
 *
 *		This simple interface assumes the message data is
 *		a single long integer value.
 *
 *		Future enhancement:
 *		If blocking is requested, wait for the receiving client to
 *		send the same client message back to the requesting client
 *		on the requesting client window.
 *
 *	RETURNS
 *		void
 *
 */
Status
XpSendClientMessageInt(dpy,win,message_type,message_data)
Display *dpy;
Window win;
Atom message_type;
long message_data;
{
    XEvent e;
    XClientMessageEvent *ecm = (XClientMessageEvent *) &e;
    long event_mask;
    Status status;

    ecm->type = ClientMessage;
				/* serial - Xserver will calculate */
				/* send_event - Xserver will calculate */
				/* window - Xserver will set to win? */

    ecm->display = dpy;		/* not sure if this is necessary */
    ecm->message_type = message_type;
    ecm->format = 32;		/* force an integer format */
    ecm->data.l[0] = message_data;

    if( win == DefaultRootWindow(dpy) ){
        /* Send the client message event to the client selecting on root */
	event_mask = XP_CLMSG_ROOT_EVENT_MASK;
    } else {
        /* Send the client message event to the client who created win */
	event_mask = (long)NULL;
    }

    status = XSendEvent(dpy, win, (Bool)False, event_mask, (XEvent *)ecm);
    if( status == 0){
        XpWarning("XSendEvent: conversion to wire protocol format failed");
    }
    return(status);
}

/*
 *	NAME
 *		XpSendClientMessage - Send a client msg
 *
 *	SYNOPSIS
 *		This routine will package (up to 5) long ints into a 
 *		client message and send it to the owner of win.
 *
 *		If win==root, then the CLMSG_ROOT_EVENT_MASK will be used
 *		so that any client that has selected that event mask
 *		on the root window will receive the message.  This
 *		technique is used when you are sending a unique
 *		atom message_type so that only one receiver is interested
 *		in the unique message.  (Or it could be used to broadcast
 *		a message to serveral receivers if that is what you want.)
 *
 *	DESCRIPTION
 *		Send a client message to the window.
 *
 *		This simple interface assumes the message data is
 *		several long integer values.
 *
 *		Future enhancement:
 *		If blocking is requested, wait for the receiving client to
 *		send the same client message back to the requesting client
 *		on the requesting client window.
 *
 *	RETURNS
 *		void
 *
 */
Status
XpSendClientMessage(dpy,win,message_type,message_data,message_length)
Display *dpy;
Window win;
Atom message_type;
long *message_data;
int message_length;
{
    XEvent e;
    XClientMessageEvent *ecm = (XClientMessageEvent *) &e;
    long event_mask;
    Status status;
    int length, i;
    long *message_ptr;

    ecm->type = ClientMessage;
				/* serial - Xserver will calculate */
				/* send_event - Xserver will calculate */
				/* window - Xserver will set to win? */

    ecm->display = dpy;		/* not sure if this is necessary */
    ecm->message_type = message_type;
    ecm->format = 32;		/* force an integer format */
    message_ptr = message_data;
    if (message_length <= 0) {
        XpWarning("XSendEvent: conversion to wire protocol format failed");
        return (0);
    }
    length = (message_length > 5) ? 5 : message_length;
    for (i=0; i < length; i++, message_ptr++) {
	ecm->data.l[i] = *message_ptr;
    }

    if( win == DefaultRootWindow(dpy) ){
        /* Send the client message event to the client selecting on root */
	event_mask = XP_CLMSG_ROOT_EVENT_MASK;
    } else {
        /* Send the client message event to the client who created win */
	event_mask = (long)NULL;
    }

    status = XSendEvent(dpy, win, (Bool)False, event_mask, (XEvent *)ecm);
    if( status == 0){
        XpWarning("XSendEvent: conversion to wire protocol format failed");
    }
    return(status);
}
