/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpSendProp.c - Routines to send window properties
 *
 *	DESCRIPTION
 *		This package allows sending properties and blocking
 *		until the property is removed.
 *
 *	EXTERNAL INCLUDES
 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
/*
 *	INTERNAL INCLUDES
 */
#ifdef DEBUG
#include <stdio.h>
#ifdef VMS
#include <Xu/XuDefineTbl.h>
#else
#include <X11/Xu/XuDefineTbl.h>
#endif /* VMS */
#endif
/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */
#define XpSendPropertyStr(dpy,win,property,str)				\
    XpSendProperty((dpy),(win),(property),XA_STRING,8,PropModeReplace,	\
	(unsigned char *)(str),strlen((str))+1);

#define XpSendPropertyInt(dpy,win,property,intptr)			\
    XpSendProperty((dpy),(win),(property),XA_INTEGER,32,PropModeReplace, \
	(unsigned char *)(intptr),1);

/*
 *	INTERNALS
 */
#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpSendProp.c,v 1.8 1992/02/20 22:18:24 marva Exp $";
#endif /* RCS_ID */
#endif /* LINT */



/*
 *	NAME
 *		XpSendProperty - Send a property, block till received
 *
 *	SYNOPSIS
 */
void
XpSendProperty(dpy,win,property,type,format,mode,data,nelements)
Display *dpy;
Window win;
Atom property, type;
int format;
int mode;
unsigned char *data;
int nelements;
/*
 *	DESCRIPTION
 *		Write the property onto the window.
 *		Wait for the property to be removed by the receiver
 *		before returning.
 *
 *	RETURNS
 *		void
 *
 */
{
    Bool NotDeleted = True;
    XEvent e;
    XPropertyEvent *eprop;


    XSelectInput(dpy,win,PropertyChangeMask);
    XChangeProperty(dpy,win,property,type,format,mode,data,nelements);
    while(NotDeleted){
	XWindowEvent(dpy,win,PropertyChangeMask,&e);
	switch(e.type){
	    case PropertyNotify:
		eprop = (XPropertyEvent *)&e;
		if( eprop->atom == property &&
		    eprop->state == PropertyDelete){
		    NotDeleted = False;
		}
	}
    }
}
