/*
 * Copyright (c) 1991, 1992 Tektronix, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *	NAME
 *		XpSetProp.c - Convenience routines to set window properties
 *
 *	DESCRIPTION
 *		Set a window property to a:
 *			string 
 *			array of strings
 *			interger 
 *
 *	EXTERNAL INCLUDES
 */
#include <X11/Xlib.h>
#include <X11/Xos.h>	/* need string.h */
/*
 *	INTERNAL INCLUDES
 */
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
/*
 *	DIAGNOSTICS
 *		<error messages, meanings, and corrective action>
 *
 *	BUGS
 *		<currently known loony behavior>
 *
 *	EXTERNALS
 */
#define XpSetPropertyStr(dpy,win,property,str)				\
    XChangeProperty((dpy),(win),(property),XA_STRING,8,PropModeReplace,	\
	(unsigned char *)(str),strlen((str))+1);

#define XpSetPropertyInt(dpy,win,property,intptr)			\
    XChangeProperty((dpy),(win),(property),XA_INTEGER,32,PropModeReplace,\
	(unsigned char *)(intptr),1);

/*
 *	INTERNALS
 */
#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/lib/Xp/RCS/XpSetProp.c,v 1.6 1992/01/30 23:22:49 cathybr Exp $";
#endif /* RCS_ID */
#endif /* LINT */



/*
 *	NAME
 *		XpSetPropertyStrListn - Set a property to a list of n strings
 *
 *	SYNOPSIS
 */
void
XpSetPropertyStrListn(dpy,win,property,strptr,count)
Display *dpy;
Window win;
Atom property;
char **strptr;	/* array of string pointers */
int count;
/*
 *	DESCRIPTION
 *		Set property on win to a list of n strings.
 *		The strings are stored as a continuous stream of bytes.
 *
 *	RETURNS
 *		void
 *
 */
{
    char *nullstr = "";
    char **strarray;
    int n=0;

    /* 
     * replace property with a null string if the count is 0
     */
    if(count==0){
	strarray = &nullstr;
	count = 1;
    } else {
	strarray = strptr;
    }

    XDeleteProperty(dpy,win,property);
    do{
	XChangeProperty(dpy,win,property,XA_STRING,8,PropModeAppend,
	    (unsigned char *)strarray[n],strlen(strarray[n])+1);
	n++;
    } while(n<count);
    
}


/*
 *	NAME
 *		XpSetPropertyStrList - Set a property to a null terminalted list of strings
 *
 *	SYNOPSIS
 */
void
XpSetPropertyStrList(dpy,win,property,strptr)
Display *dpy;
Window win;
Atom property;
char **strptr;	/* array of string pointers terminated by a null pointer */
/*
 *	DESCRIPTION
 *		Set property on win to an array of strings.
 *		The array is a list of string pointers terminated by
 *		a null pointer.
 *		The strings are stored as a continuous stream of bytes
 *		in the property.
 *
 *	RETURNS
 *		void
 *
 */
{
    int count = 0;
    while( strptr[count] != NULL ){
	count++;
    }
    XpSetPropertyStrListn(dpy,win,property,strptr,count);
}
