#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/xmodmap/RCS/XKeysym.c,v 1.4 1993/04/23 23:20:07 houchin Exp $";
#endif RCS_ID
#endif LINT

/* $XConsortium:$ */

/*
 * Copyright 1989 by Tektronix, Inc. Beaverton, Oregon,
 * and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Tektronix or M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Tektronix and M.I.T. make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * TEKTRONIX AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL TEKTRONIX OR M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Glenn Widener, Tektronix, Inc.
 *          P.O. Box 1000
 *          Wilsonville, OR, 97070
 *          glennw@orca.wv.tek.com
 */

#include <X11/Xlib.h>
#include <X11/Xlibint.h>
#define XK_LATIN1
#include <X11/keysymdef.h>

#include "Xkbd.h"	/* for KBCompose routines stolen from Tek Xlib */
#include <stdio.h>	/* for NULL */
#include <X11/Xmd.h>	/* for CARD declarations */

/* This routine finds the lowest-valued modifier bit pattern that points to
the specified column of the keycode-keysym table.  If no modifier bit
pattern selects the specified column, the routine returns zero.
If the keyboard modifier index property does not exist, the routine
returns Shift for column 1 and no modifiers for column 0. */

Status XColumnToModifier(dpy, column, modifier)
/*ARGSUSED*/	/* until we implement keyboard arch */
Display *dpy;
int column;		/* In: column of keycode-keysym table */
int *modifier;		/* Out: mask of modifier bits */
{
    /* if ( no index property) */
    switch (column) {
      case 0:
	*modifier = 0;
	return (1);
      case 1:
	*modifier = ShiftMask;
	return (1);
    }
    /* default: (keep lint happy) */
    return (0);
}

/*ARGSUSED*/
static void
XConvertCase(dpy, sym, lower, upper)
    Display *dpy;
    register KeySym sym;
    KeySym *lower;
    KeySym *upper;
{
    *lower = sym;
    *upper = sym;
    switch(sym >> 8) {
    case 0:
	if ((sym >= XK_A) && (sym <= XK_Z))
	    *lower += (XK_a - XK_A);
	else if ((sym >= XK_a) && (sym <= XK_z))
	    *upper -= (XK_a - XK_A);
	else if ((sym >= XK_Agrave) && (sym <= XK_Odiaeresis))
	    *lower += (XK_agrave - XK_Agrave);
	else if ((sym >= XK_agrave) && (sym <= XK_odiaeresis))
	    *upper -= (XK_agrave - XK_Agrave);
	else if ((sym >= XK_Ooblique) && (sym <= XK_Thorn))
	    *lower += (XK_oslash - XK_Ooblique);
	else if ((sym >= XK_oslash) && (sym <= XK_thorn))
	    *upper -= (XK_oslash - XK_Ooblique);
	break;
    default:
	/* XXX do all other sets */
	break;
    }
}

static KeySym
KeyCodetoKeySym(dpy, keycode, col)
    register Display *dpy;
    KeyCode keycode;
    int col;
{
    register int per = dpy->keysyms_per_keycode;
    register KeySym *syms;
    KeySym lsym, usym;

    if ((col < 0) || ((col >= per) && (col > 3)) ||
	(keycode < dpy->min_keycode) || (keycode > dpy->max_keycode))
      return NoSymbol;

    syms = &dpy->keysyms[(keycode - dpy->min_keycode) * per];
    if (col < 4) {
	if (col > 1) {
	    while ((per > 2) && (syms[per - 1] == NoSymbol))
		per--;
	    if (per < 3)
		col -= 2;
	}
	if ((per <= (col|1)) || (syms[col|1] == NoSymbol)) {
	    XConvertCase(dpy, syms[col&~1], &lsym, &usym);
	    if (!(col & 1))
		return lsym;
	    else if (usym == lsym)
		return NoSymbol;
	    else
		return usym;
	}
    }
    return syms[col];
}

/* This routine is the same as XKeysymToKeycode, except it also returns the
column in which the keysym was found.  It is extracted from the Tek Xlib; 
rename it on Tek workstations to avoid comflict. */

KeyCode XKeysymToKeycodeAndColumn(dpy, ks, column)
    Display *dpy;
    KeySym ks;
    int *column;
{
    register int i, j;

/*    if ((! dpy->keysyms) && (! Initialize(dpy)))
	return (KeyCode) 0;
      Really should do this!! But we can't without
	    putting this routine in Xlib. So get the effect with a null
	  call to XKeycodeToKeysym: */
    (void) XKeycodeToKeysym(dpy, (KeyCode)NoSymbol, -1);

    for (i = dpy->min_keycode; i <= dpy->max_keycode; i++) {
	for (j = 0; j < dpy->keysyms_per_keycode; j++) {
	    if (KeyCodetoKeySym(dpy, (KeyCode) i, j) == ks) {
		*column = j;
		return i;
	    }
	}
    }
    return 0;
}

static Atom	Kb_compose_table;
static Atom	Kb_compose_table_shorts;
static Bool	uninitialized = True;

InitKB(dpy)
    Display *dpy;
{
    /* Warning!!! This prototype works for only a single display! */
    /* Need to put atoms on the dpy struct */
    if (uninitialized) {
	Kb_compose_table = XInternAtom(dpy, "KB_COMPOSE_TABLE", False);
	Kb_compose_table_shorts = XInternAtom(dpy, "KB_COMPOSE_TABLE_SHORTS", 
					      False);
	uninitialized = False;
    }
}

/* 
 * XSetKBCompose sets the property
 *	KB_COMPOSE_TABLE 	type: KB_COMPOSE_TABLE
 */

XSetKBCompose(dpy, w, compose)
    Display *dpy;
    Window w;
    XKBCompose *compose;
{
    CARD8	*table = NULL;
    CARD16	*shorts_table = NULL;
    int		table_size, arraysize;
    int		i;

    if (uninitialized)
	InitKB(dpy);

    table_size = 50 + compose->num_composes * (compose->max_keycodes + 2) +
		 compose->num_cancel_keycodes + compose->num_abort_keycodes;
    /* max keycodes plus modifier and keycode per compose sequence, plus
       data[0], data[1-48], cancel keycode count, cancel and abort keycodes */
    /* Warning: we assume KeyCode=CARD8=8bits (probably a safe assumption) */
    table = (CARD8 *) malloc(table_size);
    arraysize = compose->num_composes * compose->max_keycodes;
    shorts_table = (CARD16 *) malloc(sizeof(CARD16) * (1 + arraysize));
    shorts_table[0] = compose->num_composes;
    bcopy(compose->modifiers, shorts_table + 1, sizeof(unsigned short) * 
	  arraysize);

    /* Warning -we assume unsigned short = CARD16 */

    table[0] = compose->max_keycodes;
    bcopy(compose->numeric_keycodes, table + 1, 48);
    bcopy(compose->sequences, table + 49, 
	  compose->num_composes * compose->max_keycodes);
    for (i = 0; i < compose->num_composes; i++)
	table[49 + arraysize + i] = compose->output_modifiers[i];
	/* convert from unsigned int to byte */
    bcopy(compose->output_keycodes, table + 49 + (compose->num_composes *
	  (compose->max_keycodes + 1)), compose->num_composes);
    table[49 + (compose->num_composes * (compose->max_keycodes + 2))] =
	compose->num_cancel_keycodes;
    bcopy(compose->cancel_keycodes, table + 50 + (compose->num_composes *
	  (compose->max_keycodes + 2)), compose->num_cancel_keycodes);
    bcopy(compose->abort_keycodes, table + 50 + (compose->num_composes *
	  (compose->max_keycodes + 2)) + compose->num_cancel_keycodes,
	  compose->num_abort_keycodes);
    /* Be sure shorts prop is changed first so server doesn't get incomplete
       data */
    XChangeProperty(dpy, w, Kb_compose_table_shorts, Kb_compose_table_shorts, 
		    16, 
		    PropModeReplace, shorts_table, 1 + arraysize);
    XChangeProperty(dpy, w, Kb_compose_table, Kb_compose_table, 8, 
		    PropModeReplace, table, table_size);
    free((char *)table);
    free((char *)shorts_table);
}

Status XGetKBCompose (dpy, w, compose)
	Display *dpy;
	Window w;
	XKBCompose *compose;
{
    CARD8	*table = NULL;
    CARD16	*shorts_table = NULL;
    unsigned long leftover;
    unsigned long table_size;
    unsigned long shorts_table_size;
    Atom	actual_type;
    int		actual_format;
    int		num_cancel_keycodes, num_abort_keycodes, i;

    if (uninitialized)
	InitKB(dpy);

    if (XGetWindowProperty(dpy, w, Kb_compose_table_shorts, 0L,
			   (long) dpy->max_request_size, False, 
			   Kb_compose_table_shorts, &actual_type, 
			   &actual_format, &shorts_table_size, &leftover,
			   (unsigned char **)&shorts_table)
	!= Success) return (0);
    if ((actual_type != Kb_compose_table_shorts) ||
        (actual_format != 16) || leftover) {
	if (leftover)
	    fprintf(stderr, "XGetKBCompose: Warning; prototype limit of max_request_size for compose shorts table exceeded\n");
	if (table != NULL) XFree ((char *)shorts_table);
	return(0);
    }

    if (XGetWindowProperty(dpy, w, Kb_compose_table, 0L,
		    (long) dpy->max_request_size,
		    False, Kb_compose_table, &actual_type, &actual_format,
		    &table_size, &leftover, (unsigned char **)&table)
	!= Success) return (0);
    if ((actual_type != Kb_compose_table) ||
        (actual_format != 8) || leftover) {
	if (leftover)
	    fprintf(stderr, "XGetKBCompose: Warning; prototype limit of max_request_size for compose table exceeded\n");
	if (table != NULL) XFree ((char *)table);
	return(0);
    }

    if (table_size < 50 + shorts_table[0] * (table[0] + 2)) {
        fprintf(stderr, "XGetKBCompose: Warning; compose table property is a bogus size: is %d, should be at least %d\n", table_size, 50 + shorts_table[0] * (table[0] + 2));
	XFree ((char *)table);
	XFree ((char *)shorts_table);
	return(0);
    }
    num_cancel_keycodes = table[49 + shorts_table[0] * (table[0] + 2)];
    num_abort_keycodes = table_size - (50 + shorts_table[0] * (table[0] + 2)
				       + num_cancel_keycodes);
    if (num_abort_keycodes < 0) {
        fprintf(stderr, "XGetKBCompose: Warning; compose table property is a bogus size: is %d, should be at least %d\n", table_size, 50 + shorts_table[0] * (table[0] + 2) + num_cancel_keycodes);
	XFree ((char *)table);
	XFree ((char *)shorts_table);
	return(0);
    }

    if (shorts_table_size != (shorts_table[0] * table[0]) + 1) {
        fprintf(stderr, "XGetKBCompose: Warning; shorts compose table property is a bogus size: is %d, should be %d\n", shorts_table_size, (shorts_table[0] * table[0]) + 1);
	XFree ((char *)table);
	XFree ((char *)shorts_table);
	return(0);
    }

    compose->num_composes = shorts_table[0];
    compose->max_keycodes = table[0];

    compose->modifiers = (unsigned short *) malloc(sizeof(unsigned short) *
			 compose->num_composes * compose->max_keycodes);
    bcopy(shorts_table + 1, compose->modifiers, sizeof(unsigned short) * 
	  compose->num_composes * compose->max_keycodes);
    bcopy(table + 1, compose->numeric_keycodes, 48);
    compose->sequences = (KeyCode *) malloc(
			 compose->num_composes * compose->max_keycodes);
    bcopy(table + 49, compose->sequences, 
	  compose->num_composes * compose->max_keycodes);
    /* Warning: we assume KeyCode=CARD8=8bits (probably a safe assumtion) */

    compose->output_modifiers = (unsigned int *) malloc(
				sizeof(unsigned int) * compose->num_composes);
    for (i = 0; i < compose->num_composes; i++) {
	compose->output_modifiers[i] =
	table[49 + (compose->num_composes * compose->max_keycodes) + i];
	/* convert from byte to unsigned int */
    }

    compose->output_keycodes = (KeyCode *) malloc(compose->num_composes);
    bcopy(table + 49 + (compose->num_composes * (compose->max_keycodes + 1)),
	  compose->output_keycodes, compose->num_composes);

    compose->num_cancel_keycodes = num_cancel_keycodes;
    if (num_cancel_keycodes > 0) {
	compose->cancel_keycodes = (KeyCode *) malloc(num_cancel_keycodes);
	bcopy(table + 50 + (compose->num_composes * (compose->max_keycodes + 2)),
	  compose->cancel_keycodes, num_cancel_keycodes);
    }
    else
	compose->cancel_keycodes = (KeyCode *) NULL;
    compose->num_abort_keycodes = num_abort_keycodes;
    if (num_abort_keycodes > 0) {
	compose->abort_keycodes = (KeyCode *) malloc(num_abort_keycodes);
	bcopy(table + 50 + (compose->num_composes * (compose->max_keycodes + 2) + num_cancel_keycodes),
	  compose->abort_keycodes, num_abort_keycodes);
    }
    else
	compose->abort_keycodes = (KeyCode *) NULL;
    XFree((char *)table);
    return(1);
}

XClearKBCompose (dpy)
	Display *dpy;
{
    int i, n_props;
    Atom *props;

    if (uninitialized)
	InitKB(dpy);
    props = XListProperties(dpy, DefaultRootWindow(dpy), &n_props);
    for (i = 0; i < n_props; i++) {
	if (props[i] == Kb_compose_table)
	    XDeleteProperty(dpy, DefaultRootWindow(dpy), Kb_compose_table);
	if (props[i] == Kb_compose_table_shorts)
	    XDeleteProperty(dpy, DefaultRootWindow(dpy), 
			    Kb_compose_table_shorts);
    }
}

XFreeKBCompose (compose, free_struct)
    XKBCompose *compose;
    Bool free_struct;
{
    free(compose->modifiers);
    free(compose->sequences);
    free(compose->output_modifiers);
    free(compose->output_keycodes);
    if (compose->cancel_keycodes)
	free(compose->cancel_keycodes);
    if (compose->abort_keycodes)
	free(compose->abort_keycodes);
    if (free_struct)
	free(compose);	    /* client must have malloc'ed struct */
    else
	compose->modifiers = (unsigned short *)NULL;
	compose->output_modifiers = (unsigned int *)NULL;
	compose->sequences =
	compose->output_keycodes = 
	compose->cancel_keycodes =
	compose->abort_keycodes = (KeyCode *)NULL;
}
