#ifndef LINT
#ifdef RCS_ID
static char *rcsid = "$Header: /nwd/tools/media/X11/XP/src/xmodmap/RCS/getlang.c,v 1.2 1990/07/09 11:50:58 glennw Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright 1989 by the Massachusetts Institute of Technology, 
 * Cambridge, Massachusetts, and Tektronix, Inc. Beaverton, Oregon.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Tektronix or M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Tektronix and M.I.T. make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * TEKTRONIX AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL TEKTRONIX OR M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Glenn Widener, Tektronix, Inc.
 *          P.O. Box 1000
 *          Wilsonville, OR, 97070
 *          glennw@orca.wv.tek.com
 *  Based on the r4 Hello World program by Glenn Widener, which was
 *  based on the r3 Hello World program by David Rosenthal.
 *
 *	NAME
 *		getlang.c: get the language for X clients
 *
 *	DESCRIPTION
 *		This program gets the value of a STRING property on the root 
 *		window of screen zero, and prints it to stdout.  The default
 *		is to print the language name from the server _TEK_LANGUAGE
 *		property.
 *
 *	OPTIONS
 *		-display	- the usual...
 *		-p[roperty]	- get the property named by the following 
 *				  argument.
 *
 *	ERRORS
 *		(sent to stderr)
 *		can't open display
 *		can't get the property
 *		invalid property
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

char *ProgramName;
Display	    *dpy;		/* X server connection */

void exit();

usage ()
{
    fprintf (stderr, 
	     "usage:  %s [-d[isplay] host:dpy] [-p[roperty] PROP_NAME]\n", ProgramName);
    exit (1);
}

main(argc,argv)
    int argc;
    char **argv;
{
    char	*displayname = NULL;
    int		i;
    Atom lang;
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long leftover;
    unsigned char *data = NULL;
    char *prop_name = "_TEK_LANGUAGE";

    /* parse arguments for basic X args */

    ProgramName = argv[0];
    for (i = 1; i < argc; i++) {
	char *arg = argv[i];

	if (arg[0] == '-') {
	    switch (arg[1]) {
	      case 'd':			/* -display host:dpy */
		if (++i >= argc) usage ();
		displayname = argv[i];
		continue;
	      case 'p':			/* -p[roperty] PROP_NAME */
		if (++i >= argc) usage ();
		prop_name = argv[i];
		continue;
	      default:
		usage ();
		/* doesn't return */
	    }
	} else 
	  usage ();
    }

    /*
     * Open the display using the $DISPLAY environment variable to locate
     * the X server.  See Section 2.1.
     */
    if ((dpy = XOpenDisplay(displayname)) == NULL) {
	fprintf(stderr, "%s: can't open display '%s'\n", argv[0], 
	        XDisplayName(displayname));
	exit(1);
    }

    lang = XInternAtom (dpy, prop_name, False);
    if (lang == None) {
	fprintf(stderr, "%s: can't intern \"%s\" atom\n", argv[0], 
		prop_name);
	exit(1);
    }

    if ((XGetWindowProperty(dpy, DefaultRootWindow(dpy), lang, 0L,
		  (long)BUFSIZ, False, XA_STRING, &actual_type, &actual_format,
		  &nitems, &leftover, &data) != Success) || 
	(actual_type == None)) {
	fprintf(stderr, "%s: can't get the \"%s\" property\n", argv[0], 
		prop_name);
	exit(1);
    }
    if ( (actual_type == XA_STRING) &&  (actual_format == 8) ) {

	/* The data returned by XGetWindowProperty is guarranteed to
	contain one extra byte that is null terminated to make retrieveing
	string properties easy. */
	printf("%s\n", (char *)data);
    }
    else
	fprintf(stderr, "%s: invalid \"%s\" property\n", argv[0], 
		prop_name);

    if (data) XFree ((char *)data);
    XCloseDisplay(dpy);
    exit(0);
}
