/* $Header: /nwd/tools/media/X11/XP/src/xmodmap/RCS/wq.h,v 1.5 1990/04/20 17:25:18 turner Exp $ */
/*
 * xmodmap - program for loading keymap definitions into server
 *
 * $XConsortium: wq.h,v 1.4 88/10/08 15:41:34 jim Exp $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Jim Fulton, MIT X Consortium
 */


/* 
 * Input is parsed and a work queue is built that is executed later.  This
 * allows us to swap keys as well as ensure that we don't mess up the keyboard
 * by doing a partial rebind.
 */

enum opcode { doKeycode, doAddModifier, doRemoveModifier, doClearModifier,
	      doPointer, doComposeSequence,
	      doRemoveComposeSequence, doClearComposeSequence,
	      doComposeNumeric, doRemoveComposeNumeric, doClearComposeNumeric,
	      doComposeCancel, doRemoveComposeCancel, doClearComposeCancel };

struct op_generic {
    enum opcode type;			/* oneof enum opcode */
    union op *next;			/* next element in list or NULL */
};


/*
 * keycode KEYCODE = KEYSYM
 * keysym OLDKEYSYM = NEWKEYSYM
 *
 * want to eval the OLDKEYSYM before executing the work list so that it isn't
 * effected by any assignments.
 */

struct op_keycode {
    enum opcode type;			/* doKeycode */
    union op *next;			/* next element in list or NULL */
    KeyCode target_keycode;		/* key to which we are assigning */
    int count;				/* number of new keysyms */
    KeySym *keysyms;			/* new values to insert */
};


/*
 * add MODIFIER = KEYSYM ...
 */

struct op_addmodifier {
    enum opcode type;			/* doAddModifier */
    union op *next;			/* next element in list or NULL */
    int modifier;			/* index into modifier list */
    int count;				/* number of keysyms */
    KeySym *keysyms;			/* new values to insert */
};


/*
 * remove MODIFIER = OLDKEYSYM ...
 *
 * want to eval the OLDKEYSYM before executing the work list so that it isn't
 * effected by any assignments.
 */

struct op_removemodifier {
    enum opcode type;			/* doRemoveModifier */
    union op *next;			/* next element in list or NULL */
    int modifier;			/* index into modifier list */
    int count;				/* number of keysyms */
    KeyCode *keycodes;			/* old values to remove */
};


/*
 * clear MODIFIER
 */

struct op_clearmodifier {
    enum opcode type;			/* doClearModifier */
    union op *next;			/* next element in list or NULL */
    int modifier;			/* index into modifier list */
};

/*
 * pointer = NUMBER ...
 *
 * set pointer map to the positive numbers given on the right hand side
 */

#define MAXBUTTONCODES 256		/* there are eight bits of buttons */

struct op_pointer {
    enum opcode type;			/* doPointer */
    union op *next;			/* next element in list or NULL */
    int count;				/* number of new button codes */
    unsigned char button_codes[MAXBUTTONCODES];
};

struct op_compose_sequence {
    enum opcode type;			/* doComposeSequence */
    union op *next;			/* next element in list or NULL */
    int count;				/* number of keycodes in sequence */
    KeyCode *keycodes;			/* keycodes in sequence */
    unsigned short *modifiers;		/* modifiers for keycodes */
    unsigned short output_modmask;	/* sequence output modifiers */
    KeyCode output_keycode;		/* sequence output keycode */
};

struct op_remove_compose_sequence {
    enum opcode type;			/* doRemoveComposeSequence */
    union op *next;			/* next element in list or NULL */
    int count;				/* number of keycodes in sequence */
    KeyCode *keycodes;			/* keycodes in sequence */
    unsigned short *modifiers;		/* modifiers for keycodes */
};

struct op_compose_numeric {
    enum opcode type;			/* doComposeNumeric */
    union op *next;			/* next element in list or NULL */
    int hexdigit;			/* 0-9, A-F = 0-15 */
    KeyCode keycode;			/* controlling keycodes */
};

struct op_remove_compose_numeric {
    enum opcode type;			/* doRemoveComposeNumeric */
    union op *next;			/* next element in list or NULL */
    int hexdigit;			/* 0-9, A-F = 0-15 */
    KeyCode keycode;			/* keycode to disable */
};

struct op_compose_cancel {
    enum opcode type;			/* doComposeCancel */
    union op *next;			/* next element in list or NULL */
    KeyCode keycode;			/* cancel keycode to add */
};

struct op_remove_compose_cancel {
    enum opcode type;			/* doRemoveComposeCancel */
    union op *next;			/* next element in list or NULL */
    KeyCode keycode;			/* cancel keycode to remove */
};

struct op_clear_compose {
    enum opcode type;			/* doClearComposeSequence, 
			    doClearComposeNumeric, or doClearComposeCancel */
    union op *next;			/* next element in list or NULL */
};


/*
 * all together now
 */
union op {
    struct op_generic generic;
    struct op_keycode keycode;
    struct op_addmodifier addmodifier;
    struct op_removemodifier removemodifier;
    struct op_clearmodifier clearmodifier;
    struct op_pointer pointer;
    struct op_compose_sequence compose_sequence;
    struct op_remove_compose_sequence remove_compose_sequence;
    struct op_compose_numeric compose_numeric;
    struct op_remove_compose_numeric remove_compose_numeric;
    struct op_compose_cancel compose_cancel;
    struct op_remove_compose_cancel remove_compose_cancel;
    struct op_clear_compose clear_compose;
};

extern struct wq {
    union op *head;
    union op *tail;
} work_queue;


extern struct modtab {
    char *name;
    int length;
    int value;
} modifier_table[];

#define AllocStruct(s) ((s *) malloc (sizeof (s)))

#define MAXKEYSYMNAMESIZE 80		/* absurdly large */
