#ifndef LINT
#ifdef RCS_ID
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/xmodmap/RCS/xmodmap.c,v 1.11 1991/12/05 01:06:22 paulsh Exp $";
#endif /* RCS_ID */
#endif /* LINT   */
/*
 * xmodmap - program for loading keymap definitions into server
 *
 * $XConsortium: xmodmap.c,v 1.18 89/12/10 19:48:08 jim Exp $
 *
 * Copyright 1988, 1989 by Tektronix, Inc. Beaverton, Oregon,
 * and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Tektronix or M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Tektronix and M.I.T. make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * TEKTRONIX AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL TEKTRONIX OR M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Jim Fulton, MIT X Consortium
 * compose 
 * support: Glenn Widener, Tektronix, Inc.
 *          P.O. Box 1000
 *          Wilsonville, OR, 97070
 *          glennw@orca.wv.tek.com
 */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <ctype.h>
#include "xmodmap.h"

char *ProgramName;
Display *dpy = NULL;
int min_keycode, max_keycode;
Bool verbose = False;
Bool fast = False;
Bool dontExecute = False;
Bool noCompose = False;
Bool noBindings = False;
Bool resetCompose = False;
Bool compose_initialized = False;
int errors = 0;

extern void initialize_compose();
extern int new_seq_count;
extern Bool have_compose_chg;

void Exit (status)
    int status;
{
    if (dpy) {
	/* Hack!  VMS Xlib fails to XSync across TCP/IP, so we force an XSync
	   here. */
	XSync(dpy, False);
	XCloseDisplay (dpy);
	dpy = NULL;
    }
    /* I also thought I saw some funnies printing error messages on VMS, so
       I'll flush these too... */
    fflush(stderr);
    fflush(stdout);
    exit (status);
}


static char *help_message[] = {
"\nwhere options include:",
"    -display host:dpy            X server to use",
"    -b bindingfile               binding file for multilingual keyboards",
"    -nb                          delete multilingual keyboard bindings",
"    -fast                        minimize sanity checks, run faster",
"    -verbose, -quiet             turn logging on or off",
"    -n                           don't execute changes, just show like make",
"    -e expression                execute string",
"    -pm                          print modifier map",
"    -pk                          print keymap table",
"    -pp                          print pointer map",
"    -grammar                     print out short help on allowable input",
"    -noc[ompose]                 delete existing compose properties",
"    -resetc[ompose]              reset compose properties to default",
"    -                            read standard input",
"",
NULL};


void usage ()
{
    char **cpp;

    fprintf (stderr, "usage:  %s [-options ...] [filename ...] ...\n", ProgramName);
    for (cpp = help_message; *cpp; cpp++) {
	fprintf (stderr, "%s\n", *cpp);
    }
    Exit (1);
}

static char *grammar_message[] = {
"pointer = default                  reset pointer buttons to default",
"pointer = NUMBERLIST               set pointer button codes",
"keycode KEYCODE = [KEYSYM...]      assign keysyms to the given keycode",
"keysym KEYSYM = [KEYSYM...]        look up keysym and do a keycode line",
"clear MODIFIER                     remove all keys for this modifier",
"add MODIFIER = KEYSYMLIST          add the keysyms to the modifier",
"remove MODIFIER = KEYSYMLIST       remove the keysyms from the modifier",
"compose ANYORALLMODNAMES KEYCODELIST = ANYMODNAMES KEYCODE",
"compose ANYORALLMODNAMES keysyms KEYSYMLIST = ANYMODNAMES KEYCODE",
"compose ANYORALLMODNAMES KEYCODELIST = ANYMODNAMES keysym KEYSYM",
"compose ANYORALLMODNAMES keysyms KEYSYMLIST = ANYMODNAMES keysym KEYSYM",
"                                   add a mnemonic compose sequence",
"compose ANYORALLMODNAMES KEYCODE NUMERIC",
"compose ANYORALLMODNAMES keysym KEYSYM NUMERIC",
"                                   add a numeric compose sequence",
"compose numeric HEXDIGIT = KEYCODE",
"compose numeric HEXDIGIT = keysym KEYSYM",
"                                   add a numeric compose number key",
"compose cancel KEYCODE             add a compose sequence cancel keycode",
"remove compose ANYORALLMODNAMES KEYCODELIST",
"remove compose ANYORALLMODNAMES keysyms KEYSYMLIST",
"remove compose ANYORALLMODNAMES KEYCODE NUMERIC",
"remove compose ANYORALLMODNAMES keysym KEYSYM NUMERIC",
"                                   remove a compose sequence",
"remove compose numeric HEXDIGIT = KEYCODE",
"remove compose numeric HEXDIGIT = keysym KEYSYM",
"                                   remove a numeric compose number key",
"remove compose cancel KEYCODE      remove a compose sequence cancel keycode",
"clear compose sequences            remove all compose sequences",
"clear compose numeric              remove all numeric compose number keys",
"clear compose cancel               remove all compose sequence cancel keycodes",
"execute                            execute all expressions so far",
"",
"where:",
"  NUMBERLIST is a list of decimal, octal, or hex constants,",
"  KEYCODE is a decimal, octal, or hex constant, range 8-255,",
"  KEYSYM is a valid Key Symbol name,",
"  MODIFIER is one of the eight modifier names:  Shift, Lock, Control,", 
"    Mod1, Mod2, Mod3, Mod4, or Mod5,",
"  KEYCODELIST is a list of KEYCODEs,", 
"  KEYSYMLIST is a list of KEYSYMs,", 
"  ANYMODNAMES is a list of MODIFIERs, or \"none\",", 
"  ANYORALLMODNAMES is a list of MODIFIERS or AnyModifier,", 
"  NUMERIC is one of \"binary\", \"octal\", \"decimal\", or \"hex\",", 
"  HEXDIGIT is one of 0-9 or a-f.", 
"",
"Lines beginning with an exclamation mark (!) are taken as comments.",
"Case is significant except for MODIFIER names and HEXDIGITs.",
"",
"Keysyms on the left hand side of the = sign are looked up before any changes",
"are made; keysyms on the right (except for compose expressions are looked up",
"after all of those on the left have been resolved.  This makes it possible",
"to swap modifier keys.",
"",
NULL };


void grammar_usage ()
{
    char **cpp;

    fprintf (stderr, "%s accepts the following input expressions:\n\n",
	     ProgramName);
    for (cpp = grammar_message; *cpp; cpp++) {
	fprintf (stderr, "%s\n", *cpp);
    }
    Exit (0);
}

main (argc, argv)
    int argc;
    char **argv;
{
    int i;
    char *displayname = NULL;
    int status;
    Bool printMap = False;
    Bool printKeyTable = False;
    Bool printPointerMap = False;
    Bool didAnything = False;

    ProgramName = argv[0];

    /*
     * scan the arg list once to find out which display to use
     */

    for (i = 1; i < argc; i++) {
	if (strncmp (argv[i], "-d", 2) == 0) {
	    if (++i >= argc) usage ();
	    displayname = argv[i];
	}
    }

    dpy = XOpenDisplay (displayname);
    if (!dpy) {
	fprintf (stderr, "%s:  unable to open display '%s'\n",
		 ProgramName, XDisplayName (displayname));
	Exit (1);
    }

    XDisplayKeycodes (dpy, &min_keycode, &max_keycode);

    initialize_map ();

    /*
     * scan the arg list again to do the actual work (since it requires
     * the display being open.)
     */

    status = 0;
    for (i = 1; i < argc; i++) {
	char *arg = argv[i];

	if (arg[0] == '-') {
	    switch (arg[1]) {
	      case 'd':			/* -display host:dpy */
		++i;			/* handled above */
		continue;
	      case 'b':			/* -b <binding file> */
		if (process_binding_file (argv[++i]) != 0) errors++;
		continue;
	      case 'f':			/* -fast */
		fast = True;
		continue;
	      case 'v':			/* -verbose */
		verbose = True;
		continue;
	      case 'q':			/* -quiet */
		verbose = False;
		continue;
	      case 'r':			/* -resetc[ompose] */
		if (!strcmp(&arg[2], "esetc") || !strcmp(&arg[2], "esetcompose")) {
		    if (compose_initialized)
			fprintf(stderr, 
"Warning: cannot reset compose after a compose expressions is executed;\n\
-resetcompose ignored.\n");
		    else
			resetCompose = True;
		    continue;
		}
	      case 'n':			/* -n (like make) */
		if (!strcmp(&arg[2], "oc") || !strcmp(&arg[2], "ocompose")) {
		    noCompose = True;
		    continue;
		}
		if (!strcmp(&arg[2], "ob") || !strcmp(&arg[2], "obindings")) {
		    noBindings = True;
		    continue;
		}
		dontExecute = True;
		continue;
	      case 'e':			/* -e expression */
		didAnything = True;
		if (++i >= argc) usage ();
		if (process_line (argv[i]) != 0) errors++;
		continue;
	      case 'p':			/* -p... */
		switch (arg[2]) {
	        /*case '\0':  Some folks don't like -p == -pm */
		  case 'm':		/* -pm */
		    printMap = True;
		    break;
		  case 'k':		/* -pk */
		    printKeyTable = True;
		    break;
		  case 'p':		/* -pp */
		    printPointerMap = True;
		    break;
		  default:
		    usage ();
		    /* NOTREACHED */
		}
		didAnything = True;
		continue;
	      case 'g':			/* -grammar */
		grammar_usage ();
		/*NOTREACHED*/
	      case '\0':		/* - (use standard input) */
		didAnything = True;
		if (process_file (NULL) != 0) errors++;
		continue;

	      /*
	       * provide old xmodmap args
	       */
	      case 'S':
		didAnything = True;
		if (process_line ("clear shift") != 0) errors++;
		continue;
	      case 'L':
		didAnything = True;
		if (process_line ("clear lock") != 0) errors++;
		continue;
	      case 'C':
		didAnything = True;
		if (process_line ("clear control") != 0) errors++;
		continue;
	      case '1':
	      case '2':
	      case '3':
	      case '4':
	      case '5': {
		  char *cmd = "clear modX";
		  cmd[9] = arg[1];
		  if (process_line (cmd) != 0) errors++;
		  continue;
	      }
	      case 's':
	      case 'l':
	      case 'c': {
		  char cmd[80];		/* big enough to hold line */
		  didAnything = True;
		  if (++i >= argc) usage ();
		  (void) sprintf (cmd, "remove %s = %s",
				  ((arg[1] == 's') ? "shift" :
				   ((arg[1] == 'l') ? "lock" :
				    "control")), argv[i]);
		  if (process_line (cmd) != 0) errors++;
		  continue;
	      }
	      default:
		usage ();
		/*NOTREACHED*/
	    }
	} else if (arg[0] == '+') {	/* old xmodmap args */
	    switch (arg[1]) {
	      case '1':
	      case '2':
	      case '3':
	      case '4':
	      case '5': {
		  char cmd[80];		/* big enough to hold line */
		  didAnything = True;
		  if (++i >= argc) usage ();

		  (void) sprintf (cmd, "add mod%c = %s", arg[1], argv[i]);
		  if (process_line (cmd) != 0) errors++;
		  continue;
	      }
	      case 'S':
	      case 'L':
	      case 'C':
		arg[1] = tolower (arg[1]);
		/* fall through to handler below */
	      case 's':
	      case 'l':
	      case 'c': {
		  char cmd[80];		/* big enough to hold line */
		  didAnything = True;
		  if (++i >= argc) usage ();
		  (void) sprintf (cmd, "add %s = %s",
				  ((arg[1] == 's') ? "shift" :
				   ((arg[1] == 'l') ? "lock" :
				    "control")), argv[i]);
		  if (process_line (cmd) != 0) errors++;
		  continue;
	      }
	      default:
		usage ();
	    }
	} else {
	    didAnything = True;
	    if (process_file (arg) != 0) errors++;
	    continue;
	}
    }					/* end for loop */

    /* for compatibility */
    if (!didAnything) printMap = True;

    /*
     * at this point, the work list has been built and we can view it or
     * execute it
     */

    if (dontExecute) {
	print_work_queue ();
	Exit (0);
    }

    if (errors != 0) {
	fprintf (stderr, "%s:  %d errors encountered, aborting.\n",
		 ProgramName, errors);
    } else {
	initialize_compose();
	status = execute_work_queue ();
	if (resetCompose || (have_compose_chg == True))
	    UpdateComposeProperty();
    }

    if (printMap) {
	print_modifier_map ();
    }

    if (printKeyTable) {
	print_key_table ();
    }

    if (printPointerMap) {
	print_pointer_map ();
    }

    Exit (status < 0 ? 1 : 0);
}

