/*
 * (c) Copyright 1991, 1992 Tektronix, Inc.
 *     All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Tektronix not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Tektronix disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness, in no event shall
 * Tektronix be liable for any special, indirect or consequential damages or
 * any damages whatsoever resulting from loss of use, data or profits,
 * whether in an action of contract, negligence or other tortious action,
 * arising out of or in connection with the use or performance of this
 * software.
 *
 *    (tbl xpsh.man | nroff -man | col > xpsh.txt   included below)    
 *    
 *    NAME
 *         xpsh - execute a command on a TekXpress X terminal
 *    
 *    SYNOPSIS
 *         xpsh [-display dpyname:d.s] [-access method]
 *              [-xpenv "name=value [name=value]"] command [arg...]
 *    
 *         NOTE for VMS only: "dpyname:d.s" should be "dpyname::d.s"
 *         or "wsann" where wsann is the DECW$DISPLAY device
 *    
 *    DESCRIPTION
 *         Xpsh connects to the specified display, and  there  executes
 *         the specified command.
 *    
 *         Interrupt, quit, and terminate signals are propagated to the
 *         TekXpress command.
 *    
 *         Xpsh normally terminates when  the  TekXpress  command  ter-
 *         minates.
 *    
 *         The standard error and standard output of the TekXpress com-
 *         mand  is  not  redirected, but appears on the TekXpress con-
 *         sole.
 *    
 *         If -access method is given, the access method used to obtain
 *         user  files  is set.  Currently supported values are "tftp",
 *         "nfs", "nfs/tftp", "dap", and "sxp".  If the option  is  not
 *         given,  the access is selected by using the display communi-
 *         cation protocol defined by the displayname as follows:
 *              DECnet protocol: dap
 *              non-DECnet protocols: nfs/tftp
 *         nfs/tftp access means that the client will attempt to access
 *         the  file  'filename'  by the nfs path /<hostname>/filename,
 *         where <hostname> is, by default, the name  of  the  host  on
 *         which  you  invoke xpsh.  Note that <hostname> can be null -
 *         see TEKXP_HOST below.  If the file cannot be opened via nfs,
 *         the  client will attempt to access the file by the TFTP path
 *         <hostname>:/filename.
 *    
 *         For nfs access or the nfs part of nfs/tftp access  to  work,
 *         the  remote  host filesystem(s) must be mounted.  Use of nfs
 *         or nfs/tftp access is highly recommended if  the  host  sup-
 *         ports NFS.
 *    
 *         If -xpenv is given, the specified environment variables  are
 *         passed  on to the remote command.  The following environment
 *         variables have special meaning for the remote command:
 *    
 *         TEKXP_ACCESS=access_method
 *    
 *         The access_method value is  the  same  as  for  the  -access
 *         switch: "tftp", "nfs", "nfs/tftp", "dap", and "sxp".
 *    
 *         TEKXP_HOST=hostname
 *    
 *         This is the name of the host that will be used to read files
 *         when  access  is  via  NFS.  You must make sure to have this
 *         host mounted to the XP terminal as /<hostname> prior to run-
 *         ning  xpsh  if  you wish to use NFS access.  The XP terminal
 *         will form file paths something like this:
 *              /<hostname>/u1/joe/.Xdefaults
 *              /<hostname>/usr/lib/X11/app-defaults/...
 *         The value of hostname can  be  null  (TEKXP_HOST=  ).   This
 *         allows  you  to  access files by directly mounting your home
 *         and system directories resulting in file paths like this:
 *              /u1/joe/.Xdefaults
 *              /usr/lib/X11/app-defaults/...
 *         By default, TEKXP_HOST is set to the name of the host  which
 *         is executing xpsh. See Caveats below.
 *    
 *         TEKXP_HOST_ADDERSS=address
 *    
 *         This variable specifies what host to use to read files  when
 *         the  access  is  via  TFTP  or  DAP.   If  not specified, it
 *         defaults to the value of TEKXP_HOST.  You may specify a host
 *         name, an internet address, or a DECnet address.  By default,
 *         TEKXP_HOST_ADDERSS is set to the name of the host  which  is
 *         executing xpsh.  See Caveats below.
 *    
 *         TEKXP_HOST_TYPE=type
 *    
 *         This variable specifies whether the host on  which  xpsh  is
 *         running   is   either   "unix"   or   "vms".    For  example
 *         "TEKXP_HOST_TYPE=unix".     The    default     value     for
 *         TEKXP_HOST_TYPE  is  the type of the host which is executing
 *         xpsh.  This variable is used by the remote command to deter-
 *         mine  whether to use standard VMS versus standard UNIX paths
 *         and filenames when reading files.
 *    
 *         TEKXP_DECW_USER_DEFAULTS=dir,dir,dir
 *    
 *         This  variable  defines  a  list   of   directories   (comma
 *         separated, no spaces) which are used when the remote command
 *         wishes to read files from DECW$USER_DEFAULTS on a  VMS  sys-
 *         tem.   The  default  value  is  set  to the the value of the
 *         DECW$USER_DEFAULTS logical of the user  which  is  executing
 *         xpsh.
 *    
 *         The users current environment is also passed to  the  remote
 *         command (for example HOME).
 *    
 *    EXAMPLES
 *         Example execution of a remote command  on  the  TekXpress  X
 *         Terminal  "Xpress1" when the DISPLAY environment variable is
 *         not set.
 *    
 *         xpsh -display Xpress1:0.0 mwm &
 *    
 *         Example execution of a remote command when you  are  sitting
 *         at  the  remote X terminal and the DISPLAY environment vari-
 *         able is set.
 *    
 *         xpsh mwm &
 *    
 *         Example using tftp for the home directory access:
 *    
 *         xpsh -access tftp mwm &
 *    
 *         Example execution of a remote command with additional  argu-
 *         ments:
 *    
 *         xpsh mwm -xrm resourcestring &
 *    
 *         Example of setting XP environment variables.
 *    
 *         xpsh -xpenv "TEKXP_HOST=bluejay TEKXP_HOST_TYPE=unix" mwm &
 *    
 *    DIAGNOSTICS
 *         Xpsh diagnostics are printed to standard output.  Also check
 *         the  TekXpress X Terminal console for diagnostics printed by
 *         the TekXpress command.
 *    
 *    CAVEATS
 *         The host name of the host executing xpsh (or the host speci-
 *         fied  in  TEKXP_HOST and TEKXP_HOST_ADDRESS) must be present
 *         in the TekXpress Internet Host table  (for  access  tftp  or
 *         nfs)  or  TDEnet  Host  table (access dap).  This allows the
 *         terminal to determine the address of the host.  This may not
 *         be  necessary for Internet  addresses if Domain Name Service
 *         is enabled in the terminal.  If nfs access is  to  be  used,
 *         all  necessary file systems must be mounted by the TekXpress
 *         terminal prior to using xpsh.
 *    
 *    
 */

/*
 *	INTERNAL INCLUDES
 */
#ifdef VMS
#include <unixlib.h>
#include <nam.h>
#include <clidef.h>
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>
#define ERROR_EXIT	(STS$M_CUST_DEF | STS$M_INHIB_MSG | STS$K_ERROR)
#define NORMAL_EXIT SS$_NORMAL
#else
#define ERROR_EXIT 1
#define NORMAL_EXIT 0
#endif /* VMS */

#include <stdio.h>
/* Xos.h needed for: string.h, sys/types.h, sys/time.h */
#include <X11/Xos.h>
#include <signal.h>
#include <string.h>
#ifdef VMS
#define sigmask(xx) (1<<((xx)-1))
#endif /* VMS */
#include <netdb.h>
#include <errno.h>
#if defined(STDHDRS) || (__STDC__ && !defined(NOSTDHDRS))
#include <limits.h>
#else
#ifdef VMS
#else
#include <sys/param.h>
#endif
#endif
#ifdef VMS
#else
#include <sys/wait.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef VMS
#include <Xp/Xp.h>
#else
#include <X11/Xp/Xp.h>
#endif /* VMS */
#ifdef DEBUG
#ifdef VMS
#include <Xu/XuDefineTbl.h>
#else
#include <X11/Xu/XuDefineTbl.h>
#endif /* VMS */

#define PRINT_PATH_ARGV_ENVP XpPrintPathArgvEnvp
#else
#define PRINT_PATH_ARGV_ENVP
#endif

#ifdef X11R5

#ifdef TEKXP
#include <tekxp_lang.h>
#else
#include <X11/tekxp_lang.h>
#endif

#else

#include <tekxp_lang.h>

#endif /* X11R5 */

/*
 *	INTERNALS
 */
#ifndef LINT
#ifdef RCS_ID
static char *copy_notice = "Copyright 1988 Tektronix, Inc.";
static char *rcsid=  "$Header: /nwd/tools/media/X11/XP/src/xpsh/RCS/xpsh.c,v 1.51 1993/06/17 23:10:00 michaelh Exp $";
#endif RCS_ID
#endif LINT

#ifdef VMS
#define MAXPATHLEN NAM$C_MAXRSSLCL
#endif /* VMS */

#if defined(STDHDRS) || (__STDC__ && !defined(NOSTDHDRS))
#define _XPSH_PATH_MAX	_POSIX_PATH_MAX
#else
#define _XPSH_PATH_MAX	MAXPATHLEN                          
#endif                                                

/*
 * If the server has reset, xpshd will sleep for RESTART_WAIT seconds
 * before attempting to reconnect to the server.
 * So xpsh needs to continue waiting for the TEKXP_XPSHD_WID at least
 * RESTART_WAIT seconds.  We wait a little longer just in case.
 * Example, if RESTART_WAIT is 10 seconds, the values below show that
 * we will retry every 2 seconds for a total of 2x5 + 2x4 = 18 seconds.
 */
#define RETRY_REPS      5
#define RETRY_COUNT_MAX (RETRY_REPS + 4)
#ifndef TEKXP
#define RETRY_SLEEP     (10 / RETRY_REPS)
#else
#define RETRY_SLEEP     (RESTART_WAIT / RETRY_REPS)
#endif

#ifdef VMS
struct {
	long f_link;
	int *handlerAddress;
	int argumentCount;
	int *condValue;
	int extra;
} exitHandlerBlock;
int exitStatus;
static $DESCRIPTOR (nullDev, "NLA0:");        /* null device */
struct {
	int subprocessCompletion;    /* asynchronous subprocess completion */
	unsigned long subprocessId;	 /* the last child spawned */
	unsigned char notifyFlag;    /* event flag when child completes */
} allMyChildren;	/* initially only 1 child */
#endif /* VMS */


#ifdef VMS
extern char *getVmsEnv();
static char envvarString[MAXPATHLEN];
#define getenv(var)  getVmsEnv(var, envvarString)
#else
extern char *getenv();
#endif /* VMS */

extern int errno;
Display *dpy;
int xpshSignal = 0;

void
usage(argc,argv)
int argc;
char **argv;
{
    argc;	/* noop for lint, may use argc later */
    fprintf(stderr,
#ifdef VMS
                   "%s : usage : %s [-display \"name::0.0\"] [-console] "
#else
                   "%s : usage : %s [-display \"name:0.0\"] [-console] "
#endif /* VMS */
                   ,argv[0],argv[0]);
    fprintf(stderr,"\n                    [-access \"tftp\"|\"nfs\"|\"nfs/tftp\"|\"dap\"|\"sxp\"] ");
    fprintf(stderr,"\n                    [-xpenv \"name=value [name=value]\"] ");
    fprintf(stderr,"command [arg...]\n");
    exit(ERROR_EXIT);
}

#ifdef DEBUG
char*  nullptr =  NULL;

char *envptr_debug[] = {
    "PATH=/bin:/usr/bin:/usr/paulsh/bin",
    "SHELL=/bin/sh",
    "HOME=/usr/paulsh",
    "DISPLAY=denali:0.0",
    (char *) NULL
};
#endif


#ifdef VMS
/********************************************************************
 * NAME
 *   rearmSignal()
 *
 * DESCRIPTION:
 *   this routine required to so re-arming signals after caught in VMS
 *
 * inputs:
 *   ia1 - signal number
 *
 * outputs:
 *
 * bi-directional:
 *
 * restrictions:
 *
 * calling sequence:
 *   int signalNo;
 *   void rearmSignal();
 *   (void) rearmSignal(signalNo);
 *
 * author: MMA nwd
 *
 * modifications:
 *
 * TESTING: (this field is optional)
 *	planned method
 *
 ********************************************************************/
/* parameter declarations: */
void
rearmSignal(ia1)
int ia1;
{
/*
 * local declarations: */

/*
 * description of local variables:
 *
 * global variables used or set:
 *
 * routines called:*/
	int sendsig();
/*
 *   
 * executable code
*/
	signal(ia1,sendsig);
}
#endif /* VMS */

sendsig(signo)
int signo;
{
    /*
     * Record signal to be handled in main loop.
     * DO NOT make any X calls from within a signal handler.
     */
#ifdef VMS
	(void) rearmSignal (signo);
#endif /* VMS */
    xpshSignal = signo;
#ifdef	DEBUG
    x_debug1(("\nreceived sig %d\n",signo));
#endif
}
#ifdef VMS
/********************************************************************
 * NAME
 *  errorHandler()
 *
 * DESCRIPTION:
 *  handle X errors
 *
 * inputs:
 *
 * outputs:
 *
 * bi-directional:
 *
 * restrictions:
 *
 * calling sequence:
 *
 * author:
 *
 * modifications:
 *
 * TESTING: (this field is optional)
 *	planned method
 *
 ********************************************************************/
/* parameter declarations: */
int
errorHandler(xa1,xa2)
Display *xa1;
XErrorEvent *xa2;
{
/*
 * local declarations: */
	char text[80];
/*
 * description of local variables:
 *
 * global variables used or set:
 *
 * routines called:*/
/*                 
 *
 * executable code
*/

/* sample error handler */
	XGetErrorText (xa1, xa2->error_code, text, 80);
	fprintf (stderr, "Error code while in Xlib: %s\n", text);
	return (ERROR_EXIT);
}

/********************************************************************
 * NAME
 *  ioErrorHandler()
 *
 * DESCRIPTION:
 *  handle X I/O errors
 *
 * inputs:
 *
 * outputs:
 *                                                 
 * bi-directional:
 *
 * restrictions:
 *
 * calling sequence:
 *
 * author:
 *
 * modifications:
 *
 * TESTING: (this field is optional)
 *	planned method
 *
 ********************************************************************/
/* parameter declarations: */
int
ioErrorHandler( xa1)
Display *xa1;
{
/*
 * local declarations: */

/*
 * description of local variables:
 *
 * global variables used or set:
 *                        
 * routines called:*/
/*
 *
 * executable code
*/

	fprintf(stderr, "Fatal I/O error while in Xlib\n");
	fprintf(stderr, "Probable loss of connection or unable to connect to display.\n");
	exit (ERROR_EXIT);
}

/********************************************************************
 * NAME
 *  imageExitHandler()
 *
 * DESCRIPTION:
 *  this functions as an exit handler for the xpsh image
 *
 * inputs:
 *
 * outputs:
 *
 * bi-directional:
 *
 * restrictions:
 *
 * calling sequence:
 *
 * author:
 *
 * modifications:
 *
 * TESTING: (this field is optional)
 *	planned method
 *
 ********************************************************************/
/* parameter declarations: */
int
imageExitHandler()
{
/*
 * local declarations: */

/*
 * description of local variables:
 *
 * global variables used or set:
 *
 * routines called:*/
/*
 *
 * executable code
*/

}    


int
sigbusCaught(sig,code,scp)
int   sig;
int   code;
struct sigcontext *scp;
{
	if (sig == SIGBUS) {
		fprintf(stderr, "ACCVIO possible connection to node lost while in Xlib\n");
		exit (ERROR_EXIT);
	}
}

#endif /* VMS */

Window
get_xpsh_wid(dpy,root)
Display *dpy;
Window root;
{
    int count = 0;
    int len = 0;
    unsigned long *intarray;	/* integer property data , size 32 */
    Window Wid;		/* xpshd window used to send xpshWid to */

    while (len == 0)
    {
	count++;               
	XpGetPropertyInt(dpy,root,XA_TEK_XPSHD_WID,&intarray,&len);
	if(len==1){
	    Wid = (Window) intarray[0];
	    XFree((char *)intarray);
	    break;
	} else {                              
	    sleep(RETRY_SLEEP);
	    if (count < RETRY_COUNT_MAX)
	    {
		continue;
	    }
	    XpFatalError("\
No Xpshd window id property on the root window.\n\
Check to see that xpshd is running.\n\
For v6.1 servers, use the remote config. command \"start XPSHD YES\".\n\
For earlier servers, use the remote config. command \"run_xpshd YES\".");
	}
    }
    return Wid;
}

main(argc,argv,envp)
int argc;
char **argv;
char **envp;
{

    XEvent e;
    XPropertyEvent *eprop;
    XClientMessageEvent *eclient;
    char *hostpath, **hostenvp, **hostargv;
    char *rssdisplaynum = (char *) NULL;
    Window xpshWid;		/* window used for this xpsh session */
    Window xpshdWid;		/* xpshd window used to send xpshWid to */
    unsigned long len = 0;	/* length of integer property data */
    Window root;
    char *dpyname = NULL;
    unsigned int options = 0;
    char *accessname = NULL;
    char *tekxp_access_original;
	int access_int;
    int nohome = False;
#ifndef TEKXP
    char hostnamebuf[_XPSH_PATH_MAX];
#endif /* TEKXP */
    int argcsav = argc;
    char **argvsav = argv;
    char buf_number[24];	/* large enough for an int converted to asci */
    int exitstatus;		/* exit status received from client message */
#ifdef SYSV
    sigset_t set, oset;		/* new and old set of blocked signals */
#else
    int omask;			/* old mask of blocked signals */
#endif /* SYSV */
#ifndef VMS
    fd_set readfds;		/* file descriptors to select on */
#endif /* !VMS */
#ifdef VMS
	char vmsDisplay[MAXPATHLEN];	/* display:[:]0 */
	char *dpynameEnv;    /* display node */
#endif /* VMS */
    
#ifdef DEBUG
    /* 
     * Warning, any setting of environ MUST occur BEFORE call to XpPutEnv.
     * Also, the DISPLAY set in this debug environment will override the
     * one in the original environment.  So swaping the environ variable
     * also affects calls to XOpenDisplay done after this.
     */
    environ = envptr_debug;
    PRINT_PATH_ARGV_ENVP("",argv,environ);
#endif

    /*
     * Remove the xpsh options from the argument list.
     * These options have to precede the remote cmd and args.
     *
     * -display dpyname
     * -console
     * -access "tftp" | "nfs" | "nfs/tftp" | "dap" | "sxp"
     * -xpenv "name=value name=value name=value"
     * -nohome (obsolete, but kept for backward compatibility)
     * -n 	(may be used later, see rsh )
     * -d	(debug, may be used later)
     *
     * XXX If many options are added.  Create a table and a loop to parse them.
     */

     /*
      * Initial assumptions.
      * Original argc >= 1
      * Original argv[0] is the xpsh command name.
      */
    
another:
    argv++; argc--;		/* initially skip argv[0] */
    if (argc > 0) {
	if (!strcmp(*argv, "-display")) {
	    if (argc > 1) {
			dpyname = *++argv; argc--;
#ifdef VMS
			/* get the real name, if wsa device */
			if ((caseInsensStrcmp(dpyname,"WSA")) == 0) {
				if ((dpynameEnv = buildVmsDisplayString(dpyname, vmsDisplay))
						== NULL) {
					fprintf(stderr, "Invalid WSA name specified\n");
					exit (ERROR_EXIT);
				}
			}
			else
				dpynameEnv = dpyname;
#endif /* VMS */

			XpPutEnv("DISPLAY",
#ifdef VMS
                               dpynameEnv);	/* place in passed environ */
#else
                               dpyname);	/* place in passed environ */
#endif /* VMS */

			options |= XPSH_DISPLAY;
	    } else {
			fprintf(stderr,
				"%s : usage error : Missing display argument\n",argvsav[0]);
			usage(argcsav,argvsav);
	    }
	    goto another;
	}
	if (!strcmp(*argv, "-access")) {
	    if (argc > 1) {
			accessname = *++argv; argc--;
		} else {
			fprintf(stderr,
				"%s : usage error : Missing access argument\n",argvsav[0]);
			usage(argcsav,argvsav);
	    }
	    goto another;
	}
	if (!strcmp(*argv, "-xpenv")) {
	    if (argc > 1) {
			char *xpenvbuf, *equalsignptr;
			char *envp;
			++argv; argc--;
			xpenvbuf = (char *) malloc(strlen(*argv) + 1);
			strcpy(xpenvbuf,*argv);
			envp = strtok (xpenvbuf, " \t");
			while (envp) {
				equalsignptr = index(envp,'=');
				if (equalsignptr != NULL) {
					*equalsignptr =  '\0';
					XpPutEnv(envp,equalsignptr+1);
				} else {
					fprintf(stderr,
				"%s : usage error : Missing '=' in xpenv argument\n",
						argvsav[0]);
					usage(argcsav,argvsav);
				}
				envp = strtok ((char *)NULL, " \t");
			} /* end while */
			free(xpenvbuf);
		} else {
			fprintf(stderr,
				"%s : usage error : Missing xpenv argument\n",argvsav[0]);
			usage(argcsav,argvsav);
	    }
	    goto another;
	}
	if (!strcmp(*argv, "-nohome")) {
	    nohome = True;
	    goto another;
	}
	if (!strcmp(*argv, "-console")) {
	    options |= XPSH_CONSOLE;
	    goto another;
	}
	if (!strcmp(*argv, "-d")) {
	    options |= XPSH_DEBUG;
	    goto another;
	}
	if (!strcmp(*argv, "-n")) {
	    options |= XPSH_N;
	    goto another;
	}
	/* unknown flag encountered */
 	if (**argv == '-')
		usage(argcsav,argvsav);
    }

#ifdef VMS
	/* add the display name if not in the environment, careful on how this is
	 * done.  get the device and add the transport specification
	 * DON'T FORGET TO DELETE THE DISPLAY LOGICAL NAME
	 */
	if (dpyname == NULL) {
		if ((dpynameEnv = getVmsLogicalName("DECW$DISPLAY", vmsDisplay, 0)) == 
				NULL) {
			fprintf( stderr, "Unable to get DECW$DISPLAY\n");
			exit (ERROR_EXIT);
		}
		if ((dpynameEnv = buildVmsDisplayString(vmsDisplay, vmsDisplay)) ==
				NULL) {
			fprintf( stderr, "DECW$DISPLAY does not respond to query\n");
			exit (ERROR_EXIT);
		}
		else {
			XpPutEnv("DISPLAY",dpynameEnv);	/* place in passed environ */
		}
	}
	/* for now this is only tested on VMS 
	 * set up error handlers and for VMS ONLY, an exit handler 
	 */
	XSetErrorHandler(errorHandler);
	XSetIOErrorHandler(ioErrorHandler);

	exitHandlerBlock.handlerAddress = &imageExitHandler;
	exitHandlerBlock.argumentCount = 0;
	exitHandlerBlock.condValue = &exitStatus;
	if (SYS$DCLEXH(&exitHandlerBlock) != SS$_NORMAL) {
		fprintf (stderr, "Unable to setup image exit handler\n");
		exit (ERROR_EXIT);
	}
	signal(SIGBUS, sigbusCaught);

#else
	/* get display variable, default or -display defined; it MUST be defined
	 */                              
    if (!dpyname) 
        dpyname = getenv("DISPLAY");
#endif /* VMS */

    dpy = XpOpenDisplay(argcsav,argvsav,dpyname);
    XpInternAtoms(dpy);
    root = RootWindow(dpy,DefaultScreen(dpy));

    /* must be at least a remote command remaining */
    if (argc == 0) {
	    fprintf(stderr,"%s : usage error : Missing command\n",argvsav[0]);
	    usage(argcsav,argvsav);
    }

    /*
     * Add necessary environment variables to the environment:
     * TEKXP_XPSH_WID		xpsh communication window
     * TEKXP_HOST			name of host for nfs file access
     * TEKXP_HOST_ADDRESS	address of host for tftp or dap file access
     * TEKXP_HOST_TYPE		host type: vms | unix
     * TEKXP_ACCESS			host file access method
     * TEKXP_CWD			user's current working directory
     * HOME					user's home directory
     *
     * For local execution only:
     * TEKXP_LOCAL			xpsh is running locally
	 *
	 * We will only set TEKXP_HOST, TEKXP_HOST_ADDRESS, TEKXP_HOST_TYPE,
	 * TEKXP_CWD, or HOME if it is not already set by the user.
	 *
	 * If the user passed an -access argument to xpsh, we will use that
	 * to set TEKXP_ACCESS.  Otherwise, if the user set the TEKXP_ACCESS
	 * environment variable, we will use that.  In either case, we convert
	 * the user-specified access method to an internal form and store
	 * it in TEKXP_ACCESS.
     */

    /*
	 * Create a unique property communication window for this xpsh session.
	 * Warning, don't rely on ret value of sprintf; it differs in bsd and sysV.
	 */
    xpshWid = XpCreatePropWindow(dpy);
    sprintf(buf_number,"%d",xpshWid);
    XpPutEnv(TEKXP_XPSH_WID,buf_number);

    tekxp_access_original = getenv(TEKXP_ACCESS);
    if (accessname == NULL) {
        accessname = tekxp_access_original;
    }

    xpshdWid = get_xpsh_wid(dpy,root);

    XpGetPropertyStr(dpy,root,XA_TEK_SXP_ADDRESS,&rssdisplaynum,&len);
    len = 0;

#ifdef VMS
	access_int = XpTranslateAccessName(accessname, buf_number, dpynameEnv,
					   rssdisplaynum);
#else
	access_int = XpTranslateAccessName(accessname, buf_number, dpyname,
					   rssdisplaynum);
#endif /* VMS */

    XpPutEnv(TEKXP_ACCESS, buf_number);

#ifndef TEKXP
       if (access_int != RSS_ACCESS){
          /* for backward compatibility, check for xpsh "-nohome" option */ 
	  if (!nohome && (getenv(TEKXP_HOST) == NULL)) {
	    (void) XpGetHostname(hostnamebuf, _XPSH_PATH_MAX, access_int);
	    XpPutEnv(TEKXP_HOST, hostnamebuf);
	  }

	  if (getenv(TEKXP_HOST_ADDRESS) == NULL &&
	      XpGetHostAddr(dpy,hostnamebuf, _XPSH_PATH_MAX, access_int) > 0) {
	    XpPutEnv(TEKXP_HOST_ADDRESS, hostnamebuf);
	  }
	}

	if (getenv(TEKXP_CWD) == NULL) {
		XpPutEnv(TEKXP_CWD, XpGetCwd());
	}
#endif /* !TEKXP */

	if (getenv("HOME") == NULL) {
#ifndef TEKXP
		XpPutEnv("HOME", XpGetHomeDirName());
#else
		XpPutEnv("HOME", "TEKXP_HOME");
#endif /* !TEKXP */
	}

#ifdef VMS
    /*
	 * define decw$user_defaults  >> TEKXP_DECW_USER_DEFAULTS
	 * comma-separated directory search list
     */
	if (getenv(TEKXP_DECW_USER_DEFAULTS) == NULL) {
		char string [MAXPATHLEN * 2];
		XpGetVMSLogEquiv("DECW$USER_DEFAULTS", string);
		(void) stringDowncase (string);
		XpPutEnv(TEKXP_DECW_USER_DEFAULTS, string);
	}
#endif /* VMS */

	if (getenv(TEKXP_HOST_TYPE) == NULL) {
#ifdef VMS
    	XpPutEnv(TEKXP_HOST_TYPE, "vms");
#else
    	XpPutEnv(TEKXP_HOST_TYPE, "unix");
#endif /* VMS */
	}

#ifdef TEKXP
    XpPutEnv(TEKXP_LOCAL,"1");
#endif /* TEKXP */

    PRINT_PATH_ARGV_ENVP("",argv,environ);

    /* select now for debugging */
    XSelectInput(dpy,xpshWid,PropertyChangeMask);

    /*
     * started with
     * envptr_debug for debugging hardwired environment
     * envp for real environment
     */
    XpSetPropertyStrList(dpy,xpshWid,XA_TEK_XPSH_ENV,environ);

    /* remember the argv[0] has been bumped to point to the command argument */
    XpSetPropertyStrListn(dpy,xpshWid,XA_TEK_XPSH_ARG,&argv[0],argc);
    XpSetPropertyStr(dpy,xpshWid,XA_TEK_XPSH_CMD,argv[0]);
    XpSetPropertyStr(dpy,xpshWid,XA_TEK_XPSH_LCK,"");
    XpSetPropertyInt(dpy,xpshWid,XA_TEK_XPSH_OPT,&options);

    /*
     * Now reset environment.
     */
    environ = envp;

#ifdef DEBUG
    {
	int i;
	Atom *atomlist;
	int num;

	atomlist = XListProperties(dpy,xpshWid,&num);
	x_debug3(("Properties on xpshWid window\n"));
	for( i=0; i<num; i++){
	    x_debug3(("%s\n",XGetAtomName(dpy,atomlist[i])));
	}
	x_debug3(("argv[argc] is \"%s\"\n",argv[argc]));
    }
#endif

    /*
     * Block signals until remote connection made and 
     * signal handlers assigned.
     */
#ifdef SYSV
    sigemptyset(&oset);
    sigemptyset(&set);
    sigaddset(&set,SIGINT);
    sigaddset(&set,SIGQUIT);
    sigaddset(&set,SIGTERM);
    sigprocmask(SIG_BLOCK,&set,&oset);
#else
    omask = sigblock(sigmask(SIGINT)|sigmask(SIGQUIT)|sigmask(SIGTERM));
#endif /* SYSV */

    /* 
     * Register the xpshWid with the xpshd running on the X terminal
     * by sending a client message event to the unique xpshdWid window.
     */

    XpSendClientMessageInt(dpy,xpshdWid,XA_TEK_XPSH_WID,(long)xpshWid);

    /*
     * Catch the three signals: SIGINT SIGQUIT SIGTERM
     */
    if (signal(SIGINT, SIG_IGN) != SIG_IGN){
	signal(SIGINT, sendsig);
    }
    if (signal(SIGQUIT, SIG_IGN) != SIG_IGN){
	signal(SIGQUIT, sendsig);
    }
    if (signal(SIGTERM, SIG_IGN) != SIG_IGN){
	signal(SIGTERM, sendsig);
    }
#ifdef SYSV
    sigprocmask(SIG_SETMASK,&oset,NULL);
#else  
    sigsetmask(omask);		/* turn on signal processing */
#endif /* SYSV */

    /*
     * Catch the SIGCHLD with a handler that waits on the child.
     */
#ifndef VMS
    XpSignal(SIGCHLD,XpHandlerSIGCHLD);
#endif /* !VMS */

    /*
     * Now loop forever waiting for commands from the X terminal,
     * XXX to be added:
     * input from stdin, or signals.
     */

    XSelectInput(dpy,xpshWid,PropertyChangeMask);

    while(True){

	XSync(dpy,False);	/* must flush buffer before select */
	if(XPending(dpy)){
	    goto XPending_label;
	}
	
	if(xpshSignal){
	    /*
	     * Received a signal, send it to the xpshd process.
	     * This is the only process writing to the xpshWid so
	     * we do not need to use a lock, simply send and block
	     * until it is removed.
	     * This process will wait for a XA_TEK_XPSH_EXIT from the
	     * remote process before it exits.
	     */
#ifdef  DEBUG
	    x_debug1(("\nxpsh sending sig %d to xpshd\n",xpshSignal));
#endif
	    XpSendPropertyInt(dpy,xpshWid,XA_TEK_XPSH_SIG,&xpshSignal);
	    xpshSignal = 0;
	    continue;	/* check X pending events again */
	}

#ifndef VMS
	FD_ZERO(&readfds);
	FD_SET(ConnectionNumber(dpy), &readfds);
	switch(select(FD_SETSIZE, &readfds, (fd_set *)NULL, (fd_set *)NULL, (struct timeval *)NULL)) {
	case -1:
	    if (errno == EINTR)
		continue;
	    XpFatalError("select");
	    break;

	case 0:
	    continue;

	default:
	    if (FD_ISSET(ConnectionNumber(dpy), &readfds)) {
		/* 
		 * Check for X events without blocking
		 */
#endif /* !VMS */
XPending_label:
#ifndef VMS
		while (XPending(dpy)) {
#endif /* !VMS */
		    XNextEvent(dpy,&e);
#ifdef	DEBUG
		    XpPrintEvent(&e);
#endif
		    switch(e.type){
		    case ClientMessage:
			eclient = (XClientMessageEvent *)&e;
			if(eclient->message_type == XA_TEK_XPSH_EXIT){
			    /*
			     * cleanup and exit
			     */
			    XDestroyWindow(dpy,xpshWid);
			    XSync(dpy,True);
			    exitstatus = (int) eclient->data.l[0];
			    exit(exitstatus);
			}
                        if(eclient->message_type == XA_TEK_XPSH_KILL){
                            /*
                             * use kill to send a signal to a process
                             */
                            int sig, pid;
 
                            sig = (int) eclient->data.l[0];
                            pid = (int) eclient->data.l[1];
                            (void) kill (pid,sig);
                        }
			break;

		    case PropertyNotify:
			eprop = (XPropertyEvent *)&e;
			if( eprop->atom == XA_TEK_XPSH_HLCK &&
			    eprop->state == PropertyNewValue){
			    /*
			     * The X terminal has registered a command and
			     * set the lock.  Read the command and delete
			     * the lock.  Once the lock is deleted the
			     * X terminal can send another command.
			     *
			     * Be sure to make all X calls using dpy
			     * before the fork, so we don't have to open
			     * another connection to the X server in the child.
			     */
			    XpGetPropertyStrList(dpy,xpshWid,XA_TEK_XPSH_HENV,&hostenvp);
			    XpGetPropertyStrList(dpy,xpshWid,XA_TEK_XPSH_HARG,&hostargv);
			    XpGetPropertyStr(dpy,xpshWid,XA_TEK_XPSH_HCMD,&hostpath,&len);
			    PRINT_PATH_ARGV_ENVP(hostpath,hostargv,hostenvp);
			    XDeleteProperty(dpy,xpshWid,XA_TEK_XPSH_HLCK);
#ifdef VMS
				/* scrap the silly fork/exec vms emulation that tries to look
				 * like U*** got for the real meat
				 */
				{
				    int spawnFlags;           /* for LIB$SPAWN */
				    long int returnStatus;
				    struct dsc$descriptor_s command;    /* command string char
														 * descriptor
														 */
					int eventFlag;
					char *ampersand;

				/* grab an event flag for notification when this
				 * child(ren) dies
				 */
				if ((LIB$GET_EF(&eventFlag)) == SS$_NORMAL)
					allMyChildren.notifyFlag = (char) eventFlag;
				else 
					allMyChildren.notifyFlag = '\0';

                spawnFlags = CLI$M_NOWAIT;

				if ((ampersand = strchr(*(hostargv + 2),'&')) != NULL) {
					*ampersand = '\0';
				}
                command.dsc$a_pointer = *(hostargv + 2);
                command.dsc$w_length = strlen(*(hostargv + 2));
                command.dsc$b_class = DSC$K_CLASS_S;
                command.dsc$b_dtype = DSC$K_DTYPE_T;

				/* perform the deed */
                if ((returnStatus = LIB$SPAWN (&command, &nullDev, &nullDev,
                  &spawnFlags, 0,&allMyChildren.subprocessId,
				  &allMyChildren.subprocessCompletion,&allMyChildren.notifyFlag,
				  0,0,0,0)) != SS$_NORMAL) {
                    LIB$SIGNAL (returnStatus);
                }
				/*
				 * XFree the property data
				 * free the arrays of pointers
				 * Dependent on XpGet... implementation
				 */
				XFree(hostenvp[0]);
				XFree(hostargv[0]);
				XFree(hostpath);
				free((char *)hostenvp);
				free((char *)hostargv);

				}
#else
			    switch(fork()){
			    case -1:
				XpErrorF(stderr,"%s: Fork failed\n",argv[0]);
				break;
			    case 0:
				/* child */

				/* this debugging routine doesn't call X */
				PRINT_PATH_ARGV_ENVP(hostpath,hostargv,hostenvp);

				/*
				 * Set the environ to that passed back by
				 * the local client.
				 * 
				 * Careful here.  Be sure the env ptr passed
				 * to XpPutEnv can be freed if this is not
				 * the first call to XpPutEnv.
				 */
				environ = hostenvp;

				if (tekxp_access_original == NULL) {
					XpDeleteEnv(TEKXP_ACCESS);
				} else {
					XpPutEnv(TEKXP_ACCESS, tekxp_access_original);
				}

				if(hostpath[0] == '/')
				{
#ifdef TEKXP
				    int max, j, i, slen = 0;
				    char *hargv[100];
				    char tmp1buf[256];
				    char tmp2buf[256];
				    char *hpath;
				    char *tmp1ptr, *tmp2ptr;
				    Bool first_token = True;

				    i = 0;
				    tmp1ptr = tmp1buf;
				    tmp2ptr = tmp2buf;
				    strcpy(tmp1buf, hostargv[2]);
				    max = strlen(tmp1buf);

				    for (j = 0; j < max; j++)
				    {
					if (*tmp1ptr != ' ' || *tmp1ptr != '\t')
					{
					    slen++;
					    *tmp2ptr++ = *tmp1ptr++;
					}
					
					if (*tmp1ptr == ' ' || j == max - 1)
					{
					    *tmp1ptr++;
					    *tmp2ptr = '\0';
					    if (first_token)
					    {
						hpath = (char *)malloc(MAXPATHLEN);
						if (tmp2buf[0] != '/')
						{
						    strcpy(hpath,"/bin/");
						    strcat(hpath,tmp2buf);
						}
						else
						{
						    strncpy(hpath, tmp2buf, 
							    slen+1);
						}
						first_token = False;
						fprintf(stderr,
							"hpath = %s\n",hpath);
					    }
					    hargv[i] = (char *)malloc(slen+1);
					    strncpy(hargv[i], tmp2buf, slen+1);
					    i++;
					    tmp2ptr = tmp2buf;
					    slen = 0;
					}
				    }
				    hargv[i] = NULL;
				    first_token = True;
				    execvp(hpath,hargv);
#else
				    /* assume we have a full path */
				    execve(hostpath,hostargv,environ);
#endif /* TEKXP */
				} else {
				    /*
				     * Assume we have a filename.
				     * For now use execvp to resolve the path.
				     * This is necessary if execlp or execvp
				     * called.
				     *
				     * This code relys on the fact that the
				     * host execvp will use the eviron
				     * variable which we have set to the
				     * environment passed back by the local
				     * client.
				     */
				    execvp(hostpath,hostargv);
				}
				break;
			    default:
				/* parent */
				/*
				 * XFree the property data
				 * free the arrays of pointers
				 * Dependent on XpGet... implementation
				 */
				XFree(hostenvp[0]);
				XFree(hostargv[0]);
				XFree(hostpath);
				free((char *)hostenvp);
				free((char *)hostargv);
				break;
			    } /* endswitch fork */
#endif /* VMS */
			} /* endif XA_TEK_XPSH_HLCK */                   
			break;
		    default:
			break;
		    } /* endswitch (e.type */
#ifndef VMS
		} /* endwhile (XPending( */
	    } /* endif (FS_ISSET */
    	} /* endswitch(select( */
#endif /* !VMS */

	/*
	 * If any forked children have exited and have not been waited on
	 * by the signal handler, call the handler to wait for them
	 * at least once in this main loop.
	 */

#ifndef VMS
	XpHandlerSIGCHLD((int)NULL,(int)NULL,(struct sigcontext *)NULL);
#endif /* !VMS */
    } /* endif while (forever) */
}

