#ifndef LINT
#ifdef RCS_ID
static char *rcsid = "$Header: /nwd/tools/media/X11/XP/src/xsetprop/RCS/xsetprop.c,v 1.6 1992/11/18 22:27:22 cathyga Exp $";
#endif /* RCS_ID */
#endif /* LINT */

/*
 * Copyright 1989-1992 by the Massachusetts Institute of Technology, 
 * Cambridge, Massachusetts, and Tektronix, Inc. Beaverton, Oregon.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Tektronix or M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Tektronix and M.I.T. make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * TEKTRONIX AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL TEKTRONIX OR M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 *  Based on the r4 Hello World program by Glenn Widener, which was
 *  based on the r3 Hello World program by David Rosenthal.
 *
 *	NAME
 *		getlang.c: get the language for X clients
 *
 *	DESCRIPTION
 *		This program sets a string property on the root window (type
 *		STRING, format 8).  If no new property value is given on the
 *		command line, it prints the current value of the specified
 *		property to stdout.  The default property is _TEK_LANGUAGE.
 *		This property configures a user's X display environment for a
 *		desired native language, for those clients which obey the
 *		property (TekXpress local clients).  The X server in the XPxx
 *		X stations sets this property to the current default
 *		language, i.e.  the keyboard language selected by setup.
 *
 *	OPTIONS
 *		-display	- the usual...
 *		-p[roperty]	- get/set the property named by the following 
 *				  argument, value to set given last.
 *		-r[emove]	- remove the property named by the following 
 *				  argument.
 *		-e[xists]	- test for existence of the property.
 *
 *	ERRORS
 *		(sent to stderr)
 *		can't open display
 *		can't intern property name atom
 *		can't get the property (does not exist)
 *		can't set the property (alloc X protocol error)
 *		invalid property
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define BUFSIZE 0x1000

char *ProgramName;
Display	    *dpy;		/* X server connection */

void exit();

usage ()
{
    fprintf (stderr, 
	     "usage:  %s [-d[isplay] host:dpy] [-p[roperty] PROP_NAME]\n\t\t[-r[emove] PROP_NAME] [-e[xists] PROP_NAME] [ prop_value ]\n", ProgramName);
    exit (1);
}

main(argc,argv)
    int argc;
    char **argv;
{
    char	*displayname = NULL;
    int		i;
    Atom prop_name;
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long leftover;
    unsigned char *data = NULL;
    unsigned short *intptr;
    Bool remove = False;
    Bool test = False;
    char *prop_name_string = "_TEK_LANGUAGE";
    char *prop_value = NULL;

    /* parse arguments for basic X args */

    ProgramName = argv[0];
    for (i = 1; i < argc; i++) {
	char *arg = argv[i];

	if (arg[0] == '-') {
	    switch (arg[1]) {
	      case 'd':			/* -display host:dpy */
		if (++i >= argc) usage();
		displayname = argv[i];
		continue;
	      case 'p':			/* -p[roperty] PROP_NAME */
		if (++i >= argc) usage();
		prop_name_string = argv[i];
		continue;
	      case 'r':			/* -r[emove] PROP_NAME */
		if (++i >= argc) usage();
		remove = True;
		prop_name_string = argv[i];
		continue;
	      case 'e':			/* -r[emove] PROP_NAME */
		if (++i >= argc) usage();
		test = True;
		prop_name_string = argv[i];
		continue;
	      default:
		usage();
		/* doesn't return */
	    }
	} else {
	    if (prop_value)
		usage();
	        /* doesn't return */
	    else {
	        prop_value = argv[i];
		continue;
	    }
	}
    }

    /*
     * Open the display using the $DISPLAY environment variable to locate
     * the X server.  See Section 2.1.
     */
    if ((dpy = XOpenDisplay(displayname)) == NULL) {
	fprintf(stderr, "%s: can't open display '%s'\n", argv[0], 
	        XDisplayName(displayname));
	exit(1);
    }

    prop_name = XInternAtom (dpy, prop_name_string, False);
    if (prop_name == None) {
	fprintf(stderr, "%s: can't intern \"%s\" atom\n", argv[0], 
		prop_name_string);
	exit(1);
    }

    if (!prop_value || test) {
	/* get it */
	if ((XGetWindowProperty(dpy, DefaultRootWindow(dpy), prop_name, 0L,
		 (long)BUFSIZE, False, AnyPropertyType, &actual_type, &actual_format,
		 &nitems, &leftover, &data) != Success) || 
	    (actual_type == None)) {
	    if (test) {
		printf("%s property does not exist\n", prop_name_string);
		exit(1);
	    }
	    fprintf(stderr, "%s: can't get the \"%s\" property\n", argv[0], 
		    prop_name_string);
	    exit(1);
	}
	if (test) {
	    printf("%s property exists\n", prop_name_string);
	    exit(0);
	}

	if ( (actual_type == XA_STRING) &&  (actual_format == 8) ) {

	    /* The data returned by XGetWindowProperty is guaranteed to
	       contain one extra byte that is null terminated to make
	       retrieveing string properties easy. */
	    printf("%s\n", (char *)data);
	}
	else
	if (actual_format == 8)
	{
	    printf("{ %x \n",nitems);
	    for (i=0; i<nitems; i++)
	    {
		printf("0x%x ",data[i]);
		if ((i % 12) == 0)
		    printf("\n");

            }
	    printf("\n }\n ");
        }
        else
	if (actual_format == 16)
	{
	     
	    intptr = (unsigned short *)data;

	    printf("{ %x \n",nitems);
	    for (i=0; i<nitems; i++)
	    {
		printf("0x%x ",intptr[i]);
		if ((i % 12) == 0)
		    printf("\n");
            }
	    printf("\n }\n ");
        }
	else
	    fprintf(stderr, "%s: invalid \"%s\" property\n", argv[0], 
		    prop_name_string);

	if (data) XFree ((char *)data);
    }
    if (remove) {
	XDeleteProperty(dpy, DefaultRootWindow(dpy), prop_name);
    }
    if (prop_value) {
	/* set it */
	XChangeProperty(dpy, DefaultRootWindow(dpy), prop_name, XA_STRING, 8,
		 PropModeReplace, prop_value, strlen(prop_value));
    }
    XCloseDisplay(dpy);
    exit(0);
}
