#!/bin/sh
# Dieses Shellskript erzeugt ein Photoalbum.html aus einer Reihe
# von Einzelbildern.
# Benutzt wird: convert (imagemagick), exif, sed und awk
#


declare -i row col page ppage npage PICT_WIDTH PICT_HIGHT XCOL XROW
declare -i PixelXDimension PixelYDimension ratio

col=1
row=1
page=1
ppage=1
npage=2
PREV_SGL=""

XCOL=3
XROW=5

if [ -f ./.albumrc ] ; then
  source ./.albumrc
else
  echo copying global \".albumrc\" to current directory
  cp ~/.albumrc .	
  source ./.albumrc
fi

if [ "$THUMBS" = "" ] 
then
  echo -n "Thumb-Nail-Directory: "
  read THUMBS
fi

if [ "$PAGES" = "" ] 
then
  echo -n "Unterseiten-Directory: "
  read PAGES
fi

if [ ! -d $THUMBS ]
then
  mkdir $THUMBS
else
  rm -f $THUMBS/*
fi

PALM=palm_pics
if [ ! -d $PALM ]
then
  mkdir $PALM
else
  rm -f $PALM/*
fi

if [ ! -d $PAGES ]
then
  mkdir $PAGES
else
  rm -f $PAGES/*
fi

cp $ALB_HOME/$TEMPLATE album.tmp
written=FALSE

echo -n "Zeilen , Spalten pro Seite: ["$XROW $XCOL"] "
read H0 H1
if [ "$H0" != "" ] ; then
  XROW="$H0"
fi
if [ "$H1" != "" ] ; then
  XCOL="$H1"
fi

echo -n "Bildbreite: ["$PICT_WIDTH"] "
read H0
if [ "$H0" != "" ] ; then
  PICT_WIDTH="$H0"
fi
PICT_HIGHT=$PICT_WIDTH*2/3
echo "Bildhoehe 3/2:  ["$PICT_HIGHT"]"
PICT_HIGHT=$PICT_WIDTH*3/4
echo "Bildhoehe 4/3:  ["$PICT_HIGHT"]"

echo -n "Filename: ["$FILENAME"] "
read H0
if [ "$H0" != "" ] ; then
  FILENAME="$H0"
fi

LS_FILE=$FILENAME".lst"
if [ "$LS_FILE" = "" ] 
then
  echo -n "List-File: "
  read LS_FILE
fi

if [ -f $LS_FILE ]
then
  echo List-File $LS_FILE existiert und wird verwendet.
else
  echo List-File $LS_FILE wird neu angelegt.
  ls -1tr *.jpg *.JPG *.tif *.TIF 2> /dev/null 1> $LS_FILE
fi

echo -n "Hintergrund: ["$BGCOLOR"] "
read H0
if [ "$H0" != "" ] ; then
  BGCOLOR="$H0"
fi

echo -n "Top-Link: ["$TOPLINK"] "
read H0
if [ "$H0" != "" ] ; then
  TOPLINK="$H0"
fi
echo -n "Titel im Browser: ["$BROWSERTITLE"] "
read H0 H1 H2 H3 H4 H5 H6 H7 H8 H9
if [ "$H0" != "" ] ; then
  BROWSERTITLE="$H0 $H1 $H2 $H3 $H4 $H5 $H6 $H7 $H8 $H9"
fi

echo -n "Seitentitel: ["$HEADLINE"] "
read H0 H1 H2 H3 H4 H5 H6 H7 H8 H9
if [ "$H0" != "" ] ; then
  HEADLINE="$H0 $H1 $H2 $H3 $H4 $H5 $H6 $H7 $H8 $H9"
fi

#
echo -n "Untertitel: ["$SUBHEAD"] "
read H0 H1 H2 H3 H4 H5 H6 H7 H8 H9
if [ "$H0" != "" ] ; then
  SUBHEAD="$H0 $H1 $H2 $H3 $H4 $H5 $H6 $H7 $H8 $H9"
fi

echo ALB_HOME=\"$ALB_HOME\" > .albumrc
echo TEMPLATE=\"$TEMPLATE\" >> .albumrc
echo FILENAME=\"$FILENAME\" >> .albumrc
echo BGCOLOR=\"$BGCOLOR\" >> .albumrc
echo HEADLINE=\"$HEADLINE\" >> .albumrc
echo SUBHEAD=\"$SUBHEAD\" >> .albumrc
echo BROWSERTITLE=\"$BROWSERTITLE\" >> .albumrc
echo THUMBS=\"$THUMBS\" >> .albumrc
echo PAGES=\"$PAGES\" >> .albumrc
echo PICT_WIDTH=\"$PICT_WIDTH\" >> .albumrc
echo TOPLINK=\"$TOPLINK\" >> .albumrc
echo LS_FILE=\"$LS_FILE\" >> .albumrc
echo XCOL=\"$XCOL\" >> .albumrc
echo XROW=\"$XROW\" >> .albumrc
XCOL=$XCOL+1
XROW=$XROW+1


if [ ! -f ./index.html ] ; then
  cp $ALB_HOME/album_ix.html ./index.ht	
  sed "s/_HEADLINE_/$HEADLINE/;
  s/_BROWSERTITLE_/$BROWSERTITLE/;
  s/_SUBHEAD_/$SUBHEAD/;
  s/_BGCOLOR_/$BGCOLOR/;
  s/_INIT_PAGE_/$FILENAME/" index.ht > index.html 
  ln -s index.html $FILENAME.html
  rm index.ht
fi

sed "s/_HEADLINE_/$HEADLINE/;
     s/_BROWSERTITLE_/$BROWSERTITLE/;
     s/_BGCOLOR_/$BGCOLOR/;
     s/_SUBHEAD_/$SUBHEAD/;
     s/_TOPLINK_/$TOPLINK/;
     s/_PREV_PAGE_/$FILENAME$ppage/;
     s/_NEXT_PAGE_/$FILENAME$npage/;
     s/_PAGE_NUMB_/1/;
     s/_INIT_PAGE_/$FILENAME/" album.tmp > album.html

for i in `cat $LS_FILE`
do
  echo $i $page $row $col
  ii=`echo $i | sed "s/.jpg/_tn.jpg/; s/.JPG/_tn.jpg/"`
  ip=`echo $i | sed "s/.jpg/_p.jpg/; s/.JPG/_p.jpg/"`
  is=`echo $i | sed "s/.jpg/_sml.jpg/; s/.JPG/_sml.jpg/"`
  ih=`echo $i | sed "s/.jpg/.html/; s/.JPG/.html/"`
  PixelXDimension=`exif $i | grep PixelXDimension | cut -d "|" -f 2`
  PixelYDimension=`exif $i | grep PixelYDimension | cut -d "|" -f 2`
  if [ "$PixelYDimension" = "0" ]
  then 
    PixelXDimension=640
    PixelYDimension=480
  fi
  ratio=$PixelXDimension*100/$PixelYDimension+5
  ratio=$ratio/10
# echo $ratio
  if [ "$ratio" = "13" ]
  then
    convert -thumbnail 192 -border 0x24 -bordercolor $BGCOLOR $i ./$THUMBS/$ii
    PICT_HIGHT=$PICT_WIDTH*3/4
  else
    convert -thumbnail 192 -border 0x40 -bordercolor $BGCOLOR $i ./$THUMBS/$ii
    PICT_HIGHT=$PICT_WIDTH*2/3
  fi
# Bilder fr den Palm
  if [ "$ratio" = "13" ]
  then
    convert -thumbnail 480 $i ./$PALM/$ip
    PICT_HIGHT=$PICT_WIDTH*3/4
  else
    convert -thumbnail 480 $i ./$PALM/$ip
    PICT_HIGHT=$PICT_WIDTH*2/3
  fi

  convert -scale $PICT_WIDTH $i ./$PAGES/$is
  mv album.html album.tmp

# extrahiert die Uhrzeit
  time=`ls --full-time $i | cut -d " " -f 6,7 | cut -b 12-19`
# extrahiert Datum und Uhrzeit
  date=`ls --full-time $i | cut -d " " -f 6,7 | cut -b 1-19`
#  datum=`echo $date | cut -b 9-10`.`echo $date | cut -b 6-7` " " `echo $date | cut -b 1-4`
# erzeugt Datum in deutschem Format
  datum=`echo $date | cut -b 9-10`
  datum=$datum"."`echo $date | cut -b 6-7`
  datum=$datum". "`echo $date | cut -b 1-4`
## Wenn nur die Uhrzeit angezeigt werden soll, dann die naechste Zeile
## wirksam machen.
  datum=$time
  sed "s/_TN_PIC_$row$col/$ii/;
       s/_BROWSERTITLE_/$BROWSERTITLE/;
       s/_TOPLINK_/$TOPLINK/;
       s/_DESCR1_$row$col/$i/;
       s/_SPAGE_$row$col/$ih/;
       s/_DESCR2_$row$col/$datum/" album.tmp > album.html
#      s/_DESCR2_$row$col/$time/" album.tmp > album.html
  sed "s/_PICTURE_/$is/;
       s/_BROWSERTITLE_/$BROWSERTITLE/;
       s/_TOPLINK_/$TOPLINK/;
       s/_HEADER1_/$HEADLINE/;
       s/_HEADER2_/$SUBHEAD/;
       s/_PICT_HIGHT_/$PICT_HIGHT/;
       s/_PICT_WIDTH_/$PICT_WIDTH/;
       s/_FULL_PIC_/$i/;
       s/_PICT_NAME_/$i/;
       s/_MAIN_/$FILENAME$page/;
       s/_PREV_/$PREV_SGL/;
       s/_TIMEDATE_/  ($date)/" $ALB_HOME/album_sgl.html > ./$PAGES/$ih
  if [ "$PREV_SGL" != "" ]
  then   
    sed "s/_NEXT_/$ih/" ./$PAGES/$PREV_SGL >album_sgl.tmp
         mv album_sgl.tmp ./$PAGES/$PREV_SGL
  fi
  PREV_SGL=$ih
  written=TRUE
  col=$col+1
  if [ $col = $XCOL ] 
  then
    col=1
    row=$row+1
    if [ $row = $XROW ]
    then
#      mv album.html $FILENAME$page.html
      sed '/_SPAGE_/,+2d' album.html | \
      awk 'BEGIN {LINEO="";WORD0=""} \
           {LINE1 = $0; WORD1=$1; \
           if ((WORD1 != "</tr>") || (WORD0 != "<tr>")) \
             {if (LINE0 != "<TR><TR>") {print LINE0}} \
           else {LINE1="<TR><TR>"}; \
           WORD0=WORD1; LINE0=LINE1} \
           END {print LINE1} \
          ' > $FILENAME$page.html

      ppage=$page
      npage=$page+2
      page=$page+1
      echo $FILENAME$page.html
      cp $ALB_HOME/$TEMPLATE album.tmp
      written=FALSE
      sed "s/_HEADLINE_/$HEADLINE/;
           s/_SUBHEAD_/$SUBHEAD/;
           s/_BGCOLOR_/$BGCOLOR/;
           s/_PREV_PAGE_/$FILENAME$ppage/;
           s/_NEXT_PAGE_/$FILENAME$npage/;
           s/_PAGE_NUMB_/$page/;
           s/_INIT_PAGE_/$FILENAME/" album.tmp > album.html
      row=1
    fi
  fi
done

sed '/_SPAGE_/,+2d' album.html | \
      awk 'BEGIN {LINEO="";WORD0=""} \
           {LINE1 = $0; WORD1=$1; \
           if ((WORD1 != "</tr>") || (WORD0 != "<tr>")) \
             {if (LINE0 != "<TR><TR>") {print LINE0}} \
           else {LINE1="<TR><TR>"}; \
           WORD0=WORD1; LINE0=LINE1} \
           END {print LINE1} \
          ' > $FILENAME$page.html
if [ $written = FALSE ]
then
 rm $FILENAME$page.html
fi

npage=`grep -l _TOTAL_PAGES_ $FILENAME*.html | wc -l`
for i in `grep -l _TOTAL_PAGES_ $FILENAME*.html`
do
 sed "s/_TOTAL_PAGES_/$npage/" $i > $FILENAME.tmp
 mv $FILENAME.tmp $i
done

rm album.tmp album.html
