-- An option matcher that can be set up.

indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 20:08:07 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: altmatch.e%v $
	-- Revision 1.2  1993/06/24  20:08:07  Neil_Wilson
	-- Altered header comments
	-- Anchored parameter list definitions
	--
	-- Revision 1.1  1993/06/20  12:36:09  Neil_Wilson
	-- Initial revision
	-- 

deferred class ALTERABLE_MATCHER

inherit
		
	OPTION_MATCHER

feature -- Option list manipulators         
	
	is_present (opt: STRING): BOOLEAN is
		--  Check whether an option is on the match list.
	require
		checkable: opt /= Void
	deferred
	end -- is_present

	add (opt: STRING) is
		-- Add a simple option to the match list.     
	require
		addable: opt /= Void and then not opt.empty
		not_added: not is_present (opt)
	deferred
	ensure
		list_grown: simple.count = old simple.count + 1
	end -- add       
		
	add_required (opt: STRING, parameter_name: STRING) is
		-- Add option with required parameter to match list.     
		-- Parameter_name is used in the help list.   
	require
		addable: opt /= Void and then not opt.empty;
		not_added: not is_present (opt)
	deferred
	ensure
		list_grown: param_list.count = old param_list.count + 1
	end -- add_required         

	add_optional (opt: STRING, parameter_name: STRING) is
		-- Add option with optional parameter to match list.     
		-- Parameter_name is used in the help list.   
	require
		addable: opt /= Void and then not opt.empty;
		not_added: not is_present (opt)
	deferred
	ensure
		list_grown: optional_list.count = old optional_list.count + 1
	end -- add_optional         

feature {NONE} -- option collections.  
		
	simple: COLLECTION [STRING];
		-- Holds the set of valid options that don't take parameters.
		
	optional_list: TABLE [STRING, STRING]
		-- Holds the set of valid options that take optional parameters.
	
	param_list: like optional_list
		-- Holds the set of valid options that take parameters   
		
	default_parameter_name: STRING is "parameter"
		-- Used in help message if none is supplied by user.     
	
invariant
		
	match_list_available: simple /= Void and optional_list /= Void
	    and param_list /= Void
		
end -- class ALTERABLE_MATCHER
