-- Option string identification mechanisms at front of string.

indexing

	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/20 12:18:52 $";
	revision: "$Revision: 1.1 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: frntopid.e%v $
	-- Revision 1.1  1993/06/20  12:18:52  Neil_Wilson
	-- Initial revision
	--

deferred class FRONT_OPTION_IDENTIFIER

inherit

	OPTION_IDENTIFIER

feature -- check and manipulate the option_marker in a string.
	-- Default implementation checks beginning of string for an
	-- identical match.

	is_option_string (arg: STRING): BOOLEAN is
		-- Is 'arg' an option string?
	require else
		argument_available: arg /= Void
	do
		if not arg.empty and then arg.count >= Option_marker.count then
			Result := equal (Option_marker,
			    arg.substring (1, Option_marker.count));
		end
	end -- is_option_string

	add_option_marker (arg: STRING): STRING is
		-- Add the option marker to 'arg'
	do
		Result := clone (arg);
		Result.prepend (Option_marker);
	end -- add_option_marker

	remove_option_marker (arg: STRING) : STRING is
		-- Strip the option marker from 'arg'
	require else
		argument_available: arg /= Void;
		is_option_string: is_option_string (arg)
	do
		if arg.count > Option_marker.count then
			Result := arg.substring (Option_marker.count + 1,
			    arg.count);
		else
			!!Result.make (0)
		end
	end -- remove_option_marker

feature {NONE} 

	Option_marker: STRING is
	deferred
	ensure
		marker_available: Result /= Void
	end -- Option_marker

end -- class OPTION_IDENTIFIER
