-- Option matcher that checks against whole words.

indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 20:18:47 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: fullmat.e%v $
	-- Revision 1.2  1993/06/24  20:18:47  Neil_Wilson
	-- Altered format of help message
	-- Anchored search system to 'last_search'
	--
	-- Revision 1.1  1993/06/20  12:36:09  Neil_Wilson
	-- Initial revision
	-- 

deferred class FULL_MATCHER

inherit
		
	ALTERABLE_MATCHER

feature -- Option list manipulators         
	
	is_present (opt: STRING): BOOLEAN is
		--  Check whether an option is on the match list.
	do
		search (opt)
		Result := simple_found or optional_found or parameter_found
	end -- is_present

	add (opt: STRING) is
		-- Add a simple option to the match list.     
	do
		simple.add (opt)
	end -- add       
		
	add_required (opt: STRING, parameter_name: STRING) is
		-- Add option with required parameter to match list.     
		-- Parameter_name is used in the help list.   
	do
		if parameter_name /= Void then
			param_list.add (parameter_name, opt);
		else
			param_list.add (default_parameter_name, opt);
		end
	end -- add_required         

	add_optional (opt: STRING, parameter_name: STRING) is
		-- Add option with optional parameter to match list.     
		-- Parameter_name is used in the help list.   
	do
		if parameter_name /= Void then
			optional_list.add (parameter_name, opt);
		else
			optional_list.add (default_parameter_name, opt);
		end
	end -- add_optional         
	
	help: STRING is
		-- Full word help listing.
	local
		it: ITERATOR;
	do
		!!Result.make (0);
		from
			it := simple.iterator
		until
			it.finished
		loop
			Result.append ("[");
			Result.append (add_option_marker(simple.item(it)));
			Result.append ("] ");
			it.forth
		end;
		from
			it := optional_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (add_option_marker(optional_list.key(it)))
			Result.append (" [");
			Result.append (optional_list.item(it));
			Result.append ("]] ");
			it.forth;
		end
		from
			it := param_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (add_option_marker(param_list.key(it)));
			Result.append (" ");
			Result.append (param_list.item(it));
			Result.append ("] ");
			it.forth;
		end
	end -- help

	search (element: like last_search) is
		-- Look for an option in the list
	do
		last_search := clone (element)
		simple.search (last_search)
		optional_list.search (last_search)
		param_list.search (last_search);
		simple_found := simple.found;
		optional_found := optional_list.found;
		parameter_found := param_list.found;
	end -- search

feature -- Search result interrogators

	parameter_found: BOOLEAN;

	optional_found: BOOLEAN;

	simple_found: BOOLEAN;
	
	last_search: STRING;

	remaining: STRING is
		-- Full matcher never leaves any characters remaining.
	once
		!!Result.make (0)
	end -- remaining

invariant

	remaining_is_empty: remaining.empty
		-- Prevent alteration to 'once' string.
		
end -- class FULL_MATCHER
