-- Option string identification mechanisms

indexing

	type: abstract;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 19:37:57 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: optionid.e%v $
	-- Revision 1.2  1993/06/24  19:37:57  Neil_Wilson
	-- Completed header comments
	--
	-- Revision 1.1  1993/06/20  12:18:52  Neil_Wilson
	-- Initial revision
	--

deferred class OPTION_IDENTIFIER

feature -- Check and manipulate the option_marker in a string.

	is_option_string (arg: STRING): BOOLEAN is
		-- Is 'arg' an option string?
	require
		argument_available: arg /= Void
	deferred
	end -- is_option_string;

	add_option_marker (arg: STRING) : STRING is
		-- Add the option marker from 'arg'
	require
		argument_available: arg /= Void;
	deferred
	ensure
		result_available: Result /= Void
		different_string: Result /= arg
	end -- add_option_marker

	remove_option_marker (arg: STRING) : STRING is
		-- Strip the option marker from 'arg'
	require
		argument_available: arg /= Void and not arg.empty;
		is_option_string: is_option_string (arg)
	deferred
	ensure
		option_string_available: Result /= Void
		different_string: Result /= arg
	end -- remove_option_marker

end -- class OPTION_IDENTIFIER
