-- Option matcher.

indexing

	type: abstract;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 20:11:07 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: optmatch.e%v $
	-- Revision 1.2  1993/06/24  20:11:07  Neil_Wilson
	-- Altered index type and header comments.
	--
	-- Revision 1.1  1993/06/20  12:34:54  Neil_Wilson
	-- Initial revision
	--

deferred class OPTION_MATCHER

inherit
	
	OPTION_IDENTIFIER

feature -- Interrogation facilities

	simple_found: BOOLEAN is
		-- Found a match in the 'simple option' list.
	deferred
	end -- simple_found

	optional_found: BOOLEAN is
		-- Found a match in the 'optional parameter' option list.
	deferred
	end -- optional_found

	parameter_found: BOOLEAN is
		-- Found a match in the 'required parameter' option list.
	deferred
	end -- parameter_found

	search (for: like last_search) is
		-- Using 'for', look through the option list for a match 
	require
		argument_available: for /= Void
	deferred
	ensure
		strings_available: last_search /= Void and then
		    remaining /= Void;
		altered_last_search: last_search /= old last_search
	end -- search

	last_search: STRING is
		-- The last string searched for
	deferred
	end -- last_search

	remaining: like last_search is
		-- Part of string not searched for
	deferred
	end -- remaining

	help: STRING is
		-- Provides a usage help message based on the valid
		-- option list
	deferred
	end -- help
	
invariant

	help_available: help /= Void
	
	find_consistent: not (optional_found or parameter_found) or
	    not simple_found and (parameter_found xor optional_found)
		-- That's all false or only one of (simple, optional, parameter)

end -- class OPTION_MATCHER
