-- Short options processor - Possibly more than one option per argument.

indexing
	
	type: user, concrete;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/10 20:37:43 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: short_op.e%v $
	-- Revision 1.2  1993/06/10  20:37:43  Neil_Wilson
	-- Generalised inheritance structure
	--
	-- Revision 1.1  1993/06/07  21:25:48  Neil_Wilson
	-- Initial revision
	--
	
class SHORT_OPTIONS

inherit

	SINGLE_OPTIONS
		redefine
			is_present,
			process_option
		select
			is_present,
			process_option
		end

	SINGLE_OPTIONS
		rename
			is_present as basic_is_present,
			process_option as look_for
		export
			{NONE} all
		end

creation

	make

feature -- Match list manipulators

	is_present (opt: STRING): BOOLEAN is
		-- Check whether any of the options in 'opt' are present.
	local
		i: INTEGER
	do
		from
			i := 1
		until
			i > opt.count or Result
		loop
			Result := basic_is_present(opt.substring (i, i));
			i := i + 1;
		end
	end -- add

	add (opt: STRING) is
		-- Add simple option(s) to the match list.
	local
		i: INTEGER
	do
		from
			i := 1
		until
			i > opt.count
		loop
			simple.add(opt.substring (i, i));
			i := i + 1;
		end
	end -- add

	add_required (opt: STRING, parameter_name: STRING) is
		-- Add option(s) with required parameter to match list.
		-- parameter_name is used in the help list.
	local
		i: INTEGER
	do
		from
			i := 1
		until
			i > opt.count
		loop
			if parameter_name /= Void then
				param_list.add (parameter_name, opt.substring (i, i));
			else
				param_list.add (default_parameter_name, opt.substring (i, i));
			end;
			i := i + 1;
		end
	end -- add_required

	add_optional (opt: STRING, parameter_name: STRING) is
		-- Add option(s) with optional parameter to match list.
		-- parameter_name is used in the help list.
	local
		i: INTEGER
	do
		from
			i := 1
		until
			i > opt.count
		loop
			if parameter_name /= Void then
				optional_list.add (parameter_name, opt.substring (i, i))
			else
				optional_list.add (default_parameter_name, opt.substring (i, i))
			end;
			i := i + 1;
		end
	end -- add_optional

	help: STRING is
	local
		it: ITERATOR;
	do
		!!Result.make (1);
		Result.extend ('[');
		Result.append (match.Option_marker);
		from
			it := simple.iterator
		until
			it.finished
		loop
			Result.append (simple.item(it));
			it.forth
		end;
		Result.append ("] ");
		from
			it := optional_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (match.Option_marker);
			Result.append (optional_list.key(it));
			Result.append (" [");
			Result.append (optional_list.item(it));
			Result.append ("]] ");
			it.forth;
		end;
		from
			it := param_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (match.Option_marker);
			Result.append (param_list.key(it));
			Result.append (" ");
			Result.append (param_list.item(it));
			Result.append ("] ");
			it.forth;
		end;
	end -- help

feature {NONE}
	
	process_option (arg: STRING) is
		-- Scan option string
	local
		i: INTEGER;
	do
		from
			i := 1;
			option_transition;
		until
			i > arg.count or has_invalid_option
		loop
			option_transition;
			look_for (arg.substring (i, i));
			i := i + 1;
		end;
	end;

end -- class SHORT_OPTIONS
