-- Ascii eiffel class formatter

indexing

	date: "$Date: 1993/07/18 15:37:28 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: asc_frm.e $
	-- Revision 1.2  1993/07/18  15:37:28  Neil_Wilson
	-- Generalised inheritance structure
	--

class ASCII_FORMAT

inherit

	EIFFEL_FORMAT

creation
   
	make

feature

	make (size : INTEGER) is
		-- Create formatter with indent set to 'size' characters.
	require
		positive_indent: size >= 0;
	do
		indent_width := size
	end -- make

	indent_width : INTEGER 
		-- Current size of indent

	Tab_width : INTEGER is 8
		-- Assumed width of tab stops.

	indent is
		-- Indent output line another level.
	local
		tabs: STRING
		spc: STRING
	do
		increase_indent
		!!tabs.make ((current_width + indent_width) // tab_width
			- current_width // tab_width);
		tabs.fill_with ('%T');
		!!spc.make ((current_width + indent_width) \\ tab_width);
		tabs.append (spc);
		current_width := current_width + indent_width
		output (tabs)
	ensure then
		current_width_up: current_width > old current_width
	end -- indent

	end_output is
		-- Shut down output.
	do
		drop_indent
		io.new_line
	end -- end_output

	separator is 
		-- Output the statement separator
	do
		normal_write ("; ");
	end -- separator

	space is
		-- Output a space
	do
		normal_write (" ");
	end -- space

feature {NONE} -- indent implementations

	bold_on, bold_off, italic_on, italic_off is
		-- All null in this implementation
	do
	end -- bold_on
	
	indent_line is
		-- Set the line indent
	local
		tabs: STRING
		spc: STRING
	do
		if temp_indent then
			current_width := indent_width * (indent_level + 1)
		else
			current_width := indent_width * indent_level
		end;
		!!tabs.make (current_width // tab_width);
		tabs.fill_with ('%T');
		!!spc.make (current_width \\ tab_width);
		tabs.append (spc);
		output (tabs);
		temp_indent := false
	ensure
		-- current_width set correctly
	end -- indent_line

	output (s : STRING) is
	do
		io.putstring(s)
	end -- output

invariant

	positive_indent_width: indent_width >= 0;

end -- class ASCII_FORMAT
