-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 13:17:01 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_bittyp.e $
	-- Revision 1.2  1993/07/18  13:17:01  Neil_Wilson
	-- Added 'defer' feature
	-- Using different output formatter
	--

class EIFFEL_BIT_TYPE 
-- details for bit types

inherit
   EIFFEL_CONSTRUCT
   ANY
   redefine
      copy,
      is_equal
   end
creation
   parse
   
feature

   size : EIFFEL_TOKEN

   parse is
      do
         consume -- bit
         !!size.parse
         matchconsume(Elex_int)
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := size.is_equal(other.size)
      end

   copy(other : like Current) is
      do
         size := clone (other.size)
      end

   defer, flat, short(f : EIFFEL_FORMAT) is
     do
        f.class_name_write("BIT")
        f.space
        size.short(f)
     end
      
end -- class EIFFEL_BIT_TYPE      
