-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_call.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CALL

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   expr : EIFFEL_EXPRESSION
   
   calls : LLIST[EIFFEL_UNQUALIFIED_CALL]

   parse is
      local
         k : EIFFEL_UNQUALIFIED_CALL
      do
         if match(Elex_lbracket)
         then
            consume -- (
            !!expr.parse
            matchconsume(Elex_rbracket)
            matchconsume(Elex_dot)
         end
         from
            !!calls.make
            !EIFFEL_UNQUALIFIED_CALL!k.parse
            calls.put(k)
         until
            not match(Elex_dot)
         loop
            consume -- .
            !EIFFEL_UNQUALIFIED_CALL!k.parse
            calls.put(k)
         end -- loop
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := equal(expr,other.expr) and then
                   equal(calls,other.calls)
      end

   copy(other : like Current) is
      do
         expr := clone(other.expr)
         calls := clone(other.calls)
      end

   flat (f : EIFFEL_FORMAT) is
      do
         if expr /= Void
         then
            expr.flat(f)
            f.normal_write(".")
         end -- if
         from
            calls.start
            calls.item.short(f)
            calls.forth
         until
            calls.off_right
         loop
            f.normal_write(".")
            calls.item.short(f)
            calls.forth
         end 
      end
   
   defer, short(f : EIFFEL_FORMAT) is
      do
      end
   
end -- class EIFFEL_CALL
