-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_classh.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CLASS_HEADER
-- The deferred | expanded | - class name details

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse

feature

   name : EIFFEL_TOKEN

   deferred_class, expanded_class : BOOLEAN

   comment : EIFFEL_TOKEN

   parse is
      do
         if match(Elex_deferred)
         then
            consume
            deferred_class := true
         elseif match(Elex_expanded)
         then
            consume
            expanded_class := true
         end -- if
         matchconsume(Elex_class)
         process_comment
         !!name.parse
         matchconsume(Elex_id)
      end

   flat (f : EIFFEL_FORMAT) is
      do
         if deferred_class
         then
            f.keyword_write("deferred")
            f.space
         elseif expanded_class
         then
            f.keyword_write("expanded")
            f.space
         end -- if
         f.keyword_write("class")
         f.space
         f.class_name_write(name.terminal)
      end

   -- Alteration, Neil Wilson, July 10, 1993
   -- Output formatting alterations.
   
   defer(f : EIFFEL_FORMAT) is
      do
	 f.keyword_write("deferred")
	 f.space
         f.keyword_write("class")
         f.space
         f.class_name_write(name.terminal)
      end

   short(f : EIFFEL_FORMAT) is
      do
         if deferred_class
         then
            f.keyword_write("deferred")
            f.space
         elseif expanded_class
         then
            f.keyword_write("expanded") 
            f.space
         end
         f.keyword_write("class")
	 f.space
	 f.keyword_write ("interface")
         f.space
         f.class_name_write(name.terminal)
      end

  	-- End of alteration

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := name.is_equal(other.name) and then
                   deferred_class = other.deferred_class and then
                   expanded_class = other.expanded_class and then
                   equal(comment,other.comment)
      end

   copy(other : like Current) is
      do
         name := clone(other.name)
         deferred_class := other.deferred_class
         expanded_class := other.expanded_class
         comment := clone(other.comment)
      end

feature {NONE}

   process_comment is
      do
         mark
         l.collect_to_end_of_line
         accept_comments
         consume
         ignore_comments
         if match(Elex_comment)
         then
            !!comment.parse
         end
         return
      end

end -- class EIFFEL_CLASS_HEADER
