-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_classt.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CLASS_TYPE 
-- a class type may include generic types

inherit
   EIFFEL_CONSTRUCT
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   base_class : EIFFEL_TOKEN

   types : LLIST[EIFFEL_TYPE] 

   parse is
      local
         t : EIFFEL_TYPE
      do
         !!base_class.parse
         matchconsume(Elex_id) -- the class NAME
         if match(Elex_lsqbracket) 
         then
            !!types.make
            consume
            from
            until
               match(Elex_rsqbracket)
            loop
               !!t.parse
               types.put(t)
               if match(Elex_comma)
               then
                  consume -- (Elex_comma)
               end
            end
            consume -- Elex_rsqbracket
         end 
      end

   defer, flat, short (f : EIFFEL_FORMAT) is 
      do
         f.class_name_write(base_class.terminal)
         if types /= Void and then not types.empty
         then
            from
	       f.space
               f.normal_write("[")
               types.start
               types.item.short(f)
               types.forth
            until
               types.off_right
            loop
               f.normal_write(",")
	       f.space
               types.item.short(f)
               types.forth
            end
            f.normal_write("]")
         end -- if
      end -- short

   infix "<" (other : like current):BOOLEAN is
      do
         Result := base_class < other.base_class
      end

   supplier_classes : SET[STRING] is
      do
         !!Result
         Result.add(base_class.terminal)
         if types /= Void
         then
            from
               types.start
            until
               types.off_right
            loop
               Result.union(types.item.supplier_classes)
               types.forth
            end -- loop
         end -- if
      end -- supplier_classes

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := base_class.is_equal(other.base_class) and then
                   equal(types,other.types)
      end

   copy(other : like Current) is
      do
         base_class := clone(other.base_class)
         types := clone(other.types)
      end

end -- class EIFFEL_CLASS_TYPE

