-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_compnd.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_COMPOUND 
-- A series of individual instructions

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

    instructions : LLIST[EIFFEL_INSTRUCTION]

    parse is
      local  
         i : EIFFEL_INSTRUCTION
      do
         from
            !!instructions.make
         until
            match(Elex_rescue) or match(Elex_end) or match(Elex_ensure) or 
            match(Elex_when) or match(Elex_else) or match(Elex_elseif) or
            match(Elex_until) or match(Elex_invariant) or match(Elex_variant)
         loop
            !!i.parse
            instructions.put(i)
            remove_semi
         end
      end


   defer, short(f : EIFFEL_FORMAT) is
      do
      end

   flat(f : EIFFEL_FORMAT) is
      do
         if instructions /= Void and not instructions.empty
         then
            from
               instructions.start
            until
               instructions.off_right
            loop
               f.new_line
               instructions.item.flat(f)
               instructions.forth
            end
         end
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := instructions.is_equal(other.instructions)
      end

   copy(other : like Current) is
      do
        instructions  := clone(other.instructions)
      end

end -- class EIFFEL_COMPOUND
