-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/01 09:52:45 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_constg.e $
	-- Revision 1.3  1993/08/01  09:52:45  Neil_Wilson
	-- Corrected output spacing with constrained generics
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CONSTRAINED_GENERIC
-- A generic with a possible constraint

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   formal_generic : EIFFEL_TOKEN
   
   constraint : EIFFEL_TOKEN

   parse is
      do
         !!formal_generic.parse
         matchconsume(Elex_id)
         if match(Elex_arrow)
         then
            consume
            !!constraint.parse
            matchconsume(Elex_id)
         end
      end

   defer, flat, short(f : EIFFEL_FORMAT) is
      do
         formal_generic.upshort(f)
         if constraint /= Void
         then
	    f.space
            f.normal_write("->")
	    f.space
            constraint.upshort(f)
         end
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := formal_generic.is_equal(other.formal_generic) and then
                   equal(constraint,other.constraint)
      end

   copy(other : like Current) is
      do
         formal_generic := clone(other.formal_generic)
         constraint := clone(other.constraint)
      end

end -- class EIFFEL_CONSTRAINED_GENERIC
