-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_debug.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_DEBUG
-- A debug instruction and it's keys

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   keys : LLIST[EIFFEL_TOKEN]
   
   debug_statement : EIFFEL_COMPOUND

   parse is
      local
         k : EIFFEL_TOKEN
      do
         matchconsume(Elex_debug)
         if match(Elex_lbracket)
         then
            consume
            from
               !!keys.make
               !!k.parse
               keys.put(k)
               matchconsume(Elex_string)
            until
               not match(Elex_comma)
            loop
               consume -- ,
               !!k.parse
               keys.put(k)
               matchconsume(Elex_string)
            end -- loop
            matchconsume(Elex_rbracket)
         end
         !!debug_statement.parse
         matchconsume(Elex_end)
      end

   defer, short(f : EIFFEL_FORMAT) is
      do
      end

   flat ( f : EIFFEL_FORMAT) is
      do
         f.keyword_write("debug")
         if keys /= Void
         then
            from
               keys.start
	       f.space
               f.normal_write("(")
               keys.item.short(f)
               keys.forth
            until
               keys.off_right
            loop
               f.normal_write(",")
	       f.space
               keys.item.short(f)
               keys.forth
            end -- loop
            f.normal_write(")")
         end -- if
         f.increase_indent
         f.new_line
         debug_statement.short(f)
         f.decrease_indent
         f.new_line
         f.keyword_write("end")
      end
      
   is_equal(other : like Current) : BOOLEAN is
      do
         Result := equal(keys,other.keys) and then
                   equal(debug_statement,other.debug_statement)
      end
      
   copy(other : like Current) is
      do
         keys := clone(other.keys)
         debug_statement := clone(other.debug_statement)
      end
      
end -- class      
